/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.RefundUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.RefundResponseData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.RefundResponseDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.RefundUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.RefundService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.RequestUrl;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RefundServiceImpl
extends DateBaseService
implements RefundService {
    private static String SYS_CODE = "jst.RefundServiceImpl";

    @Override
    public String saveRefund(OcRefundReDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            logger.error(SYS_CODE + ".saveRefund ocRefundDomain is null");
            return "error";
        }
        if (null == ocRefundDomain.getGmtCreate()) {
            ocRefundDomain.setGmtCreate(new Date());
        }
        if (null == ocRefundDomain.getGmtModified()) {
            ocRefundDomain.setGmtModified(ocRefundDomain.getGmtCreate());
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            logger.error(SYS_CODE + ".saveRefund getOcRefundGoodsDomainList is null");
            return "error";
        }
        String access_token = RefundServiceImpl.gettoken(ocRefundDomain.getMemberCcode(), ocRefundDomain.getTenantCode());
        if (StringUtils.isBlank((String)access_token)) {
            return "token\u5931\u6548";
        }
        List<RefundUploadRequest> refundUploadRequests = this.makeRefundUploadRequest(ocRefundDomain);
        if (ListUtil.isEmpty(refundUploadRequests)) {
            logger.error(SYS_CODE + ".saveRefund refundUploadRequests is null");
            return "error";
        }
        String appkey = RequestUrl.jstappkey;
        String secret = RequestUrl.jstsecret;
        String url = RequestUrl.jstUrl + "/open/aftersale/upload";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(refundUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = RefundServiceImpl.buildQuery(params);
        String responseStr = RefundServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error(SYS_CODE + ".saveRefund responseStr is null");
            return "error";
        }
        RefundUploadResponse refundUploadResponse = (RefundUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, RefundUploadResponse.class);
        if (null == refundUploadResponse) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponse is null", (Object)responseStr);
            return "error";
        }
        if (0 != refundUploadResponse.getCode()) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponse is error", (Object)refundUploadResponse.getMsg());
            return "error";
        }
        RefundResponseData refundUploadResponseData = refundUploadResponse.getData();
        if (null == refundUploadResponseData) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponseData is null", (Object)responseStr);
            return "error";
        }
        List<RefundResponseDatas> datas = refundUploadResponseData.getDatas();
        if (ListUtil.isEmpty(datas)) {
            logger.error(SYS_CODE + ".saveRefund refundUploadResponseDatas is null", (Object)responseStr);
            return "error";
        }
        for (RefundResponseDatas data : datas) {
            if (data.isIssuccess()) {
                this.updateRefundNcode(data.getOuter_as_id(), data.getAs_id(), ocRefundDomain.getTenantCode(), null, 1);
                continue;
            }
            logger.error(SYS_CODE + ".saveRefund data is error", (Object)responseStr);
            this.updateRefundNcode(ocRefundDomain.getRefundCode(), null, ocRefundDomain.getTenantCode(), data.getMsg(), -1);
            return "error";
        }
        return "success";
    }

    private List<RefundUploadRequest> makeRefundUploadRequest(OcRefundReDomain ocRefundDomain) {
        UmUserinfo user = this.getUser(ocRefundDomain.getTenantCode(), ocRefundDomain.getMemberCcode());
        if (null == user) {
            logger.error(SYS_CODE + ".saveRefund getUser is null");
            return null;
        }
        String shopId = user.getCompanyCode();
        if (StringUtils.isBlank((String)shopId)) {
            logger.error(SYS_CODE + ".saveRefund shopId is null");
            return null;
        }
        SgSendgoodsReDomain sgSendGoodsDomain = this.getSgSendGoodsDomain(ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode());
        if (null == sgSendGoodsDomain) {
            logger.error(SYS_CODE + ".saveRefund getSgSendGoodsDomain is null");
            return null;
        }
        ArrayList<RefundUploadRequest> refundUploadRequests = new ArrayList<RefundUploadRequest>();
        RefundUploadRequest refundUploadRequest = new RefundUploadRequest();
        refundUploadRequest.setShop_id(Integer.parseInt(shopId));
        refundUploadRequest.setOuter_as_id(ocRefundDomain.getRefundCode());
        refundUploadRequest.setSo_id(ocRefundDomain.getContractBbillcode());
        refundUploadRequest.setType(this.getRefundType(ocRefundDomain.getRefundType()));
        refundUploadRequest.setLogistics_company(ocRefundDomain.getPackageName());
        refundUploadRequest.setL_id(ocRefundDomain.getPackageBillno());
        refundUploadRequest.setShop_status(this.getShopStatus(ocRefundDomain.getDataState()));
        refundUploadRequest.setGood_status(this.getGoodStatus(ocRefundDomain.getDataState(), ocRefundDomain.getRefundType()));
        refundUploadRequest.setQuestion_type(ocRefundDomain.getRefundEx());
        refundUploadRequest.setTotal_amount(sgSendGoodsDomain.getContractMoney());
        refundUploadRequest.setRefund(ocRefundDomain.getRefundMoney());
        refundUploadRequest.setPayment(new BigDecimal(0));
        refundUploadRequests.add(refundUploadRequest);
        ArrayList<RefundGoodsDomain> refundGoodsDomains = new ArrayList<RefundGoodsDomain>();
        refundUploadRequest.setItems(refundGoodsDomains);
        RefundGoodsDomain refundGoodsDomain = null;
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            refundGoodsDomain = new RefundGoodsDomain();
            refundGoodsDomains.add(refundGoodsDomain);
            if (null == ocRefundGoodsDomain.getRefundGoodsAmt()) {
                ocRefundGoodsDomain.setRefundGoodsAmt(BigDecimal.ZERO);
            }
            if (null == ocRefundGoodsDomain.getRefundGoodsNum()) {
                ocRefundGoodsDomain.setRefundGoodsNum(BigDecimal.ZERO);
            }
            refundGoodsDomain.setAmount(ocRefundGoodsDomain.getRefundGoodsAmt());
            refundGoodsDomain.setSku_id(ocRefundGoodsDomain.getSkuNo());
            refundGoodsDomain.setQty(ocRefundGoodsDomain.getRefundGoodsNum().intValue());
            refundGoodsDomain.setOuter_oi_id(ocRefundGoodsDomain.getGoodsOldcode());
            refundGoodsDomain.setType(this.getRefundGoodsType(ocRefundDomain.getRefundType()));
        }
        return refundUploadRequests;
    }

    public static void main(String[] args) {
        OcContractReDomain ocContractReDomain = new OcContractReDomain();
        System.out.println(0 == ocContractReDomain.getDataState());
    }

    private String getRefundType(String refundType) {
        if ("B02".equals(refundType) || "F082".equals(refundType) || "F002".equals(refundType)) {
            return "\u666e\u901a\u9000\u8d27";
        }
        if ("B01".equals(refundType) || "F081".equals(refundType) || "F001".equals(refundType)) {
            return "\u4ec5\u9000\u6b3e";
        }
        return "\u5176\u5b83";
    }

    private String getRefundGoodsType(String refundType) {
        if ("B02".equals(refundType) || "F082".equals(refundType) || "F002".equals(refundType)) {
            return "\u9000\u8d27";
        }
        return "\u5176\u5b83";
    }

    private String getShopStatus(Integer dataState) {
        if (0 == dataState) {
            return "WAIT_SELLER_AGREE";
        }
        if (1 == dataState) {
            return "WAIT_BUYER_RETURN_GOODS";
        }
        if (8 == dataState) {
            return "SUCCESS";
        }
        if (-1 == dataState) {
            return "SELLER_REFUSE_BUYER";
        }
        if (2 == dataState) {
            return "WAIT_SELLER_CONFIRM_GOODS";
        }
        if (6 == dataState) {
            return "SELLER_REFUSE_BUYER";
        }
        return "error";
    }

    private String getGoodStatus(Integer dataState, String refundType) {
        if ("B02".equals(refundType) && 8 != dataState) {
            return "BUYER_RETURNED_GOODS";
        }
        if ("F002".equals(refundType) && 8 != dataState) {
            return "BUYER_RETURNED_GOODS";
        }
        if ("F082".equals(refundType) && 8 != dataState) {
            return "BUYER_RETURNED_GOODS";
        }
        if ("B02".equals(refundType) || "F002".equals(refundType) || "F082".equals(refundType)) {
            return "BUYER_RECEIVED";
        }
        if ("B01".equals(refundType) || "F001".equals(refundType) || "F081".equals(refundType)) {
            return "BUYER_NOT_RECEIVED";
        }
        return "BUYER_NOT_RECEIVED";
    }

    private void updateRefundNcode(String refundCode, String refundNcode, String tenantCode, String memo, Integer dataOpnextbillstate) {
        String apiCode = "oc.refund.updateRefundNcodeMap";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("refundNcode", refundNcode);
        param.put("dataOpnextbillstate", dataOpnextbillstate);
        param.put("memo", memo);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.internalInvoke(apiCode, param);
    }
}

