/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.jushuitan.api.OrderMessageService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.ResponseDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsGoodsRel;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgGoodsNumDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.OrdersOutQueryRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.requestin.OrderMessageRequestIn;
import com.yqbsoft.laser.service.ext.bus.jushuitan.requestin.OrderMessageRequestInItem;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryResPonse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.returnout.OrderMessageReturn;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderMessageServiceImpl
extends DateBaseService
implements OrderMessageService {
    private static String SYS_CODE = "jst.OrderMessageServiceImpl";

    @Override
    public OrderMessageReturn sendOrder(Map<String, Object> resStream, String tenantCode, String partnerid, String token, int ts, String sign) {
        logger.error(SYS_CODE + "sendOrder start", resStream);
        OrderMessageReturn orderMessageReturn = new OrderMessageReturn();
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(SYS_CODE + ".sendOrder tenantCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)tenantCode));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u79df\u6237\u53f7\u4e3a\u7a7a");
            return orderMessageReturn;
        }
        String json = JsonUtil.buildNormalBinder().toJson(resStream);
        OrderMessageRequestIn orderMessageRequestIn = (OrderMessageRequestIn)JsonUtil.buildNormalBinder().getJsonToObject(json, OrderMessageRequestIn.class);
        String so_id = orderMessageRequestIn.getSo_id();
        OcContractReDomain contractDomain = this.getContractDomain(so_id, tenantCode);
        if (null == contractDomain || ListUtil.isEmpty(contractDomain.getGoodsList())) {
            logger.error(SYS_CODE + ".sendOrder contractDomain is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728!");
            return orderMessageReturn;
        }
        List<OrderMessageRequestInItem> items = orderMessageRequestIn.getItems();
        if (ListUtil.isEmpty(items)) {
            logger.error(SYS_CODE + ".sendOrder items is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e38");
            return orderMessageReturn;
        }
        String res = this.saveSgSendGoods(this.makeSgSendGoodsDomain(orderMessageRequestIn, tenantCode, contractDomain));
        if (StringUtils.isBlank((String)res) || !"success".equals(res)) {
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u53d1\u8d27\u5355\u751f\u6210\u5931\u8d25");
            return orderMessageReturn;
        }
        orderMessageReturn.setMsg("\u6267\u884c\u6210\u529f");
        orderMessageReturn.setCode("0");
        return orderMessageReturn;
    }

    @Override
    public OrderMessageReturn logisticsUpload(Map<String, Object> resStream, String tenantCode, String partnerid, String token, String method, int ts, String sign) {
        logger.error(SYS_CODE + "logisticsUpload start", resStream);
        OrderMessageReturn orderMessageReturn = new OrderMessageReturn();
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(SYS_CODE + ".logisticsUpload tenantCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)tenantCode));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u79df\u6237\u53f7\u4e3a\u7a7a");
            return orderMessageReturn;
        }
        if (MapUtil.isEmpty(resStream)) {
            logger.error(SYS_CODE + ".logisticsUpload resStream is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)tenantCode));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u53c2\u6570\u5f02\u5e38");
            return orderMessageReturn;
        }
        String json = JsonUtil.buildNormalBinder().toJson(resStream);
        OrderMessageRequestIn orderMessageRequestIn = (OrderMessageRequestIn)JsonUtil.buildNormalBinder().getJsonToObject(json, OrderMessageRequestIn.class);
        String so_id = orderMessageRequestIn.getSo_id();
        OcContractReDomain contractDomain = this.getContractDomain(so_id, tenantCode);
        if (null == contractDomain || ListUtil.isEmpty(contractDomain.getGoodsList())) {
            logger.error(SYS_CODE + ".sendOrder contractDomain is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u8ba2\u5355\u4e0d\u5b58\u5728!");
            return orderMessageReturn;
        }
        List<OrderMessageRequestInItem> items = orderMessageRequestIn.getItems();
        if (ListUtil.isEmpty(items)) {
            logger.error(SYS_CODE + ".sendOrder items is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e38");
            return orderMessageReturn;
        }
        String res = this.saveSgSendGoods(this.makeSgSendGoodsDomain(orderMessageRequestIn, tenantCode, contractDomain));
        if (StringUtils.isBlank((String)res) || !"success".equals(res)) {
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u53d1\u8d27\u5355\u751f\u6210\u5931\u8d25");
            return orderMessageReturn;
        }
        orderMessageReturn.setMsg("\u6267\u884c\u6210\u529f");
        orderMessageReturn.setCode("0");
        return orderMessageReturn;
    }

    private List<OrdersOutQueryDatas> getOrdersOutQueryDatas(String soid, String tenantCode) {
        String url = OrderMessageServiceImpl.getDdFalgSetting(tenantCode, "orderOutqueryUrl", "orderOutqueryUrl", "");
        String appkey = OrderMessageServiceImpl.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = OrderMessageServiceImpl.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        String access_token = OrderMessageServiceImpl.gettoken("jushuitan", tenantCode);
        String parm = "";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        OrdersOutQueryRequest ordersOutQueryRequest = new OrdersOutQueryRequest();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(soid);
        ordersOutQueryRequest.setSo_ids(ids);
        params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)ordersOutQueryRequest));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        parm = OrderMessageServiceImpl.buildQuery(params);
        String responseStr = OrderMessageServiceImpl.execute(parm, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error(SYS_CODE + ".getOrdersOutQueryDatas responseStr is null");
            return null;
        }
        OrdersOutQueryResPonse jsonToObject = (OrdersOutQueryResPonse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrdersOutQueryResPonse.class);
        if (0 != jsonToObject.getCode()) {
            logger.error(SYS_CODE + ".getOrdersOutQueryDatas responseStr is error", (Object)jsonToObject.getMsg());
            return null;
        }
        OrdersOutQueryData data = jsonToObject.getData();
        if (null == data) {
            logger.error(SYS_CODE + ".getOrdersOutQueryDatas data is error", (Object)responseStr);
            return null;
        }
        List<OrdersOutQueryDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            logger.error(SYS_CODE + ".getOrdersOutQueryDatas datas is error", (Object)responseStr);
            return null;
        }
        return datas;
    }

    private SgSendgoodsDomain makeSgSendGoodsDomain(OrderMessageRequestIn orderMessageRequestIn, String tenantCode, OcContractReDomain contractReDomain) {
        logger.info(SYS_CODE + ".makeSgSendGoodsDomain", (Object)(JsonUtil.buildNormalBinder().toJson((Object)orderMessageRequestIn) + "==" + JsonUtil.buildNormalBinder().toJson((Object)contractReDomain)));
        SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
        ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
        BigDecimal sendNum = BigDecimal.ZERO;
        BigDecimal money = BigDecimal.ZERO;
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsDomain, (Object)contractReDomain);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".makeSgSendGoodsDomain.copy.e", (Throwable)e);
        }
        HashMap<String, OcContractGoodsDomain> ocContractGoodsDomainMap = new HashMap<String, OcContractGoodsDomain>();
        List<OcContractGoodsDomain> goodsList = contractReDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) && ocContractGoodsDomain.getGoodsPro().equals("5")) {
                List<OcContractGoodsDomain> ocContractGoodsDomains = this.makeOcContractGoodsDomain(ocContractGoodsDomain);
                if (!ListUtil.isNotEmpty(ocContractGoodsDomains)) continue;
                for (OcContractGoodsDomain item : ocContractGoodsDomains) {
                    ocContractGoodsDomainMap.put(item.getContractGoodsCode(), item);
                }
                continue;
            }
            ocContractGoodsDomainMap.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        List<OrderMessageRequestInItem> items = orderMessageRequestIn.getItems();
        SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = null;
        for (OrderMessageRequestInItem item : items) {
            sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
            sendNum = sendNum.add(new BigDecimal(item.getQty()));
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractGoodsDomainMap.get(item.getOuter_oi_id());
            if (null == ocContractGoodsDomain) {
                logger.error(SYS_CODE + ".makeSgSendGoodsDomain is null", (Object)(contractReDomain.getContractBillcode() + "==" + item.getOuter_oi_id()));
                continue;
            }
            try {
                BeanUtils.copyAllPropertys((Object)sgSendgoodsGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                throw new ApiException(SYS_CODE + ".makeSgSendGoodsDomain.copy.e", (Throwable)e);
            }
            sgSendgoodsGoodsDomain.setContractGoodsMoney(ocContractGoodsDomain.getContractGoodsPrice().multiply(new BigDecimal(item.getQty())));
            money = money.add(sgSendgoodsGoodsDomain.getContractGoodsMoney());
            sgSendgoodsGoodsDomain.setSendgoodsGoodsCamount(new BigDecimal(item.getQty()));
            sgSendgoodsGoodsDomain.setGoodsNum(new BigDecimal(item.getQty()));
            sgSendgoodsGoodsDomain.setGoodsCamount(new BigDecimal(item.getQty()));
            sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
        }
        sgSendgoodsDomain.setContractSendnum(sendNum);
        sgSendgoodsDomain.setGoodsNum(sendNum);
        sgSendgoodsDomain.setGoodsMoney(money);
        sgSendgoodsDomain.setDataBmoney(money);
        sgSendgoodsDomain.setDataBnum(sendNum);
        sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
        sgSendgoodsDomain.setPackageBillno(orderMessageRequestIn.getL_id());
        sgSendgoodsDomain.setPackageName(orderMessageRequestIn.getLogistics_company());
        sgSendgoodsDomain.setPackageMode(orderMessageRequestIn.getLc_id());
        return sgSendgoodsDomain;
    }

    public List<OcContractGoodsDomain> makeOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            logger.error(SYS_CODE + ".makeOcContractGoodsDomain", (Object)"is null");
            return null;
        }
        HashMap<String, String> rsGoodsRelMap = new HashMap<String, String>();
        HashMap<String, String> rsGoodsRelMapStr = new HashMap<String, String>();
        ArrayList<OcContractGoodsDomain> orderGoodsDomains = new ArrayList<OcContractGoodsDomain>();
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) && ocContractGoodsDomain.getGoodsPro().equals("5")) {
            List rsGoodsRelList;
            rsGoodsRelMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            rsGoodsRelMap.put("goodsCode", ocContractGoodsDomain.getGoodsCode());
            rsGoodsRelMap.put("goodsRelType", "3");
            rsGoodsRelMapStr.put("map", JsonUtil.buildNonNullBinder().toJson(rsGoodsRelMap));
            QueryResult queryResutl = this.getQueryResutl("rs.goodsOther.queryGoodsRelPage", rsGoodsRelMapStr, RsGoodsRel.class);
            if (ListUtil.isNotEmpty((Collection)queryResutl.getList()) && ListUtil.isNotEmpty((Collection)(rsGoodsRelList = queryResutl.getList()))) {
                for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
                    OcContractGoodsDomain contractGoodsDomain = new OcContractGoodsDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)ocContractGoodsDomain);
                    }
                    catch (Exception e) {
                        throw new ApiException(SYS_CODE + ".makeOcContractGoodsDomain.copy.e", (Throwable)e);
                    }
                    try {
                        BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsGoodsRel);
                    }
                    catch (Exception e) {
                        throw new ApiException(SYS_CODE + ".makeOcContractGoodsDomain.copy1.e", (Throwable)e);
                    }
                    contractGoodsDomain.setContractGoodsPrice(rsGoodsRel.getGoodsRelNprice());
                    contractGoodsDomain.setContractGoodsCode(rsGoodsRel.getGoodsRelCode());
                    orderGoodsDomains.add(contractGoodsDomain);
                }
            }
        }
        return orderGoodsDomains;
    }

    private List<SgGoodsNumDomain> makeSgGoodsNumDomainList(OrderMessageRequestIn orderMessageRequestIn) {
        ArrayList<SgGoodsNumDomain> sgGoodsNumDomains = new ArrayList<SgGoodsNumDomain>();
        return sgGoodsNumDomains;
    }

    private String saveSgSendGoods(SgSendgoodsDomain sgSendgoodsDomain) {
        String apiCode = "sg.sgOccontract.sendSaveManyPoolSendgoodsJst";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private ResponseDomain updateContractPayAndSgContract(List<SgGoodsNumDomain> sgGoodsNumDomainList) {
        String apiCode = "oc.contract.updateContractPayAndSgContract";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgGoodsNumDomainList", JsonUtil.buildNormalBinder().toJson(sgGoodsNumDomainList));
        String json = this.internalInvoke(apiCode, paramMap);
        ResponseDomain jsonToObject = (ResponseDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, ResponseDomain.class);
        if (!jsonToObject.isSuccess()) {
            logger.error(SYS_CODE + "updateContractPayAndSgContract josn =", (Object)(sgGoodsNumDomainList.get(0).getContractBillcode() + "=" + json));
        }
        return jsonToObject;
    }
}

