/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.DisOauthToken;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DateBaseService
extends BaseServiceImpl {
    private static final String SYS_CODE = "DateBaseService";
    protected static final SupperLogUtil logger = new SupperLogUtil(DateBaseService.class);
    private InternalRouter internalRouter;
    private static String cachekey = "DisOauthToken-channelCode";
    private static String sendsaveSgSendgoods = "sg.sendgoodsEngine.sendsaveSgSendgoods";

    public void setInternalRouter(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }

    public InternalRouter getInternalRouter() {
        return this.internalRouter;
    }

    public static String getRedisValue(String key) {
        String redisValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        if (StringUtils.isBlank((String)redisValue)) {
            redisValue = SupDisUtil.getRemotMap((String)"DdFalgSetting-key", (String)key);
        }
        return redisValue;
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (!(StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode))) {
            String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
            String value = DateBaseService.getRedisValue(field);
            return value;
        }
        return null;
    }

    public static String gettoken(String memberCode, String tenantCode) {
        String tokenStr = DisUtil.getRemotMap((String)cachekey, (String)("jushuitan-" + memberCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)tokenStr)) {
            logger.error(".getToken.tokenStr", (Object)("jushuitan-" + memberCode + "-" + tenantCode));
            return null;
        }
        DisOauthToken disOauthToken = (DisOauthToken)JsonUtil.buildNormalBinder().getJsonToObject(tokenStr, DisOauthToken.class);
        if (null == disOauthToken) {
            logger.error(".getToken.disOauthToken", (Object)("jushuitan-" + memberCode + "-" + tenantCode));
            return null;
        }
        return disOauthToken.getOauthTokenToken();
    }

    public String getRefToken(String disCode, String tenantCode) {
        String jsttokentest = DateBaseService.getDdFalgSetting(tenantCode, "jsttokentest", "jsttokentest", "");
        if (StringUtils.isNotBlank((String)jsttokentest)) {
            logger.error("testToken is not null", (Object)"\u6d4b\u8bd5\u73af\u5883\u5df2\u914d\u7f6etoken");
            return null;
        }
        String tokenStr = DisUtil.getRemotMap((String)cachekey, (String)("jushuitan-jushuitan-" + tenantCode));
        if (StringUtils.isBlank((String)tokenStr)) {
            logger.error(".getToken.tokenStr", (Object)("jushuitan-jushuitan-" + tenantCode));
            return null;
        }
        DisOauthToken disOauthToken = (DisOauthToken)JsonUtil.buildNormalBinder().getJsonToObject(tokenStr, DisOauthToken.class);
        if (null == disOauthToken) {
            logger.error(".getToken.disOauthToken", (Object)("jushuitan-jushuitan-" + tenantCode));
            return null;
        }
        return disOauthToken.getOauthTokenRefreshToken();
    }

    public static String buildQuery(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((String)name) || !StringUtils.isNotBlank((String)value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            try {
                query.append(name).append("=").append(URLEncoder.encode(value, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("buildQuery is error,", (Object)e.getMessage());
                return "error";
            }
        }
        return query.toString();
    }

    public static String execute(String param, String url) {
        logger.info("JSTexecute url= " + url);
        logger.info("JSTexecute param" + param);
        OkHttpClient okHttpClirnt = OKHttpClientUtil.getOkHttpClirnt();
        MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)param);
        Request request = new Request.Builder().url(url).method("POST", body).addHeader("charset", "UTF-8").addHeader("Content-Type", "text/xml").build();
        Response response = null;
        String responseStr = null;
        try {
            response = okHttpClirnt.newCall(request).execute();
            responseStr = response.body().string();
        }
        catch (IOException e) {
            throw new ApiException((Throwable)e);
        }
        logger.info("JSTexecute responseStr=", (Object)responseStr);
        return responseStr;
    }

    public UmUserinfo getUser(String tenantCode, String userinfoCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        String userinfoStr = this.internalInvoke(ApiCodeEnums.getUserinfoByUserCode.getApiCode(), paramMap);
        if (StringUtils.isBlank((String)userinfoStr)) {
            throw new ApiException("\u4f1a\u5458\u4fe1\u606f\u4e3aNULL");
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
        if (null == umUserinfo) {
            throw new ApiException("umUserinfo is NULL");
        }
        return umUserinfo;
    }

    public OcContractReDomain getContractDomain(String contractBillcode, String tenantCode) {
        String apiCode = "oc.contract.getContractByCode";
        HashMap<String, String> param = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String OcContractReDomainStr = this.internalInvoke(apiCode, param);
        if (StringUtils.isBlank((String)OcContractReDomainStr)) {
            return null;
        }
        return (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(OcContractReDomainStr, OcContractReDomain.class);
    }

    public SgSendgoodsReDomain getSgSendGoodsDomain(String contractBillcode, String tenantCode) {
        String apiCode = "sg.sendgoods.getSendgoodsByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sendgoodsCode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        String sgSendgoodsDomainStr = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isBlank((String)sgSendgoodsDomainStr)) {
            return null;
        }
        return (SgSendgoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(sgSendgoodsDomainStr, SgSendgoodsReDomain.class);
    }

    public OcRefundReDomain getRefundReDomain(String refundCode, String tenantCode) {
        String apiCode = "oc.refund.getRefundByCode";
        HashMap<String, String> param = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("refundCode", refundCode);
        paramMap.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String OcRefundReDomainStr = this.internalInvoke(apiCode, param);
        if (StringUtils.isBlank((String)OcRefundReDomainStr)) {
            return null;
        }
        return (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(OcRefundReDomainStr, OcRefundReDomain.class);
    }

    public void sendRefundNext(String refundCode, String tenantCode) {
        String apiCode = "oc.refundEngine.sendRefundNext";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, param);
    }

    public void sendRefundBack(String refundCode, String tenantCode) {
        String apiCode = "oc.refundEngine.sendRefundBack";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, param);
    }

    public void sendsaveSgSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        this.internalInvoke(sendsaveSgSendgoods, param);
    }

    public static String getPicPre(String tenantCode) {
        String ddFalgSetting = DateBaseService.getDdFalgSetting(tenantCode, "picUrl", "picUrl", "");
        if (StringUtils.isBlank((String)ddFalgSetting)) {
            return "";
        }
        return ddFalgSetting;
    }

    public QueryResult<RsSkuReDomain> querySkuList(String tenantCode, String skuNo, String memberCcode) {
        if (StringUtils.isBlank((String)skuNo) || null == memberCcode) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsType", "00");
        map.put("skuOldcode", "-1");
        map.put("memberCcode", memberCcode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("rs.sku.querySkuOnePage", param, RsSkuReDomain.class);
    }

    public QueryResult<OcContractReDomain> queryContractPageReDomain(Map<String, Object> map) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("oc.contract.queryContractPageReDomain", param, OcContractReDomain.class);
    }

    protected void updateContractContractNbillcode(String contractBillcode, String contractNbillcode, Integer contractEcflag, String memo, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error("DateBaseServiceupdateContractContractNbillcode param is null");
            return;
        }
        String apiCode = "oc.contract.updateContractContractNbillcodeByMap";
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("contractEcflag", contractEcflag);
        paramMap.put("memo", memo);
        paramMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String s = this.internalInvoke(apiCode, map);
        logger.error("DateBaseService.updateContractContractNbillcode." + s, (Object)((Object)paramMap).toString());
    }
}

