/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractproDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OrderGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OrderPayDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsGoodsRel;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoods;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.OrderUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.OrdersOutQueryRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrdersOutQueryResPonse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.send.ContractPollThread;
import com.yqbsoft.laser.service.ext.bus.jushuitan.send.ContractPutThread;
import com.yqbsoft.laser.service.ext.bus.jushuitan.send.ContractService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.OrderService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.SendOrderService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.RequestUrl;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderServiceImpl
extends DateBaseService
implements OrderService {
    private static final String SYS_CODE = "OrderServiceImpl";
    private static ContractService contractService;
    private static Object lock;

    @Override
    public String saveOrder(OcContractReDomain ocContractDomain) {
        return this.orderUploadRequests(ocContractDomain, "WAIT_BUYER_PAY");
    }

    private String orderUploadRequests(OcContractReDomain ocContractDomain, String shop_status) {
        String shopId;
        if (null == ocContractDomain) {
            logger.error("OrderServiceImpl.saveOrder is null");
            return "error";
        }
        String access_token = OrderServiceImpl.gettoken(ocContractDomain.getMemberCcode(), ocContractDomain.getTenantCode());
        if (StringUtils.isBlank((String)access_token)) {
            return "success";
        }
        String appkey = RequestUrl.jstappkey;
        String secret = RequestUrl.jstsecret;
        String url = RequestUrl.jstUrl + "/open/jushuitan/orders/upload";
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            logger.error("OrderServiceImpl.saveOrder goodsList is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCcode());
        if (null == user) {
            logger.error("OrderServiceImpl.saveOrder getUser is null");
            return "error";
        }
        if (null == ocContractDomain.getGmtCreate()) {
            ocContractDomain.setGmtCreate(new Date());
        }
        if (null == ocContractDomain.getGmtModified()) {
            ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
        }
        if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
            logger.error("OrderServiceImpl.saveOrder shopId  is null");
            return "error";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
        orderUploadRequest.setShop_id(Integer.parseInt(shopId));
        orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
        orderUploadRequest.setOrder_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
        orderUploadRequest.setShop_status(shop_status);
        orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBname());
        OrderServiceImpl.makeAddress(orderUploadRequest, ocContractDomain.getOcContractproDomainList());
        orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
        orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setReceiver_mobile(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setPay_amount(ocContractDomain.getDataBmoney());
        if (null == ocContractDomain.getGoodsLogmoney()) {
            ocContractDomain.setGoodsLogmoney(BigDecimal.ZERO);
        }
        if ("WAIT_SELLER_SEND_GOODS" == shop_status) {
            OrderPayDomain orderPayDomain = new OrderPayDomain();
            orderPayDomain.setOuter_pay_id("*************");
            orderPayDomain.setPay_date(OrderServiceImpl.getDataStr(ocContractDomain.getGmtCreate()));
            orderPayDomain.setAmount(ocContractDomain.getContractMoney());
            orderPayDomain.setBuyer_account(ocContractDomain.getMemberBcode());
            orderPayDomain.setSeller_account(ocContractDomain.getMemberCode());
            orderPayDomain.setPayment("\u7ebf\u4e0a");
            orderUploadRequest.setPay(orderPayDomain);
        }
        orderUploadRequest.setFreight(ocContractDomain.getGoodsLogmoney());
        orderUploadRequest.setShop_modified(OrderServiceImpl.getDataStr(ocContractDomain.getGmtModified()));
        String picUrl = OrderServiceImpl.getPicPre(ocContractDomain.getTenantCode());
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        OrderGoodsDomain orderGoodsDomain = null;
        HashMap<String, String> remarkmap = new HashMap<String, String>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) && ocContractGoodsDomain.getGoodsPro().equals("5")) {
                List<OrderGoodsDomain> orderGoodsDomains1 = this.makeOrderGoodsDomains(ocContractGoodsDomain, picUrl, remarkmap);
                if (!ListUtil.isNotEmpty(orderGoodsDomains1)) continue;
                orderGoodsDomains.addAll(orderGoodsDomains1);
                continue;
            }
            orderGoodsDomain = new OrderGoodsDomain();
            orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
            orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
            orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
            orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
            orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
            orderGoodsDomain.setName(ocContractGoodsDomain.getGoodsName());
            orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
            orderGoodsDomain.setPic(OrderServiceImpl.makeOcPic(ocContractGoodsDomain, picUrl));
            if ("Presale".equals(ocContractGoodsDomain.getGoodsSpec2())) {
                orderGoodsDomain.setRemark(ocContractGoodsDomain.getGoodsSpec3());
                remarkmap.put("\u5546\u54c1\u7f16\u7801" + ocContractGoodsDomain.getSkuNo(), "\u9884\u552e\u53d1\u8d27" + ocContractGoodsDomain.getGoodsSpec3());
            }
            orderGoodsDomains.add(orderGoodsDomain);
        }
        orderUploadRequest.setItems(orderGoodsDomains);
        orderUploadRequest.setRemark(((Object)remarkmap).toString());
        orderUploadRequests.add(orderUploadRequest);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        logger.error("OrderServiceImpl.saveOrdernew" + JsonUtil.buildNormalBinder().toJson(params));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = OrderServiceImpl.buildQuery(params);
        String responseStr = OrderServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error("OrderServiceImpl.saveOrder responseStr is null");
            return "error";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            logger.error("OrderServiceImpl.saveOrder orderUploadResponse is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)orderUploadResponse.getMsg());
            throw new RuntimeException("\u8c03\u7528\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            logger.error("OrderServiceImpl.saveOrder data is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)responseStr);
            return "error";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            logger.error("OrderServiceImpl.saveOrder datas is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)responseStr);
            return "error";
        }
        for (OrderUploadDatas orderUploadDatas : datas) {
            if (orderUploadDatas.isIssuccess()) {
                this.updateContractContractNbillcode(ocContractDomain.getContractBillcode(), orderUploadDatas.getO_id().toString(), 1, null, ocContractDomain.getTenantCode());
                continue;
            }
            logger.error("OrderServiceImpl.saveOrder orderUploadDatas is error" + JsonUtil.buildNormalBinder().toJson(params), (Object)responseStr);
            this.updateContractContractNbillcode(ocContractDomain.getContractBillcode(), orderUploadDatas.getO_id().toString(), -1, orderUploadDatas.getMsg(), ocContractDomain.getTenantCode());
            return "error";
        }
        return "success";
    }

    @Override
    public String saveOrderPay(OcContractReDomain ocContractDomain) {
        return this.orderUploadRequests(ocContractDomain, "WAIT_SELLER_SEND_GOODS");
    }

    public List<OrderGoodsDomain> makeOrderGoodsDomains(OcContractGoodsDomain ocContractGoodsDomain, String picUrl, Map<String, String> remarkmap) {
        if (null == ocContractGoodsDomain) {
            logger.error("OrderServiceImpl.makeOrderGoodsDomains", (Object)"is null");
            return null;
        }
        HashMap<String, String> rsGoodsRelMap = new HashMap<String, String>();
        HashMap<String, String> rsGoodsRelMapStr = new HashMap<String, String>();
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) && ocContractGoodsDomain.getGoodsPro().equals("5")) {
            List rsGoodsRelList;
            rsGoodsRelMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            rsGoodsRelMap.put("goodsCode", ocContractGoodsDomain.getGoodsCode());
            rsGoodsRelMap.put("goodsRelType", "3");
            rsGoodsRelMapStr.put("map", JsonUtil.buildNonNullBinder().toJson(rsGoodsRelMap));
            QueryResult queryResutl = this.getQueryResutl("rs.goodsOther.queryGoodsRelPage", rsGoodsRelMapStr, RsGoodsRel.class);
            if (ListUtil.isNotEmpty((Collection)queryResutl.getList()) && ListUtil.isNotEmpty((Collection)(rsGoodsRelList = queryResutl.getList()))) {
                for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
                    OrderGoodsDomain orderGoodsDomain = new OrderGoodsDomain();
                    orderGoodsDomain.setSku_id(rsGoodsRel.getSkuNo());
                    orderGoodsDomain.setShop_sku_id(rsGoodsRel.getSkuCode());
                    orderGoodsDomain.setAmount(ocContractGoodsDomain.getGoodsCamount().multiply(rsGoodsRel.getGoodsRelNprice()));
                    orderGoodsDomain.setBase_price(ocContractGoodsDomain.getGoodsCamount().multiply(rsGoodsRel.getPricesetNprice()));
                    orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
                    orderGoodsDomain.setName(rsGoodsRel.getGoodsName());
                    orderGoodsDomain.setOuter_oi_id(rsGoodsRel.getGoodsRelCode());
                    orderGoodsDomain.setPic(OrderServiceImpl.makeOcPic(ocContractGoodsDomain, picUrl));
                    if ("Presale".equals(ocContractGoodsDomain.getGoodsSpec2())) {
                        orderGoodsDomain.setRemark(ocContractGoodsDomain.getGoodsSpec3());
                        remarkmap.put("\u5546\u54c1\u7f16\u7801" + rsGoodsRel.getSkuNo(), "\u9884\u552e\u53d1\u8d27" + ocContractGoodsDomain.getGoodsSpec3());
                    }
                    orderGoodsDomains.add(orderGoodsDomain);
                }
            }
        }
        return orderGoodsDomains;
    }

    private static String makeOcPic(OcContractGoodsDomain ocContractGoodsDomain, String picUrl) {
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getDataPic())) {
            return "";
        }
        String pic = "";
        boolean isNotPre = false;
        if (StringUtils.isNotBlank((String)picUrl)) {
            String[] split;
            for (String pre : split = picUrl.split(",")) {
                if (!ocContractGoodsDomain.getDataPic().contains(pre)) continue;
                isNotPre = true;
                break;
            }
            pic = split[0];
        }
        if (isNotPre) {
            return ocContractGoodsDomain.getDataPic();
        }
        return pic + ocContractGoodsDomain.getDataPic();
    }

    @Override
    public String saveOrderBatch(List<OcContractReDomain> ocContractDomains) {
        return "success";
    }

    @Override
    public String saveOrderCancelAfterPay(OcContractReDomain ocContractDomain) {
        return this.orderUploadRequests(ocContractDomain, "TRADE_CLOSED");
    }

    private static String makeAddress(OrderUploadRequest orderUploadRequest, List<OcContractproDomain> ocContractproDomainList) {
        for (OcContractproDomain ocContractproDomain : ocContractproDomainList) {
            UmAddressReDomain umAddressReDomain;
            if (!"address".equals(ocContractproDomain.getContractproKey()) || null == (umAddressReDomain = (UmAddressReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractproDomain.getContractproValue(), UmAddressReDomain.class))) continue;
            if (StringUtils.isNotBlank((String)umAddressReDomain.getProvinceName())) {
                orderUploadRequest.setReceiver_state(umAddressReDomain.getProvinceName());
            }
            if (StringUtils.isNotBlank((String)umAddressReDomain.getCityName())) {
                orderUploadRequest.setReceiver_city(umAddressReDomain.getCityName());
            }
            if (StringUtils.isNotBlank((String)umAddressReDomain.getAreaName())) {
                orderUploadRequest.setReceiver_district(umAddressReDomain.getAreaName());
            }
            if (StringUtils.isNotBlank((String)umAddressReDomain.getRoadName())) {
                orderUploadRequest.setReceiver_town(umAddressReDomain.getRoadName());
            }
            if (!StringUtils.isNotBlank((String)umAddressReDomain.getAddressDetail())) continue;
            orderUploadRequest.setReceiver_address(umAddressReDomain.getAddressDetail());
        }
        return "success";
    }

    @Override
    public String saveOrderCancelBeforePay(OcContractReDomain ocContractDomain) {
        return this.orderUploadRequests(ocContractDomain, "TRADE_CLOSED_BY_TAOBAO");
    }

    @Override
    public String simpleOrderRe(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error("OrderServiceImpl.simpleOrderRe tenantCode is null");
            return "error";
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractProperty", "1");
            map.put("dataStateStr", "2,8");
            map.put("tenantCode", tenantCode);
            map.put("order", true);
            map.put("childFlag", true);
            QueryResult<OcContractReDomain> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getContractService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getContractService().getPage());
                result = this.queryContractPageReDomain(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getContractService().addPutPool(new ContractPutThread(this.getContractService(), result.getRows()));
                    if (result.getRows().size() == this.getContractService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
        }
        catch (Exception e) {
            throw new ApiException("OrderServiceImpl.loadDb.an.e", (Throwable)e);
        }
        finally {
            this.getContractService().initStartRow();
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractService getContractService() {
        Object object = lock;
        synchronized (object) {
            if (null == contractService) {
                contractService = new ContractService((SendOrderService)SpringApplicationContextUtil.getBean((String)"sendOrderService"));
                for (int i = 0; i < 50; ++i) {
                    contractService.addPollPool(new ContractPollThread(contractService));
                }
            }
            return contractService;
        }
    }

    @Override
    public String sendSaveMessageSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error("OrderServiceImpl.sendSaveExSendgoods is null");
            return "error";
        }
        if (ListUtil.isEmpty(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            logger.error("OrderServiceImpl.sendSaveExSendgoods.list", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            return "error";
        }
        if (null == sgSendgoodsDomain.getContractShow() || 1 != sgSendgoodsDomain.getContractShow()) {
            return "success";
        }
        ArrayList<SgSendgoodsGoodsDomain> list = new ArrayList<SgSendgoodsGoodsDomain>();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            list.add(sgSendgoodsGoodsDomain);
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("sg002");
        mnsMnslistDomainBean.setMnslistBusname("\u53d1\u8d27\u901a\u77e5");
        mnsMnslistDomainBean.setMemberCode(sgSendgoodsDomain.getMemberBcode());
        mnsMnslistDomainBean.setDataTenant(sgSendgoodsDomain.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(sgSendgoodsDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", sgSendgoodsDomain.getMemberBcode());
        listReceiver.put("name", sgSendgoodsDomain.getMemberBname());
        listReceiver.put("sendGoods", JsonUtil.buildNonEmptyBinder().toJson((Object)sgSendgoodsDomain));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        this.internalInvoke("mns.mns.sendMnslist", invokeMap);
        return "success";
    }

    public static void main(String[] args) {
        OrderServiceImpl.queryOrder();
    }

    private static void logisticQuery() {
        String url = "https://dev-api.jushuitan.com/open/logistic/query";
        String appkey = "1efbf09e32a047879711da12be4aff08";
        String secret = "ecf3e001e5414f7a8b750dc166198668";
        String access_token = "2fb0f16f7d9740c1af2c34f09570f7ca";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        OrdersOutQueryRequest ordersOutQueryRequest = new OrdersOutQueryRequest();
        ArrayList<String> so_ids = new ArrayList<String>();
        so_ids.add("1004686581414481956");
        ordersOutQueryRequest.setSo_ids(so_ids);
        ordersOutQueryRequest.setStatus("Sent");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)ordersOutQueryRequest));
        System.out.println(JsonUtil.buildNormalBinder().toJson(params));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = OrderServiceImpl.buildQuery(params);
        String responseStr = OrderServiceImpl.execute(parmStr, url);
        System.out.println(responseStr);
        OrdersOutQueryResPonse ordersOutQueryResPonse = (OrdersOutQueryResPonse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrdersOutQueryResPonse.class);
        if (null == ordersOutQueryResPonse) {
            // empty if block
        }
    }

    private static void queryOrder() {
        String url = "https://dev-api.jushuitan.com/open/orders/single/query";
        String appkey = "1efbf09e32a047879711da12be4aff08";
        String secret = "ecf3e001e5414f7a8b750dc166198668";
        String access_token = "2fb0f16f7d9740c1af2c34f09570f7ca";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        OrdersOutQueryRequest ordersOutQueryRequest = new OrdersOutQueryRequest();
        ArrayList<String> so_ids = new ArrayList<String>();
        so_ids.add("1004686581414481956");
        ordersOutQueryRequest.setSo_ids(so_ids);
        ordersOutQueryRequest.setStatus("Sent");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)ordersOutQueryRequest));
        System.out.println(JsonUtil.buildNormalBinder().toJson(params));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = OrderServiceImpl.buildQuery(params);
        String responseStr = OrderServiceImpl.execute(parmStr, url);
        System.out.println(responseStr);
        OrdersOutQueryResPonse ordersOutQueryResPonse = (OrdersOutQueryResPonse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrdersOutQueryResPonse.class);
        if (null == ordersOutQueryResPonse) {
            // empty if block
        }
    }

    private List<SgSendgoods> querySgSendgoodsPage(Map<String, Object> map) {
        String apiCode = "sg.sendgoods.querySendgoodsPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isBlank((String)s)) {
            logger.error("OrderServiceImpl.querySgSendgoodsPage is null");
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, SupQueryResult.class);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), SgSendgoods.class);
        return list;
    }

    private void sendSendgoodsBack(String sendgoodsCode, String tenantCode, HashMap<String, Object> map) {
        String apiCode = "sg.sendgoodsEngine.sendSendgoodsBack";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sendgoodsCode", sendgoodsCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void simpleOrderReJst(String tenantCode, Map<String, String> map) {
        if (MapUtil.isEmpty(map)) {
            logger.error("OrderServiceImplsimpleOrderReJst param is null");
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error("OrderServiceImplsimpleOrderReJst tenantCode is null");
            return;
        }
        String apiCode = "sg.sendgoods.simpleOrderReJst";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        paramMap.put("tenantCode", tenantCode);
        String s = this.internalInvoke(apiCode, paramMap);
        logger.error("OrderServiceImpl.simpleOrderReJst." + s, (Object)((Object)paramMap).toString());
    }

    private static String getDataStr(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private static String getState(Integer dataState) {
        if (1 == dataState) {
            return "WAIT_BUYER_PAY";
        }
        if (2 == dataState) {
            return "WAIT_SELLER_SEND_GOODS";
        }
        if (3 == dataState) {
            return "WAIT_BUYER_CONFIRM_GOODS";
        }
        if (4 == dataState) {
            return "TRADE_FINISHED";
        }
        if (-1 == dataState) {
            return "TRADE_CLOSED";
        }
        return "error";
    }

    private static String contractState(String dataState) {
        if ("WAIT_BUYER_PAY" == dataState) {
            return "1";
        }
        if ("WAIT_SELLER_SEND_GOODS" == dataState) {
            return "2";
        }
        if ("WAIT_BUYER_CONFIRM_GOODS" == dataState) {
            return "3";
        }
        if ("TRADE_FINISHED" == dataState) {
            return "4";
        }
        if ("TRADE_CLOSED" == dataState) {
            return "-1";
        }
        return "-3";
    }

    static {
        lock = new Object();
    }
}

