/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusOrderService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "busdata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        RestTempfacade restTempfacade = new RestTempfacade(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        OcContractRequest ocContractRequest = new OcContractRequest();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractRequest, (Object)ocContractDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusOrder.e", (Object)e);
            return "error";
        }
        OcContractResponse ocContractResponse = restTempfacade.execute(ocContractRequest);
        if (null == ocContractResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse", (Object)ocContractResponse.getMsg());
            return ocContractResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        RestTempfacade restTempfacade = new RestTempfacade(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        RestTempfacade restTempfacade = new RestTempfacade(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        RestTempfacade restTempfacade = new RestTempfacade(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }
}

