/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhOpstoreRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhWarehouseRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhOpstoreResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhWarehouseResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusStoreService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.StoreBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;

public class BusStoreServiceImpl
extends StoreBaseService
implements BusStoreService {
    private String SYS_CODE = "busdata.BusStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusStoreServiceImpl.class);
    private String ddcode = "store";

    @Override
    public String sendSaveBusWarehouse(WhWarehouseReDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseDomain");
            return "error";
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        RestTempfacade restTempfacade = new RestTempfacade(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        WhWarehouseRequest whWarehouseRequest = new WhWarehouseRequest();
        try {
            BeanUtils.copyAllPropertys((Object)whWarehouseRequest, (Object)whWarehouseDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        WhWarehouseResponse whWarehouseResponse = restTempfacade.execute(whWarehouseRequest);
        if (null == whWarehouseResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse");
            return "error";
        }
        if (!whWarehouseResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse", (Object)whWarehouseResponse.getMsg());
            return whWarehouseResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusOpstore(WhOpstoreReDomain whOpstoreReDomain) {
        if (null == whOpstoreReDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstore.WhWarehouseDomain");
            return "error";
        }
        String tenantCode = whOpstoreReDomain.getTenantCode();
        RestTempfacade restTempfacade = new RestTempfacade(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        WhOpstoreRequest whOpstoreRequest = new WhOpstoreRequest();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreRequest, (Object)whOpstoreReDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.e", (Object)e);
            return "error";
        }
        WhOpstoreResponse whOpstoreResponse = restTempfacade.execute(whOpstoreRequest);
        if (null == whOpstoreResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse");
            return "error";
        }
        if (!whOpstoreResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse", (Object)whOpstoreResponse.getMsg());
            return whOpstoreResponse.getMsg();
        }
        return "success";
    }
}

