/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.util;

import com.yqbsoft.laser.service.ext.bus.data.util.TrustAllCerts;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RequestUtils {
    static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);
    static final String SYS_CODE = "RequestUtils";

    public static Map<String, Object> makeHeader(String interfaceId) {
        HashMap<String, Object> apiHeader = new HashMap<String, Object>();
        apiHeader.put("dtsend", DateUtil.getDateString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        apiHeader.put("receiver", "S4");
        apiHeader.put("sender", "MPF");
        apiHeader.put("message_id", UUID.randomUUID().toString());
        apiHeader.put("interface_id", interfaceId);
        return apiHeader;
    }

    public static String makeRequestBody(Map<String, Object> header, Map<String, Object> data) {
        HashMap<String, Map<String, Object>> requestBodyMap = new HashMap<String, Map<String, Object>>();
        requestBodyMap.put("header", header);
        requestBodyMap.put("data", data);
        return JsonUtil.buildNormalBinder().toJson(requestBodyMap);
    }

    public static Map<String, String> makeApiHeader() {
        HashMap<String, String> requestBodyMap = new HashMap<String, String>();
        requestBodyMap.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])"MPF_WS:Swiftpo@2021".getBytes()));
        return requestBodyMap;
    }

    public static void main(String[] args) {
        String url = "https://testinterfacem.hbisscm.com/inf/external/sms/aliyun/SendSms";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("phoneNumbers", "19065423076");
        map.put("signName", "\u5e9f\u94a2\u4f9b\u5e94\u94fe\u5e73\u53f0");
        map.put("templateCode", "SMS_221735700");
        map.put("templateParam", "{'p0':'111111'}");
        String bodyParams = JsonUtil.buildNormalBinder().toJson(map);
        System.out.println(RequestUtils.postForEntity(url, bodyParams));
    }

    public static Map<String, Object> postForEntity(String url, String requestBody) {
        HttpHeaders headers = RequestUtils.getHttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("haccid", "344");
        headers.add("hacckey", "59f8ac99e9d74337be76141345446db6");
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        HashMap<String, Object> resHashMap = new HashMap<String, Object>();
        try {
            RestTemplate client = RequestUtils.getRestTemplate();
            client.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            responseEntity = client.postForEntity(url, (Object)requestEntity, Map.class, new Object[0]);
            logger.error("RequestUtils.postForEntity.responseEntity", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)responseEntity));
        }
        catch (Exception e) {
            logger.error("RequestUtils.e", (Object)(url + ":" + requestBody), (Object)e);
            resHashMap.put("code", "0001");
            resHashMap.put("msg", "\u8fde\u63a5\u4fe1\u606f\u6709\u8bef");
            logger.error("RequestUtils.postForEntity.resHashMap", (Object)JsonUtil.buildNonDefaultBinder().toJson(resHashMap));
            return resHashMap;
        }
        if (responseEntity == null || responseEntity.getBody() == null) {
            logger.error("RequestUtils.responseEntity.isnull", (Object)(url + ":" + requestBody));
            resHashMap.put("code", "0002");
            resHashMap.put("msg", "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            logger.error("RequestUtils.postForEntity.resHashMap", (Object)JsonUtil.buildNonDefaultBinder().toJson(resHashMap));
            return resHashMap;
        }
        System.out.println("responseEntity:" + responseEntity);
        Map body = (Map)responseEntity.getBody();
        logger.error("RequestUtils.postForEntity.body", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)body));
        System.out.println(body.get("data"));
        Integer status = (Integer)body.get("status");
        return null;
    }

    public static RestTemplate getRestTemplate() throws NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient httpClient = RequestUtils.createTrustingHttpClient();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    public static CloseableHttpClient createTrustingHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = RequestUtils.createTrustAllSSLContext();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
    }

    public static SSLContext createTrustAllSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
        return sslContext;
    }

    public static HttpHeaders getHttpHeaders() {
        return new HttpHeaders();
    }
}

