/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.data.util.UserInfo;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.pdf.PdfConverter;
import org.apache.poi.xwpf.converter.pdf.PdfOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WordUtil3 {
    private static final Configuration CONFIGURATION = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public static String generate(String templateFileName, Object templateParam) throws ApiException {
        Writer wordTemplateWriter = null;
        try {
            Template t = CONFIGURATION.getTemplate(templateFileName, "utf-8");
            ByteArrayOutputStream wordOutputStream = new ByteArrayOutputStream();
            wordTemplateWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)wordOutputStream, StandardCharsets.UTF_8));
            t.process(templateParam, wordTemplateWriter);
            ByteArrayInputStream wordInputStream = new ByteArrayInputStream(wordOutputStream.toByteArray());
            XWPFDocument doc = new XWPFDocument((InputStream)wordInputStream);
            WordUtil3.replacePlaceholders(doc, templateParam);
            byte[] pdfBytes = WordUtil3.convertWordToPdf(doc);
            String string = Base64.getEncoder().encodeToString(pdfBytes);
            return string;
        }
        catch (TemplateException | IOException e) {
            throw new ApiException("\u751f\u6210Word\u6587\u6863\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage(), e);
        }
        finally {
            if (wordTemplateWriter != null) {
                try {
                    wordTemplateWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void replacePlaceholders(XWPFDocument doc, Object templateParam) {
        Map params;
        if (templateParam instanceof Map && !CollectionUtils.isEmpty((Map)(params = (Map)templateParam))) {
            WordUtil3.replaceParagraphPlaceholders(doc.getParagraphs(), params);
            for (XWPFTable table : doc.getTables()) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        WordUtil3.replaceParagraphPlaceholders(cell.getParagraphs(), params);
                    }
                }
            }
        }
    }

    private static void replaceParagraphPlaceholders(List<XWPFParagraph> paragraphs, Map<String, String> params) {
        for (XWPFParagraph p : paragraphs) {
            for (XWPFRun r : p.getRuns()) {
                String content = r.getText(r.getTextPosition());
                if (!StringUtils.hasText((String)content) || !params.containsKey(content)) continue;
                r.setText(params.get(content), 0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] convertWordToPdf(XWPFDocument doc) throws ApiException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            PdfOptions options = PdfOptions.create();
            PdfConverter.getInstance().convert(doc, (OutputStream)out, (Options)options);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ApiException("\u5c06Word\u6587\u6863\u8f6c\u6362\u4e3aPDF\u65f6\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
            UserInfo userInfo = new UserInfo();
            userInfo.setId("1");
            userInfo.setName("\u529e\u516c\u684c\u9762\u7f6e\u7269\u67b6\u6587\u4ef6\u6536\u7eb3\u67b6\u6587\u4ef6\u6536\u7eb3\u76d2\u529e\u516c\u7528\u54c1");
            userInfo.setNumber("2.000000");
            userInfo.setPrice("1 7.90000000");
            userInfo.setAmount("35.80000000");
            userInfo.setAmountIncludingTax("35.80000000");
            userInfo.setMaterialCode("90348454 9527101606422");
            userInfo.setContractGoodsRemark("\u65e0");
            userInfo.setDeliveryTime(new Date().toString());
            userList.add(userInfo);
            HashMap<String, Object> templateParam = new HashMap<String, Object>(5);
            templateParam.put("date", "2024-11-19");
            templateParam.put("total", 1);
            templateParam.put("userList", userList);
            templateParam.put("businessOrderno", "908416100693377064");
            templateParam.put("orderNumber", "908416100693377064");
            templateParam.put("sellers", "\u5546\u5bb6\u8d26\u53f7\u6f14\u793a");
            templateParam.put("buyers", "18516538888");
            templateParam.put("placeOfSigning", "\u4e0a\u6d77");
            templateParam.put("dateOfSigning", "2024-11-14  17:38:03");
            templateParam.put("totalAmount", 35.8);
            templateParam.put("totalAmountIncludingTax", "w8");
            templateParam.put("rate", "1");
            templateParam.put("totalAmountUpper", 35.8);
            String templateFileName = "generate_word_test.xml";
            String base64EncodedPdf = WordUtil3.generate(templateFileName, templateParam);
            System.out.println("Base64\u7f16\u7801\u540e\u7684PDF\u5185\u5bb9: " + base64EncodedPdf);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
    }

    static {
        CONFIGURATION.setDefaultEncoding("utf-8");
        CONFIGURATION.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(WordUtil3.class, "/templates"));
    }

    public static class WordGenerationException
    extends Exception {
        public WordGenerationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

