/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.api.ExOrderService;
import com.yqbsoft.laser.service.ext.bus.data.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.crp.CrpUrechargelistReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.dd.DdFalgSetting;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcPackageDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundSettlDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.pay.PteBalancelistOpReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsPackageDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.SgU9Domain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoapply;
import com.yqbsoft.laser.service.ext.bus.data.domain.vd.VdFaccountInfo;
import com.yqbsoft.laser.service.ext.bus.data.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.CollectionUtils;

public class ExOrderServiceImpl
extends OrderBaseService
implements ExOrderService {
    private String SYS_CODE = "busdata.ExOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExOrderServiceImpl.class);

    @Override
    public SupQueryResult<OcRefundReDomain> queryExRefund(String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, String refundGoodsType, String contractBillcode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (refundGoodsType != null) {
            map.put("refundType", refundGoodsType);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("tenantCode", tenantCode);
        return this.queryOcRefundPage(map);
    }

    @Override
    public String updateExSendgoods(String sendgoodsCode, String expressName, String expressCode, String packageBillno, String sendgoodsGetdate) {
        SgSendgoodsGoods sg = this.getSendgoodsGoodsByCode(sendgoodsCode);
        if (null == sg) {
            return "\u53d1\u8d27\u5355\u3010" + sendgoodsCode + "\u3011\u4e0d\u5b58\u5728";
        }
        SgSendgoodsPackageDomain sgSendgoodsPackageDomain = new SgSendgoodsPackageDomain();
        sgSendgoodsPackageDomain.setTenantCode(sg.getTenantCode());
        return "success";
    }

    @Override
    public String sendSaveExSgSendgoodsPackage(SgSendgoodsPackageDomain sendgoodsPackageDomain) {
        if (null == sendgoodsPackageDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoodsPackageDomain(sendgoodsPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage.msg", msg);
        }
        this.sendSaveSendgoodsPackage(sendgoodsPackageDomain);
        return this.sendSendgoodsNext(sendgoodsPackageDomain.getSendgoodsCode(), sendgoodsPackageDomain.getTenantCode(), null);
    }

    private String checkSendgoodsPackageDomain(SgSendgoodsPackageDomain sendgoodsPackageDomain) {
        String msg = "";
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getSendgoodsCode())) {
            msg = msg + "\u53d1\u8d27\u5355\u53f7 sendgoodsCode \u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u53f7 tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getExpressCode())) {
            msg = msg + "\u7269\u6d41\u516c\u53f8\u4ee3\u7801 expressCode \u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getExpressName())) {
            msg = msg + "\u7269\u6d41\u516c\u53f8\u540d\u79f0 expressName \u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getPackageBillno())) {
            msg = msg + "\u7269\u6d41\u5355\u53f7 packageBillno \u4e3a\u7a7a\uff01";
        }
        return msg;
    }

    @Override
    public SupQueryResult<SgSendgoodsReDomain> queryContractsChange(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, String contractBillcode, String tenantCode) {
        logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime + "--dwEndTime" + dwEndTime + "--orderStatus" + orderStatus);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode != null) {
            map.put("memberCcode", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsProFlag", true);
        map.put("goodsFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("sg.sendgoods.querySgSendgoodsPageReDomain", pMap, SgSendgoodsReDomain.class);
        if (ocContractReDomainSupQueryResult == null) {
            return new SupQueryResult();
        }
        if (ocContractReDomainSupQueryResult.getRows() == null) {
            return new SupQueryResult();
        }
        logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomainSupQueryResult));
        return ocContractReDomainSupQueryResult;
    }

    @Override
    public String sendSaveExOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)(msg + "===" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain)));
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            msg = this.makeOcContractDomain(ocContractDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", (Object)(msg + "=====" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain)));
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", msg);
            }
            String contractBillcode = this.saveOrder(ocContractDomain);
            if (StringUtils.isBlank((String)contractBillcode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.contractBillcode" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(contractBillcode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendContractState(String contractNbillcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type)) {
            logger.error(this.SYS_CODE + ".sendContractState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendContractState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String contractBillcode = null;
        String msg = this.checkQueryContract(contractNbillcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,channelCode", new Object[]{contractNbillcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        contractBillcode = ((OcContractReDomain)qlist.getList().get(0)).getContractBillcode();
        try {
            if (type.equals("AN")) {
                this.orderNext(contractBillcode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.orderBack(contractBillcode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendRefundState(String refundNcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type) || MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendRefundState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = null;
        String msg = this.checkQueryRefund(refundNcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendRefundState.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", msg);
        }
        QueryResult<OcRefundReDomain> qlist = this.queryRefundPage(this.getQueryMapParam("refundNcode,tenantCode,channelCode", new Object[]{refundNcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", "refundNcode[" + refundNcode + "]\u4e0d\u5b58\u5728! ");
        }
        refundCode = ((OcRefundReDomain)qlist.getList().get(0)).getRefundCode();
        try {
            if (type.equals("AN")) {
                this.refundNext(refundCode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.refundBack(refundCode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExRefund(String ocRefundDomains) {
        if (StringUtils.isBlank((String)ocRefundDomains)) {
            LogRouterlogDomain logRouterlogDomain = this.creteLogRouterlogDomain(ocRefundDomains, "busdata.exOrder.sendSaveExRefund", "", "u9->\u9000\u8d27\u63a5\u53e3\u56de\u4f20");
            logRouterlogDomain.setRouterlogReturn("\u53c2\u6570\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundDomain ocRefundDomain = (OcRefundDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(ocRefundDomains, OcRefundDomain.class);
        LogRouterlogDomain logRouterlogDomain = this.creteLogRouterlogDomain(JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain), "busdata.exOrder.sendSaveExRefund", ocRefundDomain.getRefundOcode(), "u9->\u9000\u8d27\u63a5\u53e3\u56de\u4f20");
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logRouterlogDomain.setRouterlogReturn(msg);
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendSaveExRefund.msg", (Object)msg);
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.msg", msg);
        }
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomainList = new ArrayList<OcRefundSettlDomain>();
        OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
        ocRefundSettlDomain.setTenantCode(ComConstants.tenantCode);
        ocRefundSettlDomain.setContractSettlOpno(this.queryAccountId(ocRefundDomain));
        ocRefundSettlDomain.setMemberBcode(ocRefundDomain.getMemberBcode());
        ocRefundSettlDomain.setMemberBname(ocRefundDomain.getMemberBname());
        ocRefundSettlDomain.setMemberCode("20000210463648");
        ocRefundSettlDomain.setContractSettlType("0");
        ocRefundSettlDomain.setContractSettlBlance("VD");
        ocRefundSettlDomain.setContractPmode("0");
        ocRefundSettlDomain.setContractSettlGmoney(ocRefundDomain.getRefundMoney());
        ocRefundSettlDomain.setContractSettlPmoney(ocRefundDomain.getRefundMoney());
        ocRefundSettlDomain.setContractSettlOpemo("01");
        ocRefundSettlDomain.setRefundSettlBillcode(ocRefundDomain.getRefundOcode());
        ocRefundSettlDomain.setContractSettlBillcode(ocRefundDomain.getRefundOcode());
        ocRefundSettlDomain.setContractBillcode(StringUtils.isBlank((String)ocRefundDomain.getContractBillcode()) ? ocRefundDomain.getRefundOcode() : ocRefundDomain.getContractBillcode());
        ocRefundSettlDomainList.add(ocRefundSettlDomain);
        ocRefundDomain.setOcRefundSettlDomainList(ocRefundSettlDomainList);
        ocRefundDomain.setTenantCode(ComConstants.tenantCode);
        ocRefundDomain.setRefundType("U07");
        ocRefundDomain.setGoodsClass("B2B");
        ocRefundDomain.setRefundUmoney(ocRefundDomain.getRefundMoney());
        ocRefundDomain.setMemberCode(ComConstants.membercode);
        try {
            msg = this.makeOcRefundDomain(ocRefundDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logRouterlogDomain.setRouterlogReturn(msg);
                logRouterlogDomain.setRouterlogReturnstate("-1");
                logRouterlogDomain.setRouterlogReturnstates("error");
                this.sendLog(logRouterlogDomain);
                logger.error(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", (Object)msg);
                throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", msg);
            }
            ocRefundDomain.setGoodsClass("B2B");
            String refundCode = this.saveRefund(ocRefundDomain);
            if (StringUtils.isBlank((String)refundCode)) {
                logRouterlogDomain.setRouterlogReturn("refundCode is null");
                logRouterlogDomain.setRouterlogReturnstate("-1");
                logRouterlogDomain.setRouterlogReturnstates("error");
                this.sendLog(logRouterlogDomain);
                logger.error(this.SYS_CODE + ".sendSaveExRefund.refundCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.refundCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            logRouterlogDomain.setRouterlogReturn("\u9000\u8d27\u7ed3\u679c\u63a5\u6536\u6210\u529f");
            logRouterlogDomain.setRouterlogReturnstate("200");
            logRouterlogDomain.setRouterlogReturnstates("OK");
            this.sendLog(logRouterlogDomain);
            return this.makeSuccessReturn(refundCode);
        }
        catch (ApiException e) {
            logRouterlogDomain.setRouterlogReturn(e.getErrCode() + "==" + e.getErrMsg());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.e", e.getErrCode() + e.getErrMsg());
        }
        catch (Exception e) {
            logRouterlogDomain.setRouterlogReturn(e.getMessage());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e1", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExRefund.e1", e.getMessage());
        }
    }

    private String makeRefundSett(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain || ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList()) || StringUtils.isBlank((String)ocRefundDomain.getContractBbillcode())) {
            logger.error(this.SYS_CODE + ".makeRefundSett", (Object)"ocRefundDomain is null");
            return "\u6570\u636e\u4e3a\u7a7a";
        }
        if (null == ocRefundDomain.getRefundMoney()) {
            logger.error(this.SYS_CODE + ".makeRefundSett.refundMoney", (Object)"refundMoney is null");
            return "\u9000\u6b3e\u91d1\u989d\u4e3a\u7a7a";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", ComConstants.tenantCode);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ComConstants.tenantCode);
        paramMap.put("childFlag", "true");
        paramMap.put("contractBillcode", ocRefundDomain.getContractBbillcode());
        QueryResult<OcContractReDomain> ocContractReDomainQuer = this.queryOrderReDomainPage(paramMap);
        if (null == ocContractReDomainQuer || ListUtil.isEmpty((Collection)ocContractReDomainQuer.getList())) {
            logger.error(this.SYS_CODE + ".makeRefundSett.map", paramMap);
            return "\u8ba2\u5355\u7f16\u7801\u9519\u8bef";
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)ocContractReDomainQuer.getList().get(0);
        if (ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
            logger.error(this.SYS_CODE + ".makeRefundSett.goodsList", paramMap);
            return "\u8ba2\u5355\u7f16\u7801\u9519\u8bef";
        }
        String contractBlance = ocContractReDomain.getContractBlance();
        List<OcContractSettlDomain> seetList = ocContractReDomain.getOcContractSettlList();
        if (ListUtil.isEmpty(seetList) && "0".equals(contractBlance)) {
            logger.error(this.SYS_CODE + ".makeRefundSett.map", map);
            return "\u7ed3\u7b97\u4fe1\u606f\u9519\u8bef";
        }
        Map<String, List<OcContractSettlDomain>> groupedByBalance = seetList.stream().collect(Collectors.groupingBy(OcContractSettlDomain::getContractSettlBlance));
        if (ocRefundDomain.getRefundMoney().compareTo(BigDecimal.ZERO) < 0) {
            return "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570";
        }
        ocRefundDomain.setRefundType("U09");
        try {
            this.makeRefundGoodsList(ocRefundDomain, ocContractReDomain);
            ArrayList<OcContractSettlDomain> list = new ArrayList<OcContractSettlDomain>();
            String code = null;
            if (StringUtils.isNotBlank((String)contractBlance) && "3".equals(contractBlance)) {
                HashMap<String, Object> mapStr = new HashMap<String, Object>();
                mapStr.put("fchannelClassifyCode", "DCRP");
                mapStr.put("dataState", "0");
                mapStr.put("tenantCode", ocContractReDomain.getTenantCode());
                mapStr.put("rechargeOpcode", ocContractReDomain.getContractBillcode());
                mapStr.put("rechargeCategory", "4");
                mapStr.put("urechargelistDir", "1");
                QueryResult<CrpUrechargelistReDomain> crpUrechargelistReDomainQueryResult = this.queryCrpUrechargelistPage(mapStr);
                if (ListUtil.isNotEmpty((Collection)crpUrechargelistReDomainQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".makeRefundSett.crpUrechargelistReDomainSupQueryResult", mapStr);
                    return "OA \u6709\u672a\u5ba1\u6838\u5b8c\u6210\u7684\u8ba2\u5355\u4e0d\u80fd\u9000\u6b3e";
                }
                if (ListUtil.isNotEmpty(seetList)) {
                    for (OcContractSettlDomain ocContractSettlDomain : seetList) {
                        if ("FCVD".equals(ocContractSettlDomain.getContractSettlBlance())) {
                            if (null == ocContractSettlDomain.getContractSettlArmoney()) {
                                ocContractSettlDomain.setContractSettlArmoney(BigDecimal.ZERO);
                            }
                            ocContractSettlDomain.setContractSettlBlance("VD");
                            list.add(ocContractSettlDomain);
                        }
                        if ("FCCRP".equals(ocContractSettlDomain.getContractSettlBlance())) {
                            if (null == ocContractSettlDomain.getContractSettlArmoney()) {
                                ocContractSettlDomain.setContractSettlArmoney(BigDecimal.ZERO);
                            }
                            ocContractSettlDomain.setContractSettlBlance("CRP");
                            list.add(ocContractSettlDomain);
                        }
                        if ("FCDCRP".equals(ocContractSettlDomain.getContractSettlBlance())) {
                            if (null == ocContractSettlDomain.getContractSettlArmoney()) {
                                ocContractSettlDomain.setContractSettlArmoney(BigDecimal.ZERO);
                            }
                            ocContractSettlDomain.setContractSettlBlance("FCDCRP");
                            list.add(ocContractSettlDomain);
                        }
                        if (!"FCGCRP".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                        if (null == ocContractSettlDomain.getContractSettlArmoney()) {
                            ocContractSettlDomain.setContractSettlArmoney(BigDecimal.ZERO);
                        }
                        ocContractSettlDomain.setContractSettlBlance("GCRP");
                        list.add(ocContractSettlDomain);
                    }
                }
                code = this.makeSeetlListFC(ocRefundDomain, ocContractReDomain, groupedByBalance, list);
            } else if (StringUtils.isNotBlank((String)contractBlance) && "4".equals(contractBlance)) {
                if (ListUtil.isNotEmpty(seetList)) {
                    for (OcContractSettlDomain ocContractSettlDomain : seetList) {
                        if (!"VD".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                        if (null == ocContractSettlDomain.getContractSettlArmoney()) {
                            ocContractSettlDomain.setContractSettlArmoney(BigDecimal.ZERO);
                        }
                        list.add(ocContractSettlDomain);
                    }
                }
                if (null == groupedByBalance) {
                    groupedByBalance = new HashMap<String, List<OcContractSettlDomain>>();
                }
                groupedByBalance.remove("VD");
                code = this.makeSeetlListXH(ocRefundDomain, ocContractReDomain, groupedByBalance, list);
            } else {
                code = this.makeSeetlList(ocRefundDomain, ocContractReDomain, groupedByBalance);
            }
            if (!"success".equals(code)) {
                logger.error(this.SYS_CODE + ".makeRefundSett.code", (Object)code);
                return code;
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".makeRefundSett.ex", (Throwable)e);
            return "\u6570\u636e\u5f02\u5e38";
        }
        return "success";
    }

    public Map<String, OcRefundGoodsDomain> refundGoodsMap(List<OcRefundGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            logger.error(this.SYS_CODE + ".contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcRefundGoodsDomain> map = new HashMap<String, OcRefundGoodsDomain>();
        for (OcRefundGoodsDomain refundGoodsDomain : goodsList) {
            map.put(refundGoodsDomain.getSkuNo(), refundGoodsDomain);
        }
        return map;
    }

    private String makeSeetlList(OcRefundDomain ocRefundDomain, OcContractReDomain ocContractReDomain, Map<String, List<OcContractSettlDomain>> groupedByBalance) {
        OcRefundSettlDomain ocRefundSettlDo;
        Boolean flag = true;
        BigDecimal rebMoney = BigDecimal.ZERO;
        Map<String, OcRefundGoodsDomain> refundGoodsMap = this.refundGoodsMap(ocRefundDomain.getOcRefundGoodsDomainList());
        Boolean giftFlag = false;
        Boolean sendNumFlag = false;
        Map<String, OcContractGoodsDomain> contractGoodsMapStr = this.contractGoodsMap(ocContractReDomain.getGoodsList());
        BigDecimal refuddMoneyStr = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = contractGoodsMapStr.get(ocRefundGoodsDomain.getSkuNo());
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsArefnum())) {
                ocContractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            BigDecimal goodsMoney = ocRefundGoodsDomain.getRefundGoodsAmt();
            BigDecimal surAplyMoney = ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsAremoney());
            if (surAplyMoney.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".saveRefund.skuNo.makeSeetlList", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            if (surAplyMoney.compareTo(goodsMoney) != -1) {
                refuddMoneyStr = refuddMoneyStr.add(goodsMoney);
                continue;
            }
            logger.error(this.SYS_CODE + ".saveRefund.skuNo1.makeSeetlList", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney + "goodsMoney:" + goodsMoney));
            return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
        }
        BigDecimal discount = refuddMoneyStr.divide(ocContractReDomain.getDataBmoney(), 2, 4);
        for (OcContractGoodsDomain contractGoodsDomain : ocContractReDomain.getGoodsList()) {
            if ("1".equals(contractGoodsDomain.getContractGoodsGtype()) || !EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsValueNum()) && contractGoodsDomain.getContractGoodsValueNum().compareTo(BigDecimal.ZERO) == 1) {
                giftFlag = true;
            }
            if (!EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsSendnum()) && contractGoodsDomain.getContractGoodsSendnum().compareTo(BigDecimal.ZERO) == 1) {
                sendNumFlag = true;
            }
            BigDecimal reNum = BigDecimal.ZERO;
            BigDecimal refNum = BigDecimal.ZERO;
            if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsArefnum())) {
                contractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            if (!EmptyUtil.isEmpty((Object)refundGoodsMap.get(contractGoodsDomain.getSkuNo()))) {
                BigDecimal userRebMoney;
                OcRefundGoodsDomain ocRefundGoodsDomain = refundGoodsMap.get(contractGoodsDomain.getSkuNo());
                refNum = ocRefundGoodsDomain.getRefundGoodsNum();
                reNum = contractGoodsDomain.getGoodsCamount().subtract(contractGoodsDomain.getContractGoodsArefnum().add(refNum));
                if (!ListUtil.isNotEmpty((Collection)groupedByBalance.get("REB")) || !"yes".equals(contractGoodsDomain.getContractGoodsValue())) continue;
                if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getGoodsAhnum())) {
                    logger.error(this.SYS_CODE + ".makeSeetlList.pre:skuNo:" + contractGoodsDomain.getSkuNo());
                    return "\u4fe1\u606f\u5f02\u5e381";
                }
                if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getApplyRebmoney())) {
                    contractGoodsDomain.setApplyRebmoney(BigDecimal.ZERO);
                }
                if ((userRebMoney = contractGoodsDomain.getContractGoodsPefmoney().subtract(contractGoodsDomain.getContractGoodsMoney()).multiply(discount).setScale(4, 4)).compareTo(BigDecimal.ZERO) != 1) continue;
                logger.error(this.SYS_CODE + ".makeSeetlList.userRebMoney:userRebMoney:" + userRebMoney + "discount" + discount);
                BigDecimal rebPrice = userRebMoney.divide(contractGoodsDomain.getGoodsNum(), 4, 4);
                BigDecimal surRebMoney = userRebMoney.subtract(contractGoodsDomain.getApplyRebmoney());
                logger.error(this.SYS_CODE + ".makeSeetlList.surRebMoney8:rebPrice:" + rebPrice + "surRebMoney:" + surRebMoney);
                if (rebPrice.compareTo(BigDecimal.ZERO) != 1 && surRebMoney.compareTo(BigDecimal.ZERO) == 1) {
                    logger.error(this.SYS_CODE + ".makeSeetlList.userRebMoney:userRebMoney:" + userRebMoney);
                    ocRefundGoodsDomain.setApplyRebmoney(surRebMoney);
                    rebMoney = rebMoney.add(surRebMoney);
                    continue;
                }
                if (rebPrice.compareTo(BigDecimal.ZERO) != 1 || surRebMoney.compareTo(BigDecimal.ZERO) != 1) continue;
                logger.error(this.SYS_CODE + ".makeSeetlList.surRebMoney12:rebPrice:" + rebPrice + "surRebMoney:" + surRebMoney);
                BigDecimal kRefMoney = rebPrice.multiply(refNum).setScale(2, 4);
                if (kRefMoney.compareTo(surRebMoney) != -1) {
                    logger.error(this.SYS_CODE + ".makeSeetlList.userRebMoney1:surRebMoney:" + surRebMoney);
                    ocRefundGoodsDomain.setApplyRebmoney(surRebMoney);
                    rebMoney = rebMoney.add(surRebMoney);
                    continue;
                }
                logger.error(this.SYS_CODE + ".makeSeetlList.kRefMoney:kRefMoney:" + kRefMoney);
                ocRefundGoodsDomain.setApplyRebmoney(kRefMoney);
                rebMoney = rebMoney.add(kRefMoney);
                continue;
            }
            reNum = contractGoodsDomain.getGoodsCamount().subtract(contractGoodsDomain.getContractGoodsArefnum());
        }
        logger.error(this.SYS_CODE + ".makeSeetlList.surRebMoney458:rebMoney:" + rebMoney);
        List<OcContractSettlDomain> list = groupedByBalance.get("DCRP");
        if (ListUtil.isNotEmpty(list) && list.size() > 1) {
            logger.error(this.SYS_CODE + ".makeSeetlList.dCrpSettlList:", (Object)JsonUtil.buildNormalBinder().toJson(list));
            return "\u4fe1\u606f\u5f02\u5e384";
        }
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomainList = new ArrayList<OcRefundSettlDomain>();
        BigDecimal finalDCrpMoney = BigDecimal.ZERO;
        BigDecimal finalVdMoney = BigDecimal.ZERO;
        BigDecimal finalCrpMoney = BigDecimal.ZERO;
        BigDecimal finalGCrpMoney = BigDecimal.ZERO;
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractReDomain.getGoodsList());
        BigDecimal refuddMoney = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = contractGoodsMap.get(ocRefundGoodsDomain.getSkuNo());
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsArefnum())) {
                ocContractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            BigDecimal goodsMoney = ocRefundGoodsDomain.getRefundGoodsAmt();
            BigDecimal surAplyMoney = ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsAremoney());
            if (surAplyMoney.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".saveRefund.skuNo", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            if (surAplyMoney.compareTo(goodsMoney) == -1) {
                logger.error(this.SYS_CODE + ".saveRefund.skuNo1", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney + "goodsMoney:" + goodsMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            refuddMoney = refuddMoney.add(goodsMoney);
            ocRefundGoodsDomain.setContractBillcode(ocContractGoodsDomain.getContractBillcode());
        }
        logger.error(this.SYS_CODE + "refuddMoney===", (Object)refuddMoney);
        if (refuddMoney.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal vdPMoney;
            OcContractSettlDomain vdSettl;
            List<OcContractSettlDomain> vdSettlList;
            if (ListUtil.isNotEmpty(list)) {
                OcContractSettlDomain dCrpSettl = list.get(0);
                BigDecimal dCrpPMoney = dCrpSettl.getContractSettlPmoney();
                vdSettlList = groupedByBalance.get("VD");
                if (ListUtil.isEmpty(vdSettlList)) {
                    finalDCrpMoney = refuddMoney;
                } else {
                    vdSettl = vdSettlList.get(0);
                    vdPMoney = vdSettl.getContractSettlPmoney();
                    BigDecimal allMoney = vdPMoney.add(dCrpPMoney);
                    BigDecimal skuDiscount = refuddMoney.multiply(dCrpPMoney).divide(allMoney, 2, 4);
                    if (skuDiscount.compareTo(refuddMoney) == 1) {
                        skuDiscount = refuddMoney;
                    }
                    finalDCrpMoney = skuDiscount;
                    finalVdMoney = refuddMoney.subtract(skuDiscount);
                }
            } else if (ListUtil.isNotEmpty((Collection)groupedByBalance.get("CRP"))) {
                OcContractSettlDomain crpSettl = groupedByBalance.get("CRP").get(0);
                BigDecimal crpPMoney = crpSettl.getContractSettlPmoney();
                vdSettlList = groupedByBalance.get("VD");
                if (ListUtil.isEmpty(vdSettlList)) {
                    finalCrpMoney = refuddMoney;
                } else {
                    vdSettl = vdSettlList.get(0);
                    vdPMoney = vdSettl.getContractSettlPmoney();
                    BigDecimal allMoney = vdPMoney.add(crpPMoney);
                    BigDecimal skuDiscount = refuddMoney.multiply(crpPMoney).divide(allMoney, 2, 4);
                    if (skuDiscount.compareTo(refuddMoney) == 1) {
                        skuDiscount = refuddMoney;
                    }
                    finalCrpMoney = skuDiscount;
                    finalVdMoney = refuddMoney.subtract(skuDiscount);
                }
            } else if (ListUtil.isNotEmpty((Collection)groupedByBalance.get("GCRP"))) {
                OcContractSettlDomain gCrpSettl = groupedByBalance.get("GCRP").get(0);
                BigDecimal gCrpPMoney = gCrpSettl.getContractSettlPmoney();
                vdSettlList = groupedByBalance.get("VD");
                if (ListUtil.isEmpty(vdSettlList)) {
                    finalGCrpMoney = refuddMoney;
                } else {
                    vdSettl = vdSettlList.get(0);
                    vdPMoney = vdSettl.getContractSettlPmoney();
                    BigDecimal allMoney = vdPMoney.add(gCrpPMoney);
                    BigDecimal skuDiscount = refuddMoney.multiply(gCrpPMoney).divide(allMoney, 2, 4);
                    if (skuDiscount.compareTo(refuddMoney) == 1) {
                        skuDiscount = refuddMoney;
                    }
                    finalGCrpMoney = skuDiscount;
                    finalVdMoney = refuddMoney.subtract(skuDiscount);
                }
            } else {
                List<OcContractSettlDomain> vdSettlList2 = groupedByBalance.get("VD");
                List<OcContractSettlDomain> crpSettlList = groupedByBalance.get("CRP");
                List<OcContractSettlDomain> gCrpSettlList = groupedByBalance.get("GCRP");
                if (ListUtil.isNotEmpty(vdSettlList2)) {
                    finalVdMoney = refuddMoney;
                } else if (ListUtil.isNotEmpty(crpSettlList)) {
                    finalCrpMoney = refuddMoney;
                } else if (ListUtil.isNotEmpty(gCrpSettlList)) {
                    finalGCrpMoney = refuddMoney;
                }
            }
        }
        if (finalDCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("DCRP").get(0), finalDCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalVdMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("VD").get(0), finalVdMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("CRP").get(0), finalCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalGCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("GCRP").get(0), finalGCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (rebMoney.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal remRebMoney;
            OcContractSettlDomain settlDomain = groupedByBalance.get("REB").get(0);
            OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
            logger.info("refundRebMoney====", (Object)rebMoney);
            if (EmptyUtil.isEmpty((Object)settlDomain.getContractSettlArmoney())) {
                settlDomain.setContractSettlArmoney(BigDecimal.ZERO);
            }
            if ((remRebMoney = settlDomain.getContractSettlPmoney().subtract(settlDomain.getContractSettlArmoney())).compareTo(rebMoney) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlList.remRebMoney1:", (Object)("remRebMoney:" + remRebMoney + "rebMoney:" + rebMoney));
                return "\u9000\u6b3e\u91d1\u989d\u9519\u8bef2";
            }
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundSettlDomain, (Object)settlDomain);
                ocRefundSettlDomain.setContractSettlPmoney(rebMoney);
                ocRefundSettlDomain.setContractSettlGmoney(rebMoney);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundSettlDomainList.add(ocRefundSettlDomain);
        }
        String contractBbillcode = ocRefundDomain.getContractBbillcode();
        ocRefundDomain.setContractBbillcode(ocRefundDomain.getContractBillcode());
        ocRefundDomain.setContractBillcode(contractBbillcode);
        ocRefundDomain.setOcRefundSettlDomainList(ocRefundSettlDomainList);
        return "success";
    }

    private String makeSeetlListFC(OcRefundDomain ocRefundDomain, OcContractReDomain ocContractReDomain, Map<String, List<OcContractSettlDomain>> groupedByBalance, List<OcContractSettlDomain> list) {
        OcRefundSettlDomain ocRefundSettlDo;
        if (null == groupedByBalance) {
            groupedByBalance = new HashMap<String, List<OcContractSettlDomain>>();
        }
        Map<String, List<OcContractSettlDomain>> groupedByBalanceList = null;
        if (!ListUtil.isNotEmpty(list)) {
            return "\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38";
        }
        groupedByBalanceList = list.stream().collect(Collectors.groupingBy(OcContractSettlDomain::getContractSettlBlance));
        Map<String, OcContractGoodsDomain> contractGoodsMapStr = this.contractGoodsMap(ocContractReDomain.getGoodsList());
        BigDecimal refuddMoneyStr = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = contractGoodsMapStr.get(ocRefundGoodsDomain.getSkuNo());
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsArefnum())) {
                ocContractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            BigDecimal goodsMoney = ocRefundGoodsDomain.getRefundGoodsAmt();
            BigDecimal surAplyMoney = ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsAremoney());
            if (surAplyMoney.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListFC.saveRefund.skuNo.1", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            if (surAplyMoney.compareTo(goodsMoney) != -1) {
                refuddMoneyStr = refuddMoneyStr.add(goodsMoney);
                continue;
            }
            logger.error(this.SYS_CODE + ".makeSeetlListFC.saveRefund.skuNo1.1", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney + "goodsMoney:" + goodsMoney));
            return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
        }
        BigDecimal discount = refuddMoneyStr.divide(ocContractReDomain.getDataBmoney(), 2, 4);
        Boolean flag = true;
        BigDecimal rebMoney = BigDecimal.ZERO;
        Map<String, OcRefundGoodsDomain> refundGoodsMap = this.refundGoodsMap(ocRefundDomain.getOcRefundGoodsDomainList());
        Boolean giftFlag = false;
        Boolean sendNumFlag = false;
        BigDecimal sumAremoney = BigDecimal.ZERO;
        BigDecimal dataBmoney = ocContractReDomain.getDataBmoney();
        BigDecimal suBMoney = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty(list)) {
            suBMoney = list.get(0).getContractSettlPmoney();
        }
        BigDecimal contractPaygmoney = BigDecimal.ZERO;
        if (null == ocContractReDomain.getContractPaygmoney()) {
            ocContractReDomain.setContractPaygmoney(BigDecimal.ZERO);
        }
        contractPaygmoney = ocContractReDomain.getContractPaygmoney();
        for (OcContractGoodsDomain contractGoodsDomain : ocContractReDomain.getGoodsList()) {
            if ("1".equals(contractGoodsDomain.getContractGoodsGtype()) || !EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsValueNum()) && contractGoodsDomain.getContractGoodsValueNum().compareTo(BigDecimal.ZERO) == 1) {
                giftFlag = true;
            }
            if (!EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsSendnum()) && contractGoodsDomain.getContractGoodsSendnum().compareTo(BigDecimal.ZERO) == 1) {
                sendNumFlag = true;
            }
            BigDecimal reNum = BigDecimal.ZERO;
            BigDecimal refNum = BigDecimal.ZERO;
            if (null == contractGoodsDomain.getContractGoodsAremoney()) {
                contractGoodsDomain.setContractGoodsAremoney(BigDecimal.ZERO);
            }
            sumAremoney = sumAremoney.add(contractGoodsDomain.getContractGoodsAremoney());
            if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsArefnum())) {
                contractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            if (!EmptyUtil.isEmpty((Object)refundGoodsMap.get(contractGoodsDomain.getSkuNo()))) {
                OcRefundGoodsDomain ocRefundGoodsDomain = refundGoodsMap.get(contractGoodsDomain.getSkuNo());
                refNum = ocRefundGoodsDomain.getRefundGoodsNum();
                reNum = contractGoodsDomain.getGoodsCamount().subtract(contractGoodsDomain.getContractGoodsArefnum().add(refNum));
                if (ListUtil.isNotEmpty((Collection)groupedByBalance.get("REB")) && "yes".equals(contractGoodsDomain.getContractGoodsValue())) {
                    BigDecimal userRebMoney;
                    if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getGoodsAhnum())) {
                        logger.error(this.SYS_CODE + ".makeSeetlListFC.pre:skuNo:" + contractGoodsDomain.getSkuNo());
                        return "\u4fe1\u606f\u5f02\u5e381";
                    }
                    if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getApplyRebmoney())) {
                        contractGoodsDomain.setApplyRebmoney(BigDecimal.ZERO);
                    }
                    if ((userRebMoney = contractGoodsDomain.getContractGoodsPefmoney().subtract(contractGoodsDomain.getContractGoodsMoney()).multiply(discount).setScale(4, 4)).compareTo(BigDecimal.ZERO) == 1) {
                        logger.error(this.SYS_CODE + ".makeSeetlListFC.userRebMoney:userRebMoney:" + userRebMoney + "discount" + discount);
                        BigDecimal rebPrice = userRebMoney.divide(contractGoodsDomain.getGoodsNum(), 4, 4);
                        BigDecimal surRebMoney = userRebMoney.subtract(contractGoodsDomain.getApplyRebmoney());
                        logger.error(this.SYS_CODE + ".makeSeetlListFC.surRebMoney8:rebPrice:" + rebPrice + "surRebMoney:" + surRebMoney);
                        if (rebPrice.compareTo(BigDecimal.ZERO) != 1 && surRebMoney.compareTo(BigDecimal.ZERO) == 1) {
                            logger.error(this.SYS_CODE + ".makeSeetlListFC.userRebMoney:userRebMoney:" + userRebMoney);
                            ocRefundGoodsDomain.setApplyRebmoney(surRebMoney);
                            rebMoney = rebMoney.add(surRebMoney);
                        } else if (rebPrice.compareTo(BigDecimal.ZERO) == 1 && surRebMoney.compareTo(BigDecimal.ZERO) == 1) {
                            logger.error(this.SYS_CODE + ".makeSeetlListFC.surRebMoney12:rebPrice:" + rebPrice + "surRebMoney:" + surRebMoney);
                            BigDecimal kRefMoney = rebPrice.multiply(refNum).setScale(2, 4);
                            if (kRefMoney.compareTo(surRebMoney) != -1) {
                                logger.error(this.SYS_CODE + ".makeSeetlListFC.userRebMoney1:surRebMoney:" + surRebMoney);
                                ocRefundGoodsDomain.setApplyRebmoney(surRebMoney);
                                rebMoney = rebMoney.add(surRebMoney);
                            } else {
                                logger.error(this.SYS_CODE + ".makeSeetlListFC.kRefMoney:kRefMoney:" + kRefMoney);
                                ocRefundGoodsDomain.setApplyRebmoney(kRefMoney);
                                rebMoney = rebMoney.add(kRefMoney);
                            }
                        }
                    }
                }
            } else {
                reNum = contractGoodsDomain.getGoodsCamount().subtract(contractGoodsDomain.getContractGoodsArefnum());
            }
            if (reNum.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListFC.pre:skuNo:" + contractGoodsDomain.getSkuNo() + "goodsCamount:" + contractGoodsDomain.getGoodsCamount() + "contractGoodsArefnum:" + contractGoodsDomain.getContractGoodsArefnum() + "refundGoodsNum:" + refNum);
                return "\u9000\u5355\u6570\u91cf\u4e0d\u8db3";
            }
            if (reNum.compareTo(BigDecimal.ZERO) != 1) continue;
            logger.error(this.SYS_CODE + ".makeSeetlListFC.pre:skuNo:" + contractGoodsDomain.getSkuNo() + "goodsCamount:" + contractGoodsDomain.getGoodsCamount() + "contractGoodsArefnum:" + contractGoodsDomain.getContractGoodsArefnum() + "refundGoodsNum:" + refNum);
            flag = false;
        }
        logger.error(this.SYS_CODE + ".makeSeetlListFC.surRebMoney458:rebMoney:" + rebMoney);
        List<OcContractSettlDomain> dCrpSettlList = groupedByBalance.get("DCRP");
        if (ListUtil.isNotEmpty(dCrpSettlList) && dCrpSettlList.size() > 1) {
            logger.error(this.SYS_CODE + ".makeSeetlListFC.dCrpSettlList:", (Object)JsonUtil.buildNormalBinder().toJson(dCrpSettlList));
            return "\u4fe1\u606f\u5f02\u5e384";
        }
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomainList = new ArrayList<OcRefundSettlDomain>();
        BigDecimal finalDCrpMoney = BigDecimal.ZERO;
        BigDecimal finalVdMoney = BigDecimal.ZERO;
        BigDecimal finalCrpMoney = BigDecimal.ZERO;
        BigDecimal finalGCrpMoney = BigDecimal.ZERO;
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractReDomain.getGoodsList());
        BigDecimal refuddMoney = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = contractGoodsMap.get(ocRefundGoodsDomain.getSkuNo());
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsArefnum())) {
                ocContractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            BigDecimal goodsMoney = ocRefundGoodsDomain.getRefundGoodsAmt();
            BigDecimal surAplyMoney = ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsAremoney());
            if (surAplyMoney.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListFC.saveRefund.skuNo", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            if (surAplyMoney.compareTo(goodsMoney) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListFC.saveRefund.skuNo1", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney + "goodsMoney:" + goodsMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            refuddMoney = refuddMoney.add(goodsMoney);
            ocRefundGoodsDomain.setContractBillcode(ocContractGoodsDomain.getContractBillcode());
        }
        logger.error(this.SYS_CODE + ".makeSeetlListXHrefuddMoney===", (Object)refuddMoney);
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal dcrp = BigDecimal.ZERO;
        BigDecimal gcrp = BigDecimal.ZERO;
        BigDecimal crp = BigDecimal.ZERO;
        BigDecimal vd = BigDecimal.ZERO;
        if (null != groupedByBalanceList.get("FCDCRP")) {
            dcrp = groupedByBalanceList.get("FCDCRP").get(0).getContractSettlGmoney();
        }
        if (null != groupedByBalanceList.get("GCRP")) {
            gcrp = groupedByBalanceList.get("GCRP").get(0).getContractSettlGmoney();
        }
        if (null != groupedByBalanceList.get("CRP")) {
            crp = groupedByBalanceList.get("CRP").get(0).getContractSettlGmoney();
        }
        if (null != groupedByBalanceList.get("VD")) {
            vd = groupedByBalanceList.get("VD").get(0).getContractSettlGmoney();
        }
        sum = dcrp.add(gcrp).add(crp).add(vd);
        if (refuddMoney.compareTo(BigDecimal.ZERO) == 1) {
            if (flag.booleanValue()) {
                if (null != groupedByBalanceList.get("FCDCRP")) {
                    finalDCrpMoney = groupedByBalanceList.get("FCDCRP").get(0).getContractSettlPmoney().subtract(groupedByBalanceList.get("FCDCRP").get(0).getContractSettlArmoney());
                }
                if (null != groupedByBalanceList.get("GCRP")) {
                    finalGCrpMoney = groupedByBalanceList.get("GCRP").get(0).getContractSettlPmoney().subtract(groupedByBalanceList.get("GCRP").get(0).getContractSettlArmoney());
                }
                if (null != groupedByBalanceList.get("CRP")) {
                    finalCrpMoney = groupedByBalanceList.get("CRP").get(0).getContractSettlPmoney().subtract(groupedByBalanceList.get("CRP").get(0).getContractSettlArmoney());
                }
                if (null != groupedByBalanceList.get("VD")) {
                    finalVdMoney = groupedByBalanceList.get("VD").get(0).getContractSettlPmoney().subtract(groupedByBalanceList.get("VD").get(0).getContractSettlArmoney());
                }
            } else {
                BigDecimal add = dataBmoney.subtract(sumAremoney.add(contractPaygmoney));
                if (ListUtil.isNotEmpty(list)) {
                    int size = list.size();
                    HashMap<String, BigDecimal> allocatedAmounts = new HashMap<String, BigDecimal>();
                    BigDecimal allocatedSum = BigDecimal.ZERO;
                    for (int i = 0; i < size; ++i) {
                        OcContractSettlDomain item = list.get(i);
                        if (i == size - 1) {
                            BigDecimal tailDifference = refuddMoney.subtract(allocatedSum);
                            allocatedAmounts.put(item.getContractSettlBlance(), tailDifference);
                            continue;
                        }
                        BigDecimal amount = refuddMoney.multiply(item.getContractSettlGmoney()).divide(sum, 2, 4);
                        allocatedAmounts.put(item.getContractSettlBlance(), amount);
                        allocatedSum = allocatedSum.add(amount);
                    }
                    finalDCrpMoney = allocatedAmounts.getOrDefault("FCDCRP", BigDecimal.ZERO);
                    finalVdMoney = allocatedAmounts.getOrDefault("VD", BigDecimal.ZERO);
                    finalCrpMoney = allocatedAmounts.getOrDefault("CRP", BigDecimal.ZERO);
                    finalGCrpMoney = allocatedAmounts.getOrDefault("GCRP", BigDecimal.ZERO);
                }
                if (add.compareTo(BigDecimal.ZERO) >= 0) {
                    if (refuddMoney.compareTo(add) > 0) {
                        BigDecimal subtract = refuddMoney.subtract(add);
                        if (ListUtil.isNotEmpty(list)) {
                            int size = list.size();
                            HashMap<String, BigDecimal> allocatedAmounts = new HashMap<String, BigDecimal>();
                            BigDecimal allocatedSum = BigDecimal.ZERO;
                            for (int i = 0; i < size; ++i) {
                                OcContractSettlDomain item = list.get(i);
                                if (i == size - 1) {
                                    BigDecimal tailDifference = subtract.subtract(allocatedSum);
                                    allocatedAmounts.put(item.getContractSettlBlance(), tailDifference);
                                    continue;
                                }
                                BigDecimal amount = subtract.multiply(item.getContractSettlGmoney()).divide(sum, 2, 4);
                                allocatedAmounts.put(item.getContractSettlBlance(), amount);
                                allocatedSum = allocatedSum.add(amount);
                            }
                            finalDCrpMoney = allocatedAmounts.getOrDefault("FCDCRP", BigDecimal.ZERO);
                            finalVdMoney = allocatedAmounts.getOrDefault("VD", BigDecimal.ZERO);
                            finalCrpMoney = allocatedAmounts.getOrDefault("CRP", BigDecimal.ZERO);
                            finalGCrpMoney = allocatedAmounts.getOrDefault("GCRP", BigDecimal.ZERO);
                        }
                    } else {
                        finalVdMoney = BigDecimal.ZERO;
                        finalDCrpMoney = BigDecimal.ZERO;
                        finalCrpMoney = BigDecimal.ZERO;
                        finalGCrpMoney = BigDecimal.ZERO;
                    }
                }
            }
        }
        if (finalDCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalanceList.get("FCDCRP").get(0), finalDCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalVdMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalanceList.get("VD").get(0), finalVdMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalanceList.get("CRP").get(0), finalCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalGCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalanceList.get("GCRP").get(0), finalGCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (rebMoney.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal remRebMoney;
            OcContractSettlDomain settlDomain = groupedByBalance.get("REB").get(0);
            OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
            logger.info(".makeSeetlListFCrefundRebMoney====", (Object)rebMoney);
            if (EmptyUtil.isEmpty((Object)settlDomain.getContractSettlArmoney())) {
                settlDomain.setContractSettlArmoney(BigDecimal.ZERO);
            }
            if ((remRebMoney = settlDomain.getContractSettlPmoney().subtract(settlDomain.getContractSettlArmoney())).compareTo(rebMoney) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListFC.remRebMoney1:", (Object)("remRebMoney:" + remRebMoney + "rebMoney:" + rebMoney));
                return "\u9000\u6b3e\u91d1\u989d\u9519\u8bef2";
            }
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundSettlDomain, (Object)settlDomain);
                ocRefundSettlDomain.setContractSettlPmoney(rebMoney);
                ocRefundSettlDomain.setContractSettlGmoney(rebMoney);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundSettlDomainList.add(ocRefundSettlDomain);
        }
        String contractBbillcode = ocRefundDomain.getContractBbillcode();
        ocRefundDomain.setContractBbillcode(ocRefundDomain.getContractBillcode());
        ocRefundDomain.setContractBillcode(contractBbillcode);
        ocRefundDomain.setOcRefundSettlDomainList(ocRefundSettlDomainList);
        return "success";
    }

    private String makeSeetlListXH(OcRefundDomain ocRefundDomain, OcContractReDomain ocContractReDomain, Map<String, List<OcContractSettlDomain>> groupedByBalance, List<OcContractSettlDomain> list) {
        OcRefundSettlDomain ocRefundSettlDo;
        Boolean flag = true;
        BigDecimal rebMoney = BigDecimal.ZERO;
        Map<String, OcRefundGoodsDomain> refundGoodsMap = this.refundGoodsMap(ocRefundDomain.getOcRefundGoodsDomainList());
        Boolean giftFlag = false;
        Boolean sendNumFlag = false;
        BigDecimal sumAremoney = BigDecimal.ZERO;
        BigDecimal dataBmoney = ocContractReDomain.getDataBmoney();
        BigDecimal suBMoney = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty(list)) {
            suBMoney = list.get(0).getContractSettlPmoney();
        }
        BigDecimal contractPaygmoney = BigDecimal.ZERO;
        if (null == ocContractReDomain.getContractPaygmoney()) {
            ocContractReDomain.setContractPaygmoney(BigDecimal.ZERO);
        }
        contractPaygmoney = ocContractReDomain.getContractPaygmoney();
        Map<String, OcContractGoodsDomain> contractGoodsMapStr = this.contractGoodsMap(ocContractReDomain.getGoodsList());
        BigDecimal refuddMoneyStr = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = contractGoodsMapStr.get(ocRefundGoodsDomain.getSkuNo());
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsArefnum())) {
                ocContractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            BigDecimal goodsMoney = ocRefundGoodsDomain.getRefundGoodsAmt();
            BigDecimal surAplyMoney = ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsAremoney());
            if (surAplyMoney.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListXH.saveRefund.skuNo.1", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            if (surAplyMoney.compareTo(goodsMoney) != -1) {
                refuddMoneyStr = refuddMoneyStr.add(goodsMoney);
                continue;
            }
            logger.error(this.SYS_CODE + ".makeSeetlListXH.saveRefund.skuNo1.1", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney + "goodsMoney:" + goodsMoney));
            return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
        }
        BigDecimal discount = refuddMoneyStr.divide(ocContractReDomain.getDataBmoney(), 2, 4);
        for (OcContractGoodsDomain contractGoodsDomain : ocContractReDomain.getGoodsList()) {
            if ("1".equals(contractGoodsDomain.getContractGoodsGtype()) || !EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsValueNum()) && contractGoodsDomain.getContractGoodsValueNum().compareTo(BigDecimal.ZERO) == 1) {
                giftFlag = true;
            }
            if (!EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsSendnum()) && contractGoodsDomain.getContractGoodsSendnum().compareTo(BigDecimal.ZERO) == 1) {
                sendNumFlag = true;
            }
            BigDecimal reNum = BigDecimal.ZERO;
            BigDecimal refNum = BigDecimal.ZERO;
            if (null == contractGoodsDomain.getContractGoodsAremoney()) {
                contractGoodsDomain.setContractGoodsAremoney(BigDecimal.ZERO);
            }
            sumAremoney = sumAremoney.add(contractGoodsDomain.getContractGoodsAremoney());
            if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getContractGoodsArefnum())) {
                contractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            if (!EmptyUtil.isEmpty((Object)refundGoodsMap.get(contractGoodsDomain.getSkuNo()))) {
                OcRefundGoodsDomain ocRefundGoodsDomain = refundGoodsMap.get(contractGoodsDomain.getSkuNo());
                refNum = ocRefundGoodsDomain.getRefundGoodsNum();
                reNum = contractGoodsDomain.getGoodsCamount().subtract(contractGoodsDomain.getContractGoodsArefnum().add(refNum));
                if (ListUtil.isNotEmpty((Collection)groupedByBalance.get("REB")) && "yes".equals(contractGoodsDomain.getContractGoodsValue())) {
                    BigDecimal userRebMoney;
                    if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getGoodsAhnum())) {
                        logger.error(this.SYS_CODE + ".makeSeetlListXH.pre:skuNo:" + contractGoodsDomain.getSkuNo());
                        return "\u4fe1\u606f\u5f02\u5e381";
                    }
                    if (EmptyUtil.isEmpty((Object)contractGoodsDomain.getApplyRebmoney())) {
                        contractGoodsDomain.setApplyRebmoney(BigDecimal.ZERO);
                    }
                    if ((userRebMoney = contractGoodsDomain.getContractGoodsPefmoney().subtract(contractGoodsDomain.getContractGoodsMoney()).multiply(discount).setScale(4, 4)).compareTo(BigDecimal.ZERO) == 1) {
                        logger.error(this.SYS_CODE + ".makeSeetlListXH.userRebMoney:userRebMoney:" + userRebMoney);
                        BigDecimal rebPrice = userRebMoney.divide(contractGoodsDomain.getGoodsNum(), 4, 4);
                        BigDecimal surRebMoney = userRebMoney.subtract(contractGoodsDomain.getApplyRebmoney());
                        logger.error(this.SYS_CODE + ".makeSeetlListXH.surRebMoney8:rebPrice:" + rebPrice + "surRebMoney:" + surRebMoney);
                        if (rebPrice.compareTo(BigDecimal.ZERO) != 1 && surRebMoney.compareTo(BigDecimal.ZERO) == 1) {
                            logger.error(this.SYS_CODE + ".makeSeetlListXH.userRebMoney:userRebMoney:" + userRebMoney);
                            ocRefundGoodsDomain.setApplyRebmoney(surRebMoney);
                            rebMoney = rebMoney.add(surRebMoney);
                        } else if (rebPrice.compareTo(BigDecimal.ZERO) == 1 && surRebMoney.compareTo(BigDecimal.ZERO) == 1) {
                            logger.error(this.SYS_CODE + ".makeSeetlListXH.surRebMoney12:rebPrice:" + rebPrice + "surRebMoney:" + surRebMoney);
                            BigDecimal kRefMoney = rebPrice.multiply(refNum).setScale(2, 4);
                            if (kRefMoney.compareTo(surRebMoney) != -1) {
                                logger.error(this.SYS_CODE + ".makeSeetlListXH.userRebMoney1:surRebMoney:" + surRebMoney);
                                ocRefundGoodsDomain.setApplyRebmoney(surRebMoney);
                                rebMoney = rebMoney.add(surRebMoney);
                            } else {
                                logger.error(this.SYS_CODE + ".makeSeetlListXH.kRefMoney:kRefMoney:" + kRefMoney);
                                ocRefundGoodsDomain.setApplyRebmoney(kRefMoney);
                                rebMoney = rebMoney.add(kRefMoney);
                            }
                        }
                    }
                }
            } else {
                reNum = contractGoodsDomain.getGoodsCamount().subtract(contractGoodsDomain.getContractGoodsArefnum());
            }
            if (reNum.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListXH.pre:skuNo:" + contractGoodsDomain.getSkuNo() + "goodsCamount:" + contractGoodsDomain.getGoodsCamount() + "contractGoodsArefnum:" + contractGoodsDomain.getContractGoodsArefnum() + "refundGoodsNum:" + refNum);
                return "\u9000\u5355\u6570\u91cf\u4e0d\u8db3";
            }
            if (reNum.compareTo(BigDecimal.ZERO) != 1) continue;
            logger.error(this.SYS_CODE + ".makeSeetlListXH.pre:skuNo:" + contractGoodsDomain.getSkuNo() + "goodsCamount:" + contractGoodsDomain.getGoodsCamount() + "contractGoodsArefnum:" + contractGoodsDomain.getContractGoodsArefnum() + "refundGoodsNum:" + refNum);
            flag = false;
        }
        logger.error(this.SYS_CODE + ".makeSeetlListXH.surRebMoney458:rebMoney:" + rebMoney);
        List<OcContractSettlDomain> list2 = groupedByBalance.get("DCRP");
        if (ListUtil.isNotEmpty(list2) && list2.size() > 1) {
            logger.error(this.SYS_CODE + ".makeSeetlListXH.dCrpSettlList:", (Object)JsonUtil.buildNormalBinder().toJson(list2));
            return "\u4fe1\u606f\u5f02\u5e384";
        }
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomainList = new ArrayList<OcRefundSettlDomain>();
        BigDecimal finalDCrpMoney = BigDecimal.ZERO;
        BigDecimal finalVdMoney = BigDecimal.ZERO;
        BigDecimal finalCrpMoney = BigDecimal.ZERO;
        BigDecimal finalGCrpMoney = BigDecimal.ZERO;
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractReDomain.getGoodsList());
        BigDecimal refuddMoney = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = contractGoodsMap.get(ocRefundGoodsDomain.getSkuNo());
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsArefnum())) {
                ocContractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            BigDecimal goodsMoney = ocRefundGoodsDomain.getRefundGoodsAmt();
            BigDecimal surAplyMoney = ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsAremoney());
            if (surAplyMoney.compareTo(BigDecimal.ZERO) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListXH.saveRefund.skuNo", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            if (surAplyMoney.compareTo(goodsMoney) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListXH.saveRefund.skuNo1", (Object)("skuNo:" + ocRefundGoodsDomain.getSkuNo() + "surAplyMoney:" + surAplyMoney + "goodsMoney:" + goodsMoney));
                return "\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u8db3";
            }
            refuddMoney = refuddMoney.add(goodsMoney);
            ocRefundGoodsDomain.setContractBillcode(ocContractGoodsDomain.getContractBillcode());
        }
        logger.error(this.SYS_CODE + ".makeSeetlListXHrefuddMoney===", (Object)refuddMoney);
        if (refuddMoney.compareTo(BigDecimal.ZERO) == 1) {
            if (flag.booleanValue()) {
                finalVdMoney = ListUtil.isNotEmpty(list) ? list.get(0).getContractSettlPmoney().subtract(list.get(0).getContractSettlArmoney()) : BigDecimal.ZERO;
            } else {
                finalVdMoney = refuddMoney;
                BigDecimal add = dataBmoney.subtract(sumAremoney.add(contractPaygmoney));
                if (add.compareTo(BigDecimal.ZERO) >= 0) {
                    finalVdMoney = refuddMoney.compareTo(add) > 0 ? refuddMoney.subtract(add) : BigDecimal.ZERO;
                }
            }
        }
        if (finalDCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("DCRP").get(0), finalDCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalVdMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("VD").get(0), finalVdMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("CRP").get(0), finalCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (finalGCrpMoney.compareTo(BigDecimal.ZERO) > 0) {
            ocRefundSettlDo = this.createRefundSettlDomain(groupedByBalance.get("GCRP").get(0), finalGCrpMoney);
            ocRefundSettlDomainList.add(ocRefundSettlDo);
        }
        if (rebMoney.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal remRebMoney;
            OcContractSettlDomain settlDomain = groupedByBalance.get("REB").get(0);
            OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
            logger.info(".makeSeetlListXHrefundRebMoney====", (Object)rebMoney);
            if (EmptyUtil.isEmpty((Object)settlDomain.getContractSettlArmoney())) {
                settlDomain.setContractSettlArmoney(BigDecimal.ZERO);
            }
            if ((remRebMoney = settlDomain.getContractSettlPmoney().subtract(settlDomain.getContractSettlArmoney())).compareTo(rebMoney) == -1) {
                logger.error(this.SYS_CODE + ".makeSeetlListXH.remRebMoney1:", (Object)("remRebMoney:" + remRebMoney + "rebMoney:" + rebMoney));
                return "\u9000\u6b3e\u91d1\u989d\u9519\u8bef2";
            }
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundSettlDomain, (Object)settlDomain);
                ocRefundSettlDomain.setContractSettlPmoney(rebMoney);
                ocRefundSettlDomain.setContractSettlGmoney(rebMoney);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundSettlDomainList.add(ocRefundSettlDomain);
        }
        String contractBbillcode = ocRefundDomain.getContractBbillcode();
        ocRefundDomain.setContractBbillcode(ocRefundDomain.getContractBillcode());
        ocRefundDomain.setContractBillcode(contractBbillcode);
        ocRefundDomain.setOcRefundSettlDomainList(ocRefundSettlDomainList);
        return "success";
    }

    private boolean isFeatureMatch(OcContractGoodsDomain goods, OcRefundGoodsDomain refundGoods) {
        return StringUtils.equals((CharSequence)goods.getContractGoodsGtype(), (CharSequence)refundGoods.getContractGoodsGtype()) && StringUtils.equals((CharSequence)goods.getSkuNo(), (CharSequence)refundGoods.getSkuNo()) && StringUtils.equals((CharSequence)goods.getGoodsSpec5(), (CharSequence)refundGoods.getGoodsSpec5());
    }

    private OcRefundSettlDomain createRefundSettlDomain(OcContractSettlDomain settlDomain, BigDecimal refundMoney) {
        OcRefundSettlDomain ocRefundSettlDo = null;
        try {
            ocRefundSettlDo = new OcRefundSettlDomain();
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundSettlDo, (Object)settlDomain);
            ocRefundSettlDo.setContractSettlPmoney(refundMoney);
            ocRefundSettlDo.setContractSettlGmoney(refundMoney);
            ocRefundSettlDo.setContractSettlOpno(settlDomain.getContractSettlOpno1());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ocRefundSettlDo;
    }

    private String makeRefundGoodsList(OcRefundDomain ocRefundDomain, OcContractReDomain ocContractReDomain) {
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractReDomain.getGoodsList());
        for (OcRefundGoodsDomain refundGoodsList : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoods = contractGoodsMap.get(refundGoodsList.getSkuNo());
            if (null == ocContractGoods) {
                logger.error(this.SYS_CODE + ".makeRefundGoodsList.skuNo", (Object)refundGoodsList.getSkuNo());
                return "\u5546\u54c1\u4e3a\u7a7a";
            }
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getContractGoodsAremoney()) {
                ocContractGoods.setContractGoodsAremoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getGoodsCamount()) {
                ocContractGoods.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null != refundGoodsList.getGoodsCamount()) continue;
            refundGoodsList.setGoodsCamount(BigDecimal.ZERO);
        }
        return "success";
    }

    public Map<String, OcContractGoodsDomain> contractGoodsMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            logger.error(this.SYS_CODE + ".contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsArefnum()) {
                ocContractGoodsDomain.setContractGoodsArefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsAremoney()) {
                ocContractGoodsDomain.setContractGoodsAremoney(BigDecimal.ZERO);
            }
            map.put(ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
        }
        return map;
    }

    public boolean makeReGoodsNum(OcRefundDomain ocRefundDomain) {
        List<OcRefundGoodsDomain> ocRefundGoodsBeanList = ocRefundDomain.getOcRefundGoodsDomainList();
        if (ListUtil.isEmpty(ocRefundGoodsBeanList)) {
            logger.error(this.SYS_CODE + ".makeReGoodsNum.ocRefundGoodsBeanList.null");
            return true;
        }
        for (OcRefundGoodsDomain ocRefundGoodsBean : ocRefundGoodsBeanList) {
            if (ocRefundGoodsBean.getRefundGoodsNum().compareTo(new BigDecimal(0)) != 0) continue;
            logger.error(this.SYS_CODE + "makeReGoodsNum.num.0", (Object)(ocRefundDomain.getContractBillcode() + "skuNo:" + ocRefundGoodsBean.getSkuNo()));
            return true;
        }
        return false;
    }

    public List<RsSkuReDomain> querySkuPage(Map<String, Object> map) {
        if (null == map) {
            logger.error(this.SYS_CODE + ".querySkuPage.null");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult queryResult = this.sendReSupObject("rs.sku.querySkuOnePage", paramMap, RsSkuReDomain.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        return queryResult.getList();
    }

    private String queryAccountId(OcRefundDomain ocRefundDomain) {
        HashMap<String, Object> userinfoParamMap3 = new HashMap<String, Object>();
        userinfoParamMap3.put("userinfoChannelcode", ocRefundDomain.getMemberGcode());
        userinfoParamMap3.put("dateState", 1);
        userinfoParamMap3.put("userinfoCode", ocRefundDomain.getMemberBcode());
        logger.info("queryUserinfoapplyPage", userinfoParamMap3);
        HashMap<String, String> invokeMap3 = new HashMap<String, String>();
        invokeMap3.put("map", JsonUtil.buildNonNullBinder().toJson(userinfoParamMap3));
        QueryResult quresult3 = this.getQueryResutl("um.umUserinfoapply.queryUserinfoapplyPage", invokeMap3, UmUserinfoapply.class);
        if (quresult3.getList() == null || CollectionUtils.isEmpty((Collection)quresult3.getList())) {
            throw new ApiException("\u7528\u6237\u4fe1\u606f\u7533\u8bf7\u8868\u6682\u672a\u67e5\u5230");
        }
        UmUserinfoapply umUserinfoapply = (UmUserinfoapply)quresult3.getList().get(0);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("type", "01");
        map1.put("merchantCode", ocRefundDomain.getMemberBcode());
        map1.put("fundType", "01");
        map1.put("channelCode", umUserinfoapply.getUserinfoDischannelcode());
        logger.info("queryOuterFaccountInfoPage", map1);
        HashMap<String, String> invokeMap1 = new HashMap<String, String>();
        invokeMap1.put("map", JsonUtil.buildNonNullBinder().toJson(map1));
        QueryResult quresult1 = this.getQueryResutl("vd.faccount.queryOuterFaccountInfoPage", invokeMap1, VdFaccountInfo.class);
        if (quresult1 == null || CollectionUtils.isEmpty((Collection)quresult1.getList())) {
            throw new ApiException("\u8d26\u6237\u4fe1\u606f\u6682\u672a\u67e5\u5230");
        }
        return ((VdFaccountInfo)quresult1.getList().get(0)).getFaccountOuterNo();
    }

    @Override
    public String sendSaveExSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        LogRouterlogDomain logRouterlogDomain = this.creteLogRouterlogDomain(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain), "busdata.exOrder.sendSaveExSendgoods", null, "\u53d1\u8d27\u5355\u53d1\u8d27\u63a5\u53e3");
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain");
            logRouterlogDomain.setRouterlogReturn("\u53c2\u6570\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoods(sgSendgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.msg", (Object)msg);
            logRouterlogDomain.setRouterlogReturn(msg);
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.msg", msg);
        }
        logRouterlogDomain.setAppmanageOicode(sgSendgoodsDomain.getSendgoodsCode());
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        sgSendgoodsDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        sgSendgoodsDomain.setMemberName("\u5e73\u53f0");
        try {
            String sendgoodsCode = this.saveSendgoods(sgSendgoodsDomain);
            if (StringUtils.isBlank((String)sendgoodsCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            logRouterlogDomain.setRouterlogReturn(this.makeSuccessReturn(sendgoodsCode));
            logRouterlogDomain.setRouterlogReturnstate("200");
            logRouterlogDomain.setRouterlogReturnstates("OK");
            this.sendLog(logRouterlogDomain);
            return this.makeSuccessReturn(sendgoodsCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e", (Throwable)e);
            logRouterlogDomain.setRouterlogReturn(e.getErrMsg());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e1", (Throwable)e);
            logRouterlogDomain.setRouterlogReturn(e.getMessage());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(this.SYS_CODE + ".sendSaveExSendgoods.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoodsLog(sgSendgoodsLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            String sendgoodsLogCode = this.saveSendgoodsLog(sgSendgoodsLogDomain);
            if (StringUtils.isBlank((String)sendgoodsLogCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(sendgoodsLogCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendQueryExOcContract(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.map");
            throw new ApiException(this.SYS_CODE + ".sendQueryExOcContract.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExOcContract.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("childFlag")))) {
            map.put("childFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("sendGoodsFlag")))) {
            map.put("sendGoodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("packFlag")))) {
            map.put("packFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("settleFlag")))) {
            map.put("settleFlag", "true");
        }
        return this.makeSuccessReturn(this.queryOrderReDomainPage(map));
    }

    @Override
    public String sendQueryExRefund(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExRefund.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractProFlag")))) {
            map.put("ocContractProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractGoodsFlag")))) {
            map.put("ocContractGoodsFlag", "true");
        }
        return this.makeSuccessReturn(this.queryRefundReDoaminPage(map));
    }

    @Override
    public String sendQueryExSgSendgoods(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExSgSendgoods.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsFlag")))) {
            map.put("goodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        return this.makeSuccessReturn(this.querySgSendgoodsPage(map));
    }

    private String checkQueryMap(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == map.get("startRow")) {
            msg = msg + "startRow\u4e3a\u7a7a! ";
        }
        if (null == map.get("rows")) {
            msg = msg + "rows\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getContractNbbillcode())) {
            msg = msg + "contractNbbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getContractType())) {
            msg = msg + "contractType\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == ocContractDomain.getGoodsNum() || ocContractDomain.getGoodsNum().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "goodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            msg = msg + "packageList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                ++i;
                if (ListUtil.isEmpty(ocPackageDomain.getContractGoodsList())) {
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u4e3a\u7a7a! ";
                    continue;
                }
                int j = 0;
                for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                    ++j;
                    if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo())) {
                        msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cskuCode\u6216skuNo\u90fd\u4e3a\u7a7a! ";
                    }
                    if (null != ocContractGoodsDomain.getGoodsNum() && ocContractGoodsDomain.getGoodsNum().compareTo(BigDecimal.ZERO) > 0) continue;
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cgoodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
                }
            }
        }
        return msg;
    }

    private String checkQueryContract(String contractNbillcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)contractNbillcode)) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkQueryRefund(String refundNcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)refundNcode)) {
            msg = msg + "refundNcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundOcode()) && StringUtils.isBlank((String)ocRefundDomain.getContractNbillcode())) {
            msg = msg + "refundOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getMemberBcode())) {
            msg = msg + "\u4e70\u5bb6\u7f16\u7801\u4e3a\u7a7a! ";
        } else {
            UmUserinfo umUserinfo = this.queryUserinfo(ocRefundDomain.getMemberBcode());
            if (umUserinfo == null) {
                msg = msg + "\u7528\u6237\u7f16\u7801" + ocRefundDomain.getMemberBcode() + "oms\u7cfb\u7edf\u6682\u672a\u67e5\u8be2\u5230!";
            } else {
                ocRefundDomain.setCustrelCode(ocRefundDomain.getMemberBcode());
                ocRefundDomain.setMemberBcode(umUserinfo.getUserinfoCode());
            }
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getMemberGcode())) {
            msg = msg + "\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a! ";
        }
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "refundMoney\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "ocRefundGoodsDomainList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                ++i;
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuName())) {
                    msg = msg + "\u7b2c" + i + "skuName\u4e3a\u7a7a! ";
                }
                if (null == ocRefundGoodsDomain.getGoodsOrdnum() || ocRefundGoodsDomain.getGoodsOrdnum().compareTo(BigDecimal.ZERO) <= 0) {
                    msg = msg + "\u7b2c" + i + "\u884cgoodsOrdnum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
                }
                ocRefundGoodsDomain.setRefundGoodsNum(ocRefundGoodsDomain.getGoodsOrdnum());
                if (null != ocRefundGoodsDomain.getRefundGoodsAmt() && ocRefundGoodsDomain.getRefundGoodsAmt().compareTo(BigDecimal.ZERO) > 0) continue;
                msg = msg + "\u7b2c" + i + "\u884crefundGoodsAmt\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
            }
        }
        return msg;
    }

    protected UmUserinfo queryUserinfo(String userinfoEcode) {
        if (null == userinfoEcode) {
            logger.error(this.SYS_CODE + ".queryUserinfo.userinfoEcode");
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoOcode", userinfoEcode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isEmpty((String)s)) {
            logger.error(this.SYS_CODE + ".queryUserinfo.queryUserinfoPage.return.isnull", paramMap);
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, QueryResult.class);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            logger.error(this.SYS_CODE + ".queryUserinfo.queryUserinfoPage.queryResult.isnull", paramMap);
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), UmUserinfo.class);
        return (UmUserinfo)list.get(0);
    }

    private String makeOcRefundDomain(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return "\u5546\u54c1\u4e3a\u7a7a";
        }
        String msg = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ComConstants.tenantCode);
        paramMap.put("childFlag", "true");
        if (StringUtils.isNotBlank((String)ocRefundDomain.getContractBillcode())) {
            String code;
            paramMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
            QueryResult<OcContractReDomain> qlist = this.queryOrderReDomainPage(paramMap);
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.qlist", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u8ba2\u5355\u4e3a\u7a7a! " + paramMap.toString();
            }
            OcContractReDomain ocContractReDomain = (OcContractReDomain)qlist.getList().get(0);
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.copy", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()), (Throwable)e);
                return "\u5f02\u5e38! " + paramMap.toString();
            }
            List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
            if (ListUtil.isEmpty(goodsList)) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.goodsList", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a! " + paramMap.toString();
            }
            HashMap<String, OcContractGoodsDomain> contractgoodsMap = new HashMap<String, OcContractGoodsDomain>();
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                contractgoodsMap.put(ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
            }
            BigDecimal reMoney = BigDecimal.ZERO;
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                BigDecimal goodsOrdnum = ocRefundGoodsDomain.getGoodsOrdnum();
                BigDecimal refundGoodsAmt = ocRefundGoodsDomain.getRefundGoodsAmt();
                OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)contractgoodsMap.get(ocRefundGoodsDomain.getSkuNo());
                if (null == ocContractGoodsDomain) {
                    logger.error(this.SYS_CODE + ".makeOcRefundDomain.ocContractGoodsDomain", (Object)(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo()));
                    return "\u8ba2\u5355\u5546\u54c1\u5f02\u5e38! " + ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo();
                }
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ocRefundGoodsDomain.setGoodsOrdnum(goodsOrdnum);
                ocRefundGoodsDomain.setRefundGoodsAmt(refundGoodsAmt);
                reMoney = reMoney.add(refundGoodsAmt);
            }
            ocRefundDomain.setRefundMoney(reMoney);
            if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(reMoney) != 0) {
                msg = msg + "\u660e\u7ec6\u91d1\u989d\u4e0e\u6c47\u603b\u91d1\u989d";
            }
            if (!StringUtils.equals((CharSequence)"success", (CharSequence)(code = this.makeRefundSett(ocRefundDomain)))) {
                msg = msg + code;
            }
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuNo", ocRefundDomain.getOcRefundGoodsDomainList().stream().map(u -> u.getSkuNo()).collect(Collectors.joining(",")));
            map.put("channelCode", ComConstants.channelCode);
            map.put("dataOpbillstate", 1);
            List<RsSkuReDomain> rsSkuReDomains = this.querySkuPage(map);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(rsSkuReDomains)) {
                msg = msg + "\u5546\u54c1\u4fe1\u606f\u6682\u672a\u67e5\u8be2\u5230";
            }
            Map<String, List<RsSkuReDomain>> resMap = rsSkuReDomains.stream().collect(Collectors.groupingBy(RsSkuDomain::getSkuNo));
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + ocRefundGoodsDomain.getMemberContactQq() + "\u884c\u5546\u54c1\u6599\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (!resMap.containsKey(ocRefundGoodsDomain.getSkuNo())) {
                    msg = msg + "\u5546\u54c1\u6599\u53f7" + ocRefundGoodsDomain.getSkuNo() + "\u6682\u672a\u67e5\u8be2\u5230";
                } else {
                    List<RsSkuReDomain> rsSkuReDomains1 = resMap.get(ocRefundGoodsDomain.getSkuNo());
                    RsSkuReDomain rsSkuReDomain = rsSkuReDomains1.get(0);
                    ocRefundGoodsDomain.setSkuName(rsSkuReDomain.getSkuName());
                    ocRefundGoodsDomain.setGoodsName(rsSkuReDomain.getGoodsName());
                }
                ocRefundGoodsDomain.setContractGoodsGtype("0");
                ocRefundGoodsDomain.setContractGoodsCode(UUID.randomUUID().toString().substring(1, 20));
                ocRefundGoodsDomain.setTenantCode(ComConstants.tenantCode);
            }
        }
        return msg;
    }

    private String makeOcContractDomain(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            return "\u5305\u88f9\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
            ocContractDomain.setMemberCode(this.getTeananMemberCode(ocContractDomain.getTenantCode()));
            ocContractDomain.setMemberName("\u5e73\u53f0");
        }
        List<OcPackageDomain> packageList = ocContractDomain.getPackageList();
        String msg = "";
        String goodsClass = "plat";
        QueryResult<RsSkuDomain> queryResutl = null;
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            if (ListUtil.isEmpty(contractGoodsList)) {
                return "\u5305\u88f9\u91cc\u7684\u5546\u54c1\u4e3a\u7a7a";
            }
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                msg = this.checkOcContractGoodsDomain(ocContractGoodsDomain);
                if (StringUtils.isNotBlank((String)msg)) {
                    return msg;
                }
                if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuCode())) {
                    paramMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl1", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                        return "sku\u4e3a\u7a7a! " + paramMap.toString();
                    }
                    rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                } else if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuNo())) {
                    paramMap.put("goodsClass", goodsClass);
                    paramMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
                    paramMap.put("memberCode", ocContractDomain.getMemberCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl2", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    } else {
                        rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                    }
                }
                if (null == rsSkuDomain) continue;
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), ocContractDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.rsResourceGoodsReDomain", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                BigDecimal goodsNum = ocContractGoodsDomain.getGoodsNum();
                BigDecimal goodsWeight = ocContractGoodsDomain.getGoodsWeight();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)ocContractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertysNotNull((Object)ocContractGoodsDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                ocContractGoodsDomain.setGoodsNum(goodsNum);
                ocContractGoodsDomain.setGoodsWeight(goodsWeight);
                if ("14".equals(ocContractDomain.getPricesetCurrency1())) {
                    ocContractGoodsDomain.setGoodsSpec5("14");
                    continue;
                }
                ocContractGoodsDomain.setGoodsSpec5("10");
            }
        }
        return msg;
    }

    private String checkOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode())) {
            msg = msg + "skuNo\u548cskuCode\u90fd\u4e3a\u7a7a! ";
        }
        return msg;
    }

    @Override
    public String sendQueryExpress(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.msg");
            throw new ApiException(this.SYS_CODE + ".sendQueryExpress.msg", msg);
        }
        return this.makeSuccessReturn(this.queryExpressPage(map));
    }

    @Override
    public String sendSaveBusOrderToEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String contractBillcode = (String)resStream.get("sendgoodsCode");
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.sendgoodsCode");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain orderByCode = this.getOrderByCode(contractBillcode, tenantCode);
        if (null == orderByCode) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (2 != orderByCode.getDataState()) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.dataState", "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        String expressCode = (String)resStream.get("expressCode");
        if (StringUtils.isBlank((String)expressCode)) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.expressCode", "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == resStream.get("packageBillno")) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.packageBillno", "\u8fd0\u5355\u53f7\u4e3a\u7a7a");
        }
        Map<String, Object> ddMap = this.getDdMap(tenantCode, "wmsExpressCode", "wmsExpressCode");
        if (null != ddMap.get(expressCode)) {
            Map map = (Map)ddMap.get(expressCode);
            resStream.putAll(map);
        }
        String code = this.orderNext(contractBillcode, tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    public static void main2222(String[] args) {
        HashMap<String, String> resStream = new HashMap<String, String>();
        resStream.put("expressCode", "12321");
        resStream.put("expressName", "12121121");
        String json = "{\"SFSY-GP\":{\"expressCode\":\"shunfeng\",\"expressName\":\"\u987a\u4e30\u5feb\u9012\"},\"GMSF\":{\"expressCode\":\"shunfeng\",\"expressName\":\"\u987a\u4e30\u5feb\u9012\"},\"3108002701_1011\":{\"expressCode\":\"zhongtongkuaiyun\",\"expressName\":\"\u4e2d\u901a\u5feb\u8fd0\"},\"ZTO\":{\"expressCode\":\"zhongtong\",\"expressName\":\"\u4e2d\u901a\u5feb\u9012\"},\"DBKD\":{\"expressCode\":\"debangkuaidi\",\"expressName\":\"\u5fb7\u90a6\u5feb\u9012\"},\"SXJD\":{\"expressCode\":\"sxjdfreight\",\"expressName\":\"\u987a\u5fc3\u5feb\u6377\"},\"YDKY\":{\"expressCode\":\"yundakuaiyun\",\"expressName\":\"\u97f5\u8fbe\u5feb\u8fd0\"},\"FENGWANG\":{\"expressCode\":\"fengwang\",\"expressName\":\"\u4e30\u7f51\u901f\u8fd0\"}}";
        String expressCode = "GMSF";
        Map jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (null != jsonToMap.get(expressCode)) {
            Map map = (Map)jsonToMap.get(expressCode);
            resStream.putAll(map);
        }
        System.out.println(JsonUtil.buildNormalBinder().toJson(resStream));
    }

    @Override
    public String sendRefundStateForEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String refundCode = (String)resStream.get("refundCode");
        String dataState = (String)resStream.get("dataState");
        if (StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.contractBillcode");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.refundCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcRefundReDomain refundByCode = this.getRefundByCode(refundCode, tenantCode);
        if (null == refundByCode) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOrder.refundCode", "\u9000\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String code = null;
        code = "FULFILLED".equals(dataState) ? this.refundNext(refundCode, tenantCode, resStream) : this.refundBack(refundCode, tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    @Override
    public String reviewLogisticsSigning(String sendGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)sendGoodsCode)) {
            throw new ApiException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        final HashMap<String, String> querypmap = new HashMap<String, String>();
        querypmap.put("tenantCode", ComConstants.tenantCode);
        querypmap.put("contractObillcode", sendGoodsCode);
        String sendQueryPromotion = "sg.sendgoods.querySendgoodsPage";
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)querypmap));
            }
        };
        SgSendgoods sgSendgoods = null;
        try {
            QueryResult supQueryResult = this.getQueryResutl(sendQueryPromotion, map, SgSendgoods.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                logger.error(this.SYS_CODE + ".reviewLogisticsSigning.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
                throw new ApiException(sendGoodsCode + "\u83b7\u53d6\u4e0d\u5230\u53d1\u8d27\u5355");
            }
            sgSendgoods = (SgSendgoods)supQueryResult.getList().get(0);
            HashMap<String, SgSendgoodsLogDomain> pmap = new HashMap<String, SgSendgoodsLogDomain>();
            String saveSendgoodsLog = "sg.sendgoodsLog.saveSendgoodsLog";
            SgSendgoodsLogDomain sgSendgoodsLogDomain = new SgSendgoodsLogDomain();
            sgSendgoodsLogDomain.setSendgoodsLogName("\u7269\u6d41\u7b7e\u6536");
            sgSendgoodsLogDomain.setSendgoodsLogSendmem("\u7269\u6d41\u7b7e\u6536");
            sgSendgoodsLogDomain.setSendgoodsLogMsg("\u7269\u6d41\u7b7e\u6536");
            Date date = new Date();
            sgSendgoodsLogDomain.setGmtUse(date);
            sgSendgoodsLogDomain.setTenantCode(sgSendgoods.getTenantCode());
            sgSendgoodsLogDomain.setSendgoodsCode(sgSendgoods.getSendgoodsCode());
            pmap.put("sgSendgoodsLogDomain", sgSendgoodsLogDomain);
            try {
                this.getInternalRouter().inInvoke(saveSendgoodsLog, pmap);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(sendGoodsCode + ".reviewLogisticsSigning.pmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u66f4\u65b0\u6570\u636e\u5931\u8d25"));
                throw new ApiException(sendGoodsCode + "\u7269\u6d41\u7b7e\u6536\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".reviewLogisticsSigning.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
            throw new ApiException(sendGoodsCode + "\u7269\u6d41\u7b7e\u6536\u5f02\u5e38");
        }
        return this.makeSuccessReturn(sendGoodsCode + "\u7269\u6d41\u7b7e\u6536\u63a5\u6536\u6210\u529f");
    }

    @Override
    public String deliveryNum(SgSendgoodsDomain sgSendgoodsDomain) {
        LogRouterlogDomain logRouterlogDomain = this.creteLogRouterlogDomain(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain), "busdata.exOrder.deliveryNum", sgSendgoodsDomain.getSendgoodsCode(), "u9->\u53d1\u8d27\u63a5\u53e3\u56de\u4f20");
        logger.error(this.SYS_CODE + ".deliveryNum", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        if (sgSendgoodsDomain == null) {
            logger.error(this.SYS_CODE + ".deliveryNum.isnull");
            throw new ApiException("\u8bf7\u8f93\u5165\u6b63\u786e\u5165\u53c2");
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getSendgoodsCode())) {
            logRouterlogDomain.setRouterlogReturn("\u8bf7\u8f93\u5165\u53d1\u8d27\u5355\u53f7");
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".deliveryNum.sendgoodsCode.isnull", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            throw new ApiException("\u8bf7\u8f93\u5165\u53d1\u8d27\u5355\u53f7");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            logRouterlogDomain.setRouterlogReturn("\u8bf7\u8f93\u5165\u53d1\u8d27\u8be6\u60c5\u96c6\u5408\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".deliveryNum.sgSendgoodsGoodsDomainList.isnull", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            throw new ApiException("\u8bf7\u8f93\u5165\u53d1\u8d27\u8be6\u60c5\u96c6\u5408\u4e3a\u7a7a");
        }
        if (sgSendgoodsDomain.getSendgoodsGddate() == null) {
            logRouterlogDomain.setRouterlogReturn("\u53d1\u8d27\u65f6\u95f4\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".deliveryNum.sendgoodsCode.isnull", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            throw new ApiException("\u53d1\u8d27\u65f6\u95f4\u4e3a\u7a7a");
        }
        final HashMap<String, Object> querypmap = new HashMap<String, Object>();
        querypmap.put("tenantCode", ComConstants.tenantCode);
        querypmap.put("sendgoodsCode", sgSendgoodsDomain.getSendgoodsCode());
        querypmap.put("goodsFlag", true);
        String sendgoods = "sg.sendgoods.querySgSendgoodsPageReDomain";
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)querypmap));
            }
        };
        try {
            QueryResult supQueryResult = this.getQueryResutl(sendgoods, map, SgSendgoodsReDomain.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                logRouterlogDomain.setRouterlogReturn("\u83b7\u53d6\u4e0d\u5230\u53d1\u8d27\u5355");
                logRouterlogDomain.setRouterlogReturnstate("-1");
                logRouterlogDomain.setRouterlogReturnstates("error");
                this.sendLog(logRouterlogDomain);
                logger.error(this.SYS_CODE + ".deliveryNum.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
                throw new ApiException("\u6839\u636e" + sgSendgoodsDomain.getSendgoodsCode() + "\u83b7\u53d6\u4e0d\u5230\u53d1\u8d27\u5355");
            }
            SgSendgoodsReDomain sgSendgoodsDbReDomain = (SgSendgoodsReDomain)supQueryResult.getList().get(0);
            if (sgSendgoodsDbReDomain.getDataState() != 0) {
                logRouterlogDomain.setRouterlogReturn("\u53d1\u8d27\u5355\u5df2\u7ecf\u4e0d\u662f\u5f85\u53d1\u8d27\u72b6\u6001");
                logRouterlogDomain.setRouterlogReturnstate("-1");
                logRouterlogDomain.setRouterlogReturnstates("error");
                this.sendLog(logRouterlogDomain);
                logger.error(this.SYS_CODE + ".deliveryNum.supQueryResult", (Object)(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDbReDomain) + ": \u67e5\u8be2\u5931\u8d25"));
                throw new ApiException("\u53d1\u8d27\u5355\u5df2\u7ecf\u4e0d\u662f\u5f85\u53d1\u8d27\u72b6\u6001");
            }
            Map<String, SgSendgoodsGoodsDomain> collectMap = sgSendgoodsDbReDomain.getSgSendgoodsGoodsDomainList().stream().collect(Collectors.toMap(u -> u.getSendgoodsGoodsCode(), u -> u));
            ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
            HashMap<String, String> goodsMap = new HashMap<String, String>();
            for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                BigDecimal sendgoodsGoodsCamount;
                if (!collectMap.containsKey(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode())) {
                    logRouterlogDomain.setRouterlogReturn("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u5bf9\u5e94\u5355\u53f7\u4e0d\u5b58\u5728");
                    logRouterlogDomain.setRouterlogReturnstate("-1");
                    logRouterlogDomain.setRouterlogReturnstates("error");
                    this.sendLog(logRouterlogDomain);
                    throw new ApiException("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u5bf9\u5e94\u5355\u53f7\u4e0d\u5b58\u5728");
                }
                if (sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount() == null) {
                    logRouterlogDomain.setRouterlogReturn("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u5bf9\u5e94\u7684\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
                    logRouterlogDomain.setRouterlogReturnstate("-1");
                    logRouterlogDomain.setRouterlogReturnstates("error");
                    this.sendLog(logRouterlogDomain);
                    throw new ApiException("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u5bf9\u5e94\u7684\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
                }
                SgSendgoodsGoodsDomain sgSendgoodsGoodsDbDomain = collectMap.get(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode());
                BigDecimal bigDecimal = sendgoodsGoodsCamount = sgSendgoodsGoodsDbDomain.getSendgoodsGoodsCamount() == null ? BigDecimal.ZERO : sgSendgoodsGoodsDbDomain.getSendgoodsGoodsCamount();
                if (sendgoodsGoodsCamount.add(sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount()).compareTo(sgSendgoodsGoodsDbDomain.getGoodsNum()) > 0) {
                    logRouterlogDomain.setRouterlogReturn("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u53d1\u8d27\u6570\u91cf\u8d85\u8fc7\u5b9e\u9645\u6570\u91cf");
                    logRouterlogDomain.setRouterlogReturnstate("-1");
                    logRouterlogDomain.setRouterlogReturnstates("error");
                    this.sendLog(logRouterlogDomain);
                    throw new ApiException("\u884c\u53f7" + sgSendgoodsGoodsDomain.getSendgoodsGoodsCode() + "\u53d1\u8d27\u6570\u91cf\u8d85\u8fc7\u5b9e\u9645\u6570\u91cf");
                }
                if (null == sgSendgoodsGoodsDbDomain.getContractGoodsPrice()) {
                    sgSendgoodsGoodsDbDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                if (null == sgSendgoodsGoodsDbDomain.getSendgoodsGoodsCamount()) {
                    sgSendgoodsGoodsDbDomain.setSendgoodsGoodsCamount(BigDecimal.ZERO);
                }
                if (null == sgSendgoodsGoodsDbDomain.getGoodsNum()) {
                    sgSendgoodsGoodsDbDomain.setGoodsNum(BigDecimal.ZERO);
                }
                if (null == sgSendgoodsGoodsDbDomain.getGoodsTopweight()) {
                    sgSendgoodsGoodsDbDomain.setGoodsTopweight(BigDecimal.ZERO);
                }
                sgSendgoodsGoodsDbDomain.setSendgoodsGoodsCamount(sgSendgoodsGoodsDbDomain.getSendgoodsGoodsCamount().add(sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount()));
                sgSendgoodsGoodsDbDomain.setGoodsSpec5(sgSendgoodsGoodsDomain.getGoodsSpec5());
                if (goodsMap.containsKey(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode())) continue;
                goodsMap.put(sgSendgoodsGoodsDomain.getSendgoodsGoodsCode(), sgSendgoodsGoodsDomain.getSendgoodsGoodsCode());
                sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDbDomain);
            }
            sgSendgoodsDbReDomain.setContractNbillcode(sgSendgoodsDomain.getContractNbillcode());
            sgSendgoodsDbReDomain.setSendgoodsGddate(sgSendgoodsDomain.getSendgoodsGddate());
            sgSendgoodsDbReDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
            this.deliverySgNum(sgSendgoodsDbReDomain);
            logRouterlogDomain.setRouterlogReturnstates("success");
            this.sendLog(logRouterlogDomain);
        }
        catch (ApiException e) {
            logRouterlogDomain.setRouterlogReturn(e.getErrCode());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".deliveryNum.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
            throw new ApiException(e.getErrCode());
        }
        catch (Exception e) {
            logRouterlogDomain.setRouterlogReturn(e.getMessage());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".deliveryNum.querypmap", (Object)(JsonUtil.buildNormalBinder().toJson(querypmap) + ": \u67e5\u8be2\u5931\u8d25"));
            throw new ApiException("\u53d1\u8d27\u51fa\u5e93\u56de\u4f20\u5931\u8d25");
        }
        return this.makeSuccessReturn("success");
    }

    public static void main1(String[] args) {
    }

    private LocalDateTime getLocalDateTime(String datetimeStr) {
        if (StringUtils.isBlank((String)datetimeStr)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(datetimeStr, df);
    }

    private DdFalgSetting queryDdFlagSetting(final String tenantCode, InternalRouter internalRouter, final String flagSettingCode) {
        final HashMap<String, Object> ddflagMap = new HashMap<String, Object>(){
            {
                this.put("flagSettingCode", flagSettingCode);
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> ddflagParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)ddflagMap));
            }
        };
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.ddflagParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddflagParamMap));
        String flagSettingListStr = (String)internalRouter.inInvoke("dd.falgSetting.queryFalgSettingPage", (Map)ddflagParamMap);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFla\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(flagSettingListStr, SupQueryResult.class);
        List flagSettingList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DdFalgSetting.class);
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.flagSettingList", (Object)JsonUtil.buildNormalBinder().toJson((Object)flagSettingList));
        logger.error(this.SYS_CODE + ".sendUpdateCustomer.querDdFlag", (Object)"\u67e5\u8be2ddFlag\u7ed3\u675f");
        if (flagSettingList == null) {
            return null;
        }
        return (DdFalgSetting)flagSettingList.get(0);
    }

    @Override
    public String sendLoadU9Order(String erpDataStateStr, int pageSize, String starDateStr, String endDateStr, String contractBillcodeStr, String tenantCode) {
        QueryResult<DdFalgSetting> qdlist = this.queryDdFlagSetting(ComConstants.tenantCode, "ContractPartA");
        HashMap<String, DdFalgSetting> orgchannelMap = new HashMap<String, DdFalgSetting>();
        if (null != qdlist && ListUtil.isNotEmpty((Collection)qdlist.getList())) {
            for (DdFalgSetting ddFalgSetting : qdlist.getList()) {
                orgchannelMap.put(ddFalgSetting.getFlagSettingInfo(), ddFalgSetting);
            }
        }
        String sql = "";
        int pageIndex = 1;
        List<OcContractDomain> occontractU9List = null;
        try {
            boolean b = true;
            while (b) {
                if (StringUtils.isNotBlank((String)starDateStr) && StringUtils.isNotBlank((String)erpDataStateStr)) {
                    sql = "WITH NumberedRows AS (\n                        SELECT\n                        *,\n                        ROW_NUMBER ( ) OVER ( ORDER BY \u4e0b\u5355\u65e5\u671f ASC ) AS RowNum \n                        FROM\n                        L_LSXSDD_OMS2\n                        WHERE \u4e0b\u5355\u65e5\u671f >= ?\n                        and \u4e0b\u5355\u65e5\u671f <= ?\n                        and \u8ba2\u5355\u72b6\u6001 = ?\n                        ) SELECT\n                        * \n                        FROM\n                        NumberedRows \n                        WHERE\n                        RowNum BETWEEN ? \n                        AND ?;";
                    logger.debug(this.SYS_CODE + ".sendLoadU9Order.sql", (Object)sql);
                    occontractU9List = SqlServerUtils.getOcContractForListU91(sql, starDateStr, endDateStr, (pageIndex - 1) * pageSize, pageIndex * pageSize, erpDataStateStr);
                } else if (StringUtils.isNotBlank((String)contractBillcodeStr)) {
                    sql = "SELECT\n                        *\n                        FROM\n                        L_LSXSDD_OMS2\n                        WHERE ERP\u5355\u53f7 in (";
                    String[] split = contractBillcodeStr.split(",");
                    for (int i = 0; i < split.length; ++i) {
                        sql = i == split.length - 1 ? sql + "'" + split[i] + "')" : sql + "'" + split[i] + "',";
                    }
                    logger.debug(this.SYS_CODE + ".sendLoadU9Order.sql", (Object)sql);
                    occontractU9List = SqlServerUtils.getOcContractForListU92(sql);
                    b = false;
                }
                if (CollectionUtils.isEmpty(occontractU9List)) {
                    logger.error(this.SYS_CODE + ".sendLoadU9Order.occontractU9List.isnull", (Object)(starDateStr + "==" + endDateStr + "==" + contractBillcodeStr));
                    b = false;
                    break;
                }
                sql = "SELECT\n                        *\n                        FROM\n                        L_LSXSDD_OMS\n                        WHERE ERP\u5355\u53f7 in ('";
                for (int i = 0; i < occontractU9List.size(); ++i) {
                    sql = i == occontractU9List.size() - 1 ? sql + ((OcContractDomain)occontractU9List.get(i)).getContractNbbillcode() + "' )" : sql + ((OcContractDomain)occontractU9List.get(i)).getContractNbbillcode() + "','";
                }
                List<OcContractGoodsDomain> ocContractGoodsDomainList = SqlServerUtils.getOcContractGoodsForList(sql);
                if (org.apache.commons.collections.CollectionUtils.isEmpty(ocContractGoodsDomainList)) {
                    logger.error(this.SYS_CODE + ".sendLoadU9Order.ocContractGoodsDomainList.isnull", (Object)sql);
                    b = false;
                    break;
                }
                ++pageIndex;
                String custrelCode = occontractU9List.stream().map(u -> u.getCustrelCode()).distinct().collect(Collectors.joining(","));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userinfoOcode", custrelCode);
                map.put("tenantCode", ComConstants.tenantCode);
                QueryResult<UmUserinfoReDomain> umUserinfoReDomainQueryResult = this.queryUserinfoPage(map);
                if (umUserinfoReDomainQueryResult == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)umUserinfoReDomainQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendLoadU9Order.umUserinfoReDomainQueryResult.isnull", map);
                    b = false;
                    break;
                }
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("merchantCode", umUserinfoReDomainQueryResult.getList().stream().map(u -> u.getUserinfoCode()).collect(Collectors.joining(",")));
                map1.put("fundType", "01");
                HashMap<String, String> invokeMap1 = new HashMap<String, String>();
                invokeMap1.put("map", JsonUtil.buildNonNullBinder().toJson(map1));
                QueryResult quresult1 = this.getQueryResutl("vd.faccount.queryOuterFaccountInfoPage", invokeMap1, VdFaccountInfo.class);
                if (quresult1 == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)quresult1.getList())) {
                    logger.error(this.SYS_CODE + ".sendLoadU9Order.quresult1.isnull", map1);
                    b = false;
                    break;
                }
                HashMap<String, Object> userPageMap = new HashMap<String, Object>();
                userPageMap.put("userRelname", occontractU9List.stream().map(u -> u.getContractExtValue10()).collect(Collectors.joining(",")));
                QueryResult<UmUserReDomain> umUserReDomainQueryResult = this.queryUserPage(userPageMap);
                for (OcContractDomain ocContractDomain : occontractU9List) {
                    List<OcContractGoodsDomain> collect;
                    List collect2;
                    HashMap<String, Object> queryOrderPageMap = new HashMap<String, Object>();
                    queryOrderPageMap.put("contractNbbillcode", ocContractDomain.getContractNbbillcode());
                    queryOrderPageMap.put("tenantCode", ComConstants.tenantCode);
                    QueryResult<OcContractReDomain> ocContractReDomainQueryResult1 = this.queryOrderPage(queryOrderPageMap);
                    if (ocContractReDomainQueryResult1 != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ocContractReDomainQueryResult1.getList())) continue;
                    DdFalgSetting ddFalgSetting = (DdFalgSetting)orgchannelMap.get(ocContractDomain.getMschannelCode());
                    ocContractDomain.setTenantCode(ComConstants.tenantCode);
                    if (null == ddFalgSetting) {
                        logger.error("\u5386\u53f2\u8ba2\u5355\u53f7" + ocContractDomain.getContractNbbillcode() + "\u6e20\u9053\u4fe1\u606f\u6ca1\u6709\u5339\u914d\u5230");
                        continue;
                    }
                    if (umUserReDomainQueryResult != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)umUserReDomainQueryResult.getList()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(collect2 = umUserReDomainQueryResult.getList().stream().filter(u -> u.getUserRelname().equals(ocContractDomain.getContractExtValue10())).collect(Collectors.toList()))) {
                        ocContractDomain.setContractExtValue9(((UmUserReDomain)collect2.get(0)).getUserName());
                    }
                    ocContractDomain.setContractUserurl("U9");
                    HashMap<String, Object> applyMap = new HashMap<String, Object>();
                    applyMap.put("tenantCode", ComConstants.tenantCode);
                    applyMap.put("userinfoInvite", ocContractDomain.getCustrelCode());
                    applyMap.put("userinfoChannelcode", ocContractDomain.getMschannelCode());
                    applyMap.put("dataState", "1");
                    List<UmUserinfoapply> umUserinfoapplies = this.queryUserinfoApply(applyMap);
                    if (ListUtil.isEmpty(umUserinfoapplies)) {
                        logger.error("\u5386\u53f2\u8ba2\u5355\u53f7.applyMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                        continue;
                    }
                    ocContractDomain.setChannelCode(umUserinfoapplies.get(0).getUserinfoDischannelcode());
                    ocContractDomain.setChannelName(umUserinfoapplies.get(0).getUserinfoDischannelname());
                    ocContractDomain.setMemberGcode(ddFalgSetting.getFlagSettingInfo());
                    ocContractDomain.setMemberGname(ddFalgSetting.getFlagSettingPro());
                    ocContractDomain.setMemberCode("20000210463648");
                    ocContractDomain.setMemberName("\u4e0a\u6d77\u7231\u5eb7");
                    ocContractDomain.setMemberMcode(ocContractDomain.getMemberCode());
                    ocContractDomain.setMemberMname(ocContractDomain.getMemberName());
                    if ("\u5173\u95ed".equals(ocContractDomain.getErpStatus())) {
                        ocContractDomain.setContractType("I56");
                    } else if ("\u5ba1\u6838".equals(ocContractDomain.getErpStatus())) {
                        ocContractDomain.setContractType("U56");
                    } else {
                        logger.error("\u5386\u53f2\u8ba2\u5355\u53f7" + ocContractDomain.getContractNbbillcode() + "\u72b6\u6001\u6ca1\u6709\u5339\u914d\u5230" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                        continue;
                    }
                    if (umUserinfoReDomainQueryResult != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)umUserinfoReDomainQueryResult.getList())) {
                        collect = umUserinfoReDomainQueryResult.getList().stream().filter(u -> u.getUserinfoOcode().equals(ocContractDomain.getCustrelCode())).collect(Collectors.toList());
                        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(collect)) {
                            logger.error("\u5386\u53f2\u8ba2\u5355\u53f7" + ocContractDomain.getContractNbbillcode() + "\u5ba2\u6237\u6ca1\u6709\u5339\u914d\u5230" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                            continue;
                        }
                    } else {
                        logger.error("\u5386\u53f2\u8ba2\u5355\u53f7" + ocContractDomain.getContractNbbillcode() + "\u5ba2\u6237\u540d\u79f0\u6682\u672a\u67e5\u8be2\u5230" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                        continue;
                    }
                    UmUserinfoReDomain umUserinfoReDomain = (UmUserinfoReDomain)collect.get(0);
                    ocContractDomain.setMemberBcode(umUserinfoReDomain.getUserinfoCode());
                    ocContractDomain.setMemberBname(umUserinfoReDomain.getUserinfoCompname());
                    ocContractDomain.setContractExtValue7(umUserinfoReDomain.getUserinfoCompname());
                    if (quresult1 != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)quresult1.getList())) {
                        collect = quresult1.getList().stream().filter(u -> u.getMerchantCode().equals(ocContractDomain.getMemberBcode()) && u.getChannelCode().equals(ocContractDomain.getChannelCode())).collect(Collectors.toList());
                        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(collect)) {
                            logger.error("\u5386\u53f2\u8ba2\u5355\u53f7" + ocContractDomain.getContractNbbillcode() + "\u5386\u53f2\u8d26\u6237\u6ca1\u6709\u5339\u914d\u5230" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                            continue;
                        }
                    } else {
                        logger.error("\u5386\u53f2\u8ba2\u5355\u53f7" + ocContractDomain.getContractNbbillcode() + "\u5386\u53f2\u8d26\u6237\u6682\u672a\u67e5\u8be2\u5230" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                        continue;
                    }
                    OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
                    ocContractSettlDomain.setMemberCode("20000210463648");
                    ocContractSettlDomain.setMemberName("\u4e0a\u6d77\u7231\u5eb7");
                    ocContractSettlDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                    ocContractSettlDomain.setMemberBname(ocContractDomain.getMemberBname());
                    ocContractSettlDomain.setMemberCcode("20000210463648");
                    ocContractSettlDomain.setContractSettlType("0");
                    ocContractSettlDomain.setContractSettlBlance("VD");
                    ocContractSettlDomain.setContractPmode("0");
                    ocContractSettlDomain.setContractSettlGmoney(ocContractDomain.getContractPaygmoney());
                    ocContractSettlDomain.setContractSettlPmoney(ocContractDomain.getContractPaygmoney());
                    ocContractSettlDomain.setTenantCode(ocContractDomain.getTenantCode());
                    ocContractSettlDomain.setContractSettlOpno1(((VdFaccountInfo)collect.get(0)).getFaccountOuterNo());
                    ArrayList<OcContractSettlDomain> list = new ArrayList<OcContractSettlDomain>();
                    list.add(ocContractSettlDomain);
                    ocContractDomain.setOcContractSettlList(list);
                    collect = ocContractGoodsDomainList.stream().filter(u -> u.getErpNo().equals(ocContractDomain.getContractNbbillcode())).collect(Collectors.toList());
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(collect)) {
                        logger.error("\u5386\u53f2\u8ba2\u5355\u53f7" + ocContractDomain.getContractNbbillcode() + "\u4e3a\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                        continue;
                    }
                    for (OcContractGoodsDomain ocContractGoodsDomain : collect) {
                        ocContractGoodsDomain.setGoodsType("00");
                        if ("14".equals(ocContractDomain.getPricesetCurrency1())) {
                            ocContractGoodsDomain.setGoodsSpec5("14");
                            continue;
                        }
                        ocContractGoodsDomain.setGoodsSpec5("10");
                    }
                    if ("U56".equals(ocContractDomain.getContractType())) {
                        List collect1 = collect.stream().filter(u -> u.getGoodsNum().compareTo(u.getContractGoodsSendnum()) == 0).collect(Collectors.toList());
                        if (collect1.size() == collect.size()) {
                            ocContractDomain.setContractUserurl("DONE");
                        } else {
                            collect1 = collect.stream().filter(u -> u.getContractGoodsSendnum().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
                            if (collect1.size() == collect.size()) {
                                ocContractDomain.setContractUserurl("UNDO");
                            } else {
                                ocContractDomain.setContractUserurl("DOING");
                            }
                        }
                    }
                    ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
                    OcPackageDomain ocPackageDomain = new OcPackageDomain();
                    ocPackageDomain.setContractGoodsList(collect);
                    ocPackageDomain.setGoodsInmoney(ocContractDomain.getDataBmoney());
                    ocPackageDomain.setGoodsMoney(ocContractDomain.getContractInmoney());
                    packageList.add(ocPackageDomain);
                    ocContractDomain.setPackageList(packageList);
                    map = new HashMap();
                    map.put("contractNbbillcode", ocContractDomain.getContractNbbillcode());
                    QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderReDomainPage(map);
                    if (ocContractReDomainQueryResult != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ocContractReDomainQueryResult.getList())) continue;
                    this.sendSaveExOrder(ocContractDomain);
                }
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendLoadU9Order.e", (Throwable)e);
        }
        return "success";
    }

    private List<UmUserinfoapply> queryUserinfoApply(final Map<String, Object> applyMap) {
        if (MapUtil.isEmpty(applyMap)) {
            logger.error(this.SYS_CODE + ".queryUserinfoApply.applyMap", (Object)"isnull");
            return null;
        }
        HashMap<String, Object> applyParmMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)applyMap));
            }
        };
        String applyStr = this.internalInvoke("um.umUserinfoapply.queryUserinfoapplyPage", applyParmMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(applyStr, SupQueryResult.class);
        List applyList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), UmUserinfoapply.class);
        return applyList;
    }

    @Override
    public String sendLoadU9Sendgoods(String memberCode, String channelCode, int page, String starDateStr, String endDateStr, String contractBillcodeStr, String sendgoodsCodeStr, String tenantCode) {
        String sql = "";
        int pageIndex = 1;
        int pageSize = 20;
        Date date = new Date();
        if (StringUtils.isBlank((String)starDateStr)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -30);
            starDateStr = DateUtils.getDateString((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (StringUtils.isBlank((String)endDateStr)) {
            endDateStr = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        }
        List<SgU9Domain> sgU9DomainList = null;
        try {
            boolean b = true;
            while (b) {
                if (StringUtils.isNotBlank((String)starDateStr) && StringUtils.isNotBlank((String)endDateStr) && StringUtils.isBlank((String)contractBillcodeStr)) {
                    sql = "WITH NumberedRows AS (\n    SELECT\n        *,\n        ROW_NUMBER() OVER (ORDER BY \u5e94\u6536\u5355\u521b\u5efa\u65e5\u671f ASC) AS RowNum\n    FROM\n        CH_OMS\n    WHERE \u5e94\u6536\u5355\u521b\u5efa\u65e5\u671f >= ?\n      and \u5e94\u6536\u5355\u521b\u5efa\u65e5\u671f <= ?\n) SELECT\n    *\nFROM\n    NumberedRows\nWHERE\n    RowNum BETWEEN ?\n    AND ?;";
                    logger.info(this.SYS_CODE + ".sendLoadU9Sendgoods.sql", (Object)sql);
                    sgU9DomainList = SqlServerUtils.getSgForListU91(sql, starDateStr, endDateStr, (pageIndex - 1) * pageSize, pageIndex * pageSize);
                } else if (StringUtils.isNotBlank((String)contractBillcodeStr)) {
                    sql = "SELECT\n                        *\n                        FROM\n                        CH_OMS\n                        WHERE OMS\u5355\u53f7 in (";
                    String[] split = contractBillcodeStr.split(",");
                    for (int i = 0; i < split.length; ++i) {
                        sql = i == split.length - 1 ? sql + "'" + split[i] + "')" : sql + "'" + split[i] + "',";
                    }
                    logger.info(this.SYS_CODE + ".sendLoadU9Sendgoods.sql", (Object)sql);
                    sgU9DomainList = SqlServerUtils.getSgForListU92(sql);
                    b = false;
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(sgU9DomainList)) {
                    logger.error(this.SYS_CODE + ".sendLoadU9Sendgoods.sgU9DomainList.isnull", (Object)(starDateStr + "==" + endDateStr + "==" + contractBillcodeStr));
                    b = false;
                    break;
                }
                for (SgU9Domain sgU9Domain : sgU9DomainList) {
                    HashMap<String, Object> queryOrderPageMap = new HashMap<String, Object>();
                    queryOrderPageMap.put("businessOrder", sgU9Domain.getSendgoodsCode());
                    queryOrderPageMap.put("tenantCode", ComConstants.tenantCode);
                    SupQueryResult<PteBalancelistOpReDomain> pteBalancelistOpReDomainSupQueryResult = this.querypteBalancelistOpPage(queryOrderPageMap);
                    if (pteBalancelistOpReDomainSupQueryResult == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pteBalancelistOpReDomainSupQueryResult.getList())) {
                        logger.error(this.SYS_CODE + ".sendLoadU9Sendgoods.pteBalancelistOpReDomainSupQueryResult" + queryOrderPageMap + "\u4e3a\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f" + JsonUtil.buildNormalBinder().toJson(pteBalancelistOpReDomainSupQueryResult));
                        continue;
                    }
                    for (PteBalancelistOpReDomain pteBalancelistOpReDomain : pteBalancelistOpReDomainSupQueryResult.getList()) {
                        try {
                            pteBalancelistOpReDomain.setBalanceFee(sgU9Domain.getFpAmount());
                            pteBalancelistOpReDomain.setBalanceFee2(pteBalancelistOpReDomain.getBalanceAmount().subtract(sgU9Domain.getFpAmount()));
                            pteBalancelistOpReDomain.setOrderCurrency(sgU9Domain.getFpNo());
                            pteBalancelistOpReDomain.setBusinessDes1(sgU9Domain.getDocno());
                            this.updatepteBalancelistOp(pteBalancelistOpReDomain);
                        }
                        catch (Exception e) {
                            logger.error(this.SYS_CODE + ".pteBalancelistOpReDomainSupQueryResult.e", (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".pteBalancelistOpReDomainSupQueryResult.e", (Throwable)e);
        }
        return "success";
    }

    @Override
    public String sendLoadU9RefundCode(String erpDataStateStr, String page, String starDateStr, String endDateStr, String fundCodeStr, String tenantCode) {
        String sql = "";
        int pageIndex = 1;
        int pageSize = 20;
        if (StringUtils.isNotBlank((String)page)) {
            pageSize = Integer.parseInt(page);
        }
        Date date = new Date();
        if (StringUtils.isBlank((String)starDateStr)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(12, -30);
            starDateStr = DateUtils.getDateString((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (StringUtils.isBlank((String)endDateStr)) {
            endDateStr = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        }
        List<OcRefundDomain> ocRefundDomainU9List = null;
        try {
            boolean b = true;
            while (b) {
                if (StringUtils.isNotBlank((String)starDateStr) && StringUtils.isNotBlank((String)endDateStr) && StringUtils.isBlank((String)fundCodeStr)) {
                    sql = "WITH NumberedRows AS (\n    SELECT\n        *,\n        ROW_NUMBER() OVER (ORDER BY \u9000\u8d27\u5355\u521b\u5efa\u65e5\u671f ASC) AS RowNum\n    FROM\n        TH_HEAD_OMS\n    WHERE \u9000\u8d27\u5355\u521b\u5efa\u65e5\u671f >= ?\n      and \u9000\u8d27\u5355\u521b\u5efa\u65e5\u671f <= ?\n) SELECT\n    *\nFROM\n    NumberedRows\nWHERE\n    RowNum BETWEEN ?\n    AND ?;";
                    logger.info(this.SYS_CODE + ".sendLoadU9RefundCode.sql", (Object)sql);
                    ocRefundDomainU9List = SqlServerUtils.getRefundForListU91(sql, starDateStr, endDateStr, (pageIndex - 1) * pageSize, pageIndex * pageSize, erpDataStateStr);
                } else if (StringUtils.isNotBlank((String)fundCodeStr)) {
                    sql = "SELECT\n                        *\n                        FROM\n                        TH_HEAD_OMS\n                        WHERE \u9000\u8d27\u5355\u53f7 in (";
                    String[] split = fundCodeStr.split(",");
                    for (int i = 0; i < split.length; ++i) {
                        sql = i == split.length - 1 ? sql + "'" + split[i] + "')" : sql + "'" + split[i] + "',";
                    }
                    logger.info(this.SYS_CODE + ".sendLoadU9RefundCode1.sql", (Object)sql);
                    ocRefundDomainU9List = SqlServerUtils.getRefundForListU92(sql);
                    b = false;
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(ocRefundDomainU9List)) {
                    logger.error(this.SYS_CODE + ".sendLoadU9RefundCode.ocRefundDomainU9List.isnull", (Object)(starDateStr + "==" + endDateStr + "==" + fundCodeStr));
                    b = false;
                    break;
                }
                sql = "SELECT\n                        *\n                        FROM\n                        th_oms\n                        WHERE \u9000\u8d27\u5355\u53f7 in ('";
                for (int i = 0; i < ocRefundDomainU9List.size(); ++i) {
                    sql = i == ocRefundDomainU9List.size() - 1 ? sql + ((OcRefundDomain)ocRefundDomainU9List.get(i)).getRefundOcode() + "' )" : sql + ((OcRefundDomain)ocRefundDomainU9List.get(i)).getRefundOcode() + "','";
                }
                List<OcRefundGoodsDomain> OcRefundGoodsDomain2 = SqlServerUtils.getOcRefundGoodsForList(sql);
                if (org.apache.commons.collections.CollectionUtils.isEmpty(OcRefundGoodsDomain2)) {
                    logger.error(this.SYS_CODE + ".sendLoadU9RefundCode.ocContractGoodsDomainList.isnull", (Object)sql);
                    b = false;
                    break;
                }
                ++pageIndex;
                for (OcRefundDomain ocRefundDomain : ocRefundDomainU9List) {
                    HashMap<String, Object> queryOrderPageMap = new HashMap<String, Object>();
                    queryOrderPageMap.put("refundOcode", ocRefundDomain.getRefundOcode());
                    queryOrderPageMap.put("tenantCode", ComConstants.tenantCode);
                    SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult = this.queryOcRefundPage(queryOrderPageMap);
                    if (ocRefundReDomainSupQueryResult != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ocRefundReDomainSupQueryResult.getList())) {
                        logger.error(this.SYS_CODE + ".sendLoadU9RefundCode.ocRefundReDomainSupQueryResult" + queryOrderPageMap + "\u4e3a\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                        continue;
                    }
                    ocRefundDomain.setTenantCode(ComConstants.tenantCode);
                    List<OcRefundGoodsDomain> collect = OcRefundGoodsDomain2.stream().filter(u -> u.getRefundGoodsOpcode().equals(ocRefundDomain.getRefundOcode())).collect(Collectors.toList());
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(collect)) {
                        logger.error(this.SYS_CODE + ".sendLoadU9RefundCode.collect.isnull", (Object)(ocRefundDomain.getRefundOcode() + "\u4e3a\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain)));
                        continue;
                    }
                    for (OcRefundGoodsDomain ocRefundGoodsDomain : collect) {
                    }
                    ocRefundDomain.setOcRefundGoodsDomainList(collect);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("refundOcode", ocRefundDomain.getRefundOcode());
                    SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult1 = this.queryOcRefundPage(map);
                    if (ocRefundReDomainSupQueryResult1 != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ocRefundReDomainSupQueryResult1.getList())) {
                        logger.error(this.SYS_CODE + ".sendLoadU9RefundCode.collect.ocRefundReDomainSupQueryResult1", (Object)(ocRefundDomain.getRefundOcode() + "\u4e3a\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain)));
                        continue;
                    }
                    try {
                        String s = this.sendSaveExRefund(JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                        logger.error(this.SYS_CODE + ".sendLoadU9RefundCodestrs!!!", (Object)(s + "ocRefundDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain)));
                    }
                    catch (Exception e) {
                        logger.error(this.SYS_CODE + ".sendLoadU9RefundCodestr.e", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendLoadU9RefundCode.e", (Throwable)e);
        }
        return "success";
    }

    public static void main(String[] args) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, -30);
        String starDateStr = DateUtils.getDateString((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        System.out.println(starDateStr);
    }
}

