/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.asd.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.asd.ComConstants;
import com.yqbsoft.laser.service.ext.channel.asd.domain.pos.PosStoreGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.um.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhStoreSkuReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.channel.asd.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhOpstoreRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhStoregoodsNumRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhStoregoodsRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.request.wh.WhWarehouseRequest;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhOpstoreResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhStoregoodsNumResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhStoregoodsResponse;
import com.yqbsoft.laser.service.ext.channel.asd.facade.response.wh.WhWarehouseResponse;
import com.yqbsoft.laser.service.ext.channel.asd.service.BusStoreService;
import com.yqbsoft.laser.service.ext.channel.asd.supbase.StoreBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusStoreServiceImpl
extends StoreBaseService
implements BusStoreService {
    private String SYS_CODE = "asddata.BusStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusStoreServiceImpl.class);
    private String ddcode = "store";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusWarehouse(WhWarehouseReDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseDomain");
            return "error";
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        WhWarehouseRequest whWarehouseRequest = new WhWarehouseRequest();
        whWarehouseRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        try {
            BeanUtils.copyAllPropertys((Object)whWarehouseRequest, (Object)whWarehouseDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Throwable)e);
            return "error";
        }
        WhWarehouseResponse whWarehouseResponse = this.restTempfacade.execute(whWarehouseRequest);
        if (null == whWarehouseResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse");
            return "error";
        }
        if (!whWarehouseResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse", (Object)whWarehouseResponse.getMsg());
            return whWarehouseResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusOpstore(WhOpstoreReDomain whOpstoreReDomain) {
        if (null == whOpstoreReDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstore.WhWarehouseDomain");
            return "error";
        }
        String tenantCode = whOpstoreReDomain.getTenantCode();
        WhOpstoreRequest whOpstoreRequest = new WhOpstoreRequest();
        whOpstoreRequest.init(this.getDdMap(tenantCode, this.ddcode, "asddata"));
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreRequest, (Object)whOpstoreReDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.e", (Object)e);
            return "error";
        }
        WhOpstoreResponse whOpstoreResponse = this.restTempfacade.execute(whOpstoreRequest);
        if (null == whOpstoreResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse");
            return "error";
        }
        if (!whOpstoreResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse", (Object)whOpstoreResponse.getMsg());
            return whOpstoreResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendPullStoreGoods(String tenantCode, String filialeNo, String optDateStr) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.tenantCode");
            return "error";
        }
        HashMap<String, Object> umMap = new HashMap<String, Object>();
        umMap.put("tenantCode", tenantCode);
        umMap.put("userinfoQuality", "store");
        umMap.put("fuzzy", true);
        if (StringUtils.isNotBlank((String)filialeNo)) {
            umMap.put("userinfoOcode", filialeNo);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(umMap));
        QueryResult userinfoQueryResult = this.getQueryResutl("um.userbase.queryUserinfoPage", map, UmUserinfoDomain.class);
        if (EmptyUtil.isEmpty((Object)userinfoQueryResult) || ListUtil.isEmpty((Collection)userinfoQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.userinfoQueryResult.null:", map);
            return "error";
        }
        WhStoregoodsRequest whOpstoreReDomain = new WhStoregoodsRequest();
        ArrayList<String> umList = new ArrayList<String>();
        for (UmUserinfoDomain umUserinfoDomain : userinfoQueryResult.getList()) {
            if (StringUtils.isBlank((String)umUserinfoDomain.getUserinfoOcode())) {
                logger.error(this.SYS_CODE + ".sendPullStoreGoods.userinfoQueryResult.null:", (Object)umUserinfoDomain.getUserinfoCode());
                continue;
            }
            this.createStore(umUserinfoDomain, whOpstoreReDomain, optDateStr, umList);
        }
        if (ListUtil.isNotEmpty(umList)) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.umList", (Object)JsonUtil.getNotDefJsonUtil().toJson(umList));
            return JsonUtil.getNotDefJsonUtil().toJson(umList);
        }
        return "success";
    }

    public String createStore(final UmUserinfoDomain umUserinfoDomain, WhStoregoodsRequest whOpstoreReDomain, final String optDateStr, List<String> umList) {
        if (null == umUserinfoDomain) {
            logger.info(this.SYS_CODE + ".createStore.umUserinfoDomain");
            return "error";
        }
        whOpstoreReDomain.setMap((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("FilialeNo", umUserinfoDomain.getUserinfoOcode());
                this.put("OptDateStr", optDateStr);
            }
        });
        whOpstoreReDomain.init(this.getDdMap(umUserinfoDomain.getTenantCode(), ComConstants.AND_APPKEY, ComConstants.AND_APPKEY));
        String method = this.getDdFlag(umUserinfoDomain.getTenantCode(), ComConstants.AND_QRYSTORK, ComConstants.AND_QRYSTORK);
        if (StringUtils.isBlank((String)method)) {
            logger.info(this.SYS_CODE + ".createStore.umUserinfoDomain", (Object)"method is null");
            return "error";
        }
        whOpstoreReDomain.setOutsideApiUrl(method);
        WhStoregoodsResponse whStoregoodsResponse = null;
        try {
            whStoregoodsResponse = this.restTempfacade.execute(whOpstoreReDomain);
        }
        catch (Exception e) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.error(this.SYS_CODE + ".createStore.whStoregoodsResponse.e", (Throwable)e);
            return "error";
        }
        if (null == whStoregoodsResponse) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStore.whStoregoodsResponse.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain));
            return "error";
        }
        if (!whStoregoodsResponse.getSuccess().booleanValue()) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStore.whOpstoreResponse", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        if (EmptyUtil.isEmpty((Object)whStoregoodsResponse.getDataObj())) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStore.dataObj", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        List posStoreGoodsDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(whStoregoodsResponse.getDataObj(), PosStoreGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)posStoreGoodsDomainList)) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.error(this.SYS_CODE + ".createStore.posStoreGoodsDomainList", (Object)("whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        List<WhOpstoreDomain> whOpstoDomains = this.makeWhOpstoreDomainstockRelease(posStoreGoodsDomainList, umUserinfoDomain);
        if (ListUtil.isNotEmpty(whOpstoDomains)) {
            try {
                this.sendSaveOpstoreBatch(whOpstoDomains);
            }
            catch (Exception e) {
                umList.add(umUserinfoDomain.getUserinfoOcode());
                logger.error(this.SYS_CODE + ".timingStock.sendSaveOpstoreBatch.param", (Throwable)e);
                return "error";
            }
        }
        return "success";
    }

    private List<WhOpstoreDomain> makeWhOpstoreDomainstockRelease(List<PosStoreGoodsDomain> posStoreGoodsDomainList, UmUserinfoDomain umUserinfoDomain) {
        if (ListUtil.isEmpty(posStoreGoodsDomainList)) {
            return null;
        }
        ArrayList<WhOpstoreDomain> whOpstoreDomains = new ArrayList<WhOpstoreDomain>();
        for (PosStoreGoodsDomain posStoreGoodsDomain : posStoreGoodsDomainList) {
            if (StringUtils.isBlank((String)posStoreGoodsDomain.getfMaterielNo()) || EmptyUtil.isEmpty((Object)posStoreGoodsDomain.getfQuantity())) {
                logger.error(this.SYS_CODE + ".createStore.makeWhOpstoreDomainstockRelease.posStoreGoodsDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)posStoreGoodsDomain));
                continue;
            }
            WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
            whOpstoreDomain.setStoreGoodsBtype("0");
            whOpstoreDomain.setStoreGoodsType("0");
            whOpstoreDomain.setStoreType("0");
            whOpstoreDomain.setGoodsNum(BigDecimal.valueOf(posStoreGoodsDomain.getfQuantity().floatValue()));
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
            whOpstoreDomain.setTenantCode(umUserinfoDomain.getTenantCode());
            whOpstoreDomain.setMemberBcode(umUserinfoDomain.getUserinfoCode());
            whOpstoreDomain.setMemberCcode(umUserinfoDomain.getUserinfoOcode());
            whOpstoreDomain.setMemberCode(umUserinfoDomain.getUserinfoParentCode());
            whOpstoreDomain.setMemberCname(umUserinfoDomain.getUserinfoParentName());
            whOpstoreDomain.setMemberBname(umUserinfoDomain.getUserinfoCompname());
            whOpstoreDomain.setMemberCname(umUserinfoDomain.getUserinfoCompname());
            whOpstoreDomain.setWarehouseCode(umUserinfoDomain.getUserinfoOcode());
            whOpstoreDomain.setWarehouseName(umUserinfoDomain.getUserinfoParentName());
            this.assWhOpstoreGoodsDomain(whOpstoreDomain, posStoreGoodsDomain, umUserinfoDomain);
            whOpstoreDomains.add(whOpstoreDomain);
        }
        return whOpstoreDomains;
    }

    private void assWhOpstoreGoodsDomain(WhOpstoreDomain whOpstoreDomain, PosStoreGoodsDomain posStoreGoodsDomain, UmUserinfoDomain umUserinfoDomain) {
        if (null == whOpstoreDomain || null == posStoreGoodsDomain || null == umUserinfoDomain) {
            return;
        }
        WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)whOpstoreGoodsDomain, (Object)whOpstoreDomain);
            whOpstoreGoodsDomain.setGoodsNo(posStoreGoodsDomain.getfMaterielNo());
            whOpstoreGoodsDomain.setGoodsEocode(posStoreGoodsDomain.getfMaterielNo());
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.valueOf(posStoreGoodsDomain.getfQuantity().floatValue()));
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.assWhOpstoreSkuDomain(whOpstoreGoodsDomain, whOpstoreDomain);
    }

    private void assWhOpstoreSkuDomain(WhOpstoreGoodsDomain whOpstoreGoodsDomain, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain || null == whOpstoreGoodsDomain) {
            return;
        }
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)whOpstoreSkuDomain, (Object)whOpstoreGoodsDomain);
            whOpstoreSkuDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum());
            whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
            whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
            whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            whOpstoreSkuDomain.setSkuEocode(whOpstoreGoodsDomain.getGoodsEocode());
            whOpstoreSkuDomain.setSkuNo(whOpstoreGoodsDomain.getGoodsNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<WhOpstoreSkuDomain> opstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
        whOpstoreDomain.setMemberMcode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberMname(whOpstoreSkuDomain.getMemberName());
        opstoreSkuDomainList.add(whOpstoreSkuDomain);
        whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(opstoreSkuDomainList);
    }

    @Override
    public String sendUpdateGoodsNum(WhOpstoreDomain whOpstoreDomain) {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList())) {
            logger.error(this.SYS_CODE + ".sendUpdateGoodsNum.whOpstoreDomain", (Object)"is null");
            return "error";
        }
        final WhOpstoreSkuDomain skuDomain = whOpstoreDomain.getWhOpstoreSkuDomainList().get(0);
        if (StringUtils.isBlank((String)skuDomain.getSkuNo()) || EmptyUtil.isEmpty((Object)skuDomain.getGoodsNum()) || StringUtils.isBlank((String)skuDomain.getWarehouseCode())) {
            logger.error(this.SYS_CODE + ".sendUpdateGoodsNum.whOpstoreDomain.skuNo", (Object)JsonUtil.buildNormalBinder().toJson((Object)skuDomain));
            return "error";
        }
        WhStoregoodsNumRequest whStoregoodsNumRequest = new WhStoregoodsNumRequest();
        whStoregoodsNumRequest.setMap((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("item_no", skuDomain.getSkuNo());
                this.put("sku_no", skuDomain.getSkuNo());
                this.put("quantity", skuDomain.getGoodsNum());
                this.put("kdt_id", skuDomain.getWarehouseCode());
            }
        });
        whStoregoodsNumRequest.init(this.getDdMap(skuDomain.getTenantCode(), this.ddcode, "asddata"));
        WhStoregoodsNumResponse storegoodsNumResponse = null;
        try {
            storegoodsNumResponse = this.restTempfacade.execute(whStoregoodsNumRequest);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateGoodsNum.storegoodsNumResponse.e", (Throwable)e);
            return "error";
        }
        if (null == storegoodsNumResponse) {
            logger.info(this.SYS_CODE + ".sendUpdateGoodsNum.storegoodsNumResponse.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)whStoregoodsNumRequest));
            return "error";
        }
        if (!storegoodsNumResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendUpdateGoodsNum.success", (Object)("msg:" + storegoodsNumResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whStoregoodsNumRequest)));
            return "error";
        }
        return "success";
    }

    @Override
    public String sendPullUpdateGoodsNum(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendPullUpdateGoodsNum.tenantCode");
            return "error";
        }
        HashMap<String, Object> umMap = new HashMap<String, Object>();
        umMap.put("tenantCode", tenantCode);
        umMap.put("userinfoQuality", "store");
        umMap.put("fuzzy", true);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(umMap));
        QueryResult userinfoQueryResult = this.getQueryResutl("um.userbase.queryUserinfoPage", map, UmUserinfoDomain.class);
        if (EmptyUtil.isEmpty((Object)userinfoQueryResult) || ListUtil.isEmpty((Collection)userinfoQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.userinfoQueryResult.null:", map);
            return "error";
        }
        WhStoregoodsRequest whOpstoreReDomain = new WhStoregoodsRequest();
        ArrayList<String> umList = new ArrayList<String>();
        for (UmUserinfoDomain umUserinfoDomain : userinfoQueryResult.getList()) {
            if (StringUtils.isBlank((String)umUserinfoDomain.getUserinfoOcode())) {
                logger.error(this.SYS_CODE + ".sendPullStoreGoods.userinfoQueryResult.null:", (Object)umUserinfoDomain.getUserinfoCode());
                continue;
            }
            this.createStoreNum(umUserinfoDomain, whOpstoreReDomain, umList);
        }
        if (ListUtil.isNotEmpty(umList)) {
            logger.error(this.SYS_CODE + ".sendPullStoreGoods.umList", (Object)JsonUtil.getNotDefJsonUtil().toJson(umList));
            return JsonUtil.getNotDefJsonUtil().toJson(umList);
        }
        return "success";
    }

    public String createStoreNum(final UmUserinfoDomain umUserinfoDomain, WhStoregoodsRequest whOpstoreReDomain, List<String> umList) {
        if (null == umUserinfoDomain) {
            logger.info(this.SYS_CODE + ".createStoreNum.umUserinfoDomain");
            return "error";
        }
        whOpstoreReDomain.setMap((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("FilialeNo", umUserinfoDomain.getUserinfoOcode());
            }
        });
        whOpstoreReDomain.init(this.getDdMap(umUserinfoDomain.getTenantCode(), this.ddcode, "asddata"));
        whOpstoreReDomain.setOutsideApiUrl("");
        WhStoregoodsResponse whStoregoodsResponse = null;
        try {
            whStoregoodsResponse = this.restTempfacade.execute(whOpstoreReDomain);
        }
        catch (Exception e) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.error(this.SYS_CODE + ".createStoreNum.whStoregoodsResponse.e", (Throwable)e);
            return "error";
        }
        if (null == whStoregoodsResponse) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStoreNum.whStoregoodsResponse.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain));
            return "error";
        }
        if (!whStoregoodsResponse.getSuccess().booleanValue()) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStoreNum.whOpstoreResponse", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        if (EmptyUtil.isEmpty((Object)whStoregoodsResponse.getDataObj())) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.info(this.SYS_CODE + ".createStoreNum.dataObj", (Object)("msg:" + whStoregoodsResponse.getMsg() + "whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        List posStoreGoodsDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(whStoregoodsResponse.getDataObj(), PosStoreGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)posStoreGoodsDomainList)) {
            umList.add(umUserinfoDomain.getUserinfoOcode());
            logger.error(this.SYS_CODE + ".createStoreNum.posStoreGoodsDomainList", (Object)("whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
            return "error";
        }
        HashMap<String, Object> storeMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", umUserinfoDomain.getTenantCode());
                this.put("memberCode", umUserinfoDomain.getUserinfoCode());
            }
        };
        QueryResult<WhStoreSkuReDomain> queryResult = this.queryStoreSkuPage((Map<String, Object>)storeMap);
        List whStoreSkuReDomains = queryResult.getList();
        ArrayList<PosStoreGoodsDomain> posList = new ArrayList<PosStoreGoodsDomain>();
        HashMap<String, BigDecimal> stringObjectMap = new HashMap<String, BigDecimal>();
        for (WhStoreSkuReDomain whStoreSkuReDomain : whStoreSkuReDomains) {
            if (StringUtils.isBlank((String)whStoreSkuReDomain.getSkuNo()) || StringUtils.isBlank((String)whStoreSkuReDomain.getWarehouseCode())) {
                logger.error(this.SYS_CODE + ".createStoreNum.whStoreSkuReDomain", (Object)("whStoreSkuReDomain:" + whStoreSkuReDomain.getStoreSkuCode()));
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whStoreSkuReDomain.getGoodsNum())) {
                whStoreSkuReDomain.setGoodsNum(BigDecimal.ZERO);
            }
            stringObjectMap.put(whStoreSkuReDomain.getWarehouseCode() + whStoreSkuReDomain.getSkuNo(), whStoreSkuReDomain.getGoodsNum());
        }
        for (PosStoreGoodsDomain posStoreGoodsDomain : posStoreGoodsDomainList) {
            if (StringUtils.isBlank((String)posStoreGoodsDomain.getfFilialeNo()) || StringUtils.isBlank((String)posStoreGoodsDomain.getfMaterielNo()) || EmptyUtil.isEmpty((Object)posStoreGoodsDomain.getfQuantity())) {
                logger.error(this.SYS_CODE + ".createStoreNum.posStoreGoodsDomainList", (Object)("whOpstoreReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain)));
                continue;
            }
            Object o = stringObjectMap.get(posStoreGoodsDomain.getfFilialeNo() + posStoreGoodsDomain.getfMaterielNo());
            if (null == o) {
                logger.error(this.SYS_CODE + ".createStoreNum.posObject", stringObjectMap.get(posStoreGoodsDomain.getfFilialeNo() + posStoreGoodsDomain.getfMaterielNo()));
                posList.add(posStoreGoodsDomain);
                continue;
            }
            BigDecimal posNum = new BigDecimal(o.toString());
            if (posNum.compareTo(new BigDecimal(String.valueOf(posStoreGoodsDomain.getfQuantity()))) == 0) {
                logger.error(this.SYS_CODE + ".createStoreNum.posNum", (Object)(posStoreGoodsDomain.getfFilialeNo() + posStoreGoodsDomain.getfMaterielNo()));
                continue;
            }
            posList.add(posStoreGoodsDomain);
        }
        List<WhOpstoreDomain> whOpstoDomains = this.makeWhOpstoreDomainstockRelease(posList, umUserinfoDomain);
        if (ListUtil.isNotEmpty(whOpstoDomains)) {
            try {
                this.sendSaveOpstoreBatch(whOpstoDomains);
            }
            catch (Exception e) {
                umList.add(umUserinfoDomain.getUserinfoOcode());
                logger.error(this.SYS_CODE + ".timingStock.sendSaveOpstoreBatch.param", (Throwable)e);
                return "error";
            }
        }
        return "success";
    }
}

