/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.bocom.service;

import com.yqbsoft.laser.service.ext.channel.bocom.BocomConstants;
import com.yqbsoft.laser.service.ext.channel.bocom.model.DdFalgSetting;
import com.yqbsoft.laser.service.ext.channel.bocom.util.AesException;
import com.yqbsoft.laser.service.ext.channel.bocom.util.Sha1;
import com.yqbsoft.laser.service.ext.channel.bocom.util.StringUtil;
import com.yqbsoft.laser.service.ext.channel.com.api.ChannelTokenService;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRlRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelCustmnsBaseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ChannelCustmnsServiceImpl
extends ChannelCustmnsBaseService {
    private static final ExecutorService pool = Executors.newFixedThreadPool(2);
    ChannelTokenService channelTokenService;

    public String getFchannelCode() {
        return BocomConstants.channelCode;
    }

    public void setChannelTokenService(ChannelTokenService channelTokenService) {
        this.channelTokenService = channelTokenService;
    }

    protected ChannelRlRequest send(ChannelRlRequest channelRequest, Map<String, Object> map) {
        this.logger.error("cmc.ChannelCustmnsBaseService.send", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        return channelRequest;
    }

    protected Object retrunParam(ChannelRlRequest channelRequest, Map<String, Object> map) {
        this.logger.error("cmc.ChannelCustmnsBaseService.retrunParam.param", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            return "success";
        }
        if (MapUtil.isNotEmpty(map) && null != map.get("echostr") && null != map.get("timestamp") && null != map.get("nonce")) {
            return map.get("echostr");
        }
        if (null != pool && null != map.get("resStream")) {
            final Map param = (Map)JsonUtil.buildNormalBinder().getJsonToMap(map.get("resStream").toString(), String.class, Object.class);
            param.putAll(map);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    ChannelCustmnsServiceImpl.this.getParam(param);
                }
            });
        }
        return "success";
    }

    private boolean checksign(Map<String, Object> map) {
        if (MapUtil.isNotEmpty(map) && null != map.get("echostr") && null != map.get("timestamp") && null != map.get("nonce")) {
            String token = this.getUrl((String)map.get("tenantCode"), "custmns_token", "custmns_token");
            if (StringUtil.isEmpty(token)) {
                this.logger.error("cmc.ChannelCustmnsBaseService.checksign.token", (Object)map.toString());
                return false;
            }
            String signature = (String)map.get("signature");
            try {
                String encrypt = Sha1.getSHA1(token, (String)map.get("timestamp"), (String)map.get("nonce"));
                this.logger.error("cmc.ChannelCustmnsBaseService.checksign.encrypt", (Object)encrypt);
                if (encrypt.equals(signature)) {
                    return true;
                }
            }
            catch (AesException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error("cmc.ChannelCustmnsBaseService.getUrl", (Object)(tenantCode + "=" + flagSettingType + "=" + flagSettingCode + "=" + value));
        return value;
    }

    private void getParam(Map<String, Object> param) {
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";
        this.logger.error("cmc.ChannelCustmnsBaseService.retrunParam.token", (Object)param.toString());
        Object token = this.getToken(param);
        if (null == token) {
            this.logger.error("cmc.ChannelCustmnsBaseService.retrunParam.token", (Object)param.toString());
            return;
        }
        url = url + token;
        this.logger.error("cmc.ChannelCustmnsBaseService.retrunParam.url", (Object)url);
        String json = this.getUrl((String)param.get("tenantCode"), "custmns", "custmns" + param.get("MsgType"));
        if (StringUtil.isEmpty(json)) {
            this.logger.error("cmc.ChannelCustmnsBaseService.retrunParam.json", (Object)param.toString());
            return;
        }
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(json, Map.class);
        for (Map map : jsonToList) {
            String template = ChannelCustmnsServiceImpl.getTemplate(JsonUtil.buildNonNullBinder().toJson((Object)map), param);
            this.logger.error("cmc.ChannelCustmnsBaseService.sendMsgWechat.sendJson", (Object)template);
            Map requestMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(template, String.class, Object.class);
            this.sendPost(requestMap, url);
        }
    }

    public static String getTemplate(String template, Map<String, Object> params) {
        String finalTemp = template;
        if (StringUtils.isBlank((String)template)) {
            return template;
        }
        for (String key : params.keySet()) {
            String value = params.get(key).toString();
            finalTemp = StringUtil.replace(finalTemp, "{" + key + "}", value);
        }
        return finalTemp;
    }

    private Object getToken(Map<String, Object> param) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ifUpdate", false);
        params.put("tenantCode", param.get("tenantCode"));
        Object token = this.channelTokenService.channelToken(params);
        if (null == token) {
            params.put("ifUpdate", true);
            token = this.channelTokenService.channelToken(params);
        }
        this.logger.error("cmc.ChannelCustmnsBaseService.retrunParam.token", token);
        return token;
    }

    public List<DdFalgSetting> getDdFalgSettingList(String tenantCode, String msgType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingType", "custmns" + msgType);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        this.logger.error("cmc.ChannelCustmnsBaseServiceddresultByPageStr.invokeMap", (Object)((Object)invokeMap).toString());
        String ddresultByPageStr = null;
        try {
            ddresultByPageStr = this.internalInvoke("dd.falgSetting.queryFalgSettingPage", invokeMap);
            this.logger.error("cmc.ChannelCustmnsBaseServiceddresultByPageStr", (Object)ddresultByPageStr);
            if (StringUtils.isBlank((String)ddresultByPageStr)) {
                this.logger.error("cmc.ChannelCustmnsBaseServiceddresultByPageStr", (Object)ddresultByPageStr);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelCustmnsBaseServiceddresultByPageStr", (Object)ddresultByPageStr, (Throwable)e);
            return null;
        }
        SupQueryResult supQueryresultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(ddresultByPageStr, SupQueryResult.class);
        if (null == supQueryresultStr) {
            this.logger.error("cmc.ChannelCustmnsBaseService.supQueryresultStr", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddresultByPageStr));
            return null;
        }
        List ddList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryresultStr.getList()), DdFalgSetting.class);
        if (ListUtil.isEmpty((Collection)ddList)) {
            this.logger.error("cmc.ChannelCustmnsBaseService.ddList", (Object)JsonUtil.buildNormalBinder().toJson((Object)supQueryresultStr));
            return null;
        }
        return ddList;
    }

    private Map<String, Object> sendPost(Map<String, Object> param, String url) {
        if (MapUtil.isEmpty(param) || StringUtils.isBlank((String)url)) {
            this.logger.error("cmc.ChannelCustmnsBaseService.sendPost", (Object)(param.toString() + "-" + url));
            return null;
        }
        String result = "";
        try {
            result = WebUtils.doPostJson((String)url, param, (int)100000, (int)100000);
            this.logger.error("cmc.ChannelCustmnsBaseService.sendPost", (Object)JsonUtil.buildNormalBinder().toJson((Object)result));
        }
        catch (IOException e) {
            this.logger.error("cmc.ChannelCustmnsBaseService.sendPost.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)e));
        }
        return null;
    }

    public static void main(String[] args) {
        String token = "40_lxN1Pjhazy1Rl_-eo36u2u9DtxtiXiXoo6MGQ2htKmK-kSvZuE7vzgZouxywScjMO0yl_fzR5RM4TXEDK0YLerTN040jSNOIl32L9thvIdWeFn19KdjtSpeHcGF1623ayRNUToKwXeVsRTLrQJPdAGAIBH";
        String file = ChannelCustmnsServiceImpl.getFile(token);
    }

    public static String getFile(String token) {
        String url = "https://api.weixin.qq.com/cgi-bin/media/upload?type=image&access_token=" + token;
        String urlPath = "http://qjstatic.oss-cn-shanghai.aliyuncs.com/logo/weixin_logo.png";
        try {
            ChannelCustmnsServiceImpl.getMediaIdFromUrl(url, urlPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMediaIdFromUrl(String urlPath, String url1) throws Exception {
        String result = null;
        String fileName = url1.substring(url1.lastIndexOf("/") + 1);
        URL mediaUrl = new URL(url1);
        HttpURLConnection meidaConn = (HttpURLConnection)mediaUrl.openConnection();
        meidaConn.setDoOutput(true);
        meidaConn.setRequestMethod("GET");
        try {
            URL urlObj = new URL(urlPath);
            HttpURLConnection con = (HttpURLConnection)urlObj.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Connection", "Keep-Alive");
            con.setRequestProperty("Charset", "UTF-8");
            String BOUNDARY = "----------" + System.currentTimeMillis();
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"media\";filelength=\"" + meidaConn.getContentLength() + "\";filename=\"" + fileName + "\"\r\n");
            sb.append("Content-Type:application/octet-stream\r\n\r\n");
            byte[] head = sb.toString().getBytes("utf-8");
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            ((OutputStream)out).write(head);
            DataInputStream in = new DataInputStream(meidaConn.getInputStream());
            int bytes = 0;
            byte[] bufferout = new byte[1024];
            while ((bytes = in.read(bufferout)) != -1) {
                ((OutputStream)out).write(bufferout, 0, bytes);
            }
            byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
            ((OutputStream)out).write(foot);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            StringBuffer buffer = new StringBuffer();
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                }
                if (result == null) {
                    result = buffer.toString();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

