/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.bocom.oauth.service;

import com.yqbsoft.laser.service.ext.channel.bocom.BocomConstants;
import com.yqbsoft.laser.service.ext.channel.bocom.domain.OauthBeanForJdVop;
import com.yqbsoft.laser.service.ext.channel.bocom.util.HttpRequestUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOauthBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DisOauthServiceImpl
extends DisOauthBaseServiceImpl {
    private String SYS_CODE = "bocom.DisOauthServiceImpl";

    public Map<String, Object> sendGetTokenParam(Map<String, Object> map) {
        return map;
    }

    public String sendGetToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.param");
            return "error";
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return "error";
        }
        String json = null;
        String url = configMap.get(BocomConstants.serviceUrl);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = HttpRequestUtil.sendGet(url, ((Object)httpParam).toString());
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        this.logger.error(this.SYS_CODE + ".sendGetToken.json1", (Object)(json + ":" + channelApiCode));
        String memberCode = (String)param.get("memberCode");
        if (channelApiCode.equals("cmc.disOauth.getUrl")) {
            return "success";
        }
        OauthBeanForJdVop oa = (OauthBeanForJdVop)JsonUtil.buildNormalBinder().getJsonToObject(json, OauthBeanForJdVop.class);
        return this.saveDisTokenForJd(disChannel, oa, memberCode);
    }

    private String saveDisTokenForJd(DisChannel disChannel, OauthBeanForJdVop oauthBean, String memberCode) {
        if (StringUtils.isBlank((String)memberCode) || null == disChannel || null == oauthBean) {
            this.logger.error(this.SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        String api = "dis.oauth.saveOauthToken";
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode(disChannel.getChannelCode());
        disOauthTokenDomain.setChannelName(disChannel.getChannelName());
        disOauthTokenDomain.setMemberCode(memberCode);
        disOauthTokenDomain.setMemberName(memberCode);
        disOauthTokenDomain.setOauthTokenExpireIn(oauthBean.getExpires_in());
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthBean.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthBean.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(disChannel.getTenantCode());
        paramMap.put("disOauthTokenDomain", JsonUtil.buildNormalBinder().toJson((Object)disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
        return "success";
    }

    public String sendReflashToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendReflashToken.param");
            return "error";
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return "error";
        }
        String json = null;
        String url = configMap.get(BocomConstants.serviceUrl);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = HttpRequestUtil.sendGet(url, ((Object)httpParam).toString());
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        String memberCode = (String)param.get("memberCode");
        this.logger.error(this.SYS_CODE + ".sendGetToken.remap", (Object)json);
        OauthBeanForJdVop oa = new OauthBeanForJdVop();
        Map remap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        oa.setAccess_token((String)remap.get("access_token"));
        oa.setExpires_in((Integer)remap.get("expires_in"));
        oa.setRefresh_token((String)remap.get("refresh_token"));
        return this.saveDisTokenForJd(disChannel, oa, memberCode);
    }

    public boolean befAppentParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, Object> param, Map<String, String> configMap) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap)) {
            return true;
        }
        String channelApiCode = (String)param.get("channelApiCode");
        if (StringUtils.isBlank((String)channelApiCode)) {
            return true;
        }
        this.logger.error(this.SYS_CODE + ".befAppentParam", (Object)channelApiCode);
        if (channelApiCode.equals("cmc.disOauth.getUrl")) {
            String client_id = configMap.get("client_id");
            String redirect_uri = configMap.get("redirect_uri");
            try {
                String encodeClientId = URLEncoder.encode(client_id, "utf-8");
                sendParam.put("client_id", encodeClientId);
                String encodeRedirectUri = URLEncoder.encode(redirect_uri, "utf-8");
                sendParam.put("redirect_uri", encodeRedirectUri);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.e1", (Throwable)e);
            }
            String url = configMap.get(BocomConstants.serviceUrl);
            HashMap<String, String> httpParam = new HashMap<String, String>();
            if (MapUtil.isNotEmpty(sendParam)) {
                for (String key : sendParam.keySet()) {
                    httpParam.put(key, String.valueOf(sendParam.get(key)));
                }
            }
            String json = "";
            try {
                json = HttpRequestUtil.sendGet(url, ((Object)httpParam).toString());
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            }
            if (StringUtils.isBlank((String)json)) {
                this.logger.error(this.SYS_CODE + ".befAppentParam.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            }
            this.logger.error(this.SYS_CODE + ".befAppentParam.json1", (Object)(json + "=" + url + ":" + sendParam.toString() + ":" + configMap.toString()));
        }
        return false;
    }

    protected String getChannelCode() {
        return null;
    }
}

