/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.chint.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.chint.dao.ZtBillMapper;
import com.yqbsoft.laser.service.ext.chint.domain.zt.ZtBillDomain;
import com.yqbsoft.laser.service.ext.chint.domain.zt.ZtBillReDomain;
import com.yqbsoft.laser.service.ext.chint.model.ZtBill;
import com.yqbsoft.laser.service.ext.chint.service.ZtBillService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZtBillServiceImpl
extends BaseServiceImpl
implements ZtBillService {
    private static final String SYS_CODE = "chint.ZtBillServiceImpl";
    private ZtBillMapper ztBillMapper;

    public void setZtBillMapper(ZtBillMapper ztBillMapper) {
        this.ztBillMapper = ztBillMapper;
    }

    private Date getSysDate() {
        try {
            return this.ztBillMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkbill(ZtBillDomain ztBillDomain) {
        if (null == ztBillDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ztBillDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setbillDefault(ZtBill ztBill) {
        if (null == ztBill) {
            return;
        }
        if (null == ztBill.getDataState()) {
            ztBill.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ztBill.getGmtCreate()) {
            ztBill.setGmtCreate(date);
        }
        ztBill.setGmtModified(date);
        if (StringUtils.isBlank((String)ztBill.getRbillCode())) {
            ztBill.setRbillCode(this.getNo(null, "ZtBill", "ztBill", ztBill.getTenantCode()));
        }
    }

    private int getbillMaxCode() {
        int code = 0;
        try {
            return this.ztBillMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getbillMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setbillUpdataDefault(ZtBill ztBill) {
        if (null == ztBill) {
            return;
        }
        ztBill.setGmtModified(this.getSysDate());
    }

    private void savebillModel(ZtBill ztBill) throws ApiException {
        if (null == ztBill) {
            return;
        }
        try {
            this.ztBillMapper.insert(ztBill);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.savebillModel.ex", (Throwable)e);
        }
    }

    private void savebillBatchModel(List<ZtBill> ztBillList) throws ApiException {
        if (null == ztBillList || ztBillList.isEmpty()) {
            return;
        }
        try {
            this.ztBillMapper.insertBatch(ztBillList);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.savebillBatchModel.ex", (Throwable)e);
        }
    }

    private ZtBill getbillModelById(Integer billId) {
        if (null == billId) {
            return null;
        }
        try {
            return this.ztBillMapper.selectByPrimaryKey(billId);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getbillModelById", (Throwable)e);
            return null;
        }
    }

    private ZtBill getbillModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ztBillMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getbillModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delbillModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ztBillMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.delbillModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtBillServiceImpl.delbillModelByCode.num");
        }
    }

    private void deletebillModel(Integer billId) throws ApiException {
        if (null == billId) {
            return;
        }
        int i = 0;
        try {
            i = this.ztBillMapper.deleteByPrimaryKey(billId);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.deletebillModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtBillServiceImpl.deletebillModel.num");
        }
    }

    private void updatebillModel(ZtBill ztBill) throws ApiException {
        if (null == ztBill) {
            return;
        }
        int i = 0;
        try {
            i = this.ztBillMapper.updateByPrimaryKey(ztBill);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebillModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebillModel.num");
        }
    }

    private void updateStatebillModel(Integer billId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == billId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billId", billId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztBillMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModel.null");
        }
    }

    private void updateStatebillModelByCode(String tenantCode, String billCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("billCode", billCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztBillMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModelByCode.null");
        }
    }

    private ZtBill makebill(ZtBillDomain ztBillDomain, ZtBill ztBill) {
        if (null == ztBillDomain) {
            return null;
        }
        if (null == ztBill) {
            ztBill = new ZtBill();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ztBill, (Object)ztBillDomain);
            return ztBill;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.makebill", (Throwable)e);
            return null;
        }
    }

    private ZtBillReDomain makeZtBillReDomain(ZtBill ztBill) {
        if (null == ztBill) {
            return null;
        }
        ZtBillReDomain ztBillReDomain = new ZtBillReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ztBillReDomain, (Object)ztBill);
            return ztBillReDomain;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.makeZtBillReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ZtBill> querybillModelPage(Map<String, Object> parammap) {
        try {
            return this.ztBillMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.querybillModel", (Throwable)e);
            return null;
        }
    }

    private int countbill(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ztBillMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.countbill", (Throwable)e);
        }
        return i;
    }

    private ZtBill createZtBill(ZtBillDomain ztBillDomain) {
        String msg = this.checkbill(ztBillDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtBillServiceImpl.savebill.checkbill", msg);
        }
        ZtBill ztBill = this.makebill(ztBillDomain, null);
        this.setbillDefault(ztBill);
        return ztBill;
    }

    @Override
    public String savebill(ZtBillDomain ztBillDomain) throws ApiException {
        ZtBill ztBill = this.createZtBill(ztBillDomain);
        this.savebillModel(ztBill);
        return ztBill.getRbillCode();
    }

    @Override
    public String savebillBatch(List<ZtBillDomain> ztBillDomainList) throws ApiException {
        if (null == ztBillDomainList || ztBillDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ZtBill> ztBillList = new ArrayList<ZtBill>();
        String code = "";
        for (ZtBillDomain ztBillDomain : ztBillDomainList) {
            ZtBill ztBill = this.createZtBill(ztBillDomain);
            code = ztBill.getRbillCode();
            ztBillList.add(ztBill);
        }
        this.savebillBatchModel(ztBillList);
        return code;
    }

    @Override
    public void updatebillState(Integer billId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == billId) {
            return;
        }
        this.updateStatebillModel(billId, dataState, oldDataState, map);
    }

    @Override
    public void updatebillStateByCode(String tenantCode, String billCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatebillModelByCode(tenantCode, billCode, dataState, oldDataState, map);
    }

    @Override
    public void updatebill(ZtBillDomain ztBillDomain) throws ApiException {
        String msg = this.checkbill(ztBillDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebill.checkbill", msg);
        }
        ZtBill oldZtBill = this.getbillModelById(ztBillDomain.getBillId());
        if (null == oldZtBill) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebill.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ZtBill ztBill = this.makebill(ztBillDomain, oldZtBill);
        this.setbillUpdataDefault(ztBill);
        this.updatebillModel(ztBill);
    }

    @Override
    public ZtBill getbill(Integer billId) {
        if (null == billId) {
            return null;
        }
        return this.getbillModelById(billId);
    }

    @Override
    public void deletebill(Integer billId) throws ApiException {
        if (null == billId) {
            return;
        }
        this.deletebillModel(billId);
    }

    @Override
    public QueryResult<ZtBill> querybillPage(Map<String, Object> map) {
        List<ZtBill> ztBillList = this.querybillModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countbill(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ztBillList);
        return queryResult;
    }

    @Override
    public ZtBill getbillByCode(String tenantCode, String billCode) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("billCode", billCode);
        return this.getbillModelByCode(map);
    }

    @Override
    public void deletebillByCode(String tenantCode, String billCode) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("billCode", billCode);
        this.delbillModelByCode(map);
    }
}

