/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.chint.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.chint.dao.ZtSecurityMapper;
import com.yqbsoft.laser.service.ext.chint.domain.zt.ZtSecurityDomain;
import com.yqbsoft.laser.service.ext.chint.domain.zt.ZtSecurityReDomain;
import com.yqbsoft.laser.service.ext.chint.model.ZtSecurity;
import com.yqbsoft.laser.service.ext.chint.service.ZtSecurityService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZtSecurityServiceImpl
extends BaseServiceImpl
implements ZtSecurityService {
    private static final String SYS_CODE = "chint.ZtSecurityServiceImpl";
    private ZtSecurityMapper ztSecurityMapper;

    public void setZtSecurityMapper(ZtSecurityMapper ztSecurityMapper) {
        this.ztSecurityMapper = ztSecurityMapper;
    }

    private Date getSysDate() {
        try {
            return this.ztSecurityMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checksecurity(ZtSecurityDomain ztSecurityDomain) {
        if (null == ztSecurityDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ztSecurityDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setsecurityDefault(ZtSecurity ztSecurity) {
        if (null == ztSecurity) {
            return;
        }
        if (null == ztSecurity.getDataState()) {
            ztSecurity.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ztSecurity.getGmtCreate()) {
            ztSecurity.setGmtCreate(date);
        }
        ztSecurity.setGmtModified(date);
        if (StringUtils.isBlank((String)ztSecurity.getSecurityCode())) {
            ztSecurity.setSecurityCode(this.getNo(null, "ZtSecurity", "ztSecurity", ztSecurity.getTenantCode()));
        }
    }

    private int getsecurityMaxCode() {
        int code = 0;
        try {
            return this.ztSecurityMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.getsecurityMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setsecurityUpdataDefault(ZtSecurity ztSecurity) {
        if (null == ztSecurity) {
            return;
        }
        ztSecurity.setGmtModified(this.getSysDate());
    }

    private void savesecurityModel(ZtSecurity ztSecurity) throws ApiException {
        if (null == ztSecurity) {
            return;
        }
        try {
            this.ztSecurityMapper.insert(ztSecurity);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtSecurityServiceImpl.savesecurityModel.ex", (Throwable)e);
        }
    }

    private void savesecurityBatchModel(List<ZtSecurity> ztSecurityList) throws ApiException {
        if (null == ztSecurityList || ztSecurityList.isEmpty()) {
            return;
        }
        try {
            this.ztSecurityMapper.insertBatch(ztSecurityList);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtSecurityServiceImpl.savesecurityBatchModel.ex", (Throwable)e);
        }
    }

    private ZtSecurity getsecurityModelById(Integer securityId) {
        if (null == securityId) {
            return null;
        }
        try {
            return this.ztSecurityMapper.selectByPrimaryKey(securityId);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.getsecurityModelById", (Throwable)e);
            return null;
        }
    }

    private ZtSecurity getsecurityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ztSecurityMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.getsecurityModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delsecurityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ztSecurityMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtSecurityServiceImpl.delsecurityModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtSecurityServiceImpl.delsecurityModelByCode.num");
        }
    }

    private void deletesecurityModel(Integer securityId) throws ApiException {
        if (null == securityId) {
            return;
        }
        int i = 0;
        try {
            i = this.ztSecurityMapper.deleteByPrimaryKey(securityId);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtSecurityServiceImpl.deletesecurityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtSecurityServiceImpl.deletesecurityModel.num");
        }
    }

    private void updatesecurityModel(ZtSecurity ztSecurity) throws ApiException {
        if (null == ztSecurity) {
            return;
        }
        int i = 0;
        try {
            i = this.ztSecurityMapper.updateByPrimaryKey(ztSecurity);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updatesecurityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updatesecurityModel.num");
        }
    }

    private void updateStatesecurityModel(Integer securityId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == securityId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("securityId", securityId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztSecurityMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updateStatesecurityModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updateStatesecurityModel.null");
        }
    }

    private void updateStatesecurityModelByCode(String tenantCode, String securityCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)securityCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("securityCode", securityCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztSecurityMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updateStatesecurityModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updateStatesecurityModelByCode.null");
        }
    }

    private ZtSecurity makesecurity(ZtSecurityDomain ztSecurityDomain, ZtSecurity ztSecurity) {
        if (null == ztSecurityDomain) {
            return null;
        }
        if (null == ztSecurity) {
            ztSecurity = new ZtSecurity();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ztSecurity, (Object)ztSecurityDomain);
            return ztSecurity;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.makesecurity", (Throwable)e);
            return null;
        }
    }

    private ZtSecurityReDomain makeZtSecurityReDomain(ZtSecurity ztSecurity) {
        if (null == ztSecurity) {
            return null;
        }
        ZtSecurityReDomain ztSecurityReDomain = new ZtSecurityReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ztSecurityReDomain, (Object)ztSecurity);
            return ztSecurityReDomain;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.makeZtSecurityReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ZtSecurity> querysecurityModelPage(Map<String, Object> parammap) {
        try {
            return this.ztSecurityMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.querysecurityModel", (Throwable)e);
            return null;
        }
    }

    private int countsecurity(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ztSecurityMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtSecurityServiceImpl.countsecurity", (Throwable)e);
        }
        return i;
    }

    private ZtSecurity createZtSecurity(ZtSecurityDomain ztSecurityDomain) {
        String msg = this.checksecurity(ztSecurityDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtSecurityServiceImpl.savesecurity.checksecurity", msg);
        }
        ZtSecurity ztSecurity = this.makesecurity(ztSecurityDomain, null);
        this.setsecurityDefault(ztSecurity);
        return ztSecurity;
    }

    @Override
    public String savesecurity(ZtSecurityDomain ztSecurityDomain) throws ApiException {
        ZtSecurity ztSecurity = this.createZtSecurity(ztSecurityDomain);
        this.savesecurityModel(ztSecurity);
        return ztSecurity.getSecurityCode();
    }

    @Override
    public String savesecurityBatch(List<ZtSecurityDomain> ztSecurityDomainList) throws ApiException {
        if (null == ztSecurityDomainList || ztSecurityDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ZtSecurity> ztSecurityList = new ArrayList<ZtSecurity>();
        String code = "";
        for (ZtSecurityDomain ztSecurityDomain : ztSecurityDomainList) {
            ZtSecurity ztSecurity = this.createZtSecurity(ztSecurityDomain);
            code = ztSecurity.getSecurityCode();
            ztSecurityList.add(ztSecurity);
        }
        this.savesecurityBatchModel(ztSecurityList);
        return code;
    }

    @Override
    public void updatesecurityState(Integer securityId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == securityId) {
            return;
        }
        this.updateStatesecurityModel(securityId, dataState, oldDataState, map);
    }

    @Override
    public void updatesecurityStateByCode(String tenantCode, String securityCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)securityCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatesecurityModelByCode(tenantCode, securityCode, dataState, oldDataState, map);
    }

    @Override
    public void updatesecurity(ZtSecurityDomain ztSecurityDomain) throws ApiException {
        String msg = this.checksecurity(ztSecurityDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updatesecurity.checksecurity", msg);
        }
        ZtSecurity oldZtSecurity = this.getsecurityModelById(ztSecurityDomain.getSecurityId());
        if (null == oldZtSecurity) {
            throw new ApiException("chint.ZtSecurityServiceImpl.updatesecurity.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ZtSecurity ztSecurity = this.makesecurity(ztSecurityDomain, oldZtSecurity);
        this.setsecurityUpdataDefault(ztSecurity);
        this.updatesecurityModel(ztSecurity);
    }

    @Override
    public ZtSecurity getsecurity(Integer securityId) {
        if (null == securityId) {
            return null;
        }
        return this.getsecurityModelById(securityId);
    }

    @Override
    public void deletesecurity(Integer securityId) throws ApiException {
        if (null == securityId) {
            return;
        }
        this.deletesecurityModel(securityId);
    }

    @Override
    public QueryResult<ZtSecurity> querysecurityPage(Map<String, Object> map) {
        List<ZtSecurity> ztSecurityList = this.querysecurityModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countsecurity(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ztSecurityList);
        return queryResult;
    }

    @Override
    public ZtSecurity getsecurityByCode(String tenantCode, String securityCode) throws ApiException {
        if (StringUtils.isBlank((String)securityCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("securityCode", securityCode);
        return this.getsecurityModelByCode(map);
    }

    @Override
    public void deletesecurityByCode(String tenantCode, String securityCode) throws ApiException {
        if (StringUtils.isBlank((String)securityCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("securityCode", securityCode);
        this.delsecurityModelByCode(map);
    }
}

