/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.chint.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.chint.api.ExStoreService;
import com.yqbsoft.laser.service.ext.chint.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.chint.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.chint.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.chint.domain.wh.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.chint.domain.wh.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.ext.chint.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.chint.domain.wh.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.ext.chint.domain.wh.WhWarehouseDomain;
import com.yqbsoft.laser.service.ext.chint.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.chint.supbase.StoreBaseService;
import com.yqbsoft.laser.service.ext.chint.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ExStoreServiceImpl
extends StoreBaseService
implements ExStoreService {
    private String SYS_CODE = "chint.ExStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExStoreServiceImpl.class);

    @Override
    public String sendSaveExWarehouse(WhWarehouseDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkWarehouse(whWarehouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.msg", msg);
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        whWarehouseDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        whWarehouseDomain.setMemberName("\u5e73\u53f0");
        try {
            String warehouseCode = this.saveWarehouse(whWarehouseDomain);
            if (StringUtils.isBlank((String)warehouseCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(warehouseCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExOpstore(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkOpstore(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.checkOpstore");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.checkOpstore", msg);
        }
        try {
            msg = this.makeWhOpstoreDomain(whOpstoreDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.makeWhOpstoreDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.makeWhOpstoreDomain", msg);
            }
            String opstoreCode = this.sendSaveOpstore(whOpstoreDomain);
            if (StringUtils.isBlank((String)opstoreCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.opstoreCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.opstoreCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(opstoreCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExOpstoreByEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.tenantCode", (Object)tenantCode);
        if (MapUtil.isEmpty(resStream)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), WhOpstoreDomain.class);
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u9519\u8bef");
        }
        whOpstoreDomain.setTenantCode(tenantCode);
        whOpstoreDomain.setStoreGoodsType("1");
        if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "whOpstoreSkuDomainList\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
        QueryResult<WhOpstoreReDomain> queryResult = this.queryOpstorePage(map);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.opstoreOcode", "\u6570\u636e\u5df2\u7ecf\u5b58\u5728");
        }
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.skuNo", "skuNo\u53c2\u6570\u4e3a\u7a7a");
            }
            if (null == whOpstoreSkuDomain.getGoodsNum()) {
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.goodsNum", "goodsNum\u53c2\u6570\u4e3a\u7a7a");
            }
            whOpstoreSkuDomain.setTenantCode(tenantCode);
            whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
        }
        String code = this.sendSaveOpstoreTwo(whOpstoreDomain);
        return this.makeSuccessReturn(code);
    }

    @Override
    public String sendQueryExMaterialInventory(Map<String, Object> map) {
        logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.map", (Object)"isnull");
            return null;
        }
        String productID = (String)map.get("ProductID");
        if (StringUtils.isEmpty((String)productID)) {
            logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.productID", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "queryExMaterialInventory", "queryExMaterialInventory");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.url", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.isnull" + url, map, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.returnResultsMap" + url + "map" + map, (Object)data);
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.returnResultsMap.1" + url + "map" + map, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("Code");
        if (null != code && String.valueOf(code).equals("200")) {
            return JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("Data"));
        }
        logger.error(this.SYS_CODE + ".sendQueryExMaterialInventory.code" + url + "map" + map, (Object)data);
        return null;
    }

    private String makeWhOpstoreDomain(WhOpstoreDomain whOpstoreDomain) {
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList;
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreDomain");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        HashMap<String, WhWarehouseReDomain> waMap = new HashMap<String, WhWarehouseReDomain>();
        HashMap<String, WhWarehouseReDomain> owaMap = new HashMap<String, WhWarehouseReDomain>();
        WhWarehouseReDomain whWarehouseReDomain = this.getWarehouse(whOpstoreDomain.getWarehouseCode(), whOpstoreDomain.getWarehouseOcode(), whOpstoreDomain.getTenantCode());
        owaMap.put(whWarehouseReDomain.getWarehouseOcode(), whWarehouseReDomain);
        waMap.put(whWarehouseReDomain.getWarehouseCode(), whWarehouseReDomain);
        whOpstoreDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        if (StringUtils.isBlank((String)whOpstoreDomain.getMemberCode())) {
            whOpstoreDomain.setMemberCode(whWarehouseReDomain.getMemberCode());
            whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getMemberMcode())) {
            UmUserinfoReDomain umUserinfoReDomain = this.getUserinfoByCode(whOpstoreDomain.getMemberCode(), whOpstoreDomain.getTenantCode());
            if (null == umUserinfoReDomain) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.umUserinfoReDomain", (Object)(whOpstoreDomain.getMemberCode() + "=" + whOpstoreDomain.getTenantCode()));
                return "\u8f6c\u6362\u7528\u6237\u4e3a\u7a7a";
            }
            whOpstoreDomain.setMemberMcode(umUserinfoReDomain.getUserinfoParentCode());
            whOpstoreDomain.setMemberMname(umUserinfoReDomain.getUserinfoParentName());
        }
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreGoodsDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
            return "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String goodsClass = "plat";
        QueryResult<RsSkuDomain> queryResutl = null;
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            String partsnameWeightunit;
            String partsnameNumunit1;
            String partsnameNumunit;
            BigDecimal goodsWeight;
            BigDecimal goodsNum1;
            BigDecimal goodsNum;
            String warehouseCode;
            whWarehouseReDomain = StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseCode()) ? (WhWarehouseReDomain)owaMap.get(whOpstoreGoodsDomain.getWarehouseOcode()) : (WhWarehouseReDomain)waMap.get(whOpstoreGoodsDomain.getWarehouseCode());
            if (null == whWarehouseReDomain) {
                whWarehouseReDomain = this.getWarehouse(whOpstoreGoodsDomain.getWarehouseCode(), whOpstoreGoodsDomain.getWarehouseOcode(), whOpstoreDomain.getTenantCode());
                if (null == whWarehouseReDomain) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whWarehouseReDomain", (Object)(whOpstoreGoodsDomain.getWarehouseOcode() + "=" + whOpstoreGoodsDomain.getWarehouseCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u4ed3\u5e93\u4ee3\u7801\u5f02\u5e38! ";
                }
                owaMap.put(whWarehouseReDomain.getWarehouseOcode(), whWarehouseReDomain);
                waMap.put(whWarehouseReDomain.getWarehouseCode(), whWarehouseReDomain);
            }
            whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
            whOpstoreGoodsDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            whOpstoreGoodsDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreSkuDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
                return "whOpstoreSkuDomainList\u4e3a\u7a7a! ";
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                paramMap.put("goodsClass", goodsClass);
                paramMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                paramMap.put("memberCode", whOpstoreDomain.getMemberCode());
                paramMap.put("tenantCode", whOpstoreDomain.getTenantCode());
                queryResutl = this.queryRsSkuPage(paramMap);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.queryResutl", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "sku\u4e3a\u7a7a! " + paramMap.toString();
                }
                rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), whOpstoreDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.rsResourceGoodsReDomain", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                warehouseCode = whOpstoreSkuDomain.getWarehouseCode();
                goodsNum = whOpstoreSkuDomain.getGoodsNum();
                goodsNum1 = whOpstoreSkuDomain.getGoodsNum1();
                goodsWeight = whOpstoreSkuDomain.getGoodsWeight();
                partsnameNumunit = whOpstoreSkuDomain.getPartsnameNumunit();
                partsnameNumunit1 = whOpstoreSkuDomain.getPartsnameNumunit1();
                partsnameWeightunit = whOpstoreSkuDomain.getPartsnameWeightunit();
                try {
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
                whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                whOpstoreSkuDomain.setGoodsNum(goodsNum);
                whOpstoreSkuDomain.setGoodsNum1(goodsNum1);
                whOpstoreSkuDomain.setGoodsWeight(goodsWeight);
                whOpstoreSkuDomain.setPartsnameNumunit(partsnameNumunit);
                whOpstoreSkuDomain.setPartsnameNumunit1(partsnameNumunit1);
                whOpstoreSkuDomain.setPartsnameWeightunit(partsnameWeightunit);
            }
            warehouseCode = whOpstoreGoodsDomain.getWarehouseCode();
            String warehouseName = whOpstoreGoodsDomain.getWarehouseName();
            goodsNum = whOpstoreGoodsDomain.getGoodsNum();
            goodsNum1 = whOpstoreGoodsDomain.getGoodsNum1();
            goodsWeight = whOpstoreGoodsDomain.getGoodsWeight();
            partsnameNumunit = whOpstoreGoodsDomain.getPartsnameNumunit();
            partsnameNumunit1 = whOpstoreGoodsDomain.getPartsnameNumunit1();
            partsnameWeightunit = whOpstoreGoodsDomain.getPartsnameWeightunit();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, rsResourceGoodsReDomain);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copyspu", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u7cfb\u7edf\u5f02\u5e38! ";
            }
            whOpstoreGoodsDomain.setWarehouseCode(warehouseCode);
            whOpstoreGoodsDomain.setWarehouseName(warehouseName);
            whOpstoreGoodsDomain.setGoodsNum(goodsNum);
            whOpstoreGoodsDomain.setGoodsNum1(goodsNum1);
            whOpstoreGoodsDomain.setGoodsWeight(goodsWeight);
            whOpstoreGoodsDomain.setPartsnameNumunit(partsnameNumunit);
            whOpstoreGoodsDomain.setPartsnameNumunit1(partsnameNumunit1);
            whOpstoreGoodsDomain.setPartsnameWeightunit(partsnameWeightunit);
        }
        return null;
    }

    private WhWarehouseReDomain getWarehouse(String warehouseCode, String warehouseOcode, String tenantCode) {
        WhWarehouseReDomain whWarehouseReDomain;
        if (StringUtils.isBlank((String)warehouseCode)) {
            Map map = this.getQueryMapParam("warehouseOcode", new Object[]{warehouseOcode, tenantCode});
            QueryResult<WhWarehouseReDomain> qwh = this.queryWarehousePage(map);
            if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
                logger.error(this.SYS_CODE + ".getWarehouse.getWarehouseCode", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
            if (qwh.getList().size() > 1) {
                logger.error(this.SYS_CODE + ".getWarehouse.qwh", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u5f02\u5e38");
            }
            whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        } else {
            whWarehouseReDomain = this.getWarehouseByCode(warehouseCode, tenantCode);
            if (null == whWarehouseReDomain) {
                logger.error(this.SYS_CODE + ".getWarehouse.whWarehouseReDomain", (Object)(warehouseCode + "=" + tenantCode));
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
        }
        return whWarehouseReDomain;
    }

    private String checkOpstore(WhOpstoreDomain whOpstoreDomain) {
        QueryResult<WhOpstoreReDomain> qwh;
        if (null == whOpstoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreDomain.getWarehouseOcode())) {
            msg = msg + "warehouseCode\u548cwarehouseOcode\u90fd\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            msg = msg + "opstoreOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseName())) {
            msg = msg + "warehouseName\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == whOpstoreDomain.getGoodsNum()) {
            msg = msg + "goodsNum\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
            msg = msg + "storeGoodsBtype\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u4e3a\u7a7a! ";
        } else if (!"0,1,2,3,4,5,11,12".contains(whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u5f02\u5e38[" + whOpstoreDomain.getStoreGoodsType() + "]! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreType())) {
            msg = msg + "storeType\u4e3a\u7a7a! ";
        } else if (!"0,1".contains(whOpstoreDomain.getStoreType())) {
            msg = msg + "storeType\u5f02\u5e38[" + whOpstoreDomain.getStoreType() + "]! ";
        }
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreOcode()) && null != (qwh = this.queryOpstorePage(this.getQueryMapParam("opstoreOcode,tenantCode", new Object[]{whOpstoreDomain.getOpstoreOcode(), whOpstoreDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qwh.getList())) {
            msg = msg + "opstoreOcode[" + whOpstoreDomain.getOpstoreOcode() + "]\u91cd\u590d! ";
            return msg;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            msg = msg + "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
            return msg;
        }
        int i = 0;
        int j = 0;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            ++i;
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                msg = msg + "\u7b2c" + i + "\u884cgoodsNo\u4e3a\u7a7a! ";
            }
            if (null == whOpstoreGoodsDomain.getGoodsNum()) {
                msg = msg + "\u7b2c" + i + "\u884cgoodsNum\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getStoreType())) {
                msg = msg + "\u7b2c" + i + "\u884cstoreType\u4e3a\u7a7a! ";
            } else if (!"0,1".contains(whOpstoreGoodsDomain.getStoreType())) {
                msg = msg + "\u7b2c" + i + "\u884cstoreType\u5f02\u5e38[" + whOpstoreGoodsDomain.getStoreType() + "]! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getOpstoreDir())) {
                msg = msg + "\u7b2c" + i + "\u884copstoreDir\u4e3a\u7a7a! ";
            } else if (!"0,1".contains(whOpstoreGoodsDomain.getOpstoreDir())) {
                msg = msg + "\u7b2c" + i + "\u884cOpstoreDir\u5f02\u5e38[" + whOpstoreGoodsDomain.getOpstoreDir() + "]! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit())) {
                msg = msg + "\u7b2c" + i + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseOcode())) {
                msg = msg + "\u7b2c" + i + "\u884cwarehouseCode\u548cwarehouseOcode\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseName())) {
                msg = msg + "\u7b2c" + i + "\u884cwarehouseName\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit())) {
                msg = msg + "\u7b2c" + i + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
            }
            whOpstoreGoodsDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                msg = msg + "\u7b2c" + i + "\u884cwhOpstoreSkuDomainList\u4e3a\u7a7a! ";
                return msg;
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                ++j;
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getOpstoreDir())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884copstoreDir\u4e3a\u7a7a! ";
                } else if (!"0,1".contains(whOpstoreSkuDomain.getOpstoreDir())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cOpstoreDir\u5f02\u5e38[" + whOpstoreSkuDomain.getOpstoreDir() + "]! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getStoreType())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cstoreType\u4e3a\u7a7a! ";
                } else if (!"0,1".contains(whOpstoreSkuDomain.getStoreType())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cstoreType\u5f02\u5e38[" + whOpstoreSkuDomain.getStoreType() + "]! ";
                }
                whOpstoreSkuDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (null == whOpstoreSkuDomain.getGoodsNum()) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cgoodsNum\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreSkuDomain.getWarehouseOcode())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cwarehouseCode\u548cwarehouseOcode\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getWarehouseName())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cwarehouseName\u4e3a\u7a7a! ";
                }
                if (!StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit())) continue;
                msg = msg + "\u7b2c" + i + "-" + j + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
            }
        }
        return msg;
    }

    private String checkWarehouse(WhWarehouseDomain whWarehouseDomain) {
        QueryResult<WhWarehouseReDomain> qlist;
        if (null == whWarehouseDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseOcode())) {
            msg = msg + "warehouseOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseName())) {
            msg = msg + "warehouseName\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)whWarehouseDomain.getWarehouseOcode()) && null != (qlist = this.queryWarehousePage(this.getQueryMapParam("warehouseOcode,tenantCode", new Object[]{whWarehouseDomain.getWarehouseOcode(), whWarehouseDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "warehouseOcode[" + whWarehouseDomain.getWarehouseOcode() + "]\u91cd\u590d! ";
        }
        return msg;
    }
}

