/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.chint.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.chint.domain.sks.SksUnbindingAddressReDomain;
import com.yqbsoft.laser.service.ext.chint.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.chint.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.chint.domain.zt.CrpRecharge;
import com.yqbsoft.laser.service.ext.chint.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.chint.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.chint.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.chint.service.BusUserService;
import com.yqbsoft.laser.service.ext.chint.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.ext.chint.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "chint.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        umUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "chint"));
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoRequest, (Object)umUserinfo);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusUserLogin(String loginName, String password, String tenantCode) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("code", "-1");
        if (null == loginName || null == password) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            returnMap.put("message", "\u7528\u6237\u540d\u5bc6\u7801\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String url = this.getUrl(tenantCode, "getUserLogin", "getUserLogin");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.getUserLogin\uff0curl", (Object)"\u5730\u5740\u4e3a\u7a7a");
            returnMap.put("message", "\u5730\u5740\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("loginName", loginName);
        map.put("password", password);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.url" + url, map);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        if (StringUtils.isBlank((String)data)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.sendPost", (Object)data);
            returnMap.put("message", "\u8fd4\u56de\u6570\u636e\u4e3anull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, String.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            logger.error(this.SYS_CODE + "sendSaveBusUserLogin.sendPost1", (Object)data);
            returnMap.put("message", "\u8fd4\u56de\u6570\u636e\u4e3anull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String code = (String)jsonToMap.get("code");
        String msg = (String)jsonToMap.get("msg");
        String datastr = (String)jsonToMap.get("data");
        if (StringUtils.isNotBlank((String)code) && code.equals("200") && StringUtils.isNotBlank((String)datastr) && datastr.equals("LICENSE_IS_OK")) {
            returnMap.put("code", "200");
            returnMap.put("message", msg);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        if (StringUtils.isNotBlank((String)code) && !code.equals("200")) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.url=" + url + ",response=" + data);
            returnMap.put("message", msg);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        return JsonUtil.buildNormalBinder().toJson(returnMap);
    }

    @Override
    public String getUserAccInfo(String tenantCode, String faccountType, String JsonStr) throws ApiException {
        if (StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)JsonStr)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "getUserAcc");
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        map.put("userAccInfo", map1);
        map1.put("syb", "8a8ad0a038d53d3a0138d58b16cf006b");
        map1.put("customer", "8a8ad0c35ac02ca8015ada27cd287642");
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".getUserAccInfo.code", (Object)data);
        return null;
    }

    @Override
    public String unBindingAddressToSkshu(SksUnbindingAddressReDomain sksUnbindingAddressReDomain) {
        logger.error(this.SYS_CODE + ".unBindingAddressToSkshu.sksUnbindingAddressReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)sksUnbindingAddressReDomain));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String url = this.getUrl(sksUnbindingAddressReDomain.getTenantCode(), "OaWorkflowCategoryCreate", "OaWorkflowCategoryCreate");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".unBindingAddressToSkshu.getUserLogin\uff0curl", (Object)("url\u4e3a\u7a7a:" + url));
            returnMap.put("message", "url\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("creator", sksUnbindingAddressReDomain.getAddressMember());
        map.put("workflowid", "8a8acee26dc991b6016dccd6652e0a09");
        map.put("layoutid", "8a8acee26dc991b6016dcd5524500da7");
        map.put("issave", "0");
        map.put("masterTable", "1");
        LinkedHashMap hashMap = Maps.newLinkedHashMap();
        hashMap.put("UF_UNLOCKADDRESS__APPLICANT", sksUnbindingAddressReDomain.getAddressMember());
        hashMap.put("UF_UNLOCKADDRESS__PROJECTNAME", sksUnbindingAddressReDomain.getProjectCode());
        LinkedHashMap linkedMap = Maps.newLinkedHashMap();
        linkedMap.put("maintable", hashMap);
        map.put("jsonString", linkedMap);
        String data = null;
        try {
            logger.error(this.SYS_CODE + "unBindingAddressToSkshu.map", (Object)JsonUtil.buildNormalBinder().toJson((Object)map));
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson((Object)map));
            logger.error(this.SYS_CODE + "unBindingAddressToSkshu.data", (Object)JsonUtil.buildNormalBinder().toJson((Object)data));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".unBindingAddressToSkshu.url" + url, (Object)map);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        if (StringUtils.isBlank((String)data)) {
            logger.error(this.SYS_CODE + ".unBindingAddressToSkshu.sendPost", (Object)data);
            returnMap.put("message", "\u8fd4\u56de\u6570\u636e\u4e3anull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, String.class);
        logger.error(this.SYS_CODE + ".unBindingAddressToSkshu.jsonToMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToMap));
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            logger.error(this.SYS_CODE + "unBindingAddressToSkshu.sendPost1", (Object)data);
            returnMap.put("message", "\u8fd4\u56de\u6570\u636e\u4e3anull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String code = (String)jsonToMap.get("code");
        String msg = (String)jsonToMap.get("msg");
        String datastr = (String)jsonToMap.get("data");
        if (StringUtils.isNotBlank((String)code) && code.equals("200") && StringUtils.isNotBlank((String)datastr)) {
            returnMap.put("code", "200");
            returnMap.put("message", msg);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        if (StringUtils.isNotBlank((String)code) && !code.equals("200")) {
            logger.error(this.SYS_CODE + ".unBindingAddressToSkshu.url=" + url + ",response=" + data);
            returnMap.put("message", msg);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        return JsonUtil.buildNormalBinder().toJson(returnMap);
    }

    @Override
    public String sendQueryReconciliationRecords(Map<String, Object> map) {
        return null;
    }

    @Override
    public String sendQueryCredit(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryCredit" + map);
            return null;
        }
        String url = this.getUrl((String)map.get("tenantCode"), "sendQueryCredit", "sendQueryCredit");
        if (StringUtils.isBlank((String)url)) {
            url = "http://10.128.10.108:8700/uapws/service/nc.itf.chintwebservices.ddx.IChintDdxService";
        }
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryCredit.getUserLogin\uff0curl", (Object)("url\u4e3a\u7a7a:" + url));
            return null;
        }
        String data = null;
        HashMap hashMap = new HashMap();
        String[] custcodes = new String[]{map.get("custcodes").toString()};
        map.put("custcodes", custcodes);
        map.remove("tenantCode");
        ObjectMapper objectMapper = new ObjectMapper();
        String json = null;
        try {
            json = objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            ServiceClient client = new ServiceClient();
            Options options = client.getOptions();
            EndpointReference to = new EndpointReference(url);
            options.setTo(to);
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMNamespace ns = factory.createOMNamespace("http://ddx.chintwebservices.itf.nc/IChintDdxService", "ich");
            OMElement method = factory.createOMElement("ddx03", ns);
            OMElement string = factory.createOMElement("string", null);
            string.setText(json);
            method.addChild((OMNode)string);
            logger.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
            logger.info("\u8bf7\u6c42\u53c2\u6570: {}", (Object)method);
            method.build();
            OMElement result = client.sendReceive(method);
            data = result.toString();
            logger.info("\u54cd\u5e94\u7ed3\u679c: {}", (Object)data);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5f02\u5e38\uff0c", (Throwable)e);
        }
        logger.error(this.SYS_CODE + "sendQueryCredit.data.data" + url, (Object)JsonUtil.buildNormalBinder().toJson(data));
        String message = null;
        String xyed = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(data)));
            Element returnElement = (Element)document.getElementsByTagName("return").item(0);
            String jsonStr = returnElement.getTextContent();
            ObjectMapper objectMapper1 = new ObjectMapper();
            JsonNode jsonNode = objectMapper1.readTree(jsonStr);
            message = jsonNode.get("message").asText();
            boolean success = jsonNode.get("success").asBoolean();
            JsonNode dataNode = jsonNode.get("data");
            if (null != dataNode && null != dataNode.get(0).get("xyed")) {
                xyed = dataNode.get(0).get("xyed").toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank(data) && "OK".equals(message)) {
            return xyed;
        }
        return null;
    }

    @Override
    public String sendUpdateCredit(CrpRecharge crpRechargeDomain) {
        logger.error(this.SYS_CODE + ".sendUpdateCredit.1" + JsonUtil.buildNormalBinder().toJson((Object)crpRechargeDomain));
        if (null == crpRechargeDomain) {
            logger.error(this.SYS_CODE + ".sendUpdateCredit" + JsonUtil.buildNormalBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        String url = this.getUrl(crpRechargeDomain.getTenantCode(), "sendUpdateCredit", "sendUpdateCredit");
        if (StringUtils.isBlank((String)url)) {
            url = "http://10.128.10.108:8700/uapws/service/nc.itf.chintwebservices.ddx.IChintDdxService";
        }
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendUpdateCredit.getUserLogin\uff0curl", (Object)("url\u4e3a\u7a7a:" + url));
            return "error";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String data = null;
        map.put("custcode", crpRechargeDomain.getBankcardCode());
        map.put("custname", crpRechargeDomain.getUserinfoName());
        map.put("xyed", crpRechargeDomain.getRechargeName1());
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(map);
        ObjectMapper objectMapper = new ObjectMapper();
        String json = null;
        try {
            json = objectMapper.writeValueAsString(list);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            ServiceClient client = new ServiceClient();
            Options options = client.getOptions();
            EndpointReference to = new EndpointReference(url);
            options.setTo(to);
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMNamespace ns = factory.createOMNamespace("http://ddx.chintwebservices.itf.nc/IChintDdxService", "ich");
            OMElement method = factory.createOMElement("ddx04", ns);
            OMElement string = factory.createOMElement("string", null);
            string.setText(json);
            method.addChild((OMNode)string);
            logger.info(this.SYS_CODE + ".sendUpdateCredit.1\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
            logger.info(this.SYS_CODE + ".sendUpdateCredit.1\u8bf7\u6c42\u53c2\u6570: {}", (Object)method);
            method.build();
            OMElement result = client.sendReceive(method);
            data = result.toString();
            logger.info(this.SYS_CODE + ".sendUpdateCredit.2\u54cd\u5e94\u7ed3\u679c: {}", (Object)data);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendUpdateCredit.2\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
            logger.error(this.SYS_CODE + ".sendUpdateCredit.3\u8bf7\u6c42\u5730\u5740\uff1a{}", (Throwable)e);
            return "error";
        }
        String message = null;
        Object xyed = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(data)));
            Element returnElement = (Element)document.getElementsByTagName("return").item(0);
            String jsonStr = returnElement.getTextContent();
            ObjectMapper objectMapper1 = new ObjectMapper();
            JsonNode jsonNode = objectMapper1.readTree(jsonStr);
            message = jsonNode.get("message").asText();
            logger.error(this.SYS_CODE + ".sendUpdateCredit.4\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)message);
            boolean bl = jsonNode.get("success").asBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
        if (StringUtils.isNotBlank((String)data) && "OK".equals(message)) {
            return "success";
        }
        return "error";
    }
}

