/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.chint.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.chint.dao.ZtRegionMapper;
import com.yqbsoft.laser.service.ext.chint.domain.chint.ZtRegionDomain;
import com.yqbsoft.laser.service.ext.chint.domain.chint.ZtRegionReDomain;
import com.yqbsoft.laser.service.ext.chint.model.ZtRegion;
import com.yqbsoft.laser.service.ext.chint.service.ZtRegionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZtRegionServiceImpl
extends BaseServiceImpl
implements ZtRegionService {
    private static final String SYS_CODE = "chint.ZtRegionServiceImpl";
    private ZtRegionMapper ztRegionMapper;

    public void setZtRegionMapper(ZtRegionMapper ztRegionMapper) {
        this.ztRegionMapper = ztRegionMapper;
    }

    private Date getSysDate() {
        try {
            return this.ztRegionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRegion(ZtRegionDomain ztRegionDomain) {
        if (null == ztRegionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ztRegionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRegionDefault(ZtRegion ztRegion) {
        if (null == ztRegion) {
            return;
        }
        if (null == ztRegion.getDataState()) {
            ztRegion.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ztRegion.getGmtCreate()) {
            ztRegion.setGmtCreate(date);
        }
        ztRegion.setGmtModified(date);
        if (StringUtils.isBlank((String)ztRegion.getRegionCode())) {
            ztRegion.setRegionCode(this.getNo(null, "ZtRegion", "ztRegion", ztRegion.getTenantCode()));
        }
    }

    private int getRegionMaxCode() {
        int code = 0;
        try {
            return this.ztRegionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.getRegionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRegionUpdataDefault(ZtRegion ztRegion) {
        if (null == ztRegion) {
            return;
        }
        ztRegion.setGmtModified(this.getSysDate());
    }

    private void saveRegionModel(ZtRegion ztRegion) throws ApiException {
        if (null == ztRegion) {
            return;
        }
        try {
            this.ztRegionMapper.insert(ztRegion);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtRegionServiceImpl.saveRegionModel.ex", (Throwable)e);
        }
    }

    private void saveRegionBatchModel(List<ZtRegion> ztRegionList) throws ApiException {
        if (null == ztRegionList || ztRegionList.isEmpty()) {
            return;
        }
        try {
            this.ztRegionMapper.insertBatch(ztRegionList);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtRegionServiceImpl.saveRegionBatchModel.ex", (Throwable)e);
        }
    }

    private ZtRegion getRegionModelById(Integer regionId) {
        if (null == regionId) {
            return null;
        }
        try {
            return this.ztRegionMapper.selectByPrimaryKey(regionId);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.getRegionModelById", (Throwable)e);
            return null;
        }
    }

    private ZtRegion getRegionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ztRegionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.getRegionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRegionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ztRegionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtRegionServiceImpl.delRegionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtRegionServiceImpl.delRegionModelByCode.num");
        }
    }

    private void deleteRegionModel(Integer regionId) throws ApiException {
        if (null == regionId) {
            return;
        }
        int i = 0;
        try {
            i = this.ztRegionMapper.deleteByPrimaryKey(regionId);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtRegionServiceImpl.deleteRegionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtRegionServiceImpl.deleteRegionModel.num");
        }
    }

    private void updateRegionModel(ZtRegion ztRegion) throws ApiException {
        if (null == ztRegion) {
            return;
        }
        int i = 0;
        try {
            i = this.ztRegionMapper.updateByPrimaryKey(ztRegion);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateRegionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateRegionModel.num");
        }
    }

    private void updateStateRegionModel(Integer regionId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == regionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regionId", regionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztRegionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateStateRegionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateStateRegionModel.null");
        }
    }

    private void updateStateRegionModelByCode(String tenantCode, String regionCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)regionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regionCode", regionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztRegionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateStateRegionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateStateRegionModelByCode.null");
        }
    }

    private ZtRegion makeRegion(ZtRegionDomain ztRegionDomain, ZtRegion ztRegion) {
        if (null == ztRegionDomain) {
            return null;
        }
        if (null == ztRegion) {
            ztRegion = new ZtRegion();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ztRegion, (Object)ztRegionDomain);
            return ztRegion;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.makeRegion", (Throwable)e);
            return null;
        }
    }

    private ZtRegionReDomain makeZtRegionReDomain(ZtRegion ztRegion) {
        if (null == ztRegion) {
            return null;
        }
        ZtRegionReDomain ztRegionReDomain = new ZtRegionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ztRegionReDomain, (Object)ztRegion);
            return ztRegionReDomain;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.makeZtRegionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ZtRegion> queryRegionModelPage(Map<String, Object> parammap) {
        try {
            return this.ztRegionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.queryRegionModel", (Throwable)e);
            return null;
        }
    }

    private int countRegion(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ztRegionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.countRegion", (Throwable)e);
        }
        return i;
    }

    private ZtRegion createZtRegion(ZtRegionDomain ztRegionDomain) {
        String msg = this.checkRegion(ztRegionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtRegionServiceImpl.saveRegion.checkRegion", msg);
        }
        ZtRegion ztRegion = this.makeRegion(ztRegionDomain, null);
        this.setRegionDefault(ztRegion);
        return ztRegion;
    }

    @Override
    public String saveRegion(ZtRegionDomain ztRegionDomain) throws ApiException {
        ZtRegion ztRegion = this.createZtRegion(ztRegionDomain);
        this.saveRegionModel(ztRegion);
        return ztRegion.getRegionCode();
    }

    @Override
    public ZtRegion queryRegion(ZtRegionDomain ztRegionDomain) throws ApiException {
        String msg = this.checkRegion(ztRegionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtRegionServiceImpl.queryRegion.checkRegion", msg);
        }
        ZtRegion ztRegion = this.createZtRegion(ztRegionDomain);
        try {
            return this.ztRegionMapper.selectByProvincName(ztRegion.getProvincName());
        }
        catch (Exception e) {
            this.logger.error("chint.ZtRegionServiceImpl.queryRegion", (Throwable)e);
            return null;
        }
    }

    @Override
    public String saveRegionBatch(List<ZtRegionDomain> ztRegionDomainList) throws ApiException {
        if (null == ztRegionDomainList || ztRegionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ZtRegion> ztRegionList = new ArrayList<ZtRegion>();
        String code = "";
        for (ZtRegionDomain ztRegionDomain : ztRegionDomainList) {
            ZtRegion ztRegion = this.createZtRegion(ztRegionDomain);
            code = ztRegion.getRegionCode();
            ztRegionList.add(ztRegion);
        }
        this.saveRegionBatchModel(ztRegionList);
        return code;
    }

    @Override
    public void updateRegionState(Integer regionId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == regionId) {
            return;
        }
        this.updateStateRegionModel(regionId, dataState, oldDataState, map);
    }

    @Override
    public void updateRegionStateByCode(String tenantCode, String regionCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)regionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRegionModelByCode(tenantCode, regionCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRegion(ZtRegionDomain ztRegionDomain) throws ApiException {
        String msg = this.checkRegion(ztRegionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateRegion.checkRegion", msg);
        }
        ZtRegion oldZtRegion = this.getRegionModelById(ztRegionDomain.getRegionId());
        if (null == oldZtRegion) {
            throw new ApiException("chint.ZtRegionServiceImpl.updateRegion.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ZtRegion ztRegion = this.makeRegion(ztRegionDomain, oldZtRegion);
        this.setRegionUpdataDefault(ztRegion);
        this.updateRegionModel(ztRegion);
    }

    @Override
    public ZtRegion getRegion(Integer regionId) {
        if (null == regionId) {
            return null;
        }
        return this.getRegionModelById(regionId);
    }

    @Override
    public void deleteRegion(Integer regionId) throws ApiException {
        if (null == regionId) {
            return;
        }
        this.deleteRegionModel(regionId);
    }

    @Override
    public QueryResult<ZtRegion> queryRegionPage(Map<String, Object> map) {
        List<ZtRegion> ztRegionList = this.queryRegionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRegion(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ztRegionList);
        return queryResult;
    }

    @Override
    public ZtRegion getRegionByCode(String tenantCode, String regionCode) throws ApiException {
        if (StringUtils.isBlank((String)regionCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regionCode", regionCode);
        return this.getRegionModelByCode(map);
    }

    @Override
    public void deleteRegionByCode(String tenantCode, String regionCode) throws ApiException {
        if (StringUtils.isBlank((String)regionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regionCode", regionCode);
        this.delRegionModelByCode(map);
    }

    public static void main(String[] args) {
    }
}

