/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.chint.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.chint.dao.ZtBillMapper;
import com.yqbsoft.laser.service.ext.chint.domain.zt.ZtBillDomain;
import com.yqbsoft.laser.service.ext.chint.domain.zt.ZtBillReDomain;
import com.yqbsoft.laser.service.ext.chint.model.ZtBill;
import com.yqbsoft.laser.service.ext.chint.service.ZtBillService;
import com.yqbsoft.laser.service.ext.chint.supbase.BusBaseService;
import com.yqbsoft.laser.service.ext.chint.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ZtBillServiceImpl
extends BusBaseService
implements ZtBillService {
    private static final String SYS_CODE = "chint.ZtBillServiceImpl";
    private ZtBillMapper ztBillMapper;

    public void setZtBillMapper(ZtBillMapper ztBillMapper) {
        this.ztBillMapper = ztBillMapper;
    }

    private Date getSysDate() {
        try {
            return this.ztBillMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkbill(ZtBillDomain ztBillDomain) {
        if (null == ztBillDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ztBillDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setbillDefault(ZtBill ztBill) {
        if (null == ztBill) {
            return;
        }
        if (null == ztBill.getDataState()) {
            ztBill.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ztBill.getGmtCreate()) {
            ztBill.setGmtCreate(date);
        }
        ztBill.setGmtModified(date);
        if (StringUtils.isBlank((String)ztBill.getRbillCode())) {
            ztBill.setRbillCode(this.getNo(null, "ZtBill", "ztBill", ztBill.getTenantCode()));
        }
    }

    private int getbillMaxCode() {
        int code = 0;
        try {
            return this.ztBillMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getbillMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setbillUpdataDefault(ZtBill ztBill) {
        if (null == ztBill) {
            return;
        }
        ztBill.setGmtModified(this.getSysDate());
    }

    private void savebillModel(ZtBill ztBill) throws ApiException {
        if (null == ztBill) {
            return;
        }
        try {
            this.ztBillMapper.insert(ztBill);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.savebillModel.ex", (Throwable)e);
        }
    }

    private void savebillBatchModel(List<ZtBill> ztBillList) throws ApiException {
        if (null == ztBillList || ztBillList.isEmpty()) {
            return;
        }
        try {
            this.ztBillMapper.insertBatch(ztBillList);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.savebillBatchModel.ex", (Throwable)e);
        }
    }

    private ZtBill getbillModelById(Integer billId) {
        if (null == billId) {
            return null;
        }
        try {
            return this.ztBillMapper.selectByPrimaryKey(billId);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getbillModelById", (Throwable)e);
            return null;
        }
    }

    private ZtBill getbillModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ztBillMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.getbillModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delbillModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ztBillMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.delbillModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtBillServiceImpl.delbillModelByCode.num");
        }
    }

    private void deletebillModel(Integer billId) throws ApiException {
        if (null == billId) {
            return;
        }
        int i = 0;
        try {
            i = this.ztBillMapper.deleteByPrimaryKey(billId);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.deletebillModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtBillServiceImpl.deletebillModel.num");
        }
    }

    private void updatebillModel(ZtBill ztBill) throws ApiException {
        if (null == ztBill) {
            return;
        }
        int i = 0;
        try {
            i = this.ztBillMapper.updateByPrimaryKey(ztBill);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebillModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebillModel.num");
        }
    }

    private void updateStatebillModel(Integer billId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == billId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billId", billId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztBillMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModel.null");
        }
    }

    private void updateStatebillModelByCode(String tenantCode, String billCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("billCode", billCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ztBillMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("chint.ZtBillServiceImpl.updateStatebillModelByCode.null");
        }
    }

    private ZtBill makebill(ZtBillDomain ztBillDomain, ZtBill ztBill) {
        if (null == ztBillDomain) {
            return null;
        }
        if (null == ztBill) {
            ztBill = new ZtBill();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ztBill, (Object)ztBillDomain);
            return ztBill;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.makebill", (Throwable)e);
            return null;
        }
    }

    private ZtBillReDomain makeZtBillReDomain(ZtBill ztBill) {
        if (null == ztBill) {
            return null;
        }
        ZtBillReDomain ztBillReDomain = new ZtBillReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ztBillReDomain, (Object)ztBill);
            return ztBillReDomain;
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.makeZtBillReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ZtBill> querybillModelPage(Map<String, Object> parammap) {
        try {
            return this.ztBillMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.querybillModel", (Throwable)e);
            return null;
        }
    }

    private int countbill(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ztBillMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("chint.ZtBillServiceImpl.countbill", (Throwable)e);
        }
        return i;
    }

    private ZtBill createZtBill(ZtBillDomain ztBillDomain) {
        String msg = this.checkbill(ztBillDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtBillServiceImpl.savebill.checkbill", msg);
        }
        ZtBill ztBill = this.makebill(ztBillDomain, null);
        this.setbillDefault(ztBill);
        return ztBill;
    }

    @Override
    public String savebill(ZtBillDomain ztBillDomain) throws ApiException {
        ZtBill ztBill = this.createZtBill(ztBillDomain);
        this.savebillModel(ztBill);
        return ztBill.getRbillCode();
    }

    @Override
    public String savebillBatch(List<ZtBillDomain> ztBillDomainList) throws ApiException {
        if (null == ztBillDomainList || ztBillDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ZtBill> ztBillList = new ArrayList<ZtBill>();
        String code = "";
        for (ZtBillDomain ztBillDomain : ztBillDomainList) {
            ZtBill ztBill = this.createZtBill(ztBillDomain);
            code = ztBill.getRbillCode();
            ztBillList.add(ztBill);
        }
        this.savebillBatchModel(ztBillList);
        return code;
    }

    @Override
    public void updatebillState(Integer billId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == billId) {
            return;
        }
        this.updateStatebillModel(billId, dataState, oldDataState, map);
    }

    @Override
    public void updatebillStateByCode(String tenantCode, String billCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatebillModelByCode(tenantCode, billCode, dataState, oldDataState, map);
    }

    @Override
    public void updatebill(ZtBillDomain ztBillDomain) throws ApiException {
        String msg = this.checkbill(ztBillDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebill.checkbill", msg);
        }
        ZtBill oldZtBill = this.getbillModelById(ztBillDomain.getBillId());
        if (null == oldZtBill) {
            throw new ApiException("chint.ZtBillServiceImpl.updatebill.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ZtBill ztBill = this.makebill(ztBillDomain, oldZtBill);
        this.setbillUpdataDefault(ztBill);
        this.updatebillModel(ztBill);
    }

    @Override
    public ZtBill getbill(Integer billId) {
        if (null == billId) {
            return null;
        }
        return this.getbillModelById(billId);
    }

    @Override
    public void deletebill(Integer billId) throws ApiException {
        if (null == billId) {
            return;
        }
        this.deletebillModel(billId);
    }

    @Override
    public QueryResult<ZtBill> querybillPage(Map<String, Object> map) {
        List<ZtBill> ztBillList = this.querybillModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countbill(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ztBillList);
        return queryResult;
    }

    @Override
    public ZtBill getbillByCode(String tenantCode, String billCode) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("billCode", billCode);
        return this.getbillModelByCode(map);
    }

    @Override
    public void deletebillByCode(String tenantCode, String billCode) throws ApiException {
        if (StringUtils.isBlank((String)billCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("billCode", billCode);
        this.delbillModelByCode(map);
    }

    @Override
    public String savePullingBill(String tenantCode, String zdMonth, String agencyId, String account, String page) throws ApiException {
        String url;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ZdMonth", zdMonth);
        map.put("AgencyID", agencyId);
        map.put("tenantCode", tenantCode);
        map.put("page", page);
        LocalDate currentDate = LocalDate.now();
        int year = currentDate.getYear();
        int month = currentDate.getMonthValue();
        if (StringUtils.isBlank((String)zdMonth)) {
            map.put("ZdMonth", year + "-" + month);
        }
        if (StringUtils.isBlank((String)(url = this.getUrl((String)map.get("tenantCode"), "bill", "bill")))) {
            this.logger.error("chint.ZtBillServiceImpl.savePullingBill.url", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String data = null;
        Integer page1 = 1;
        Integer totalPage = 1;
        if (StringUtils.isNotBlank((String)page)) {
            page1 = Integer.valueOf(page);
        }
        boolean flag = true;
        while (flag) {
            try {
                map.put("AgencyID", "");
                map.put("tenantCode", "");
                map.put("Account", "all");
                map.put("page", page1);
                data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
                Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
                if (MapUtil.isEmpty((Map)returnResultsMap)) {
                    flag = false;
                    this.logger.error("chint.ZtBillServiceImpl.savePullingBill.flag" + url, (Object)("flag" + flag + "===" + map));
                } else {
                    Object code = returnResultsMap.get("Code");
                    if (null != code && String.valueOf(code).equals("200")) {
                        List jsonToList;
                        if (null != returnResultsMap.get("totalPage")) {
                            totalPage = Integer.valueOf(returnResultsMap.get("totalPage").toString());
                        }
                        if (ListUtil.isEmpty((Collection)(jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonNullBinder().toJson(returnResultsMap.get("rowst")), Map.class)))) {
                            flag = false;
                            this.logger.error("chint.ZtBillServiceImpl.savePullingBill.flag.1" + url, (Object)("flag" + flag + "===" + map));
                        }
                        for (Map paramsMap : jsonToList) {
                            ZtBillReDomain ztBill = new ZtBillReDomain();
                            ztBill.setAccount((String)paramsMap.get("Account"));
                            ztBill.setAgencyid((String)paramsMap.get("AgencyID"));
                            ztBill.setAgencyname((String)paramsMap.get("AgencyName"));
                            if (null != paramsMap.get("CheckDate")) {
                                ztBill.setCheckDate(ZtBillServiceImpl.getDate((String)paramsMap.get("CheckDate")));
                            }
                            if (null != paramsMap.get("CreateDate")) {
                                ztBill.setCreateDate(ZtBillServiceImpl.getDate((String)paramsMap.get("CreateDate")));
                            }
                            if (null != paramsMap.get("EndDate")) {
                                ztBill.setEndDate(ZtBillServiceImpl.getDate((String)paramsMap.get("CreateDate")));
                            }
                            ztBill.setId((String)paramsMap.get("id"));
                            ztBill.setBillRemark((String)paramsMap.get("Memo"));
                            if (null != paramsMap.get("Money")) {
                                ztBill.setRbillMoney(new BigDecimal((String)paramsMap.get("Money")));
                            }
                            ztBill.setRbillNo((String)paramsMap.get("NO"));
                            if (null != paramsMap.get("State")) {
                                ztBill.setDataState(Integer.valueOf((String)paramsMap.get("State")));
                            }
                            ztBill.setPush((String)paramsMap.get("Push"));
                            ztBill.setTenantCode(tenantCode);
                            this.savebill(ztBill);
                            Integer n = page1;
                            Integer n2 = page1 = Integer.valueOf(page1 + 1);
                        }
                    }
                }
                if (null == totalPage || page1 <= totalPage) continue;
                flag = false;
                this.logger.error("chint.ZtBillServiceImpl.savePullingBill.flag.flag" + url, (Object)("flag" + flag + "===" + page1));
            }
            catch (Exception e) {
                this.logger.error("chint.ZtBillServiceImpl.savePullingBill.flag.2" + url, (Object)("flag" + flag + "===" + map));
            }
        }
        return "Success";
    }

    public static void main(String[] args) {
        Object code;
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.put("ZdMonth", "2022-11");
        map.put("AgencyID", "");
        map.put("tenantCode", "");
        map.put("Account", "all");
        map.put("page", 10);
        System.out.println(JsonUtil.buildNonNullBinder().toJson(map));
        LocalDate currentDate = LocalDate.now();
        int year = currentDate.getYear();
        int month = currentDate.getMonthValue();
        String data = OKHttpClientUtil.sendPost("http://192.168.176.40:8080/api/DMS_DZ/GetDZList", JsonUtil.buildNormalBinder().toJson(map));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (!MapUtil.isEmpty((Map)returnResultsMap) && null != (code = returnResultsMap.get("Code")) && String.valueOf(code).equals("200")) {
            System.out.println(JsonUtil.buildNonNullBinder().toJson(returnResultsMap.get("rowst")));
            Integer totalPage = Integer.valueOf(returnResultsMap.get("totalPage").toString());
            System.out.println(totalPage);
            List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonNullBinder().toJson(returnResultsMap.get("rowst")), Map.class);
            System.out.println(data);
            for (Map paramsMap : jsonToList) {
                ZtBillReDomain ztBill = new ZtBillReDomain();
                ztBill.setAccount((String)paramsMap.get("Account"));
                ztBill.setAgencyid((String)paramsMap.get("AgencyID"));
                ztBill.setAgencyname((String)paramsMap.get("AgencyName"));
                if (null != paramsMap.get("CheckDate")) {
                    ztBill.setCheckDate(ZtBillServiceImpl.getDate((String)paramsMap.get("CheckDate")));
                }
                if (null != paramsMap.get("CreateDate")) {
                    ztBill.setCreateDate(ZtBillServiceImpl.getDate((String)paramsMap.get("CreateDate")));
                }
                if (null != paramsMap.get("EndDate")) {
                    ztBill.setEndDate(ZtBillServiceImpl.getDate((String)paramsMap.get("CreateDate")));
                }
                ztBill.setId((String)paramsMap.get("id"));
                ztBill.setBillRemark((String)paramsMap.get("Memo"));
                if (null != paramsMap.get("Money")) {
                    ztBill.setRbillMoney(new BigDecimal((String)paramsMap.get("Money")));
                }
                ztBill.setRbillNo((String)paramsMap.get("NO"));
                if (null != paramsMap.get("State")) {
                    ztBill.setDataState(Integer.valueOf((String)paramsMap.get("State")));
                }
                ztBill.setPush((String)paramsMap.get("Push"));
                System.out.println(JsonUtil.buildNonNullBinder().toJson((Object)ztBill));
            }
        }
    }

    public static Date getDate(String time) {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = null;
        try {
            date = dateformat.parse(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }
}

