/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.com.service;

import com.yqbsoft.laser.service.dynamic.GroovyUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.com.api.BankCall;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApi;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApiparam;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelReparse;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiParamType;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiSign;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelConfigScope;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ChannelSuppService
extends BaseServiceImpl {
    private static final String SYS_CODE = "cmc.ChannelSuppService";
    protected Map<String, String> apicode = new ConcurrentHashMap<String, String>(){
        private static final long serialVersionUID = 3757846883081103776L;
        {
            this.put("bankChannelCall", "cmc.channelCall.bankChannelCall");
            this.put("channelSPay", "cmc.channelIn.channelSPay");
            this.put("channelBPay", "cmc.channelIn.channelBPay");
            this.put("channelSOut", "cmc.channelOut.channelSOut");
            this.put("channelBOut", "cmc.channelOut.channelBOut");
            this.put("channelSQuery", "cmc.channelQuery.channelSQuery");
            this.put("channelBQuery", "cmc.channelQuery.channelBQuery");
            this.put("channelSRe", "cmc.channelRe.channelSRe");
            this.put("channelBRe", "cmc.channelRe.channelBRe");
            this.put("channelOauth", "cmc.channelOauth.channelOauth");
            this.put("channelInfuencer", "cmc.channelInfuencer.channelInfuencer");
            this.put("channelToken", "cmc.channelToken.getToken");
            this.put("channelSpStart", "cmc.channelSp.channelSpStart");
            this.put("channelSpEnd", "cmc.channelSp.channelSpEnd");
            this.put("channelSpCannel", "cmc.channelSp.channelSpCannel");
        }
    };

    public Map<String, Object> makeMap(Map<String, String> requestData) {
        if (null == requestData || requestData.isEmpty()) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        for (String key : requestData.keySet()) {
            parammap.put(key, requestData.get(key));
        }
        return parammap;
    }

    public abstract String getFchannelCode();

    protected String getApiCode(String method) {
        return this.apicode.get(method);
    }

    protected CmFchannelApi getCmFchannelApi(String fchannelCode, String channelApiCode, String tenantCode) {
        String key = fchannelCode + "-" + channelApiCode + "-" + tenantCode;
        CmFchannelApi cmFchannelApi = (CmFchannelApi)DisUtil.getMapJson((String)"Fchannel_api", (String)key, CmFchannelApi.class);
        if (null == cmFchannelApi) {
            key = fchannelCode + "-" + channelApiCode + "-00000000";
            cmFchannelApi = (CmFchannelApi)DisUtil.getMapJson((String)"Fchannel_api", (String)key, CmFchannelApi.class);
        }
        if (null == cmFchannelApi) {
            this.logger.error("cmc.ChannelSuppService.buildApiReuestParam.cmFchannelApi", (Object)(key + ":"));
            return null;
        }
        return cmFchannelApi;
    }

    protected List<CmFchannelApiparam> getCmFchannelApiparam(String fchannelCode, String channelApiCode, String apiParamType, String tenantCode) {
        String paramkey = fchannelCode + "-" + channelApiCode + "-" + apiParamType + "-" + tenantCode;
        List apiparamList = DisUtil.getMapListJson((String)"Fchannel_apiparam", (String)paramkey, CmFchannelApiparam.class);
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            paramkey = fchannelCode + "-" + channelApiCode + "-" + apiParamType + "-" + "00000000";
            apiparamList = DisUtil.getMapListJson((String)"Fchannel_apiparam", (String)paramkey, CmFchannelApiparam.class);
        }
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            this.logger.error("cmc.ChannelSuppService.buildApiReuestParam.apiParamStr", (Object)paramkey);
            return null;
        }
        return apiparamList;
    }

    protected Map<String, String> getConfigMap(String channelClearFchannel, String fchannelConfigScope, String fchannelCode, String proappCode, String tenantCode) {
        if (StringUtils.isBlank((String)fchannelConfigScope)) {
            fchannelConfigScope = ChannelConfigScope.PRO.getCode();
        }
        String configkeyProappCode = "";
        if (StringUtils.isNotBlank((String)proappCode)) {
            configkeyProappCode = fchannelCode + "-" + proappCode + "-" + tenantCode;
        }
        String configkey = fchannelCode + "-" + fchannelConfigScope + "-" + tenantCode;
        this.logger.info("cmc.ChannelSuppService.getConfigMap.configkeyProappCode", (Object)configkey);
        Map configMap = DisUtil.getMapMapJson((String)"Fchannel_config", (String)configkey, String.class, String.class);
        if (MapUtil.isEmpty((Map)configMap)) {
            configMap = DisUtil.getMapMapJson((String)"Fchannel_config", (String)configkeyProappCode, String.class, String.class);
        }
        if (MapUtil.isEmpty((Map)configMap)) {
            this.logger.error("cmc.ChannelSuppService.buildApiReuestParam.configStr", (Object)configkey);
            return null;
        }
        if (StringUtils.isNotBlank((String)channelClearFchannel) && !channelClearFchannel.equals(fchannelCode)) {
            Map readlConfigMap;
            String realConfigkey = channelClearFchannel + "-" + fchannelConfigScope + "-" + tenantCode;
            String realConfigkeyProappCode = "";
            if (StringUtils.isNotBlank((String)proappCode)) {
                realConfigkeyProappCode = channelClearFchannel + "-" + proappCode + "-" + tenantCode;
            }
            if (MapUtil.isEmpty((Map)(readlConfigMap = DisUtil.getMapMapJson((String)"Fchannel_config", (String)realConfigkey, String.class, String.class)))) {
                readlConfigMap = DisUtil.getMapMapJson((String)"Fchannel_config", (String)realConfigkeyProappCode, String.class, String.class);
            }
            if (MapUtil.isNotEmpty((Map)readlConfigMap)) {
                configMap.putAll(readlConfigMap);
            }
        }
        return configMap;
    }

    public static void main(String[] args) {
        HashMap jsMap = new HashMap();
        HashMap<String, Integer> ext = new HashMap<String, Integer>();
        ext.put("test", 10);
        jsMap.put("ext", ext);
        Object value = ScriptUtil.evel((String)"var fee=ext.get('test'); fee=Math.round(fee*100); return fee.toFixed();", jsMap);
        System.out.println(value);
    }

    protected ChannelRest buildBank(Map<String, String> map) {
        BankRequest bankRequest = this.parse(map);
        if (null == bankRequest) {
            this.logger.error("cmc.ChannelSuppService.bankChannelCall.bankRequest");
            return null;
        }
        bankRequest.setSing(true);
        return this.verifySign(bankRequest);
    }

    protected abstract ChannelRest verifySign(BankRequest var1);

    protected ChannelRest buildResponeBank(Map<String, String> map, ChannelRequest channelRequest) {
        if (null == channelRequest || null == map || map.isEmpty() || null == channelRequest.getCmFchannelApi()) {
            this.logger.error("cmc.ChannelSuppService.buildResponeBank", (Object)"\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        map.put("type", ChannelApiParamType.OUT.getCode());
        String respase = channelRequest.getCmFchannelApi().getFchannelApiReparse();
        if (StringUtils.isBlank((String)respase)) {
            this.logger.error("cmc.ChannelSuppService.buildResponeBank.respase");
            throw new ApiException("cmc.ChannelSuppService.buildResponeBank.respase", "");
        }
        BankRequest bankRequest = this.bankReustPaser(map, this.getFchannelCode(), channelRequest.getCmChannelClear().getTenantCode(), "respone", respase);
        if (null == bankRequest) {
            this.logger.error("cmc.ChannelSuppService.buildResponeBank.bankRequest");
            return null;
        }
        bankRequest.setChannelApiCode(channelRequest.getCmFchannelApi().getChannelApiCode());
        bankRequest.setType(ChannelApiParamType.OUT.getCode());
        if (ChannelApiSign.SIGN.getCode().equals(channelRequest.getCmFchannelApi().getFchannelApiResign())) {
            bankRequest.setSing(true);
        } else {
            bankRequest.setSing(false);
        }
        return this.verifySign(bankRequest);
    }

    private BankRequest parse(Map<String, String> map) {
        BankRequest bankRequest = new BankRequest();
        bankRequest.setSuccess(false);
        if (null == map) {
            bankRequest.setBmsg("\u53c2\u6570\u4e3a\u7a7a");
            return bankRequest;
        }
        String fchannelCode = map.get("channelClearFchannel");
        String tenantCode = map.get("tenantCode");
        String type = "call";
        CmFchannelReparse cmFchannelReparse = (CmFchannelReparse)DisUtil.getMapJson((String)"Fchannel_parse_pro", (String)(fchannelCode + "-" + type + "-" + tenantCode), CmFchannelReparse.class);
        if (null == cmFchannelReparse) {
            cmFchannelReparse = (CmFchannelReparse)DisUtil.getMapJson((String)"Fchannel_parse_pro", (String)(fchannelCode + "-" + type + "-00000000"), CmFchannelReparse.class);
        }
        if (null == cmFchannelReparse) {
            this.logger.error("cmc.ChannelSuppService.parse.strs", (Object)(fchannelCode + "-call-" + tenantCode));
            bankRequest.setBmsg("\u89e3\u6790\u6a21\u677f\u4e3a\u7a7a");
            return bankRequest;
        }
        BankRequest rebankRequest = this.bankReustPaser(map, fchannelCode, tenantCode, type, cmFchannelReparse.getFchannelReparseRe());
        if (null == rebankRequest) {
            this.logger.error("cmc.ChannelSuppService.parse.rebankRequest", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
            bankRequest.setBmsg("\u89e3\u6790\u5931\u8d251");
            return bankRequest;
        }
        rebankRequest.setType(ChannelApiParamType.CALL.getCode());
        rebankRequest.setReError(cmFchannelReparse.getFchannelReparseError());
        rebankRequest.setReSuccess(cmFchannelReparse.getFchannelReparseSuccess());
        return rebankRequest;
    }

    private BankRequest bankReustPaser(Map<String, String> map, String fchannelCode, String tenantCode, String type, String reparseStr) {
        BankRequest rebankRequest;
        if (StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)reparseStr)) {
            this.logger.error("cmc.ChannelSuppService.bankReustPaser.null", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
            return null;
        }
        BankCall bankCall = (BankCall)GroovyUtil.executeCalculate((String)reparseStr);
        if (null == bankCall) {
            this.logger.error("cmc.ChannelSuppService.bankReustPaser.bankCall", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
            return null;
        }
        try {
            rebankRequest = bankCall.callEx(map);
            if (null == rebankRequest || null == rebankRequest.getRequestData() || rebankRequest.getRequestData().isEmpty()) {
                this.logger.error("cmc.ChannelSuppService.bankReustPaser.remap", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
                return rebankRequest;
            }
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelSuppService.bankReustPaser.remap", (Object)(fchannelCode + "-" + type + "-" + tenantCode), (Throwable)e);
            return null;
        }
        String fchannelConfigScope = map.get("fchannelConfigScope");
        if (StringUtils.isBlank((String)fchannelConfigScope)) {
            fchannelConfigScope = ChannelConfigScope.PRO.getCode();
        }
        String realFchannelCode = map.get("realFchannelCode");
        rebankRequest.setConfigMap(this.getConfigMap(realFchannelCode, fchannelConfigScope, fchannelCode, null, tenantCode));
        return rebankRequest;
    }
}

