/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fnps.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.yqbsoft.laser.service.ext.channel.fnps.common.exception.ServerErrorException;
import com.yqbsoft.laser.service.ext.channel.fnps.common.exception.ServiceException;
import com.yqbsoft.laser.service.ext.channel.fnps.common.exception.SourceTimeoutException;
import com.yqbsoft.laser.service.ext.channel.fnps.common.utils.SignatureUtil;
import com.yqbsoft.laser.service.ext.channel.fnps.common.utils.StringUtils;
import com.yqbsoft.laser.service.ext.channel.fnps.config.Config;
import com.yqbsoft.laser.service.ext.channel.fnps.config.oauth.response.Token;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.base.BaseBizResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";

    public static String doPost(Config context, String url, Map<String, String> params, String charset, String rid, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils.post(context, url, ctype, content, rid, connectTimeout, readTimeout, headerMap);
    }

    public static String doPost(Config context, String url, String ctype, byte[] content, String rid, int connectTimeout, int readTimeout) throws SocketTimeoutException, IOException {
        return WebUtils.post(context, url, ctype, content, rid, connectTimeout, readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String post(Config context, String url, String ctype, byte[] content, String rid, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws SocketTimeoutException, IOException {
        String rsp;
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            conn = WebUtils.getConnection(new URL(url), METHOD_POST, ctype, headerMap, rid);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap, String rid) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("Content-Type", ctype);
        conn.setRequestProperty("Accept-Encoding", "gzip");
        conn.setRequestProperty("User-Agent", "eleme-openapi-java-sdk");
        String elemeRequestId = rid;
        conn.setRequestProperty("x-eleme-requestid", elemeRequestId);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset, conn);
        }
        String msg = WebUtils.getStreamAsString(es, charset, conn);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset, HttpURLConnection conn) throws IOException {
        try {
            int read;
            InputStreamReader reader = "gzip".equals(conn.getContentEncoding()) ? new InputStreamReader((InputStream)new GZIPInputStream(stream), charset) : new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String getReqId() {
        return WebUtils.generateuuid() + "|" + System.currentTimeMillis();
    }

    public static String generateuuid() {
        try {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            if (uuid.length() > 32) {
                uuid = uuid.substring(0, 32);
            }
            return uuid.toUpperCase();
        }
        catch (Exception e) {
            return "00112233445566778899AABBCCDDEEFF";
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static <T> T call(Config context, String apiCode, Map<String, Object> parameters, Token token, Type type) throws ServiceException {
        BaseBizResponse bizResponse;
        long timestamp = System.currentTimeMillis();
        String appId = context.getAppId();
        String secret = context.getSecretKey();
        String accessToken = token.getAccessToken();
        String merchantId = token.getMerchantId();
        String requestId = WebUtils.getReqId();
        log.error("requestId: {}", (Object)requestId);
        HashMap<String, Object> requestPayload = new HashMap<String, Object>(8);
        requestPayload.put("version", "1.0");
        requestPayload.put("app_id", appId);
        requestPayload.put("merchant_id", merchantId);
        String bizApiUrl = context.getBizApiUrl();
        requestPayload.put("access_token", accessToken);
        requestPayload.put("timestamp", timestamp);
        requestPayload.put("business_data", JSON.toJSONString(parameters));
        String sortedParamsStr = SignatureUtil.sortApiParams(appId, merchantId, timestamp + "", accessToken, JSON.toJSONString(parameters));
        String signature = SignatureUtil.genSignature(secret, sortedParamsStr);
        requestPayload.put("signature", signature);
        context.setPostUrl(bizApiUrl + apiCode);
        String requestJson = JSON.toJSONString(requestPayload);
        try {
            bizResponse = WebUtils.doRequest(context, requestJson, requestId);
        }
        catch (SocketTimeoutException ex) {
            throw new SourceTimeoutException();
        }
        catch (IOException ex) {
            throw new ServiceException(ex.getClass().getName(), ex);
        }
        if (bizResponse != null && !"200".equals(bizResponse.getCode())) {
            ServiceException serviceException = WebUtils.toException(bizResponse);
            if (serviceException != null) {
                throw serviceException;
            }
            throw new ServerErrorException();
        }
        if (type == Void.TYPE) {
            return null;
        }
        String s2 = bizResponse.getBusinessData();
        return (T)JSON.parseObject((String)s2, (Type)type, (Feature[])new Feature[0]);
    }

    private static BaseBizResponse doRequest(Config context, String requestJson, String rid) throws SocketTimeoutException, IOException {
        String response = WebUtils.doPost(context, context.getPostUrl(), "application/json; charset=utf-8", requestJson.getBytes(DEFAULT_CHARSET), rid, 15000, 15000);
        log.info("http response:{}", (Object)JSON.toJSONString((Object)response));
        return (BaseBizResponse)JSON.parseObject((String)response, BaseBizResponse.class);
    }

    private static ServiceException toException(BaseBizResponse error) throws ServiceException {
        String code = error.getCode();
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        String message = error.getMsg();
        return new ServiceException(message);
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

