/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fnps.service.store;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfoQua;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisStoreBaseService;
import com.yqbsoft.laser.service.ext.channel.fnps.FnpsConstants;
import com.yqbsoft.laser.service.ext.channel.fnps.common.WebUtils;
import com.yqbsoft.laser.service.ext.channel.fnps.domain.FnpsResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisStoreServiceImpl2
extends DisStoreBaseService {
    private String SYS_CODE = "fnps.StoreServiceImpl";

    public Map<String, Object> buildStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        UmUserinfo umUserinfo = (UmUserinfo)param.get("umUserinfo");
        if (null == umUserinfo) {
            return null;
        }
        sendParam.put("address", umUserinfo.getCompanyAddress());
        sendParam.put("longitude", umUserinfo.getUserinfoMap());
        sendParam.put("latitude", umUserinfo.getUserinfoMap());
        List umUserinfoChannelDomains = umUserinfo.getUmUserinfoChannelDomainList();
        int i = 0;
        sendParam.put("timeError", "\u8425\u4e1a\u65f6\u95f4\u8bbe\u7f6e\u6709\u8bef\uff01");
        if (ListUtil.isNotEmpty((Collection)umUserinfoChannelDomains)) {
            String servingTime = "";
            for (Object ucd : umUserinfoChannelDomains) {
                if (!disChannel.getChannelCode().equals(ucd.getChannelCode())) continue;
                if (!StringUtils.isEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("transportFree")) {
                    sendParam.put("shipping_fee", ucd.getUserinfoChannelVaule());
                }
                if (!StringUtils.isEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("checkBusiness")) {
                    String status = "3";
                    if (ucd.getUserinfoChannelVaule().equals("0")) {
                        status = "1";
                    }
                    sendParam.put("open_level", status);
                    sendParam.put("is_online", status.equals("1") ? "1" : "0");
                }
                if (!StringUtils.isEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("channelOpenTime")) {
                    if (StringUtils.isBlank((String)ucd.getUserinfoChannelVaule())) continue;
                    servingTime = servingTime + ucd.getUserinfoChannelVaule() + "-";
                    ++i;
                }
                if (!StringUtils.isEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("channelCloseTime")) {
                    if (StringUtils.isBlank((String)ucd.getUserinfoChannelVaule())) continue;
                    servingTime = servingTime + ucd.getUserinfoChannelVaule();
                    ++i;
                }
                if (i < 2) continue;
                List<String> timeStr = Arrays.asList(servingTime);
                sendParam.put("shipping_time", timeStr);
                sendParam.remove("timeError");
            }
        }
        if (i == 0) {
            List userinfoQuas = umUserinfo.getUmUserinfoQuaList();
            String time = "";
            if (ListUtil.isNotEmpty((Collection)userinfoQuas)) {
                for (UmUserinfoQua userinfoQua : userinfoQuas) {
                    if (!StringUtils.isEmpty((String)userinfoQua.getUserinfoQuaKey()) && userinfoQua.getUserinfoQuaKey().equals("storeOpenTime")) {
                        if (StringUtils.isBlank((String)userinfoQua.getUserinfoQuaVaule())) continue;
                        time = time + userinfoQua.getUserinfoQuaVaule() + "-";
                        ++i;
                    }
                    if (StringUtils.isEmpty((String)userinfoQua.getUserinfoQuaKey()) || !userinfoQua.getUserinfoQuaKey().equals("storeCloseTime") || StringUtils.isBlank((String)userinfoQua.getUserinfoQuaVaule())) continue;
                    time = time + userinfoQua.getUserinfoQuaVaule();
                    ++i;
                }
            }
            if (i >= 2) {
                List<String> result = Arrays.asList(time);
                sendParam.put("shipping_time", result);
                sendParam.remove("timeError");
            }
        }
        sendParam.put("description", umUserinfo.getUserinfoRemark());
        sendParam.put("name", umUserinfo.getUserinfoCompname());
        sendParam.put("phone", umUserinfo.getUserinfoPhone());
        sendParam.put("third_tag_name", "\u8d85\u5e02");
        return sendParam;
    }

    public Map<String, Object> buildStoreStartParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }

    public Map<String, Object> buildStoreEndParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }

    public Map<String, Object> buildGetStoreParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            sendParam.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        return sendParam;
    }

    public String sendStoreStartParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }

    public UmUserinfo sendGetStore(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return null;
        }
        String url = configMap.get(FnpsConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendhttpParam)) {
            for (String key : sendhttpParam.keySet()) {
                httpParam.put(key, String.valueOf(sendhttpParam.get(key)));
            }
        }
        try {
            json = WebUtils.doGet(url, httpParam, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        FnpsResult mtResult = this.make(json);
        if (null != mtResult && StringUtils.isNotBlank((String)mtResult.getMessage())) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.e ======  " + mtResult.getMessage(), (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        List dataList = (List)mtResult.getData();
        if (ListUtil.isEmpty((Collection)dataList)) {
            return null;
        }
        Map dataMap = (Map)dataList.get(0);
        UmUserinfo umUserinfo = new UmUserinfo();
        umUserinfo.setCompanyAddress((String)dataMap.get("address"));
        umUserinfo.setUserinfoMap(String.valueOf(dataMap.get("longitude")) + " / " + String.valueOf(dataMap.get("latitude")));
        umUserinfo.setUserinfoRemark((String)dataMap.get("promotion_info"));
        umUserinfo.setUserinfoCompname((String)dataMap.get("name"));
        umUserinfo.setUserinfoPhone((String)dataMap.get("phone"));
        umUserinfo.setDataState(Integer.valueOf(-1));
        if ((Integer)dataMap.get("is_online") == 1) {
            umUserinfo.setDataState(Integer.valueOf(0));
        }
        return umUserinfo;
    }

    public String sendStoreEndParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }

    public String sendStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    private String sendStoreComParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        if (StringUtils.isNotBlank((String)((String)sendhttpParam.get("timeError")))) {
            return (String)sendhttpParam.get("timeError");
        }
        String url = configMap.get(FnpsConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map<String, String> mapStr = this.convert(sendhttpParam);
        try {
            json = WebUtils.doPost(url, mapStr, 1000, 1000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        FnpsResult mtResult = this.make(json);
        if (null == mtResult) {
            return json;
        }
        if (null != mtResult && StringUtils.isNotBlank((String)mtResult.getMessage())) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.e ======  " + mtResult.getMessage(), (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return mtResult.getMessage();
        }
        return "SUCCESS";
    }

    public Map<String, String> convert(Map<String, Object> map) {
        HashMap<String, String> strMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            strMap.put(key, String.valueOf(map.get(key)));
        }
        return strMap;
    }

    protected String getChannelCode() {
        return FnpsConstants.channelCode;
    }

    private FnpsResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        FnpsResult mtResult = (FnpsResult)JsonUtil.buildNormalBinder().getJsonToObject(json, FnpsResult.class);
        if (null == mtResult) {
            return null;
        }
        return mtResult;
    }
}

