/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fnps.service.shop;

import com.yqbsoft.laser.service.ext.channel.fnps.annotation.Service;
import com.yqbsoft.laser.service.ext.channel.fnps.base.BaseBizApiService;
import com.yqbsoft.laser.service.ext.channel.fnps.common.exception.ServiceException;
import com.yqbsoft.laser.service.ext.channel.fnps.config.Config;
import com.yqbsoft.laser.service.ext.channel.fnps.config.oauth.response.Token;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreCreateReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreCreateRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreQueryListReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreQueryListRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreUpdateReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ChainstoreUpdateRes;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.QueryChainStoreReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.ShopInfo;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.UploadImgReq;
import com.yqbsoft.laser.service.ext.channel.fnps.entity.shop.UploadImgRes;
import java.util.HashMap;

@Service(value="me.ele.order")
public class ShopService
extends BaseBizApiService {
    private static final String CHAIN_STORE_QUERY_API_CODE = "chainstoreQuery";
    private static final String CHAIN_STORE_QUERY_LIST_API_CODE = "chainstoreQueryList";
    private static final String CHAIN_STORE_CREATE_API_CODE = "chainstoreCreate";
    private static final String CHAIN_STORE_UPDATE_API_CODE = "chainstoreUpdate";
    private static final String UPLOAD_FILE_API_CODE = "newUploadFile";

    public ShopService(Config config, Token token) {
        super(config, token, ShopService.class);
    }

    public UploadImgRes uploadImg(UploadImgReq uploadImgReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("file_binary", uploadImgReq.getFileBinary());
        params.put("file_type", uploadImgReq.getFileType());
        return (UploadImgRes)this.call(UPLOAD_FILE_API_CODE, params);
    }

    public ShopInfo getShop(QueryChainStoreReq queryChainStoreReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("chain_store_id", queryChainStoreReq.getChainStoreId());
        params.put("merchant_id", queryChainStoreReq.getMerchantId());
        params.put("out_shop_code", queryChainStoreReq.getOutShopCode());
        return (ShopInfo)this.call(CHAIN_STORE_QUERY_API_CODE, params);
    }

    public ChainstoreQueryListRes chainstoreQueryList(ChainstoreQueryListReq chainstoreQueryListReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("merchant_id", chainstoreQueryListReq.getMerchantId());
        params.put("page_no", chainstoreQueryListReq.getPageNo());
        params.put("page_size", chainstoreQueryListReq.getPageSize());
        return (ChainstoreQueryListRes)this.call(CHAIN_STORE_QUERY_LIST_API_CODE, params);
    }

    public ChainstoreCreateRes createChainstore(ChainstoreCreateReq chainstoreCreateReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("head_shop_name", chainstoreCreateReq.getHeadShopName());
        params.put("branch_shop_name", chainstoreCreateReq.getBranchShopName());
        params.put("chainstore_type", chainstoreCreateReq.getChainStoreType());
        params.put("contact_phone", chainstoreCreateReq.getContactPhone());
        params.put("address", chainstoreCreateReq.getAddress());
        params.put("longitude", chainstoreCreateReq.getLongitude());
        params.put("latitude", chainstoreCreateReq.getLatitude());
        params.put("position_source", chainstoreCreateReq.getPositionSource());
        params.put("out_shop_code", chainstoreCreateReq.getOutShopCode());
        params.put("category_id", chainstoreCreateReq.getCategoryId());
        params.put("owner_name", chainstoreCreateReq.getOwnerName());
        params.put("owner_id_num", chainstoreCreateReq.getOwnerIdNum());
        params.put("handheld_licence_pic_hash", chainstoreCreateReq.getHandheldLicencePicHash());
        params.put("owner_id_pic_front_hash", chainstoreCreateReq.getOwnerIdPicFrontHash());
        params.put("owner_id_pic_back_hash", chainstoreCreateReq.getOwnerIdPicBackHash());
        params.put("credit_code", chainstoreCreateReq.getCreditCode());
        params.put("business_licence_pic_hash", chainstoreCreateReq.getBusinessLicencePicHash());
        params.put("food_license_pic_hash", chainstoreCreateReq.getFoodLicensePicHash());
        params.put("second_medical_equipment_license_pic_hash", chainstoreCreateReq.getSecondMedicalEquipmentLicensePicHash());
        params.put("medical_institution_license_pic_hash", chainstoreCreateReq.getMedicineLicensePicHash());
        params.put("medical_equipment_license_pic_hash", chainstoreCreateReq.getMedicalEquipmentLicensePicHash());
        params.put("medicine_license_pic_hash", chainstoreCreateReq.getMedicineLicensePicHash());
        params.put("tabacoo_license_pic_hash", chainstoreCreateReq.getTabacooLicensePicHash());
        params.put("settlement_model", chainstoreCreateReq.getSettlementModel());
        params.put("settlement_account_id", chainstoreCreateReq.getSettlementAccountId());
        return (ChainstoreCreateRes)this.call(CHAIN_STORE_CREATE_API_CODE, params);
    }

    public ChainstoreUpdateRes updateChainstore(ChainstoreUpdateReq chainstoreUpdateReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("chain_store_id", chainstoreUpdateReq.getChainStoreId());
        params.put("head_shop_name", chainstoreUpdateReq.getHeadShopName());
        params.put("branch_shop_name", chainstoreUpdateReq.getBranchShopName());
        params.put("chainstore_type", chainstoreUpdateReq.getChainStoreType());
        params.put("contact_phone", chainstoreUpdateReq.getContactPhone());
        params.put("address", chainstoreUpdateReq.getAddress());
        params.put("longitude", chainstoreUpdateReq.getLongitude());
        params.put("latitude", chainstoreUpdateReq.getLatitude());
        params.put("position_source", chainstoreUpdateReq.getPositionSource());
        params.put("out_shop_code", chainstoreUpdateReq.getOutShopCode());
        params.put("category_id", chainstoreUpdateReq.getCategoryId());
        params.put("owner_name", chainstoreUpdateReq.getOwnerName());
        params.put("owner_id_num", chainstoreUpdateReq.getOwnerIdNum());
        params.put("handheld_licence_pic_hash", chainstoreUpdateReq.getHandheldLicencePicHash());
        params.put("owner_id_pic_front_hash", chainstoreUpdateReq.getOwnerIdPicFrontHash());
        params.put("owner_id_pic_back_hash", chainstoreUpdateReq.getOwnerIdPicBackHash());
        params.put("credit_code", chainstoreUpdateReq.getCreditCode());
        params.put("business_licence_pic_hash", chainstoreUpdateReq.getBusinessLicencePicHash());
        params.put("food_license_pic_hash", chainstoreUpdateReq.getFoodLicensePicHash());
        params.put("second_medical_equipment_license_pic_hash", chainstoreUpdateReq.getSecondMedicalEquipmentLicensePicHash());
        params.put("medical_institution_license_pic_hash", chainstoreUpdateReq.getMedicineLicensePicHash());
        params.put("medical_equipment_license_pic_hash", chainstoreUpdateReq.getMedicalEquipmentLicensePicHash());
        params.put("medicine_license_pic_hash", chainstoreUpdateReq.getMedicineLicensePicHash());
        params.put("tabacoo_license_pic_hash", chainstoreUpdateReq.getTabacooLicensePicHash());
        return (ChainstoreUpdateRes)this.call(CHAIN_STORE_UPDATE_API_CODE, params);
    }
}

