/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fxg.order.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.fxg.FxgConstants;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.ApimFacadeUtil;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.StringConvertUtil;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.apim.AfterSaleDetailRequest;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.apim.AfterSaleDetailResponse;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.apim.DisRefundRequest;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.apim.DisRefundResponse;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "fxg.DisRefundServiceImpl";
    public static final ArrayList<String> REFUND_TAGS = new ArrayList();
    private static ThreadLocal<DateFormat> threadLocal;

    protected String getChannelCode() {
        return FxgConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.sendParam", (Object)("sendParam=" + sendParam.toString()));
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.configMap", (Object)("configMap=" + configMap.toString()));
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.param", (Object)("param=" + param.toString()));
        if ("cmc.disRefund.saveSendRefundAccept".equals(channelApiCode)) {
            sendParam = param;
        }
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        return sendParam;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    private String sendRequestToDoudianConnector(Map<String, String> configMap, DisRefundRequest request) {
        configMap.put("serviceUrl", configMap.get("host") + "/sc-fulfillment-douyin-api-proxy/v2/proxy/doudian");
        configMap.put("action", "afterSale.Operate");
        ApimFacadeUtil util = new ApimFacadeUtil(configMap);
        String token = util.fetchToken();
        try {
            DisRefundResponse response = (DisRefundResponse)util.execute(token, request);
            this.logger.error(this.SYS_CODE + ".sendComRefund.sendRequestToDoudianConnector.response", (Object)("aftersaleId=" + request.getItems().get(0).getAftersale_id() + ";response=" + JsonUtil.buildNormalBinder().toJson((Object)response)));
            return "ERROR";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.sendRequestToDoudianConnector.error", (Object)("aftersaleId=" + request.getItems().get(0).getAftersale_id() + ";Exception=" + e));
            e.printStackTrace();
            return "ERROR";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".sendComRefund.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
        this.logger.error(this.SYS_CODE + ".sendComRefund.sendParam", (Object)("sendParam=" + sendParam.toString()));
        this.logger.error(this.SYS_CODE + ".sendComRefund.configMap", (Object)("configMap=" + configMap.toString()));
        this.logger.error(this.SYS_CODE + ".sendComRefund.param", (Object)("param=" + param.toString()));
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap)) {
            this.logger.error(this.SYS_CODE, (Object)"sendComOrder.disChannel or sendParam or configMap is null!");
            return "ERROR";
        }
        if (!"cmc.disRefund.saveSendRefundAccept".equals(channelApiCode)) {
            return "SUCCESS";
        }
        try {
            DisRefundRequest request;
            ArrayList<DisRefundRequest.Aftersale> items;
            block20: {
                String dataState;
                String frequency;
                block21: {
                    frequency = StringConvertUtil.valueOf(sendParam.get("frequency"));
                    String aftersaleId = StringConvertUtil.valueOf(sendParam.get("refundCode"));
                    dataState = StringConvertUtil.valueOf(sendParam.get("dataState"));
                    if (StringUtils.isBlank((String)aftersaleId)) {
                        this.logger.error(this.SYS_CODE + ".sendComRefund.aftersaleId=" + aftersaleId, (Object)("channelApiCode=" + channelApiCode));
                        return "ERROR";
                    }
                    if (!StringUtils.equals((CharSequence)"1", (CharSequence)frequency) && !StringUtils.equals((CharSequence)"2", (CharSequence)frequency)) {
                        this.logger.error(this.SYS_CODE + ".sendComRefund.frequency=" + frequency, (Object)("channelApiCode=" + channelApiCode));
                        return "ERROR";
                    }
                    if (!StringUtils.equals((CharSequence)"0", (CharSequence)dataState) && !StringUtils.equals((CharSequence)"1", (CharSequence)dataState)) {
                        this.logger.error(this.SYS_CODE + ".sendComRefund.dataState=" + dataState, (Object)("channelApiCode=" + channelApiCode));
                        return "ERROR";
                    }
                    String afterSaleType = StringConvertUtil.valueOf(sendParam.get("afterSaleType"));
                    DisRefundRequest.Aftersale aftersale = new DisRefundRequest.Aftersale();
                    aftersale.setAftersale_id(aftersaleId);
                    if (StringUtils.equals((CharSequence)"B51", (CharSequence)afterSaleType) && StringUtils.equals((CharSequence)"0", (CharSequence)dataState) && "1".equals(frequency)) {
                        Long receiverAddressId = null;
                        try {
                            receiverAddressId = Long.valueOf(StringConvertUtil.valueOf(sendParam.get("receiverAddressId")));
                            DisRefundRequest.Logistics logistics = new DisRefundRequest.Logistics();
                            logistics.setReceiver_address_id(receiverAddressId);
                            aftersale.setLogistics(logistics);
                        }
                        catch (Exception e) {
                            this.logger.error(this.SYS_CODE + ".sendComRefund.receiverAddressId.error", (Object)("aftersaleId=" + sendParam.get("refundCode") + ";Exception=" + e));
                            e.printStackTrace();
                            return "ERROR";
                        }
                    }
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)dataState)) {
                        aftersale.setReason(sendParam.get("reason") == null ? "" : sendParam.get("reason").toString());
                        Long type = sendParam.get("type") == null ? null : Long.valueOf(Long.parseLong(sendParam.get("type").toString()));
                        String desc = sendParam.get("desc") == null ? "" : sendParam.get("desc").toString();
                        String url = sendParam.get("url") == null ? "" : sendParam.get("url").toString();
                        Map urlMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(url, String.class, String.class);
                        DisRefundRequest.Evidence evidence = null;
                        ArrayList<DisRefundRequest.Evidence> evidenceList = new ArrayList<DisRefundRequest.Evidence>();
                        if (MapUtil.isNotEmpty((Map)urlMap)) {
                            Set entrySet = urlMap.entrySet();
                            for (Map.Entry entry : entrySet) {
                                evidence = new DisRefundRequest.Evidence();
                                evidence.setType(type);
                                evidence.setUrl((String)entry.getValue());
                                evidence.setDesc(desc);
                                evidenceList.add(evidence);
                            }
                        } else {
                            evidence = new DisRefundRequest.Evidence();
                            evidence.setType(type);
                            evidence.setUrl("");
                            evidence.setDesc(desc);
                            evidenceList.add(evidence);
                        }
                        aftersale.setEvidence(evidenceList);
                    }
                    items = new ArrayList<DisRefundRequest.Aftersale>();
                    items.add(aftersale);
                    request = new DisRefundRequest();
                    if (!"1".equals(frequency)) break block21;
                    if (StringUtils.equals((CharSequence)"B50", (CharSequence)afterSaleType)) {
                        String orderState = StringConvertUtil.valueOf(sendParam.get("orderState"));
                        if (!StringUtils.equals((CharSequence)"2", (CharSequence)orderState)) {
                            request.setType(202L);
                            break block20;
                        } else {
                            request.setType(401L);
                        }
                        break block20;
                    } else {
                        if (!StringUtils.equals((CharSequence)"B51", (CharSequence)afterSaleType)) {
                            this.logger.error(this.SYS_CODE + ".sendComRefund.afterSaleType=" + afterSaleType, (Object)("aftersaleId=" + sendParam.get("refundCode")));
                            return "ERROR";
                        }
                        request.setType(StringUtils.equals((CharSequence)"0", (CharSequence)dataState) ? 101L : 102L);
                    }
                    break block20;
                }
                if (!"2".equals(frequency)) {
                    return "ERROR";
                }
                request.setType(StringUtils.equals((CharSequence)"0", (CharSequence)dataState) ? 111L : 112L);
            }
            request.setItems(items);
            return this.sendRequestToDoudianConnector(configMap, request);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.error", (Object)("aftersaleId=" + sendParam.get("refundCode") + ";Exception=" + e));
            e.printStackTrace();
            return "ERROR";
        }
    }

    public Map<String, Object> getAfterSaleDetailForDoudianConnnector(Map<String, String> configMap, String afterSaleId) {
        configMap.put("serviceUrl", configMap.get("host") + "/sc-fulfillment-douyin-api-proxy/v2/proxy/doudian");
        configMap.put("action", "afterSale.Detail");
        ApimFacadeUtil util = new ApimFacadeUtil(configMap);
        String token = util.fetchToken();
        AfterSaleDetailRequest request = new AfterSaleDetailRequest();
        request.setAfter_sale_id(afterSaleId);
        AfterSaleDetailResponse response = (AfterSaleDetailResponse)util.execute(token, request);
        this.logger.error(this.SYS_CODE + ".afterSale.Detail", (Object)("afterSaleId=" + afterSaleId + ";response=" + JsonUtil.buildNonNullBinder().toJson((Object)response)));
        try {
            Map responseMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(response.getBody(), String.class, Object.class);
            Map afterSaleDetailResponse = (Map)responseMap.get("data");
            if (MapUtil.isNotEmpty((Map)afterSaleDetailResponse)) {
                return afterSaleDetailResponse;
            }
            this.logger.error(this.SYS_CODE + ".afterSale.Detail", (Object)("afterSaleId=" + afterSaleId + ";\u8c03\u7528\u83b7\u53d6\u552e\u540e\u8be6\u60c5\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a"));
            return null;
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".afterSale.Detail.error", (Object)("afterSaleId=" + afterSaleId + ";\u8c03\u7528\u83b7\u53d6\u552e\u540e\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38"));
            return null;
        }
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".saveRefundParam.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
        this.logger.error(this.SYS_CODE + ".saveRefundParam.param", (Object)("param=" + param.toString()));
        this.logger.error(this.SYS_CODE + ".saveRefundParam.sendParam", (Object)("sendParam=" + sendParam.toString()));
        String resStream = StringConvertUtil.filterUtf8mb4(StringConvertUtil.valueOf(param.get("resStream")));
        List jsonToList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(resStream, Object.class);
        Map msgData = (Map)jsonToList.get(0);
        String tag = (String)msgData.get("tag");
        String s = (String)msgData.get("data");
        Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(s, String.class, Object.class);
        this.logger.error(this.SYS_CODE + ".saveRefundParam.dataMap", (Object)("dataMap=" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
        return this.resultReturn(0, "success");
    }

    private DisRefundDomain createRefund(DisChannel disChannel, Map<String, Object> dataMap, String refund_type) {
        return this.makeRefund(dataMap, disChannel, refund_type);
    }

    private DisRefundDomain makeRefund(Map<String, Object> dataMap, DisChannel disChannel, String refund_type) {
        String refundAuditTime;
        Object refundAmount;
        Map map = (Map)dataMap.get("aftersale_detail");
        if (MapUtil.isEmpty((Map)map)) {
            this.logger.error(this.SYS_CODE + ".makeRefund.dataMap.aftersale_detail is null", (Object)("aftersale_detail=" + JsonUtil.buildNormalBinder().toJson((Object)map)));
            return null;
        }
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(disChannel.getTenantCode());
        disRefundDomain.setMemberCcode(disChannel.getMemberMcode());
        disRefundDomain.setMemberCname(disChannel.getMemberMname());
        disRefundDomain.setGoodsClass(disChannel.getGoodsClass());
        disRefundDomain.setMemberMcode(disChannel.getMemberMcode());
        disRefundDomain.setMemberMname(disChannel.getMemberMname());
        String skuOrderId = map.get("sku_order_id").toString();
        DisContractDomain disContractDomain = null;
        try {
            disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), skuOrderId, disChannel);
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain1", (Object)skuOrderId);
                return null;
            }
            disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode());
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain", (Object)skuOrderId);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain.error", (Object)skuOrderId);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.error", (Object)("copyAllPropertys=" + e.getMessage()));
            return null;
        }
        disRefundDomain.setContractNbillcode(skuOrderId);
        disRefundDomain.setRefundOcode(map.get("aftersale_id").toString());
        disRefundDomain.setDataStatestr(dataMap.get("aftersale_status").toString());
        disRefundDomain.setContractPumode(refund_type);
        disRefundDomain.setDataState(Integer.valueOf(disRefundDomain.getDataStatestr()));
        String applyTime = map.get("apply_time").toString();
        Date refundDate = null;
        if (StringUtils.isNotBlank((String)applyTime)) {
            try {
                refundDate = threadLocal.get().parse(applyTime);
            }
            catch (ParseException e) {
                this.logger.error(this.SYS_CODE + ".makeRefund.error", (Object)("refundDate=" + e.getMessage()));
                return null;
            }
        }
        disRefundDomain.setRefundDate(refundDate);
        Object reasonCode = dataMap.get("reason_code");
        String reasonCodeId = null == reasonCode ? null : reasonCode.toString();
        disRefundDomain.setRefundEx(this.fetchRefundType(reasonCodeId));
        String reasonDesc = null == map.get("reason_desc") ? "" : map.get("reason_desc").toString();
        disRefundDomain.setRefundMeo(reasonDesc);
        disRefundDomain.setRefundUsertype("0");
        List listStr = (List)map.get("evidence");
        this.logger.error(this.SYS_CODE + ".makeRefund", (Object)("evidence=" + JsonUtil.buildNormalBinder().toJson((Object)listStr)));
        if (ListUtil.isNotEmpty((Collection)listStr)) {
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        String refundPrice = null == (refundAmount = dataMap.get("refund_offtake")) ? null : String.valueOf(refundAmount);
        List goodsList = (List)map.get("aftersale_items");
        if (ListUtil.isEmpty((Collection)goodsList)) {
            this.logger.error(this.SYS_CODE + ".makeRefund.data.aftersale_items is empty", (Object)map);
        }
        if (null != (refundAuditTime = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode())) && StringUtils.isNotBlank((String)refundAuditTime)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(refundAuditTime)));
        }
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        if (refundPrice != null) {
            BigDecimal refundMoney = new BigDecimal(refundPrice).divide(new BigDecimal("100"), 2, 4);
            disRefundDomain.setRefundMoney(refundMoney);
        }
        String aftersaleType = StringConvertUtil.valueOf(map.get("aftersale_type"));
        String refundType = null;
        refundType = "1".equals(aftersaleType) || "2".equals(aftersaleType) ? "B50" : ("0".equals(aftersaleType) ? "B51" : aftersaleType);
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodsList, disContractDomain, disRefundDomain, refundType, disChannel));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisContractDomain disContractDomain, DisRefundDomain disRefundDomain, String refundType, DisChannel disChannel) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)("disRefundDomain=" + disRefundDomain + ";disContractDomain=" + disContractDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            for (String key : map.keySet()) {
                BigDecimal refnum;
                disRefundDomain.setRefundType(refundType);
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.get(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
                if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                    refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                disRefundGoodsDomain.setGoodsClass(disChannel.getGoodsClass());
                disRefundGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
                disRefundGoodsDomain.setMemberMname(disChannel.getMemberMname());
                refundGoodsList.add(disRefundGoodsDomain);
                if (null == disContractGoodsDomain.getContractGoodsPrice()) continue;
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
            }
            if (null != disRefundDomain.getRefundMoney()) {
                disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
            }
        } else {
            BigDecimal addRefundNum = BigDecimal.ZERO;
            for (Map<String, Object> gmap : goodlist) {
                String productId = ((DisContractGoodsDomain)((DisPackageDomain)disContractDomain.getPackageList().get(0)).getContractGoodsList().get(0)).getSkuNo();
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.get(productId);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                disRefundGoodsDomain.setGoodsClass(disChannel.getGoodsClass());
                disRefundGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
                disRefundGoodsDomain.setMemberMname(disChannel.getMemberMname());
                Integer skuCount = null == gmap.get("qty") ? null : (Integer)gmap.get("qty");
                BigDecimal number = null == skuCount ? BigDecimal.ZERO : BigDecimal.valueOf(skuCount.intValue());
                Object o = gmap.get("pay_offtake");
                String payOfftake = null == o ? null : String.valueOf(o);
                BigDecimal totalRefund = null == payOfftake ? BigDecimal.ZERO : new BigDecimal(payOfftake).divide(new BigDecimal("100"), 2, 4);
                disRefundGoodsDomain.setRefundGoodsNum(number);
                disRefundGoodsDomain.setRefundGoodsPrice(totalRefund.divide(number, 2, 4));
                disRefundGoodsDomain.setRefundGoodsAmt(totalRefund);
                disRefundGoodsDomain.setRefundGoodsWeight(number);
                addRefundNum = addRefundNum.add(number);
                refundGoodsList.add(disRefundGoodsDomain);
            }
            BigDecimal refundNum = BigDecimal.ZERO;
            refundNum = refundNum.add(addRefundNum);
            List disRefundList = this.queryDisRefundByNbbillcode(disContractDomain.getChannelCode(), disContractDomain.getContractNbillcode(), disContractDomain.getTenantCode());
            if (ListUtil.isEmpty((Collection)disRefundList)) {
                disRefundDomain.setRefundType(refundType);
            } else {
                disRefundDomain.setRefundType(refundType);
                for (DisRefundReDomain disRefundReDomain : disRefundList) {
                    List ocRefundGoodsDomainList = disRefundReDomain.getOcRefundGoodsDomainList();
                    if (ListUtil.isEmpty((Collection)ocRefundGoodsDomainList)) {
                        return null;
                    }
                    for (DisRefundGoodsDomain disRefundGoods : ocRefundGoodsDomainList) {
                        refundNum = refundNum.add(disRefundGoods.getRefundGoodsNum());
                    }
                }
            }
            if (refundNum.compareTo(disContractDomain.getGoodsNum()) == 0) {
                disRefundDomain.setRefundType(refundType);
            }
        }
        return refundGoodsList;
    }

    private String fetchRefundType(String reasonCodeId) {
        if (StringUtils.isBlank((String)reasonCodeId)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "\u591a\u62cd / \u9519\u62cd / \u4e0d\u60f3\u8981");
        map.put("2", "\u672a\u6309\u7ea6\u5b9a\u65f6\u95f4\u53d1\u8d27");
        map.put("3", "\u5feb\u9012\u4e00\u76f4\u672a\u9001\u8fbe");
        map.put("4", "\u5feb\u9012\u65e0\u8ddf\u8e2a\u8bb0\u5f55");
        map.put("5", "\u6536\u5230\u5546\u54c1\u5c11\u4ef6 / \u9519\u4ef6 / \u7a7a\u5305\u88f9");
        map.put("6", "\u4e0d\u559c\u6b22 / \u6548\u679c\u4e0d\u597d");
        map.put("7", "\u505a\u5de5\u7c97\u7cd9 / \u6709\u7455\u75b5 / \u7834\u635f\u6216\u6c61\u6e0d");
        map.put("8", "\u529f\u80fd\u6545\u969c");
        map.put("9", "\u6548\u679c\u4e0e\u5546\u54c1\u63cf\u8ff0\u4e0d\u7b26");
        map.put("10", "\u5546\u54c1\u6750\u8d28 / \u54c1\u724c / \u5916\u89c2\u7b49\u63cf\u8ff0\u4e0d\u7b26");
        map.put("11", "\u751f\u4ea7\u65e5\u671f / \u4fdd\u8d28\u671f / \u89c4\u683c\u7b49\u63cf\u8ff0\u4e0d\u7b26");
        map.put("12", "\u5047\u5192\u54c1\u724c");
        map.put("13", "\u534f\u5546\u4e00\u81f4\u9000\u6b3e");
        map.put("14", "\u7f3a\u8d27");
        map.put("15", "\u5176\u4ed6");
        map.put("16", "\u5927\u5c0f\uff0f\u5c3a\u5bf8\uff0f\u91cd\u91cf\u4e0e\u5546\u54c1\u63cf\u8ff0\u4e0d\u7b26");
        map.put("17", "\u751f\u4ea7\u65e5\u671f\uff0f\u4fdd\u8d28\u671f\u4e0e\u5546\u54c1\u63cf\u8ff0\u4e0d\u7b26");
        map.put("18", "\u54c1\u79cd\uff0f\u89c4\u683c\uff0f\u6210\u5206\u7b49\u63cf\u8ff0\u4e0d\u7b26");
        map.put("19", "\u5546\u54c1\u8150\u70c2/\u53d8\u8d28");
        map.put("20", "\u5c11\u4ef6\uff0f\u6f0f\u53d1");
        map.put("21", "\u5305\u88c5\uff0f\u5546\u54c1\u7834\u635f");
        map.put("22", "\u5546\u5bb6\u53d1\u9519\u8d27");
        map.put("23", "\u4e0e\u5546\u5bb6\u534f\u5546\u4e00\u81f4\u9000\u6b3e");
        map.put("24", "\u9000\u8fd0\u8d39");
        map.put("25", "\u54c1\u79cd\uff0f\u4ea7\u54c1\uff0f\u89c4\u683c\uff0f\u6210\u5206\u7b49\u63cf\u8ff0\u4e0d\u7b26");
        map.put("26", "\u5546\u54c1\u8150\u70c2\uff0f\u53d8\u8d28\uff0f\u6b7b\u4ea1");
        map.put("27", "\u5546\u54c1\u53d8\u8d28\uff0f\u8fc7\u671f");
        map.put("28", "\u89c4\u683c\u7b49\u63cf\u8ff0\u4e0d\u7b26");
        map.put("29", "\u6536\u5230\u5546\u54c1\u5c11\u4ef6\uff0f\u9519\u4ef6\uff0f\u7a7a\u5305\u88f9");
        map.put("30", "\u76d7\u7248");
        map.put("31", "\u505a\u5de5\u7c97\u7cd9 / \u6709\u7455\u75b5 / \u6709\u6c61\u6e0d");
        map.put("32", "\u4ea7\u54c1\u7834\u635f / \u635f\u574f");
        map.put("33", "\u5546\u54c1\u6750\u8d28 / \u5916\u89c2\u7b49\u63cf\u8ff0\u4e0d\u7b26");
        map.put("34", "\u4f7f\u7528\u540e\u8fc7\u654f");
        map.put("35", "\u5546\u54c1\u91cd\u590d\u9500\u552e/\u7f3a\u8d27");
        map.put("36", "\u60f3\u66f4\u6362\u5176\u4ed6\u5546\u54c1");
        map.put("37", "\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u8d2d\u4e70");
        map.put("38", "\u5546\u54c1\u6210\u8272\u4e0e\u63cf\u8ff0\u4e0d\u7b26");
        map.put("39", "\u5546\u54c1\u7455\u75b5\u4e0e\u63cf\u8ff0\u4e0d\u7b26");
        map.put("40", "\u5546\u54c1\u5c3a\u5bf8\u4e0e\u63cf\u8ff0\u4e0d\u7b26");
        map.put("41", "\u5546\u54c1\u4e0e\u8ba2\u5355\u4fe1\u606f\u4e0d\u7b26");
        map.put("42", "\u5546\u54c1\u7f3a\u53d1\u914d\u4ef6/\u8d60\u54c1");
        map.put("43", "\u60f3\u8d2d\u4e70\u5176\u4ed6\u5546\u54c1");
        map.put("44", "\u5546\u54c1\u6750\u8d28 / \u7455\u75b5 / \u5c3a\u5bf8\u7b49\u4e0e\u63cf\u8ff0\u4e0d\u7b26");
        map.put("45", "\u5546\u54c1\u505a\u5de5\u7c97\u7cd9 / \u54c1\u8d28\u5dee");
        map.put("46", "\u5546\u54c1\u7834\u635f");
        map.put("47", "\u5546\u54c1\u6f0f\u53d1\u914d\u4ef6 / \u8d60\u54c1 / \u8bc1\u4e66");
        map.put("48", "\u672a\u6536\u5230\u5546\u54c1");
        map.put("49", "\u9884\u7ea6\u4e0d\u4e0a");
        map.put("50", "\u8054\u7cfb\u4e0d\u5230\u5546\u5bb6");
        map.put("51", "\u65e0\u6cd5\u6838\u9500");
        map.put("52", "\u8ba1\u5212\u6709\u53d8\uff0c\u65e0\u65f6\u95f4\u6d88\u8d39");
        map.put("53", "\u5546\u5bb6\u8981\u6c42\u7528\u5176\u4ed6\u65b9\u5f0f\u8fdb\u884c\u6d88\u8d39");
        map.put("54", "\u5151\u6362\u5730\u70b9\u592a\u8fdc");
        map.put("55", "\u7ebf\u4e0b\u66f4\u4f18\u60e0");
        map.put("56", "\u5546\u5bb6\u5e73\u53f0\u529f\u80fd\u4f53\u9a8c\u5dee");
        map.put("57", "\u8bfe\u7a0b\u8fdb\u5ea6/\u96be\u5ea6\u4e0d\u5408\u9002");
        map.put("58", "\u4e3b\u8bb2\u8001\u5e08\u80fd\u529b\u4e0d\u5339\u914d");
        map.put("59", "\u4e0d\u60f3\u7ee7\u7eed\u4e0a\u8bfe");
        map.put("60", "\u8d60\u54c1\u672a\u5bc4\u9001");
        map.put("61", "\u5546\u5bb6\u7ad9\u5916\u5bfc\u6d41");
        map.put("62", "\u5546\u5bb6\u8bc4\u4ef7\u4e0d\u597d");
        map.put("63", "\u5546\u5bb6\u5173\u5e97\u3001\u88c5\u4fee\u3001\u8f6c\u8ba9");
        map.put("64", "\u8054\u7cfb\u4e0d\u4e0a\u5546\u5bb6\uff0c\u6216\u5b9e\u5730\u5730\u5740\u65e0\u6b64\u5e97");
        map.put("65", "\u5e97\u91cc\u6d3b\u52a8\u66f4\u4f18\u60e0");
        map.put("66", "\u5546\u5bb6\u8981\u6c42\u7528\u5176\u4ed6\u65b9\u5f0f\u8fdb\u884c\u6d88\u8d39");
        map.put("67", "\u529f\u80fd/\u6548\u679c\u4e0e\u5546\u54c1\u63cf\u8ff0\u4e0d\u7b26");
        map.put("68", "\u5ba0\u7269\u98df\u7528\u4e0d\u9002");
        map.put("69", "\u5546\u54c1\u5c3a\u5bf8/\u5c3a\u7801/\u5927\u5c0f\u4e0e\u5b9e\u7269\u4e0d\u7b26");
        map.put("70", "\u5546\u54c1\u6750\u8d28\u9762\u6599\u4e0e\u5b9e\u7269\u63cf\u8ff0\u4e0d\u7b26");
        map.put("71", "\u5546\u54c1\u989c\u8272/\u56fe\u6848/\u6b3e\u5f0f\u4e0e\u5b9e\u7269\u4e0d\u7b26");
        map.put("72", "\u5916\u89c2/\u578b\u53f7/\u89c4\u683c/\u53c2\u6570\u4e0e\u5546\u54c1\u63cf\u8ff0\u4e0d\u7b26");
        map.put("73", "\u98df\u7528\u540e\u4e0d\u9002");
        map.put("74", "\u5546\u5bb6\u672a\u6309\u7ea6\u5b9a\u65f6\u95f4\u53d1\u8d27");
        map.put("75", "\u7cfb\u7edf\u7b7e\u6536\u5b9e\u7269\u672a\u6536\u5230");
        map.put("76", "\u7269\u6d41\u4fe1\u606f\u957f\u65f6\u95f4\u672a\u66f4\u65b0");
        map.put("77", "\u5546\u54c1/\u8d60\u54c1/\u914d\u4ef6/\u8bc1\u4e66\u6f0f\u53d1");
        map.put("78", "\u5546\u5bb6\u53d1\u9519\u8d27");
        return (String)map.get(reasonCodeId);
    }

    private String resultReturn(Integer code, String msg) {
        String result = "{\"code\":" + code + ",\"msg\":\"" + msg + "\"}";
        return result;
    }

    static {
        REFUND_TAGS.add("200");
        threadLocal = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        };
    }
}

