/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fxg.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class StringConvertUtil {
    public static String filterOffUtf8Mb4_2(String text) throws UnsupportedEncodingException {
        byte[] bytes = text.getBytes("utf-8");
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            short b = bytes[i];
            if (b > 0) {
                buffer.put(bytes[i++]);
                continue;
            }
            if (((b = (short)(b + 256)) >> 5 ^ 6) == 0) {
                buffer.put(bytes, i, 2);
                i += 2;
                continue;
            }
            if ((b >> 4 ^ 0xE) == 0) {
                buffer.put(bytes, i, 3);
                i += 3;
                continue;
            }
            if ((b >> 3 ^ 0x1E) == 0) {
                i += 4;
                continue;
            }
            if ((b >> 2 ^ 0xBE) == 0) {
                i += 5;
                continue;
            }
            i += 6;
        }
        buffer.flip();
        return new String(buffer.array(), "utf-8");
    }

    public static String filterUtf8mb4(String str) {
        int LAST_BMP = 65535;
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int codePoint = str.codePointAt(i);
            if (codePoint < 65535) {
                sb.appendCodePoint(codePoint);
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String valueOf(Object obj) {
        return "null".equals(String.valueOf(obj)) ? "" : String.valueOf(obj);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String testStr = "a\u4e2d\ud83d\udd11a\u4e2d\u5f97\ud83d\ude29\u5f97\u5f97\ud83d\ude29\";* N. |0 S: N* \\* ?\u6cb3\u6e90\u5e02\u6e90\u57ce\u533a\u65b0\u6c5f*\u8def\u5357*\u5df7\u4e1c**\u53f7\ud847\udfe8\u65b0\u6c5f\u5e02\u573a\u5185\u3009";
        System.out.println(testStr);
        System.out.println(StringConvertUtil.filterOffUtf8Mb4_2(testStr));
        System.out.println(StringConvertUtil.filterUtf8mb4(testStr));
    }
}

