/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fxg.oauth.service;

import com.doudian.open.core.AccessToken;
import com.doudian.open.core.AccessTokenBuilder;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOauthBaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.fxg.FxgConstants;
import com.yqbsoft.laser.service.ext.channel.fxg.domain.OauthBeanForFxg;
import com.yqbsoft.laser.service.ext.channel.fxg.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DisOauthServiceImpl
extends DisOauthBaseServiceImpl {
    private String SYS_CODE = "fxg.DisOauthServiceImpl";

    private String saveDisTokenForDy(DisChannel disChannel, OauthBeanForFxg oauthBean, String memberCode) {
        if (StringUtils.isBlank((String)memberCode) || null == disChannel || null == oauthBean) {
            this.logger.error(this.SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        String api = "dis.oauth.saveOauthToken";
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode(disChannel.getChannelCode());
        disOauthTokenDomain.setChannelName(disChannel.getChannelName());
        disOauthTokenDomain.setMemberCode(memberCode);
        disOauthTokenDomain.setMemberName(memberCode);
        disOauthTokenDomain.setOauthTokenExpireIn(oauthBean.getExpires_in());
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthBean.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthBean.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(disChannel.getTenantCode());
        paramMap.put("disOauthTokenDomain", JsonUtil.buildNormalBinder().toJson((Object)disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
        return "success";
    }

    public String sendGetToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.param");
            return "error";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userInfoCode", (String)param.get("memberCode"));
        paramMap.put("tenantCode", disChannel.getTenantCode());
        UmUserinfoDomain umUserinfo = (UmUserinfoDomain)this.readObj("um.user.getUserinfoByUserCode", paramMap, "object", new Object[]{UmUserinfoDomain.class});
        if (null == umUserinfo) {
            throw new RuntimeException();
        }
        AccessToken accessToken = AccessTokenBuilder.build((Long)Long.valueOf(umUserinfo.getUserinfoOcode()));
        if (!accessToken.isSuccess()) {
            System.out.println(JsonUtil.buildNormalBinder().toJson((Object)accessToken));
        }
        this.logger.error(this.SYS_CODE + ".sendGetToken.accessToken", (Object)("accessToken=" + JsonUtil.buildNormalBinder().toJson((Object)accessToken)));
        String token = JsonUtil.buildNormalBinder().toJson((Object)accessToken);
        Integer expiresIn = 1000;
        OauthBeanForFxg oa = new OauthBeanForFxg();
        oa.setAccess_token(token);
        oa.setExpires_in(expiresIn);
        oa.setRefresh_token(accessToken.getRefreshToken());
        String memberCode = (String)param.get("memberCode");
        return this.saveDisTokenForDy(disChannel, oa, memberCode);
    }

    public String sendReflashToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendReflashToken.param");
            return "error";
        }
        String token = (String)param.get("token");
        Integer expiresIn = (Integer)param.get("expiresIn");
        OauthBeanForFxg oa = new OauthBeanForFxg();
        oa.setAccess_token(token);
        oa.setExpires_in(expiresIn);
        oa.setRefresh_token("1000");
        String memberCode = (String)param.get("memberCode");
        return this.saveDisTokenForDy(disChannel, oa, memberCode);
    }

    public boolean befAppentParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, Object> param, Map<String, String> configMap) {
        return true;
    }

    public Map<String, Object> sendGetTokenParam(Map<String, Object> map) {
        String tokenJson = (String)map.get("token");
        JsonUtil.buildNormalBinder();
        Map jsonToMap = JsonUtil.getJsonToMap((String)tokenJson);
        String token = (String)jsonToMap.get("{token");
        map.put("token", token);
        String expiresIn = (String)jsonToMap.get("expires_in");
        map.put("expiresIn", expiresIn);
        return map;
    }

    protected String getChannelCode() {
        return FxgConstants.channelCode;
    }
}

