/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fxg.order.service;

import com.doudian.open.api.order_logisticsAddMultiPack.OrderLogisticsAddMultiPackRequest;
import com.doudian.open.api.order_logisticsAddMultiPack.OrderLogisticsAddMultiPackResponse;
import com.doudian.open.api.order_logisticsAddMultiPack.param.OrderLogisticsAddMultiPackParam;
import com.doudian.open.api.order_logisticsAddMultiPack.param.PackListItem;
import com.doudian.open.api.order_logisticsAddMultiPack.param.ShippedOrderInfoItem;
import com.doudian.open.api.order_orderDetail.OrderOrderDetailRequest;
import com.doudian.open.api.order_orderDetail.OrderOrderDetailResponse;
import com.doudian.open.api.order_orderDetail.data.OrderOrderDetailData;
import com.doudian.open.api.order_orderDetail.data.PostAddr;
import com.doudian.open.api.order_orderDetail.data.ShopOrderDetail;
import com.doudian.open.api.order_orderDetail.data.SkuOrderListItem;
import com.doudian.open.api.order_orderDetail.param.OrderOrderDetailParam;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.AccessTokenBuilder;
import com.doudian.open.core.GlobalConfig;
import com.doudian.open.exception.DoudianOpException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisRefundService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractproDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSku;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.fxg.FxgConstants;
import com.yqbsoft.laser.service.ext.channel.fxg.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.channel.fxg.order.service.DisRefundServiceImpl;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.StringConvertUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "fxg.DisOrderServiceImpl";
    private static ThreadLocal<DateFormat> threadLocal;
    @Autowired
    private DisRefundService disRefundService;

    protected String getChannelCode() {
        return FxgConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".buildComOrderParam.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
        this.logger.error(this.SYS_CODE + ".buildComOrderParam.sendParam", (Object)("sendParam=" + sendParam.toString()));
        this.logger.error(this.SYS_CODE + ".buildComOrderParam.configMap", (Object)("configMap=" + configMap.toString()));
        this.logger.error(this.SYS_CODE + ".buildComOrderParam.param", (Object)("param=" + param.toString()));
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".sendComOrder.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
        this.logger.error(this.SYS_CODE + ".sendComOrder.sendParam", (Object)("sendParam=" + sendParam.toString()));
        this.logger.error(this.SYS_CODE + ".sendComOrder.configMap", (Object)("configMap=" + configMap.toString()));
        this.logger.error(this.SYS_CODE + ".sendComOrder.param", (Object)("param=" + param.toString()));
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap)) {
            this.logger.error(this.SYS_CODE, (Object)"sendComOrder.disChannel or sendParam or configMap is null!");
            return "ERROR";
        }
        switch (channelApiCode) {
            case "cmc.disOrder.updateSendOrderDeling": {
                try {
                    String requestId = StringConvertUtil.valueOf(sendParam.get("shippedOrderId"));
                    String orderId = StringConvertUtil.valueOf(sendParam.get("orderId"));
                    if (StringUtils.isBlank((String)orderId)) {
                        DisContractDomain disContract = this.getContractByNbCode(disChannel.getTenantCode(), requestId, disChannel);
                        orderId = disContract.getContractObillcode();
                    }
                    Long shippedNum = null;
                    try {
                        shippedNum = Long.valueOf(StringConvertUtil.valueOf(sendParam.get("shippedNum")));
                    }
                    catch (NumberFormatException e) {
                        shippedNum = 0L;
                    }
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("userinfoCode", (String)sendParam.get("memberCcode"));
                    paramMap.put("tenantCode", disChannel.getTenantCode());
                    UmUserinfoDomain umUserinfo = (UmUserinfoDomain)this.getForObject("um.user.getUserinfoModelByUserCode", UmUserinfoDomain.class, paramMap);
                    if (null == umUserinfo) {
                        this.logger.error(this.SYS_CODE + ".sendComOrder.userInfo.null", (Object)((Object)paramMap).toString());
                        return this.resultReturn(-1, "success");
                    }
                    AccessToken accessToken = null;
                    accessToken = AccessTokenBuilder.build((Long)Long.valueOf(umUserinfo.getUserinfoOcode()));
                    if (null == accessToken) {
                        this.logger.error(this.SYS_CODE + ".sendComOrder.accessToken.null");
                        return this.resultReturn(-1, "success");
                    }
                    if (!accessToken.isSuccess()) {
                        this.logger.error(this.SYS_CODE + ".sendComOrder.accessToken.error");
                        return this.resultReturn(-1, "success");
                    }
                    OrderLogisticsAddMultiPackRequest request = new OrderLogisticsAddMultiPackRequest();
                    OrderLogisticsAddMultiPackParam requestParam = (OrderLogisticsAddMultiPackParam)request.getParam();
                    requestParam.setRequestId(requestId);
                    requestParam.setOrderId(orderId);
                    ShippedOrderInfoItem shippedOrderInfoItem = new ShippedOrderInfoItem();
                    shippedOrderInfoItem.setShippedOrderId(requestId);
                    shippedOrderInfoItem.setShippedNum(shippedNum);
                    PackListItem packListItem = new PackListItem();
                    packListItem.setShippedOrderInfo(Collections.singletonList(shippedOrderInfoItem));
                    String wms_companyCode = StringConvertUtil.valueOf(sendParam.get("companyCode"));
                    String field = disChannel.getTenantCode().concat("-").concat(wms_companyCode).concat("-").concat(wms_companyCode);
                    String dd_companyCode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                    if (StringUtils.isNotBlank((String)dd_companyCode)) {
                        wms_companyCode = dd_companyCode;
                    } else if ("YD".equals(wms_companyCode) || "YUNDA".equals(wms_companyCode)) {
                        wms_companyCode = "yunda";
                    }
                    packListItem.setCompanyCode(wms_companyCode);
                    packListItem.setLogisticsCode(StringConvertUtil.valueOf(sendParam.get("logisticsCode")));
                    requestParam.setPackList(Collections.singletonList(packListItem));
                    OrderLogisticsAddMultiPackResponse response = null;
                    try {
                        response = (OrderLogisticsAddMultiPackResponse)request.execute(accessToken);
                        if (null == response) {
                            this.logger.error(this.SYS_CODE + ".sendComOrder.OrderLogisticsAddMultiPackResponse.null", (Object)"shopOrderId= ");
                            return this.resultReturn(-1, "success");
                        }
                    }
                    catch (DoudianOpException e) {
                        throw new RuntimeException();
                    }
                    this.logger.error(this.SYS_CODE + ".sendComOrder.order.logisticsAddMultiPack.response", (Object)("request(" + requestId + ").response=" + JsonUtil.buildNormalBinder().toJson((Object)response)));
                    if (null != response.getErrNo() && response.getErrNo() == 0L) {
                        return "SUCCESS";
                    }
                    return response.getMessage();
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + "sendComOrder.error.contractNBillcode=" + sendParam.get("shippedOrderId"), (Object)"Exception=", (Throwable)e);
                    return "ERROR";
                }
            }
        }
        return "SUCCESS";
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    public static void main(String[] args) {
        AccessToken accessToken = AccessTokenBuilder.build((Long)Long.valueOf("749276"));
        if (!accessToken.isSuccess()) {
            System.out.println(JsonUtil.buildNormalBinder().toJson((Object)accessToken));
        }
        System.out.println(JsonUtil.buildNormalBinder().toJson((Object)accessToken));
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".saveOrderParam.param", (Object)("param=" + param.toString()));
        this.logger.error(this.SYS_CODE + ".saveOrderParam.sendParam", (Object)("sendParam=" + sendParam.toString()));
        String resStream = StringConvertUtil.filterUtf8mb4(StringConvertUtil.valueOf(param.get("resStream")));
        if (StringUtils.isBlank((String)resStream)) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.resStream", (Object)"resStream isnull");
            return this.resultReturn(0, "success");
        }
        List jsonToList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(resStream, Object.class);
        Map msgData = (Map)jsonToList.get(0);
        String tag = (String)msgData.get("tag");
        if (DisRefundServiceImpl.REFUND_TAGS.contains(tag) || "2".equals(tag.substring(0, 1))) {
            return this.disRefundService.saveSendRefundState(param);
        }
        if (StringUtils.equals((CharSequence)"100", (CharSequence)tag)) {
            return this.resultReturn(0, "success");
        }
        String s = "";
        Map dataMap = null;
        if (msgData.get("data") instanceof String) {
            s = (String)msgData.get("data");
            if (!DisOrderServiceImpl.getJSONType(s)) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.data", (Object)resStream);
                return this.resultReturn(0, "success");
            }
            dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(s, String.class, Object.class);
        } else {
            dataMap = (Map)msgData.get("data");
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.dataMap", (Object)resStream);
                return this.resultReturn(0, "success");
            }
        }
        if (null == dataMap.get("shop_id") || StringUtils.isBlank((String)dataMap.get("shop_id").toString())) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.shop_id", (Object)resStream);
            return this.resultReturn(-1, "success");
        }
        String shop_id = dataMap.get("shop_id").toString();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userInfoOcode", shop_id);
        paramMap.put("tenantCode", disChannel.getTenantCode());
        UmUserinfoDomain umUserinfo = (UmUserinfoDomain)this.readObj("um.userbase.getUserInfoByOcode", paramMap, "object", new Object[]{UmUserinfoDomain.class});
        if (null == umUserinfo) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.userInfo.null", (Object)("shop_id= " + shop_id + "tenantCode = " + disChannel.getTenantCode()));
            return this.resultReturn(-1, "success");
        }
        AccessToken accessToken = null;
        accessToken = AccessTokenBuilder.build((Long)Long.valueOf(shop_id));
        if (null == accessToken) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.accessToken", (Object)("channelCode= " + disChannel.getChannelCode() + "memberCode = " + umUserinfo.getUserinfoCode() + "tenantCode = " + disChannel.getTenantCode()));
            return this.resultReturn(-1, "success");
        }
        if (!accessToken.isSuccess()) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.accessToken.error", (Object)("channelCode= " + disChannel.getChannelCode() + "memberCode = " + umUserinfo.getUserinfoCode() + "tenantCode = " + disChannel.getTenantCode()));
            return this.resultReturn(-1, "success");
        }
        OrderOrderDetailRequest request = new OrderOrderDetailRequest();
        OrderOrderDetailParam requestParam = (OrderOrderDetailParam)request.getParam();
        requestParam.setShopOrderId(dataMap.get("p_id").toString());
        OrderOrderDetailResponse response = null;
        try {
            response = (OrderOrderDetailResponse)request.execute(accessToken);
        }
        catch (DoudianOpException e) {
            throw new RuntimeException();
        }
        if (null == response) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.OrderOrderDetailResponse.null", (Object)("shopOrderId= " + dataMap.get("p_id").toString()));
            return this.resultReturn(-1, "success");
        }
        ShopOrderDetail orderDetail = ((OrderOrderDetailData)response.getData()).getShopOrderDetail();
        String orderId = orderDetail.getOrderId();
        List<DisContractDomain> disContractDomainList = this.queryOrCreateDisContract(orderId, disChannel, orderDetail, umUserinfo);
        if (disContractDomainList == null) {
            return this.resultReturn(1, "\u8ba2\u5355\u83b7\u53d6\u6216\u521b\u5efa\u5931\u8d25 orderId=" + orderId);
        }
        boolean updateResult = this.updateOrderStatus(orderDetail, disContractDomainList, disChannel);
        if (!updateResult) {
            return this.resultReturn(1, "\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25 orderId=" + orderId);
        }
        return this.resultReturn(0, "success");
    }

    private static boolean getJSONType(String str) {
        boolean result = false;
        if (StringUtils.isNotBlank((String)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }

    private boolean updateOrderStatus(ShopOrderDetail orderDetail, List<DisContractDomain> disContractDomainList, DisChannel disChannel) {
        boolean result = true;
        List skuOrderList = orderDetail.getSkuOrderList();
        for (SkuOrderListItem skuOrder : skuOrderList) {
            String skuOrderId = skuOrder.getOrderId();
            String skuOrderStatus = StringConvertUtil.valueOf(skuOrder.getOrderStatus());
            for (DisContractDomain disContractDomain : disContractDomainList) {
                String oldDataStatestr = disContractDomain.getDataStatestr();
                if (!StringUtils.equals((CharSequence)skuOrderId, (CharSequence)disContractDomain.getContractNbillcode()) || Integer.valueOf(skuOrderStatus) <= Integer.valueOf(oldDataStatestr)) continue;
                try {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("dataStatestr", skuOrderStatus);
                    this.updateOrder(disChannel.getTenantCode(), skuOrderId, Integer.valueOf(skuOrderStatus), null, paramMap, disChannel);
                }
                catch (Exception e) {
                    result = false;
                }
            }
        }
        return result;
    }

    private List<DisContractDomain> queryOrCreateDisContract(String orderId, DisChannel disChannel, ShopOrderDetail orderDetail, UmUserinfoDomain umUserinfo) {
        List disContractDomainList;
        block3: {
            String msg = "";
            int step = 0;
            disContractDomainList = null;
            try {
                step = 0;
                QueryResult<DisContractDomain> queryResult = this.queryContractPage(orderId, disChannel.getChannelCode(), disChannel.getTenantCode());
                disContractDomainList = queryResult.getList();
                step = 1;
                if (!ListUtil.isEmpty((Collection)disContractDomainList)) break block3;
                disContractDomainList = this.createOrder(orderDetail, disChannel, umUserinfo);
                step = 2;
                if (ListUtil.isNotEmpty(disContractDomainList)) {
                    this.saveOrder(disContractDomainList, disChannel);
                    step = 3;
                    disContractDomainList = this.queryContractPage(orderId, disChannel.getChannelCode(), disChannel.getTenantCode()).getList();
                    break block3;
                }
                msg = "\u8ba2\u5355\u83b7\u53d6\u6216\u521b\u5efa\u5931\u8d25 orderId=" + orderId;
                this.logger.error(this.SYS_CODE + ".saveOrderParam.disContractDomain cannot be get or created.", (Object)("orderId=" + orderId));
                this.logger.error(this.SYS_CODE + ".saveOrderParam.error", (Object)(" return=" + this.resultReturn(2, msg)));
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return disContractDomainList;
    }

    private boolean checkDataValid(String data) {
        if (StringUtils.isBlank((String)data)) {
            return false;
        }
        Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)dataMap)) {
            return false;
        }
        Map orderDetailMap = (Map)dataMap.get("order_detail");
        return !MapUtil.isEmpty((Map)orderDetailMap);
    }

    private String tradeCreated() {
        this.logger.error(this.SYS_CODE + ".TRADE_CREATE.saveOrderParam.success", (Object)(" return=" + this.resultReturn(0, "\u8ba2\u5355\u521b\u5efa\u6d88\u606f\u6682\u4e0d\u5904\u7406,\u6536\u8d27\u5730\u5740\u53d8\u66f4\u95ee\u9898\u5904\u7406\u65b9\u6848")));
        return this.resultReturn(0, "\u8ba2\u5355\u521b\u5efa\u6d88\u606f\u6682\u4e0d\u5904\u7406,\u6536\u8d27\u5730\u5740\u53d8\u66f4\u95ee\u9898\u5904\u7406\u65b9\u6848");
    }

    private List<DisContractDomain> createOrder(ShopOrderDetail orderDetail, DisChannel disChannel, UmUserinfoDomain umUserinfo) {
        return this.makeOrder(orderDetail, disChannel, umUserinfo);
    }

    private List<DisContractDomain> makeOrder(ShopOrderDetail orderDetail, DisChannel disChannel, UmUserinfoDomain umUserinfo) {
        Long makeOrderStart = System.currentTimeMillis();
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        PostAddr postAddr = orderDetail.getPostAddr();
        String encryptDetail = postAddr.getEncryptDetail();
        encryptDetail = encryptDetail.replaceAll(" ", "+");
        String postReceiver = orderDetail.getPostReceiver();
        String encryptPostReceiver = orderDetail.getEncryptPostReceiver();
        encryptPostReceiver = encryptPostReceiver.replaceAll(" ", "+");
        String postTelphone = orderDetail.getPostTel();
        String encryptPostTelphone = orderDetail.getEncryptPostTel();
        encryptPostTelphone = encryptPostTelphone.replaceAll(" ", "+");
        this.logger.info("\u8be6\u7ec6\u5730\u5740\u5bf9\u8c61:" + JsonUtil.buildNormalBinder().toJson((Object)postAddr) + ",\u8131\u654f\u6536\u4ef6\u4eba:" + postReceiver);
        List skuOrderList = orderDetail.getSkuOrderList();
        if (ListUtil.isEmpty((Collection)skuOrderList)) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam.param.data.order_detail.sku_order_list is null", (Object)"\u5b50\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return disContractDomainList;
        }
        DisContractDomain disContractDomain = null;
        for (SkuOrderListItem skuOrder : skuOrderList) {
            disContractDomain = new DisContractDomain();
            this.setContractPro(disContractDomain, "encryptDetail", null, "\u52a0\u5bc6\u5730\u5740", encryptDetail);
            this.setContractPro(disContractDomain, "encryptPostReceiver", postReceiver, "\u52a0\u5bc6\u6536\u8d27\u4eba", encryptPostReceiver);
            this.setContractPro(disContractDomain, "encryptPostTelphone", postTelphone, "\u52a0\u5bc6\u624b\u673a\u53f7", encryptPostTelphone);
            disContractDomain.setGoodsReceiptArrdess(postAddr.getProvince().getName() + "," + postAddr.getCity().getName() + "," + postAddr.getTown().getName() + "," + postAddr.getStreet().getName() + postAddr.getDetail());
            disContractDomain.setGoodsReceiptMem(postReceiver);
            if (StringUtils.isNotBlank((String)postTelphone)) {
                if (postTelphone.contains(",")) {
                    disContractDomain.setGoodsReceiptPhone(postTelphone.replace(",", "\u8f6c"));
                } else {
                    disContractDomain.setGoodsReceiptPhone(postTelphone);
                }
            }
            disContractDomain.setChannelCode(disChannel.getChannelCode());
            disContractDomain.setChannelName(disChannel.getChannelName());
            disContractDomain.setMemberBcode(umUserinfo.getUserinfoCode());
            disContractDomain.setMemberBname(umUserinfo.getUserinfoCompname());
            disContractDomain.setTenantCode(disChannel.getTenantCode());
            String activeAt = StringConvertUtil.valueOf(skuOrder.getCreateTime());
            disContractDomain.setContractValidate(StringUtils.isNotBlank((String)activeAt) ? new Date(Long.valueOf(activeAt) * 1000L) : null);
            this.setContractPro(disContractDomain, "createTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.valueOf(activeAt) * 1000L)), "\u6296\u5e97\u8ba2\u5355\u4e0b\u5355\u65f6\u95f4");
            String confirmCookingTime = StringConvertUtil.valueOf(skuOrder.getShipTime());
            if (StringUtils.isNotBlank((String)confirmCookingTime) && !"0".equals(confirmCookingTime)) {
                disContractDomain.setGmtVaild(new Date(Long.valueOf(confirmCookingTime) * 1000L));
            } else {
                confirmCookingTime = StringConvertUtil.valueOf(skuOrder.getExpShipTime());
                if (StringUtils.isNotBlank((String)confirmCookingTime) && !"0".equals(confirmCookingTime)) {
                    disContractDomain.setGmtVaild(new Date(Long.valueOf(confirmCookingTime) * 1000L));
                }
            }
            disContractDomain.setFchannelCode(String.valueOf(skuOrder.getPayType()));
            if (null != skuOrder.getPayType()) {
                disContractDomain.setFaccountName(this.payType(skuOrder.getPayType().intValue()));
            }
            disContractDomain.setContractPumode("0");
            disContractDomain.setContractTypepro("00");
            disContractDomain.setContractType("50");
            disContractDomain.setContractPmode("0");
            if (null != skuOrder.getPayType() && 0L == skuOrder.getPayType()) {
                disContractDomain.setContractPmode("1");
            }
            disContractDomain.setContractNbillcode(skuOrder.getOrderId());
            disContractDomain.setContractObillcode(skuOrder.getParentOrderId());
            disContractDomain.setMemberCode(disChannel.getMemberCode());
            disContractDomain.setMemberName(disChannel.getMemberName());
            disContractDomain.setMemberCcode(disChannel.getMemberMcode());
            disContractDomain.setMemberCname(disChannel.getMemberMname());
            disContractDomain.setGoodsClass(disChannel.getGoodsClass());
            disContractDomain.setMemberMcode(disChannel.getMemberMcode());
            disContractDomain.setMemberMname(disChannel.getMemberMname());
            disContractDomain.setDataStatestr(StringConvertUtil.valueOf(skuOrder.getOrderStatus()));
            disContractDomain.setDataState(Integer.valueOf(skuOrder.getOrderStatus().intValue()));
            disContractDomain.setDataBmoney(BigDecimal.valueOf(skuOrder.getPayAmount()).divide(new BigDecimal(100), 2, 4));
            disContractDomain.setContractMoney(disContractDomain.getDataBmoney());
            disContractDomain.setContractInmoney(BigDecimal.valueOf(skuOrder.getPayAmount()).divide(new BigDecimal(100), 2, 4));
            disContractDomain.setGoodsPmoney(BigDecimal.valueOf(skuOrder.getPromotionAmount()).divide(new BigDecimal(100), 2, 4));
            BigDecimal sumskuNum = BigDecimal.ZERO;
            if (null != skuOrder.getItemNum()) {
                sumskuNum = sumskuNum.add(BigDecimal.valueOf(skuOrder.getItemNum()));
                disContractDomain.setGoodsNum(sumskuNum);
                disContractDomain.setDataBnum(sumskuNum);
            }
            disContractDomain.setContractProperty("0");
            if (null != skuOrder.getTradeType() && "1".equals(StringConvertUtil.valueOf(skuOrder.getTradeType()))) {
                disContractDomain.setContractProperty("1");
            }
            Long otherSetEnd = System.currentTimeMillis();
            this.logger.error(this.SYS_CODE + ".makeOrder.otherSetEnd.", (Object)("otherSetEnd=" + (otherSetEnd - makeOrderStart) + "ms"));
            List<DisPackageDomain> disPackageDomains = this.makeDisPackageDomain(skuOrder, disContractDomain, disChannel);
            if (ListUtil.isEmpty(disPackageDomains)) {
                this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.null", (Object)"\u5305\u88f9\u6216\u5546\u54c1\u4e3a\u7a7a");
                return new ArrayList<DisContractDomain>();
            }
            disContractDomain.setPackageList(disPackageDomains);
            Long makeOrderEnd = System.currentTimeMillis();
            this.logger.error(this.SYS_CODE + ".makeOrder.makeDisPackageDomain", (Object)("makeDisPackageDomain=" + (makeOrderEnd - otherSetEnd) + "ms"));
            String field = disChannel.getTenantCode().concat("-").concat("douyinInvCode").concat("-").concat("douyinInvCode");
            String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            if (StringUtils.isNotBlank((String)value)) {
                disContractDomain.setContractInvoice(value);
            }
            disContractDomainList.add(disContractDomain);
        }
        return disContractDomainList;
    }

    private List<DisPackageDomain> makeDisPackageDomain(SkuOrderListItem skuOrder, DisContractDomain disContractDomain, DisChannel disChannel) {
        ArrayList<DisPackageDomain> rePagList = new ArrayList<DisPackageDomain>();
        DisPackageDomain pag = new DisPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pag, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.e", (Throwable)e);
        }
        List<DisContractGoodsDomain> goodsList = this.makeDisContractGoodsDomain(skuOrder, pag, disContractDomain, disChannel);
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        pag.setContractGoodsList(goodsList);
        disContractDomain.setGoodsMoney(pag.getGoodsInmoney());
        disContractDomain.setGoodsNum(pag.getGoodsNum());
        disContractDomain.setDataBnum(pag.getGoodsNum());
        disContractDomain.setGoodsWeight(pag.getGoodsWeight());
        disContractDomain.setDataBweight(pag.getGoodsWeight());
        rePagList.add(pag);
        return rePagList;
    }

    private List<DisContractGoodsDomain> makeDisContractGoodsDomain(SkuOrderListItem skuOrder, DisPackageDomain disPackageDomain, DisContractDomain disContractDomain, DisChannel disChannel) {
        RsSku rsSku;
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        DisContractGoodsDomain disContractGoodsDomain = null;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        disContractGoodsDomain = new DisContractGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disPackageDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.e", (Throwable)e);
        }
        String productId = StringConvertUtil.valueOf(skuOrder.getProductId());
        String field = disChannel.getTenantCode().concat("-").concat("DOUYIN_GOODS_WHITE").concat("-").concat(productId);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isNotBlank((String)value)) {
            productId = StringConvertUtil.valueOf(skuOrder.getCode());
        }
        if (null != (rsSku = this.getSkuBySkuNo(productId, disContractDomain.getMemberCode(), disContractDomain.getMemberCcode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode()))) {
            disContractGoodsDomain.setSkuCode(rsSku.getSkuCode());
        }
        disContractGoodsDomain.setSkuNo(productId);
        disContractGoodsDomain.setSkuEocode(StringConvertUtil.valueOf(skuOrder.getSkuId()));
        disContractGoodsDomain.setGoodsEocode(productId);
        disContractGoodsDomain.setSkuName(StringConvertUtil.valueOf(skuOrder.getProductName()));
        disContractGoodsDomain.setGoodsName(StringConvertUtil.valueOf(skuOrder.getProductName()));
        disContractGoodsDomain.setGoodsClass(disChannel.getGoodsClass());
        disContractGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
        disContractGoodsDomain.setMemberMname(disChannel.getMemberMname());
        disContractGoodsDomain.setContractGoodsGtype("0");
        disContractGoodsDomain.setPricesetNprice(BigDecimal.valueOf(skuOrder.getOriginAmount()).divide(new BigDecimal(100), 2, 4));
        Long o = skuOrder.getPayAmount();
        String payOfftake = null == o ? null : String.valueOf(o);
        BigDecimal totalRefund = null == payOfftake ? BigDecimal.ZERO : new BigDecimal(payOfftake).divide(new BigDecimal("100"), 2, 4);
        BigDecimal goodsNum = BigDecimal.valueOf(skuOrder.getItemNum());
        disContractGoodsDomain.setContractGoodsPrice(totalRefund.divide(goodsNum, 2, 4));
        if (null == disContractGoodsDomain.getContractGoodsPrice() || disContractGoodsDomain.getContractGoodsPrice().compareTo(BigDecimal.ZERO) <= 0 && !"1".equals(disContractGoodsDomain.getContractGoodsGtype())) {
            disContractGoodsDomain.setContractGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        }
        disContractGoodsDomain.setGoodsCamount(goodsNum);
        disContractGoodsDomain.setGoodsNum(goodsNum);
        disContractGoodsDomain.setContractGoodsInmoney(disContractGoodsDomain.getPricesetNprice().multiply(goodsNum));
        disContractGoodsDomain.setContractGoodsMoney(disContractGoodsDomain.getContractGoodsPrice().multiply(goodsNum));
        if (null == disContractGoodsDomain.getGoodsNum()) {
            disContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        packageGoodsNum = packageGoodsNum.add(disContractGoodsDomain.getGoodsNum());
        if (null == disContractGoodsDomain.getContractGoodsInmoney()) {
            disContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
        }
        goodsInmoney = goodsInmoney.add(disContractGoodsDomain.getContractGoodsInmoney());
        if (null == disContractGoodsDomain.getContractGoodsMoney()) {
            disContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
        }
        goodsMoney = goodsMoney.add(disContractGoodsDomain.getContractGoodsMoney());
        if (null == disContractGoodsDomain.getContractGoodsPefinmoney()) {
            disContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
        }
        goodsPef = goodsPef.add(disContractGoodsDomain.getContractGoodsPefinmoney());
        if (null == disContractGoodsDomain.getGoodsWeight()) {
            disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        packageGoodsWeight = packageGoodsWeight.add(disContractGoodsDomain.getGoodsWeight());
        goodsDomainList.add(disContractGoodsDomain);
        disPackageDomain.setGoodsWeight(packageGoodsWeight);
        disPackageDomain.setGoodsNum(packageGoodsNum);
        disPackageDomain.setMemberBcode(disContractDomain.getMemberBcode());
        disPackageDomain.setMemberBname(disContractDomain.getMemberBname());
        disPackageDomain.setGoodsMoney(goodsInmoney);
        disPackageDomain.setPricesetRefrice(goodsPef);
        disPackageDomain.setGoodsPmoney(goodsMoney);
        disPackageDomain.setGoodsInmoney(goodsMoney);
        return goodsDomainList;
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName) {
        this.setContractPro(disContractDomain, contractproKey, contractproValue, contractproName, null);
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName, String contractproValue1) {
        if (null == disContractDomain || StringUtils.isBlank((String)contractproKey) || StringUtils.isBlank((String)contractproName)) {
            return;
        }
        DisContractproDomain contractproDomain = new DisContractproDomain();
        contractproDomain.setContractproKey(contractproKey);
        contractproDomain.setContractproValue(contractproValue);
        contractproDomain.setContractproName(contractproName);
        contractproDomain.setContractproValue1(contractproValue1);
        this.setContractPro(disContractDomain, contractproDomain);
    }

    private void setContractPro(DisContractDomain disContractDomain, DisContractproDomain disContractproDomain) {
        if (null == disContractDomain || null == disContractproDomain) {
            return;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = disContractDomain.getOcContractproDomainList();
        if (null == disContractproDomainList) {
            disContractproDomainList = new ArrayList<DisContractproDomain>();
            disContractDomain.setOcContractproDomainList(disContractproDomainList);
        }
        disContractproDomainList.add(disContractproDomain);
    }

    private String resultReturn(Integer code, String msg) {
        String result = "{\"code\":" + code + ",\"msg\":\"" + msg + "\"}";
        return result;
    }

    private String payType(Integer payType) {
        if (null == payType) {
            this.logger.error(this.SYS_CODE + ".payType", (Object)"param is null");
            return null;
        }
        String faccountName = "";
        switch (payType) {
            case 0: {
                faccountName = "\u8d27\u5230\u4ed8\u6b3e";
                break;
            }
            case 1: {
                faccountName = "\u5fae\u4fe1";
                break;
            }
            case 2: {
                faccountName = "\u652f\u4ed8\u5b9d";
                break;
            }
            default: {
                faccountName = "\u672a\u77e5";
            }
        }
        return faccountName;
    }

    private QueryResult<DisContractDomain> queryContractPage(String contractObillcode, String channelCode, String tenantCode) {
        if (!(StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractObillcode) || StringUtils.isBlank((String)channelCode))) {
            String apiCode = "dis.contract.queryContractPage";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("fuzzy", false);
            paramMap.put("contractObillcode", contractObillcode);
            paramMap.put("channelCode", channelCode);
            paramMap.put("tenantCode", tenantCode);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResult = this.getQueryResutl(apiCode, map, DisContractDomain.class);
            this.logger.error(this.SYS_CODE + ".queryContractPage.", (Object)("queryResult=" + JsonUtil.buildNormalBinder().toJson((Object)queryResult)));
            return queryResult;
        }
        return new QueryResult();
    }

    static {
        GlobalConfig.initAppKey((String)"7088509765772379655");
        GlobalConfig.initAppSecret((String)"50a7d94b-610b-414a-9b39-02687dab6e98");
        threadLocal = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
        };
    }
}

