/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fxg.order.service;

import com.doudian.open.api.afterSale_Detail.AfterSaleDetailRequest;
import com.doudian.open.api.afterSale_Detail.AfterSaleDetailResponse;
import com.doudian.open.api.afterSale_Detail.data.AfterSaleDetailData;
import com.doudian.open.api.afterSale_Detail.data.AfterSaleInfo;
import com.doudian.open.api.afterSale_Detail.data.Return;
import com.doudian.open.api.afterSale_Detail.data.SkuOrderInfosItem;
import com.doudian.open.api.afterSale_Detail.param.AfterSaleDetailParam;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.AccessTokenBuilder;
import com.doudian.open.exception.DoudianOpException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.fxg.FxgConstants;
import com.yqbsoft.laser.service.ext.channel.fxg.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.ApimFacadeUtil;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.StringConvertUtil;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.apim.DisRefundRequest;
import com.yqbsoft.laser.service.ext.channel.fxg.utils.apim.DisRefundResponse;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "fxg.DisRefundServiceImpl";
    public static final ArrayList<String> REFUND_TAGS = new ArrayList();
    private static ThreadLocal<DateFormat> threadLocal;

    protected String getChannelCode() {
        return FxgConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.sendParam", (Object)("sendParam=" + sendParam.toString()));
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.configMap", (Object)("configMap=" + configMap.toString()));
        this.logger.error(this.SYS_CODE + ".buildComRefundParam.param", (Object)("param=" + param.toString()));
        if ("cmc.disRefund.saveSendRefundAccept".equals(channelApiCode)) {
            sendParam = param;
        }
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        return sendParam;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    private String sendRequestToDoudianConnector(Map<String, String> configMap, DisRefundRequest request) {
        configMap.put("serviceUrl", configMap.get("host") + "/sc-fulfillment-douyin-api-proxy/v2/proxy/doudian");
        configMap.put("action", "afterSale.Operate");
        ApimFacadeUtil util = new ApimFacadeUtil(configMap);
        String token = util.fetchToken();
        try {
            DisRefundResponse response = (DisRefundResponse)util.execute(token, request);
            this.logger.error(this.SYS_CODE + ".sendComRefund.sendRequestToDoudianConnector.response", (Object)("aftersaleId=" + request.getItems().get(0).getAftersale_id() + ";response=" + JsonUtil.buildNormalBinder().toJson((Object)response)));
            return "ERROR";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.sendRequestToDoudianConnector.error", (Object)("aftersaleId=" + request.getItems().get(0).getAftersale_id() + ";Exception=" + e));
            e.printStackTrace();
            return "ERROR";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".sendComRefund.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
        this.logger.error(this.SYS_CODE + ".sendComRefund.sendParam", (Object)("sendParam=" + sendParam.toString()));
        this.logger.error(this.SYS_CODE + ".sendComRefund.configMap", (Object)("configMap=" + configMap.toString()));
        this.logger.error(this.SYS_CODE + ".sendComRefund.param", (Object)("param=" + param.toString()));
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap)) {
            this.logger.error(this.SYS_CODE, (Object)"sendComOrder.disChannel or sendParam or configMap is null!");
            return "ERROR";
        }
        if (!"cmc.disRefund.saveSendRefundAccept".equals(channelApiCode)) {
            return "SUCCESS";
        }
        try {
            DisRefundRequest request;
            ArrayList<DisRefundRequest.Aftersale> items;
            block20: {
                String dataState;
                String frequency;
                block21: {
                    frequency = StringConvertUtil.valueOf(sendParam.get("frequency"));
                    String aftersaleId = StringConvertUtil.valueOf(sendParam.get("refundCode"));
                    dataState = StringConvertUtil.valueOf(sendParam.get("dataState"));
                    if (StringUtils.isBlank((String)aftersaleId)) {
                        this.logger.error(this.SYS_CODE + ".sendComRefund.aftersaleId=" + aftersaleId, (Object)("channelApiCode=" + channelApiCode));
                        return "ERROR";
                    }
                    if (!StringUtils.equals((CharSequence)"1", (CharSequence)frequency) && !StringUtils.equals((CharSequence)"2", (CharSequence)frequency)) {
                        this.logger.error(this.SYS_CODE + ".sendComRefund.frequency=" + frequency, (Object)("channelApiCode=" + channelApiCode));
                        return "ERROR";
                    }
                    if (!StringUtils.equals((CharSequence)"0", (CharSequence)dataState) && !StringUtils.equals((CharSequence)"1", (CharSequence)dataState)) {
                        this.logger.error(this.SYS_CODE + ".sendComRefund.dataState=" + dataState, (Object)("channelApiCode=" + channelApiCode));
                        return "ERROR";
                    }
                    String afterSaleType = StringConvertUtil.valueOf(sendParam.get("afterSaleType"));
                    DisRefundRequest.Aftersale aftersale = new DisRefundRequest.Aftersale();
                    aftersale.setAftersale_id(aftersaleId);
                    if (StringUtils.equals((CharSequence)"B51", (CharSequence)afterSaleType) && StringUtils.equals((CharSequence)"0", (CharSequence)dataState) && "1".equals(frequency)) {
                        Long receiverAddressId = null;
                        try {
                            receiverAddressId = Long.valueOf(StringConvertUtil.valueOf(sendParam.get("receiverAddressId")));
                            DisRefundRequest.Logistics logistics = new DisRefundRequest.Logistics();
                            logistics.setReceiver_address_id(receiverAddressId);
                            aftersale.setLogistics(logistics);
                        }
                        catch (Exception e) {
                            this.logger.error(this.SYS_CODE + ".sendComRefund.receiverAddressId.error", (Object)("aftersaleId=" + sendParam.get("refundCode") + ";Exception=" + e));
                            e.printStackTrace();
                            return "ERROR";
                        }
                    }
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)dataState)) {
                        aftersale.setReason(sendParam.get("reason") == null ? "" : sendParam.get("reason").toString());
                        Long type = sendParam.get("type") == null ? null : Long.valueOf(Long.parseLong(sendParam.get("type").toString()));
                        String desc = sendParam.get("desc") == null ? "" : sendParam.get("desc").toString();
                        String url = sendParam.get("url") == null ? "" : sendParam.get("url").toString();
                        Map urlMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(url, String.class, String.class);
                        DisRefundRequest.Evidence evidence = null;
                        ArrayList<DisRefundRequest.Evidence> evidenceList = new ArrayList<DisRefundRequest.Evidence>();
                        if (MapUtil.isNotEmpty((Map)urlMap)) {
                            Set entrySet = urlMap.entrySet();
                            for (Map.Entry entry : entrySet) {
                                evidence = new DisRefundRequest.Evidence();
                                evidence.setType(type);
                                evidence.setUrl((String)entry.getValue());
                                evidence.setDesc(desc);
                                evidenceList.add(evidence);
                            }
                        } else {
                            evidence = new DisRefundRequest.Evidence();
                            evidence.setType(type);
                            evidence.setUrl("");
                            evidence.setDesc(desc);
                            evidenceList.add(evidence);
                        }
                        aftersale.setEvidence(evidenceList);
                    }
                    items = new ArrayList<DisRefundRequest.Aftersale>();
                    items.add(aftersale);
                    request = new DisRefundRequest();
                    if (!"1".equals(frequency)) break block21;
                    if (StringUtils.equals((CharSequence)"B50", (CharSequence)afterSaleType)) {
                        String orderState = StringConvertUtil.valueOf(sendParam.get("orderState"));
                        if (!StringUtils.equals((CharSequence)"2", (CharSequence)orderState)) {
                            request.setType(202L);
                            break block20;
                        } else {
                            request.setType(401L);
                        }
                        break block20;
                    } else {
                        if (!StringUtils.equals((CharSequence)"B51", (CharSequence)afterSaleType)) {
                            this.logger.error(this.SYS_CODE + ".sendComRefund.afterSaleType=" + afterSaleType, (Object)("aftersaleId=" + sendParam.get("refundCode")));
                            return "ERROR";
                        }
                        request.setType(StringUtils.equals((CharSequence)"0", (CharSequence)dataState) ? 101L : 102L);
                    }
                    break block20;
                }
                if (!"2".equals(frequency)) {
                    return "ERROR";
                }
                request.setType(StringUtils.equals((CharSequence)"0", (CharSequence)dataState) ? 111L : 112L);
            }
            request.setItems(items);
            return this.sendRequestToDoudianConnector(configMap, request);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.error", (Object)("aftersaleId=" + sendParam.get("refundCode") + ";Exception=" + e));
            e.printStackTrace();
            return "ERROR";
        }
    }

    private static boolean getJSONType(String str) {
        boolean result = false;
        if (StringUtils.isNotBlank((String)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        DisRefundDomain disRefundDomain;
        String msg;
        String afterSaleStatus;
        AfterSaleDetailData afterSaleDetailData;
        HashMap<String, String> paramMap;
        String tag;
        block19: {
            this.logger.error(this.SYS_CODE + ".saveRefundParam.>>>>>>>>>>>>>", (Object)"start>>>>>>>>>>>>>");
            this.logger.error(this.SYS_CODE + ".saveRefundParam.param", (Object)("param=" + param.toString()));
            this.logger.error(this.SYS_CODE + ".saveRefundParam.sendParam", (Object)("sendParam=" + sendParam.toString()));
            String resStream = StringConvertUtil.filterUtf8mb4(StringConvertUtil.valueOf(param.get("resStream")));
            if (StringUtils.isBlank((String)resStream)) {
                this.logger.error(this.SYS_CODE + ".saveRefundParam.resStream", (Object)"resStream isnull");
                return this.resultReturn(0, "success");
            }
            List jsonToList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(resStream, Object.class);
            Map msgData = (Map)jsonToList.get(0);
            tag = (String)msgData.get("tag");
            String s = "";
            Map dataMap = null;
            if (msgData.get("data") instanceof String) {
                s = (String)msgData.get("data");
                if (!DisRefundServiceImpl.getJSONType(s)) {
                    this.logger.error(this.SYS_CODE + ".saveRefundParam.data", (Object)resStream);
                    return this.resultReturn(0, "success");
                }
                dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(s, String.class, Object.class);
            } else {
                dataMap = (Map)msgData.get("data");
                if (MapUtil.isEmpty((Map)dataMap)) {
                    this.logger.error(this.SYS_CODE + ".saveRefundParam.dataMap", (Object)resStream);
                    return this.resultReturn(0, "success");
                }
            }
            if (null == dataMap.get("shop_id") || StringUtils.isBlank((String)dataMap.get("shop_id").toString())) {
                this.logger.error(this.SYS_CODE + ".saveRefundParam.shop_id", (Object)resStream);
                return this.resultReturn(-1, "success");
            }
            String shop_id = dataMap.get("shop_id").toString();
            paramMap = new HashMap<String, String>();
            paramMap.put("userInfoOcode", shop_id);
            paramMap.put("tenantCode", disChannel.getTenantCode());
            UmUserinfoDomain umUserinfo = (UmUserinfoDomain)this.readObj("um.userbase.getUserInfoByOcode", paramMap, "object", new Object[]{UmUserinfoDomain.class});
            if (null == umUserinfo) {
                this.logger.error(this.SYS_CODE + ".saveRefundParam.userInfo.null", (Object)("shop_id= " + shop_id + "tenantCode = " + disChannel.getTenantCode()));
                return this.resultReturn(-1, "success");
            }
            AccessToken accessToken = null;
            accessToken = AccessTokenBuilder.build((Long)Long.valueOf(shop_id));
            if (null == accessToken) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.accessToken", (Object)("channelCode= " + disChannel.getChannelCode() + "memberCode = " + umUserinfo.getUserinfoCode() + "tenantCode = " + disChannel.getTenantCode()));
                return this.resultReturn(-1, "success");
            }
            if (!accessToken.isSuccess()) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.accessToken.error", (Object)("channelCode= " + disChannel.getChannelCode() + "memberCode = " + umUserinfo.getUserinfoCode() + "tenantCode = " + disChannel.getTenantCode()));
                return this.resultReturn(-1, "success");
            }
            AfterSaleDetailRequest request = new AfterSaleDetailRequest();
            AfterSaleDetailParam requestParam = (AfterSaleDetailParam)request.getParam();
            requestParam.setAfterSaleId(dataMap.get("aftersale_id").toString());
            AfterSaleDetailResponse response = null;
            try {
                response = (AfterSaleDetailResponse)request.execute(accessToken);
                if (null == response) {
                    this.logger.error(this.SYS_CODE + ".saveRefundParam.AfterSaleDetailResponse.null", (Object)("afterSaleId= " + dataMap.get("aftersale_id").toString()));
                    return this.resultReturn(-1, "success");
                }
            }
            catch (DoudianOpException e) {
                throw new RuntimeException();
            }
            afterSaleDetailData = (AfterSaleDetailData)response.getData();
            String afterSaleId = afterSaleDetailData.getProcessInfo().getAfterSaleInfo().getAfterSaleId().toString();
            afterSaleStatus = afterSaleDetailData.getProcessInfo().getAfterSaleInfo().getAfterSaleStatus().toString();
            msg = "";
            disRefundDomain = null;
            int step = 0;
            try {
                disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), afterSaleId, disChannel);
                step = 1;
                if (null != disRefundDomain) break block19;
                disRefundDomain = this.createRefund(disChannel, afterSaleDetailData);
                step = 2;
                if (null != disRefundDomain) {
                    this.saveRefund(Collections.singletonList(disRefundDomain), disChannel);
                    step = 3;
                    disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), afterSaleId, disChannel);
                    break block19;
                }
                msg = "\u552e\u540e\u5355\u83b7\u53d6\u6216\u521b\u5efa\u5931\u8d25 afterSaleId=" + afterSaleId;
                this.logger.error(this.SYS_CODE + ".saveRefundParam.disRefundDomain cannot be get or created.", (Object)("afterSaleId=" + afterSaleId));
                return this.resultReturn(-1, msg);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".saveRefundParam.step" + step + ".error", (Object)("afterSaleId=" + afterSaleId + "return=" + this.resultReturn(2, msg)));
                e.printStackTrace();
                return this.resultReturn(-1, e.getMessage());
            }
        }
        if (!StringUtils.equals((CharSequence)tag, (CharSequence)"200")) {
            if (StringUtils.equals((CharSequence)tag, (CharSequence)"203")) {
                Return aReturn = afterSaleDetailData.getProcessInfo().getLogisticsInfo().get_return();
                paramMap.put("packageBillno", aReturn.getTrackingNo());
                paramMap.put("packageMode", aReturn.getCompanyCode());
                paramMap.put("packageName", aReturn.getCompanyName());
            }
            paramMap.put("dataStatestr", afterSaleStatus);
            String refundCode = disRefundDomain.getRefundCode();
            try {
                this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), refundCode, disChannel.getChannelCode(), Integer.parseInt(afterSaleStatus), disRefundDomain.getDataState(), paramMap);
            }
            catch (Exception e) {
                msg = "\u552e\u540e\u5355\u66f4\u65b0\u5931\u8d25";
                this.logger.error(this.SYS_CODE + ".saveRefundParam.sendUpdateRefundStateByCode.error.", (Object)("refundCode=" + refundCode));
                e.printStackTrace();
                return this.resultReturn(-1, msg);
            }
        }
        return this.resultReturn(0, "success");
    }

    private DisRefundDomain createRefund(DisChannel disChannel, AfterSaleDetailData afterSaleDetailData) {
        return this.makeRefund(disChannel, afterSaleDetailData);
    }

    private DisRefundDomain makeRefund(DisChannel disChannel, AfterSaleDetailData afterSaleDetailData) {
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(disChannel.getTenantCode());
        disRefundDomain.setMemberCcode(disChannel.getMemberMcode());
        disRefundDomain.setMemberCname(disChannel.getMemberMname());
        disRefundDomain.setGoodsClass(disChannel.getGoodsClass());
        disRefundDomain.setMemberMcode(disChannel.getMemberMcode());
        disRefundDomain.setMemberMname(disChannel.getMemberMname());
        String shopOrderId = afterSaleDetailData.getOrderInfo().getShopOrderId().toString();
        DisContractDomain disContractDomain = null;
        try {
            disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), shopOrderId, disChannel);
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain1", (Object)shopOrderId);
                return null;
            }
            disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode());
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain2", (Object)shopOrderId);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain.error", (Object)shopOrderId);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.error", (Object)("copyAllPropertys=" + e.getMessage()));
            return null;
        }
        AfterSaleInfo afterSaleInfo = afterSaleDetailData.getProcessInfo().getAfterSaleInfo();
        disRefundDomain.setContractNbillcode(shopOrderId);
        disRefundDomain.setRefundOcode(afterSaleInfo.getAfterSaleId().toString());
        disRefundDomain.setDataStatestr(afterSaleInfo.getAfterSaleStatus().toString());
        disRefundDomain.setContractPumode(afterSaleInfo.getAfterSaleType().toString());
        disRefundDomain.setDataState(Integer.valueOf(disRefundDomain.getDataStatestr()));
        disRefundDomain.setRefundDate(new Date(Long.valueOf(afterSaleInfo.getApplyTime().toString() + "000")));
        disRefundDomain.setRefundCreate(disRefundDomain.getRefundDate());
        disRefundDomain.setRefundEx(afterSaleInfo.getReason());
        disRefundDomain.setRefundMeo(afterSaleInfo.getReasonRemark());
        disRefundDomain.setRefundUsertype("0");
        List listStr = afterSaleInfo.getEvidence();
        this.logger.error(this.SYS_CODE + ".makeRefund", (Object)("evidence=" + JsonUtil.buildNormalBinder().toJson((Object)listStr)));
        if (ListUtil.isNotEmpty((Collection)listStr)) {
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        BigDecimal refundMoney = new BigDecimal(afterSaleInfo.getRealRefundAmount()).divide(new BigDecimal("100"), 2, 4);
        disRefundDomain.setRefundMoney(refundMoney);
        String aftersaleType = afterSaleInfo.getAfterSaleType().toString();
        String refundType = null;
        refundType = "1".equals(aftersaleType) || "2".equals(aftersaleType) ? "B50" : ("0".equals(aftersaleType) ? "B51" : aftersaleType);
        List skuOrderInfos = afterSaleDetailData.getOrderInfo().getSkuOrderInfos();
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(skuOrderInfos, disContractDomain, disRefundDomain, refundType, disChannel));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<SkuOrderInfosItem> skuOrderInfos, DisContractDomain disContractDomain, DisRefundDomain disRefundDomain, String refundType, DisChannel disChannel) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)("disRefundDomain=" + disRefundDomain + ";disContractDomain=" + disContractDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(skuOrderInfos)) {
            for (String key : map.keySet()) {
                BigDecimal refnum;
                disRefundDomain.setRefundType(refundType);
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.get(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
                if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                    refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                disRefundGoodsDomain.setGoodsClass(disChannel.getGoodsClass());
                disRefundGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
                disRefundGoodsDomain.setMemberMname(disChannel.getMemberMname());
                refundGoodsList.add(disRefundGoodsDomain);
                if (null == disContractGoodsDomain.getContractGoodsPrice()) continue;
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
            }
            if (null != disRefundDomain.getRefundMoney()) {
                disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
            }
        } else {
            BigDecimal addRefundNum = BigDecimal.ZERO;
            for (SkuOrderInfosItem skuOrderInfosItem : skuOrderInfos) {
                String productId = String.valueOf(skuOrderInfosItem.getProductId());
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.get(productId);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                disRefundGoodsDomain.setGoodsClass(disChannel.getGoodsClass());
                disRefundGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
                disRefundGoodsDomain.setMemberMname(disChannel.getMemberMname());
                BigDecimal number = BigDecimal.valueOf(skuOrderInfosItem.getItemQuantity());
                BigDecimal totalRefund = new BigDecimal(skuOrderInfosItem.getPayAmount()).divide(new BigDecimal("100"), 2, 4);
                disRefundGoodsDomain.setRefundGoodsNum(number);
                disRefundGoodsDomain.setRefundGoodsPrice(totalRefund.divide(number, 2, 4));
                disRefundGoodsDomain.setRefundGoodsAmt(totalRefund);
                disRefundGoodsDomain.setRefundGoodsWeight(number);
                addRefundNum = addRefundNum.add(number);
                refundGoodsList.add(disRefundGoodsDomain);
            }
            BigDecimal refundNum = BigDecimal.ZERO;
            refundNum = refundNum.add(addRefundNum);
            List disRefundList = this.queryDisRefundByNbbillcode(disContractDomain.getChannelCode(), disContractDomain.getContractNbillcode(), disContractDomain.getTenantCode());
            if (ListUtil.isEmpty((Collection)disRefundList)) {
                disRefundDomain.setRefundType(refundType);
            } else {
                disRefundDomain.setRefundType(refundType);
                for (DisRefundReDomain disRefundReDomain : disRefundList) {
                    List ocRefundGoodsDomainList = disRefundReDomain.getOcRefundGoodsDomainList();
                    if (ListUtil.isEmpty((Collection)ocRefundGoodsDomainList)) {
                        return null;
                    }
                    for (DisRefundGoodsDomain disRefundGoods : ocRefundGoodsDomainList) {
                        refundNum = refundNum.add(disRefundGoods.getRefundGoodsNum());
                    }
                }
            }
            if (refundNum.compareTo(disContractDomain.getGoodsNum()) == 0) {
                disRefundDomain.setRefundType(refundType);
            }
        }
        return refundGoodsList;
    }

    private String resultReturn(Integer code, String msg) {
        String result = "{\"code\":" + code + ",\"msg\":\"" + msg + "\"}";
        return result;
    }

    static {
        REFUND_TAGS.add("200");
        threadLocal = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        };
    }
}

