/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.fxg.utils;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.facade.SupperFacade;
import com.yqbsoft.laser.service.ext.channel.discom.request.SupperRequest;
import com.yqbsoft.laser.service.ext.channel.discom.response.SupperResponse;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class Apimfacade
extends SupperFacade {
    private static String SYS_CODE = "Httpfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(Apimfacade.class);
    private String accessToken = "";
    private String action = "";

    public Apimfacade(String host, String appkey, String secret) {
        super(host, appkey, secret);
    }

    public Apimfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public Apimfacade(String host) {
        super(host);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String apimRequestReJson(String url, Map<String, String> params, Map<String, Object> bodyParams, String secret, String Key, String appKey) {
        logger.error(SYS_CODE + ".apimRequestReJson.param", (Object)("secret==" + secret + "Key==" + Key + "appKey==" + appKey + "url==" + url));
        if (bodyParams.containsKey("method")) {
            bodyParams.remove("method");
        }
        if (MapUtil.isEmpty(params)) {
            params.put("api_key", Key);
            params.put("nonce_str", "111");
            params.put("timestamp", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        }
        String requestBody = JsonUtil.buildNonDefaultBinder().toJson(bodyParams);
        params.put("body", requestBody);
        params.put("secret", secret);
        String sign = this.sign(params);
        params.remove("secret");
        params.remove("body");
        params.put("sign", sign);
        logger.error(SYS_CODE + ".apimRequestReJson.bodyParams", (Object)JsonUtil.buildNonNullBinder().toJson(bodyParams));
        url = url + "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            url = url + entry.getKey() + "=" + URLEncoder.encode(entry.getValue()) + "&";
        }
        url = url.substring(0, url.length() - 1);
        logger.error(SYS_CODE + ".apim.url", (Object)("URL: " + url));
        HttpPost post = new HttpPost(url);
        post.addHeader("Ocp-Apim-Subscription-Key", appKey);
        post.addHeader("Content-Type", "application/json");
        if (StringUtils.isNotBlank((String)this.accessToken)) {
            post.addHeader("access_token", this.accessToken);
        }
        try (CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(Apimfacade.getSSLContext()).build();){
            post.setEntity((HttpEntity)new ByteArrayEntity(requestBody.getBytes(StandardCharsets.UTF_8)));
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity httpEntity = response.getEntity();
            StatusLine statusLine = response.getStatusLine();
            String body = EntityUtils.toString((HttpEntity)httpEntity);
            response.close();
            logger.error(SYS_CODE, (Object)String.format("code: %s, body: %s", statusLine.getStatusCode(), body));
            if (statusLine.getStatusCode() == 200) {
                String string2 = body;
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String apimRequestReJsonV2(String url, Map<String, String> params, Map<String, Object> bodyParams, String secret, String Key, String appKey) {
        logger.error(SYS_CODE + ".apimRequestReJson.param", (Object)("secret==" + secret + "Key==" + Key + "appKey==" + appKey + "url==" + url));
        if (bodyParams.containsKey("method")) {
            bodyParams.remove("method");
        }
        if (MapUtil.isEmpty(params)) {
            params.put("method", this.action);
            params.put("api_key", Key);
            params.put("nonce_str", "222");
            params.put("timestamp", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        }
        String requestBody = JsonUtil.buildNonDefaultBinder().toJson(bodyParams);
        params.put("body", requestBody);
        params.put("secret", secret);
        String sign = this.sign(params);
        params.remove("secret");
        params.remove("body");
        params.put("sign", sign);
        logger.error(SYS_CODE + ".apimRequestReJson.bodyParams", (Object)JsonUtil.buildNonNullBinder().toJson(bodyParams));
        url = url + "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            url = url + entry.getKey() + "=" + URLEncoder.encode(entry.getValue()) + "&";
        }
        url = url.substring(0, url.length() - 1);
        logger.error(SYS_CODE + ".apim.url", (Object)("URL: " + url));
        HttpPost post = new HttpPost(url);
        post.addHeader("Ocp-Apim-Subscription-Key", appKey);
        post.addHeader("Content-Type", "application/json");
        if (StringUtils.isNotBlank((String)this.accessToken)) {
            post.addHeader("access_token", this.accessToken);
        }
        try (CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(Apimfacade.getSSLContext()).build();){
            post.setEntity((HttpEntity)new ByteArrayEntity(requestBody.getBytes(StandardCharsets.UTF_8)));
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity httpEntity = response.getEntity();
            StatusLine statusLine = response.getStatusLine();
            String body = EntityUtils.toString((HttpEntity)httpEntity);
            response.close();
            logger.error(SYS_CODE, (Object)String.format("code: %s, body: %s", statusLine.getStatusCode(), body));
            String string = body;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String json = null;
        json = supperRequest.getTextParams().containsKey("method") && supperRequest.getTextParams().get("method").equals("GET") ? this.apimRequestReJsonByGet(this.getHost(), supperRequest.getHeaderMap(), supperRequest.getTextParams(), this.getSecret(), this.getAppkey(), this.getSigntype()) : this.apimRequestReJson(this.getHost(), supperRequest.getHeaderMap(), supperRequest.getTextParams(), this.getSecret(), this.getAppkey(), this.getSigntype());
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException((Throwable)xe);
        }
        System.out.println(json);
        localResponse.setBody(json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    private static SSLContext getSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String apimRequestReJsonByGet(String url, Map<String, String> params, Map<String, Object> bodyParams, String secret, String Key, String subKey) {
        if (bodyParams.containsKey("method")) {
            bodyParams.remove("method");
        }
        bodyParams.put("api_key", Key);
        bodyParams.put("nonce_str", "111");
        bodyParams.put("timestamp", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        bodyParams.put("secret", secret);
        Map stringObjectMap = MapUtil.castMap(bodyParams);
        String sign = this.sign(stringObjectMap);
        bodyParams.remove("secret");
        bodyParams.put("sign", sign);
        System.out.println(bodyParams + url);
        url = url + "?";
        for (Map.Entry<String, Object> entry : bodyParams.entrySet()) {
            url = url + entry.getKey() + "=" + URLEncoder.encode(String.valueOf(entry.getValue())) + "&";
        }
        url = url.substring(0, url.length() - 1);
        logger.error(SYS_CODE + ".apim.url", (Object)("URL: " + url));
        HttpGet get = new HttpGet(url);
        get.addHeader("Ocp-Apim-Subscription-Key", subKey);
        get.addHeader("Content-Type", "application/json");
        try (CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(Apimfacade.getSSLContext()).build();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity httpEntity = response.getEntity();
            StatusLine statusLine = response.getStatusLine();
            String body = EntityUtils.toString((HttpEntity)httpEntity);
            response.close();
            logger.error(SYS_CODE, (Object)String.format("code: %s, body: %s", statusLine.getStatusCode(), body));
            if (statusLine.getStatusCode() == 200) {
                String string2 = body;
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String sign(Map<String, String> param) {
        String secret = param.get("secret");
        param.remove("secret");
        ArrayList<String> paramList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : param.entrySet()) {
            paramList.add(entry.getKey() + "=" + entry.getValue());
        }
        Collections.sort(paramList);
        StringBuilder sb = new StringBuilder();
        sb.append(secret);
        for (String paramStr : paramList) {
            sb.append(paramStr);
            sb.append("&");
        }
        sb.replace(sb.length() - 1, sb.length(), secret);
        Object var5_7 = null;
        byte[] bytes = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            bytes = messageDigest.digest(sb.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Hex.encodeHexString(bytes).toUpperCase();
    }
}

