/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRlRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBankBaseService;
import com.yqbsoft.laser.service.ext.channel.haihang.HaihangConstants;
import com.yqbsoft.laser.service.ext.channel.haihang.util.HttpClientUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;

public class ChannelBankServiceImpl
extends ChannelBankBaseService {
    public static final String SYS_CODE = "cmc.ChannelBankServiceImpl";
    private static String bankList = "/v1/agent/bank/list/";
    private static String bankSubList = "/v1/agent/bankSub/list/";
    private static String bankinfoList = "/v1/agent/pay/bankinfo/list";
    private static String queryBankList = "cmc.channelBank.queryBankList";
    private static String queryBankSubList = "cmc.channelBank.queryBankSubList";
    private static String bankinfoListApi = "cmc.channelBank.bankinfoList";

    protected Object retrunParam(ChannelRlRequest channelRequest, Map<String, Object> map) {
        this.logger.error("cmc.ChannelBankServiceImpl.retrunParam.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        this.logger.error("cmc.ChannelBankServiceImpl.retrunParam.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (StringUtils.isBlank((String)channelRequest.getCmFchannelApi().getAppapiCode()) || StringUtils.isBlank((String)channelRequest.getChannelApiCode())) {
            throw new ApiException("cmc.ChannelBankServiceImpl.send.apicode", channelRequest.getCmFchannelApi().getFchannelApiCode());
        }
        if (queryBankList.equals(channelRequest.getChannelApiCode())) {
            return this.queryBankList(channelRequest, map);
        }
        if (queryBankSubList.equals(channelRequest.getChannelApiCode())) {
            return this.queryBankSubList(channelRequest, map);
        }
        if (bankinfoListApi.equals(channelRequest.getChannelApiCode())) {
            return this.bankinfoList(channelRequest, map);
        }
        return null;
    }

    public String getFchannelCode() {
        return HaihangConstants.CHANNEL_CODE;
    }

    protected ChannelRlRequest send(ChannelRlRequest channelRequest, Map<String, Object> param) {
        this.logger.error("cmc.ChannelBankServiceImpl.send", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        return channelRequest;
    }

    public String post(String url, Map<String, Object> map, String secretKey, String accesskey, String path) {
        String response = HttpClientUtil.post(url, map, secretKey, accesskey, path);
        this.logger.error("cmc.ChannelBankServiceImpl.post.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response;
    }

    public String get(String url, String secretKey, String accesskey, String path) {
        String response = HttpClientUtil.get(url, secretKey, accesskey, path);
        this.logger.error("cmc.ChannelBankServiceImpl.get.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
        return response;
    }

    private String queryBankList(ChannelRlRequest channelRequest, Map<String, Object> map) {
        try {
            Map configMap = channelRequest.getConfigMap();
            String bankName = (String)map.get("bankName");
            if (StringUtils.isBlank((String)bankName)) {
                bankName = "";
            }
            return this.bankList(bankName, configMap);
        }
        catch (Exception e) {
            throw new ApiException("cmc.ChannelBankServiceImplpartnerCreate.e", (Throwable)e);
        }
    }

    private String queryBankSubList(ChannelRlRequest channelRequest, Map<String, Object> map) {
        try {
            Map configMap = channelRequest.getConfigMap();
            String bankCode = (String)map.get("bankCode");
            String bankName = (String)map.get("bankName");
            if (StringUtils.isBlank((String)bankName)) {
                bankName = "";
            }
            return this.bankSubList(bankCode + "/" + bankName, configMap);
        }
        catch (Exception e) {
            throw new ApiException("cmc.ChannelBankServiceImplpartnerCreate.e", (Throwable)e);
        }
    }

    private String bankinfoList(ChannelRlRequest channelRequest, Map<String, Object> map) {
        try {
            Map configMap = channelRequest.getConfigMap();
            return this.getbankinfoList(configMap);
        }
        catch (Exception e) {
            throw new ApiException("cmc.ChannelBankServiceImplpartnerCreate.e", (Throwable)e);
        }
    }

    private String bankList(String bankName, Map<String, String> configMap) {
        String path = bankList + bankName;
        return this.get("https://openapi.duolabao.com" + path, configMap.get("secretKey"), configMap.get("accesskey"), path);
    }

    private String bankSubList(String bankName, Map<String, String> configMap) {
        String path = bankSubList + bankName;
        return this.get("https://openapi.duolabao.com" + path, configMap.get("secretKey"), configMap.get("accesskey"), path);
    }

    private String getbankinfoList(Map<String, String> configMap) {
        return this.get("https://openapi.duolabao.com" + bankinfoList, configMap.get("secretKey"), configMap.get("accesskey"), bankinfoList);
    }
}

