/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.util;

import com.alibaba.fastjson.JSONObject;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class Pboc3desmac {
    public static final byte[] ZERO_IVC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String sign(Map<String, String> params, String key) {
        return Pboc3desmac.sign(params, key, "0000000000000000", true);
    }

    public static String sign(JSONObject jsonData, String key, boolean type) {
        return Pboc3desmac.sign(jsonData, key, "0000000000000000", type);
    }

    public static String sign(String respJsonStr, String key) {
        return Pboc3desmac.sign(respJsonStr, key, "0000000000000000");
    }

    public static String sign(String respJsonStr, String key, String iv) {
        String signData = respJsonStr;
        byte[] sign = null;
        try {
            sign = Pboc3desmac.calculatePboc3desMAC(signData.getBytes("UTF-8"), Pboc3desmac.hexStringToBytes(key), Pboc3desmac.hexStringToBytes(iv));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Pboc3desmac.encodeHexString(sign);
    }

    public static String sign(Map<String, String> params, String key, boolean isOld) {
        return Pboc3desmac.sign(params, key, "0000000000000000", isOld);
    }

    public static String sign(JSONObject jsonData, String key, String iv, boolean type) {
        String sortData = Pboc3desmac.sort2((Map<String, Object>)jsonData);
        byte[] sign = null;
        try {
            sign = Pboc3desmac.calculatePboc3desMAC(sortData.getBytes("UTF-8"), Pboc3desmac.hexStringToBytes(key), Pboc3desmac.hexStringToBytes(iv));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type) {
            sign = ArrayUtils.subarray(sign, (int)0, (int)4);
        }
        return Pboc3desmac.encodeHexString(sign);
    }

    public static String string2MD5(String inStr) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        char[] charArray = inStr.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String sort(Map<String, String> params) {
        ArrayList<String> list = new ArrayList<String>();
        for (String mapkey : params.keySet()) {
            String value = params.get(mapkey);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            list.add(mapkey + "=" + value);
        }
        Collections.sort(list);
        String signData = StringUtils.join(list, (String)"&");
        return signData;
    }

    public static String sort2(Map<String, Object> params) {
        ArrayList<String> list = new ArrayList<String>();
        for (String mapkey : params.keySet()) {
            String value = params.get(mapkey) + "";
            if (!StringUtils.isNotEmpty((String)value)) continue;
            list.add(mapkey + "=" + value);
        }
        Collections.sort(list);
        String signData = StringUtils.join(list, (String)"&");
        return signData;
    }

    public static String sign(Map<String, String> params, String key, String iv, boolean type) {
        ArrayList<String> list = new ArrayList<String>();
        for (String mapkey : params.keySet()) {
            String value = params.get(mapkey);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            list.add(mapkey + "=" + value);
        }
        Collections.sort(list);
        String signData = StringUtils.join(list, (String)"&");
        byte[] sign = null;
        try {
            sign = Pboc3desmac.calculatePboc3desMAC(signData.getBytes("UTF-8"), Pboc3desmac.hexStringToBytes(key), Pboc3desmac.hexStringToBytes(iv));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type) {
            sign = ArrayUtils.subarray(sign, (int)0, (int)4);
        }
        return Pboc3desmac.encodeHexString(sign);
    }

    public static String generateKey() {
        KeyGenerator kg;
        try {
            kg = KeyGenerator.getInstance("DESede");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        kg.init(112);
        byte[] key24 = kg.generateKey().getEncoded();
        byte[] result = new byte[16];
        System.arraycopy(key24, 0, result, 0, 16);
        return Pboc3desmac.encodeHexString(result);
    }

    public static final byte[] hexStringToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String encodeHexString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEXCHAR[(b[i] & 0xF0) >>> 4]);
            sb.append(HEXCHAR[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] calculatePboc3desMAC(byte[] data, byte[] key, byte[] icv) throws Exception {
        if (key == null || data == null) {
            throw new RuntimeException("data or key is null.");
        }
        if (key.length != 16) {
            throw new RuntimeException("key length is not 16 byte.");
        }
        byte[] leftKey = new byte[8];
        System.arraycopy(key, 0, leftKey, 0, 8);
        int dataLength = data.length;
        int groupCount = dataLength / 8 + 1;
        int lastGroupLength = dataLength % 8;
        byte[][] dataGroup = new byte[groupCount][];
        for (int i = 0; i < groupCount; ++i) {
            byte[] dataBlk = new byte[8];
            if (i == groupCount - 1) {
                System.arraycopy(data, i * 8, dataBlk, 0, dataLength % 8);
            } else {
                System.arraycopy(data, i * 8, dataBlk, 0, 8);
            }
            dataGroup[i] = dataBlk;
        }
        dataGroup[groupCount - 1][lastGroupLength] = -128;
        byte[] desXor = Pboc3desmac.xOr(dataGroup[0], icv);
        for (int i = 1; i < groupCount; ++i) {
            byte[] des = Pboc3desmac.encryptByDesCbc(desXor, leftKey);
            desXor = Pboc3desmac.xOr(dataGroup[i], des);
        }
        desXor = Pboc3desmac.encryptBy3DesCbc(desXor, key);
        return desXor;
    }

    private static byte[] xOr(byte[] b1, byte[] b2) {
        byte[] tXor = new byte[Math.min(b1.length, b2.length)];
        for (int i = 0; i < tXor.length; ++i) {
            tXor[i] = (byte)(b1[i] ^ b2[i]);
        }
        return tXor;
    }

    public static byte[] encryptBy3DesCbc(byte[] content, byte[] key) throws Exception {
        byte[] _3deskey = new byte[24];
        System.arraycopy(key, 0, _3deskey, 0, 16);
        System.arraycopy(key, 0, _3deskey, 16, 8);
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        SecretKeySpec secureKey = new SecretKeySpec(_3deskey, "DESede");
        IvParameterSpec iv = new IvParameterSpec(ZERO_IVC);
        cipher.init(1, (Key)secureKey, iv);
        return cipher.doFinal(content);
    }

    public static byte[] encryptByDesCbc(byte[] content, byte[] key) throws Exception {
        return Pboc3desmac.encryptByDesCbc(content, key, ZERO_IVC);
    }

    public static byte[] encryptByDesCbc(byte[] content, byte[] key, byte[] icv) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
        IvParameterSpec iv = new IvParameterSpec(icv);
        cipher.init(1, (Key)secretKey, iv, sr);
        return cipher.doFinal(content);
    }
}

