/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.haihang.util;

import com.yqbsoft.laser.service.ext.channel.haihang.util.Base64;
import com.yqbsoft.laser.service.ext.channel.haihang.util.SignUtils;
import com.yqbsoft.laser.service.ext.channel.haihang.util.SignatureUtil;
import com.yqbsoft.laser.service.ext.channel.haihang.util.SymmtricCryptoUtil;
import java.security.GeneralSecurityException;

public class SignUtilsImpl
implements SignUtils {
    @Override
    public String sign(String text, String key, String algorithm) {
        byte[] textBytes = text.getBytes();
        byte[] keyBytes = Base64.decode(key);
        byte[] resultBytes = null;
        try {
            resultBytes = SignatureUtil.sign(textBytes, keyBytes, algorithm);
            return Base64.encode(resultBytes);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public boolean verify(String text, String signText, String key, String algorithm) {
        try {
            return SignatureUtil.verify(text.getBytes(), Base64.decode(signText), Base64.decode(key), algorithm);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String encrypt(String text, String key, String algorithm) {
        byte[] bytes = text.getBytes();
        byte[] keyData = Base64.decode(key);
        try {
            byte[] cipherBytes = SymmtricCryptoUtil.symmtricCrypto(bytes, keyData, algorithm, 1);
            return Base64.encode(cipherBytes);
        }
        catch (GeneralSecurityException e) {
            return "";
        }
    }

    @Override
    public String decrypt(String text, String key, String algorithm) {
        byte[] bytes = Base64.decode(text);
        byte[] keyData = Base64.decode(key);
        try {
            byte[] cipherBytes = SymmtricCryptoUtil.symmtricCrypto(bytes, keyData, algorithm, 2);
            return new String(cipherBytes);
        }
        catch (GeneralSecurityException e) {
            return "";
        }
    }
}

