/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.huifu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.request.BaseRequest;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentJspayRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.com.api.ChannelExtService;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.OcContract;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.PteBalanceopDomain;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.PteDprice;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.PteDpriceConf;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.UmUserinfoChannel;
import com.yqbsoft.laser.service.ext.channel.huifu.init.OppsMerchantConfigDemo;
import com.yqbsoft.laser.service.ext.channel.huifu.util.BaseCommonDemo;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    private static final String CODE = "cmc.ChannelInBaseService.ChannelInServiceImpl";

    public String getFchannelCode() {
        return "huifu";
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelInBaseService.ChannelInServiceImpl.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelInBaseService.ChannelInServiceImpl.sign.null", "");
        }
        this.logger.error("cmc.ChannelInBaseService.ChannelInServiceImpl.httpInvoke.channelRequest2", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        Object channelExtService = SpringApplicationContextUtil.getBean((String)"channelExtServiceImpl");
        if (channelExtService != null) {
            return ((ChannelExtService)channelExtService).httpInvokeExt(channelRequest);
        }
        Map configMap = channelRequest.getConfigMap();
        Map requestData = channelRequest.getRequestData();
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        String tenantCode = cmChannelClear.getTenantCode();
        Map<String, BigDecimal> map = this.queryBusMoney(tenantCode, cmChannelClear.getBusinessOrderno(), (String)configMap.get("huifuId"));
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        this.logger.error("cmc.ChannelInBaseService.httpInvoke \u5206\u8d26\u4fe1\u606f", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (null == BasePay.getConfig(null)) {
            try {
                BaseCommonDemo.doInit(OppsMerchantConfigDemo.getMerchantConfig(configMap));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        V2TradePaymentJspayRequest request = new V2TradePaymentJspayRequest();
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        request.setReqSeqId(cmChannelClear.getChannelClearSeqno());
        request.setHuifuId((String)configMap.get("huifuId"));
        request.setTradeType((String)configMap.get("tradeType"));
        request.setTransAmt((String)requestData.get("transAmt"));
        request.setGoodsDesc("\u534e\u897f\u5546\u57ce\u5546\u54c1");
        Map<String, Object> extendInfoMap = ChannelInServiceImpl.getExtendInfos(requestData, configMap);
        request.setExtendInfo(extendInfoMap);
        Map<String, Object> response = null;
        try {
            this.logger.error("cmc.ChannelInBaseService.ChannelInServiceImpl.httpInvoke.request", (Object)JSONObject.toJSONString((Object)request));
            response = BaseCommonDemo.doExecute((BaseRequest)request);
            this.logger.error("cmc.ChannelInBaseService.ChannelInServiceImpl.httpInvoke.response", (Object)JSONObject.toJSONString(response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = null;
        if (MapUtil.isNotEmpty(response)) {
            result = JSONObject.toJSONString(response);
        }
        return result;
    }

    private static Map<String, Object> getExtendInfos(Map<String, String> requestData, Map<String, String> configMap) {
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        extendInfoMap.put("limit_pay_type", "NO_CREDIT");
        if (requestData.get("acct_split_bunch") == null) {
            extendInfoMap.put("delay_acct_flag", "N");
        } else {
            extendInfoMap.put("delay_acct_flag", "Y");
        }
        extendInfoMap.put("pay_scene", "01");
        extendInfoMap.put("term_div_coupon_type", "0");
        extendInfoMap.put("wx_data", ChannelInServiceImpl.getWxData(requestData));
        extendInfoMap.put("notify_url", configMap.get("notify_url"));
        return extendInfoMap;
    }

    private static String getWxData(Map<String, String> requestData) {
        JSONObject dto = new JSONObject();
        dto.put("openid", (Object)requestData.get("openid"));
        return dto.toJSONString();
    }

    private static String getAcctSplitBunch() {
        JSONObject dto = new JSONObject();
        return dto.toJSONString();
    }

    private static JSON getAcctInfosRucan() {
        JSONObject dto = new JSONObject();
        JSONArray dtoList = new JSONArray();
        dtoList.add((Object)dto);
        return dtoList;
    }

    private Map<String, BigDecimal> queryBusMoney(String tenantCode, String contractBbillcode, String huifuNo) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBbillcode", contractBbillcode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String jsonOc = this.internalInvoke("oc.contract.queryContractPage", map);
        if (StringUtils.isBlank((String)jsonOc)) {
            this.logger.error("cmc.ChannelInBaseService.queryContractPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult contractStr = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonOc, QueryResult.class);
        if (contractStr == null || ListUtil.isEmpty((Collection)contractStr.getList())) {
            this.logger.error("cmc.ChannelInBaseService.queryContractPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List contractList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)contractStr.getList()), OcContract.class);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        BigDecimal dprice = new BigDecimal("0");
        ArrayList<PteBalanceopDomain> pteBalanceopDomainList = new ArrayList<PteBalanceopDomain>();
        for (OcContract ocContract : contractList) {
            UmUserinfoChannel umUserinfoChannel = this.queryUserinfoChannelPage(tenantCode, ocContract.getMemberCcode());
            if (null == umUserinfoChannel) {
                this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.getMemberCcode", (Object)ocContract.getMemberCcode());
                return null;
            }
            String userinfoChannelVaule = umUserinfoChannel.getUserinfoChannelVaule();
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.getMemberCcode", (Object)userinfoChannelVaule);
            BigDecimal orderMoney = ocContract.getDataBmoney().subtract(ocContract.getGoodsLogmoney());
            PteDprice pteDprice = this.queryDpricePage(tenantCode, ocContract.getChannelCode());
            if (pteDprice == null || pteDprice.getDataState() != 1) {
                this.logger.error("cmc.ChannelInBaseService.queryDpricePage.pteDprice", (Object)"\u627e\u4e0d\u5230\u5206\u4f63\u6216\u8005\u672a\u5f00\u542f\u5206\u4f63");
                resultMap.put(userinfoChannelVaule, orderMoney);
                continue;
            }
            PteDpriceConf busDpriceConf = this.getBusDpriceConf(tenantCode, pteDprice.getDpriceCode(), ocContract.getMemberCcode());
            if (busDpriceConf == null) {
                resultMap.put(userinfoChannelVaule, orderMoney);
                continue;
            }
            BigDecimal dpriceOc = BigDecimal.ZERO;
            if ("2".equals(busDpriceConf.getDpriceConfPro())) {
                if (orderMoney.compareTo(busDpriceConf.getDpriceConfPrice()) <= 0) {
                    dpriceOc = orderMoney;
                    dprice = dprice.add(dpriceOc);
                } else {
                    dpriceOc = busDpriceConf.getDpriceConfPrice();
                    resultMap.put(userinfoChannelVaule, orderMoney.subtract(busDpriceConf.getDpriceConfPrice()));
                    dprice = dprice.add(dpriceOc);
                }
            } else if ("0".equals(busDpriceConf.getDpriceConfPro())) {
                if (new BigDecimal("100").compareTo(busDpriceConf.getDpriceConfPrice()) <= 0) {
                    dpriceOc = orderMoney;
                    dprice = dprice.add(dpriceOc);
                } else {
                    dpriceOc = busDpriceConf.getDpriceConfPrice().multiply(orderMoney).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
                    resultMap.put(userinfoChannelVaule, orderMoney.subtract(dpriceOc));
                    dprice = dprice.add(dpriceOc);
                }
            } else {
                resultMap.put(userinfoChannelVaule, orderMoney);
            }
            if (dpriceOc.compareTo(BigDecimal.ZERO) == 0) continue;
            PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
            ChannelInServiceImpl.convertSendBalanceDTO2BO(ocContract, pteBalanceopDomain);
            pteBalanceopDomain.setOrderDviAmt(dpriceOc);
            pteBalanceopDomain.setBalanceopFee(busDpriceConf.getDpriceConfPrice());
            pteBalanceopDomain.setBusinessDes(busDpriceConf.getDpriceConfPro());
            pteBalanceopDomain.setBusinessDes1(userinfoChannelVaule);
            pteBalanceopDomain.setDataState(3);
            pteBalanceopDomainList.add(pteBalanceopDomain);
        }
        if (dprice.compareTo(BigDecimal.ZERO) >= 0) {
            resultMap.put(huifuNo, dprice);
            if (ListUtil.isNotEmpty(pteBalanceopDomainList)) {
                this.saveBalanceopBatch(pteBalanceopDomainList);
            }
        }
        return resultMap;
    }

    private UmUserinfoChannel queryUserinfoChannelPage(String tenantCode, String userinfoCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoChannelKey", "huifuNo");
        paramMap.put("userinfoCode", userinfoCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String json = this.internalInvoke("um.umUserinfoChannel.queryUserinfoChannelPage", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult umUserinfoChannelStr = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (umUserinfoChannelStr == null || ListUtil.isEmpty((Collection)umUserinfoChannelStr.getList())) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List userinfoChannelList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelStr.getList()), UmUserinfoChannel.class);
        if (ListUtil.isEmpty((Collection)userinfoChannelList)) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return (UmUserinfoChannel)userinfoChannelList.get(0);
    }

    private PteDprice queryDpricePage(String tenantCode, String channelCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("dpriceType", "oc");
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String json = this.internalInvoke("pte.dprice.queryDpricePage", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), PteDprice.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return (PteDprice)list.get(0);
    }

    private PteDpriceConf getBusDpriceConf(String tenantCode, String dpriceCode, String memberCcode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("dataState", 1);
        paramMap.put("dpriceCode", dpriceCode);
        paramMap.put("dpriceConfValue", memberCcode);
        paramMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String json = this.internalInvoke("pte.dpriceConf.queryDpriceConfPage", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), PteDpriceConf.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return (PteDpriceConf)list.get(0);
    }

    private void saveBalanceopBatch(List<PteBalanceopDomain> pteBalanceopDomainList) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("pteBalanceopDomainList", JsonUtil.buildNonDefaultBinder().toJson(pteBalanceopDomainList));
        String json = this.internalInvoke("pte.balanceop.saveBalanceopBatch", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelInBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
    }

    public static void convertSendBalanceDTO2BO(OcContract ocContractDomain, PteBalanceopDomain pteBalanceopDomain) {
        pteBalanceopDomain.setGoodsPmoney(ocContractDomain.getGoodsPmoney());
        pteBalanceopDomain.setMsChannelName(ocContractDomain.getMschannelName());
        pteBalanceopDomain.setBalanceopAmount(ocContractDomain.getDataBmoney());
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney().add(ocContractDomain.getGoodsLogmoney()));
        pteBalanceopDomain.setOrderPortion(ocContractDomain.getGoodsLogmoney());
        pteBalanceopDomain.setBalanceType("oc");
        pteBalanceopDomain.setBusinessType("oc");
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberCode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberName());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setMemberMcode(ocContractDomain.getMemberMcode());
        pteBalanceopDomain.setMemberMname(ocContractDomain.getMemberMname());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setChannelCode(ocContractDomain.getChannelCode());
        pteBalanceopDomain.setChannelName(ocContractDomain.getChannelName());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setGmtPaySubmit(ocContractDomain.getGmtCreate());
        pteBalanceopDomain.setGmtPayout(ocContractDomain.getContractPaydate());
    }
}

