/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.huifu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.request.BaseRequest;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentDelaytransConfirmRequest;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentDelaytransConfirmqueryRequest;
import com.huifu.bspay.sdk.opps.core.request.V2TradePaymentDelaytransConfirmrefundRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.com.api.ChannelExtService;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelSpBaseService;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.OcContract;
import com.yqbsoft.laser.service.ext.channel.huifu.domain.PteBalanceop;
import com.yqbsoft.laser.service.ext.channel.huifu.init.OppsMerchantConfigDemo;
import com.yqbsoft.laser.service.ext.channel.huifu.util.BaseCommonDemo;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelSpBaseServiceImpl
extends ChannelSpBaseService {
    private static final String CODE = "cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl";
    private static String channelSpStart = "cmc.channelSp.channelSpStart";
    private static String channelSpQuery = "cmc.channelSp.channelSpQuery";
    private static String channelSpCannel = "cmc.channelSp.channelSpCannel";

    public String getFchannelCode() {
        return "huifu";
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        Object channelExtService = SpringApplicationContextUtil.getBean((String)"channelExtServiceImpl");
        if (channelExtService != null) {
            return ((ChannelExtService)channelExtService).httpInvokeExt(channelRequest);
        }
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            this.logger.error("cmc.ChannelSpBaseService.sign.channelRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            throw new ApiException("cmc.ChannelSpBaseService.sign.null", "");
        }
        this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.channelRequest2", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        if (channelSpStart.equals(channelRequest.getChannelApiCode())) {
            return this.delaytransConfirm(channelRequest);
        }
        if (channelSpQuery.equals(channelRequest.getChannelApiCode())) {
            return this.channelSpQuery(channelRequest);
        }
        if (channelSpCannel.equals(channelRequest.getChannelApiCode())) {
            return this.channelSpCannel(channelRequest);
        }
        return null;
    }

    private String channelSpQuery(ChannelRequest channelRequest) {
        Map configMap = channelRequest.getConfigMap();
        com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        if (cmChannelClear == null || StringUtils.isBlank((String)cmChannelClear.getBusinessOrderno())) {
            return null;
        }
        PteBalanceop pteBalanceop = this.queryBalanceopPage(cmChannelClear.getTenantCode(), cmChannelClear.getBusinessOrderno(), 3);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.doInit(configMap);
        V2TradePaymentDelaytransConfirmqueryRequest request = new V2TradePaymentDelaytransConfirmqueryRequest();
        request.setHuifuId((String)configMap.get("huifuId"));
        request.setOrgReqDate(pteBalanceop.getBusinessDes2());
        request.setOrgReqSeqId(pteBalanceop.getBusinessDes3());
        Map<String, Object> extendInfoMap = ChannelSpBaseServiceImpl.getExtendInfos();
        request.setExtendInfo(extendInfoMap);
        return this.doExecute((BaseRequest)request);
    }

    private String channelSpCannel(ChannelRequest channelRequest) {
        Map configMap = channelRequest.getConfigMap();
        com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        if (cmChannelClear == null || StringUtils.isBlank((String)cmChannelClear.getBusinessOrderno())) {
            return null;
        }
        PteBalanceop pteBalanceop = this.queryBalanceopPage(cmChannelClear.getTenantCode(), cmChannelClear.getBusinessOrderno(), 4);
        this.doInit(configMap);
        V2TradePaymentDelaytransConfirmrefundRequest request = new V2TradePaymentDelaytransConfirmrefundRequest();
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        request.setHuifuId((String)configMap.get("huifuId"));
        request.setOrgReqDate(pteBalanceop.getBusinessDes2());
        request.setOrgReqSeqId(pteBalanceop.getBusinessDes3());
        Map<String, Object> extendInfoMap = ChannelSpBaseServiceImpl.getExtendInfos();
        request.setExtendInfo(extendInfoMap);
        return this.doExecute((BaseRequest)request);
    }

    private String delaytransConfirm(ChannelRequest channelRequest) {
        Map configMap = channelRequest.getConfigMap();
        com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        if (cmChannelClear == null || StringUtils.isBlank((String)cmChannelClear.getBusinessOrderno())) {
            return null;
        }
        CmChannelClear oldChannelClear = this.getCmChannelClear(cmChannelClear.getTenantCode(), cmChannelClear.getBusinessOrderno());
        if (oldChannelClear == null) {
            return null;
        }
        this.doInit(configMap);
        V2TradePaymentDelaytransConfirmRequest request = new V2TradePaymentDelaytransConfirmRequest();
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        request.setReqSeqId(SequenceTools.getReqSeqId32());
        request.setHuifuId((String)configMap.get("huifuId"));
        PteBalanceop pteBalanceop = this.queryBalanceopPage(cmChannelClear.getTenantCode(), cmChannelClear.getBusinessOrderno(), 3);
        String dtosStr = this.makeAcctInfos((String)configMap.get("huifuId"), pteBalanceop);
        if (StringUtils.isBlank((String)dtosStr)) {
            return "error";
        }
        this.logger.error("cmc.ChannelSpBaseService.httpInvoke \u5206\u8d26\u4fe1\u606f", (Object)dtosStr);
        Map<String, Object> extendInfoMap = ChannelSpBaseServiceImpl.getExtendInfos(oldChannelClear, dtosStr);
        request.setExtendInfo(extendInfoMap);
        Map<String, Object> response = null;
        try {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.request", (Object)JSONObject.toJSONString((Object)request));
            response = BaseCommonDemo.doExecute((BaseRequest)request);
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.response", (Object)JSONObject.toJSONString(response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pteBalanceop.setBusinessDes2(request.getReqDate());
        pteBalanceop.setBusinessDes3(request.getReqSeqId());
        String result = "error";
        if (MapUtil.isNotEmpty(response) && "00000000".equals(response.get("resp_code"))) {
            if ("S".equals(response.get("trans_stat"))) {
                pteBalanceop.setDataState(4);
                this.updateBalanceop(pteBalanceop);
                result = "success";
            } else if ("F".equals(response.get("trans_stat"))) {
                result = "eror";
            } else {
                String queryResult = this.channelSpQuery(channelRequest);
                Map jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(queryResult, String.class, String.class);
                if ("00000000".equals(jsonToMap.get("resp_code"))) {
                    if ("S".equals(jsonToMap.get("trans_stat"))) {
                        pteBalanceop.setDataState(4);
                        this.updateBalanceop(pteBalanceop);
                        result = "success";
                    } else if ("F".equals(jsonToMap.get("trans_stat"))) {
                        result = "eror";
                    }
                }
            }
        }
        return result;
    }

    private String makeAcctInfos(String huifuId, PteBalanceop pteBalanceop) {
        List<OcContract> contractList = this.queryContractPage(pteBalanceop);
        if (contractList == null || ListUtil.isEmpty(contractList)) {
            this.logger.error("cmc.ChannelSpBaseService.getRefundMoney.pteBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceop));
            return null;
        }
        BigDecimal refundMoney = contractList.get(0).getRefundMoney();
        if (refundMoney == null) {
            refundMoney = BigDecimal.ZERO;
        }
        BigDecimal orderMoney = pteBalanceop.getBalanceopAmount().subtract(pteBalanceop.getOrderPortion()).subtract(refundMoney);
        BigDecimal dpriceOc = BigDecimal.ZERO;
        BigDecimal balanceopFee = pteBalanceop.getBalanceopFee();
        if ("2".equals(pteBalanceop.getBusinessDes())) {
            dpriceOc = orderMoney.compareTo(balanceopFee) <= 0 ? orderMoney : balanceopFee;
        } else if ("0".equals(pteBalanceop.getBusinessDes())) {
            dpriceOc = new BigDecimal("100").compareTo(balanceopFee) <= 0 ? orderMoney : balanceopFee.multiply(orderMoney).divide(new BigDecimal("100"), 2, RoundingMode.DOWN);
        }
        JSONObject dtos = new JSONObject();
        JSONArray dtoList = new JSONArray();
        JSONObject dto = null;
        if (dpriceOc.compareTo(BigDecimal.ZERO) != 0) {
            dto = new JSONObject();
            dto.put("huifu_id", (Object)huifuId);
            dto.put("div_amt", (Object)dpriceOc.setScale(2, RoundingMode.DOWN));
            dtoList.add((Object)dto);
        }
        if (orderMoney.subtract(dpriceOc).compareTo(BigDecimal.ZERO) != 0) {
            dto = new JSONObject();
            dto.put("huifu_id", (Object)pteBalanceop.getBusinessDes1());
            dto.put("div_amt", (Object)orderMoney.subtract(dpriceOc).setScale(2, RoundingMode.DOWN));
            dtoList.add((Object)dto);
        }
        dtos.put("acct_infos", (Object)dtoList);
        pteBalanceop.setOrderDviAmt(dpriceOc);
        return dtos.toJSONString();
    }

    private void updateBalanceop(PteBalanceop pteBalanceopDomain) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("pteBalanceopDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)pteBalanceopDomain));
        String json = this.internalInvoke("pte.balanceop.updateBalanceop", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.updateBalanceop.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
    }

    private static Map<String, Object> getExtendInfos() {
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        return extendInfoMap;
    }

    private static Map<String, Object> getExtendInfos(CmChannelClear cmChannelClear, String acct_infos) {
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        extendInfoMap.put("org_req_date", sdf.format(cmChannelClear.getChannelAcceptDate()));
        extendInfoMap.put("org_hf_seq_id", cmChannelClear.getOrderBankseq());
        extendInfoMap.put("acct_split_bunch", acct_infos);
        return extendInfoMap;
    }

    private static String getAcctSplitBunch() {
        JSONObject dto = new JSONObject();
        dto.put("acct_infos", (Object)ChannelSpBaseServiceImpl.getAcctInfosRucan());
        return dto.toJSONString();
    }

    private static JSON getAcctInfosRucan() {
        JSONObject dto = new JSONObject();
        dto.put("div_amt", (Object)"0.01");
        dto.put("huifu_id", (Object)"6666000103423237");
        dto.put("acct_id", (Object)"C01400109");
        JSONArray dtoList = new JSONArray();
        dtoList.add((Object)dto);
        return dtoList;
    }

    private void doInit(Map<String, String> configMap) {
        if (null == BasePay.getConfig(null)) {
            try {
                BaseCommonDemo.doInit(OppsMerchantConfigDemo.getMerchantConfig(configMap));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String doExecute(BaseRequest request) {
        Map<String, Object> response = null;
        try {
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.request", (Object)JSONObject.toJSONString((Object)request));
            response = BaseCommonDemo.doExecute(request);
            this.logger.error("cmc.ChannelSpBaseService.ChannelSpBaseServiceImpl.httpInvoke.response", (Object)JSONObject.toJSONString(response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = null;
        if (MapUtil.isNotEmpty(response)) {
            result = JSONObject.toJSONString(response);
        }
        return result;
    }

    private List<OcContract> queryContractPage(PteBalanceop pteBalanceop) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", pteBalanceop.getTenantCode());
        paramMap.put("contractBillcode", pteBalanceop.getBusinessOrder());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String jsonOc = this.internalInvoke("oc.contract.queryContractPage", map);
        if (StringUtils.isBlank((String)jsonOc)) {
            this.logger.error("cmc.ChannelSpBaseService.queryContractPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult contractStr = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonOc, QueryResult.class);
        if (contractStr == null || ListUtil.isEmpty((Collection)contractStr.getList())) {
            this.logger.error("cmc.ChannelSpBaseService.queryContractPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)contractStr.getList()), OcContract.class);
    }

    private CmChannelClear getCmChannelClear(String tenantCode, String businessOrderno) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("dataState", 2);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("businessOrderno", businessOrderno);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String json = this.internalInvoke("cm.channelClear.querychannelClearPage", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.getCmChannelClear.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("cmc.ChannelSpBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), CmChannelClear.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("cmc.ChannelSpBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return (CmChannelClear)list.get(0);
    }

    protected PteBalanceop queryBalanceopPage(String tenantCode, String businessOrder, Integer dataState) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("dataState", dataState);
        paramMap.put("businessOrder", businessOrder);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String json = this.internalInvoke("pte.balanceop.queryBalanceopPage", map);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cmc.ChannelSpBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("cmc.ChannelSpBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), PteBalanceop.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("cmc.ChannelSpBaseService.queryUserinfoChannelPage.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return null;
        }
        return (PteBalanceop)list.get(0);
    }
}

