/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.hw.saas.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.router.HttpResponseBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.hw.saas.common.constant.ResultCodeEnum;
import com.yqbsoft.laser.service.hw.saas.domain.AppInfo;
import com.yqbsoft.laser.service.hw.saas.domain.BaseResp;
import com.yqbsoft.laser.service.hw.saas.domain.HwProductDomain;
import com.yqbsoft.laser.service.hw.saas.domain.NewInstanceResp;
import com.yqbsoft.laser.service.hw.saas.domain.OcContractDomain;
import com.yqbsoft.laser.service.hw.saas.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.hw.saas.domain.TmScene;
import com.yqbsoft.laser.service.hw.saas.domain.TmSceneApi;
import com.yqbsoft.laser.service.hw.saas.domain.TmSceneProapp;
import com.yqbsoft.laser.service.hw.saas.domain.TmSceneProappDomain;
import com.yqbsoft.laser.service.hw.saas.domain.TmTmsceneDomain;
import com.yqbsoft.laser.service.hw.saas.domain.TmTmsceneProappDomain;
import com.yqbsoft.laser.service.hw.saas.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.hw.saas.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.hw.saas.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.hw.saas.service.HwSaasService;
import com.yqbsoft.laser.service.hw.saas.utils.TokenUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class HwSaasServiceImpl
extends BaseServiceImpl
implements HwSaasService {
    private static final int ENCRYPT_TYPE = 1;
    private static final String ACCESS_KEY = "7721336f-6319-4023-93eb-188751b9a099";
    private static final String BODY_SIGN_KEY = "Body-Sign";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String BODY_SIGN_VALUE = "sign_type=\"HMAC-SHA256\", signature= \"{signature}\"";
    ObjectMapper mapper = new ObjectMapper();
    private String SYS_CODE = "hwSaas.HwSaasServiceImpl";

    @Override
    public String productInterface(HwProductDomain hwProductDomain) throws IOException {
        if (null == hwProductDomain) {
            this.logger.error(this.SYS_CODE + ".productInterface", (Object)"param is null");
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
        }
        String jsonStr = JSONObject.toJSONString((Object)hwProductDomain);
        this.logger.info(this.SYS_CODE + ".productInterface,param=" + jsonStr);
        Map paramsMap = (Map)JSONObject.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        boolean verificationResult = TokenUtils.verificationRequestParams(paramsMap, ACCESS_KEY);
        if (!verificationResult) {
            this.logger.error(this.SYS_CODE + ".productInterface token is invalid ----", (Object)jsonStr);
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_TOKEN.getResultCode(), ResultCodeEnum.INVALID_TOKEN.getResultMsg());
        }
        String responsStr = null;
        String activity = hwProductDomain.getActivity();
        if (StringUtils.equals((CharSequence)"newInstance", (CharSequence)activity)) {
            if (StringUtils.isBlank((String)hwProductDomain.getMobilePhone())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("mobile is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            if (StringUtils.isBlank((String)hwProductDomain.getSkuCode())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("skuCode is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            responsStr = this.executeNew(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"refreshInstance", (CharSequence)activity)) {
            if (StringUtils.isBlank((String)hwProductDomain.getProductId())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("productId is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            if (StringUtils.isBlank((String)hwProductDomain.getExpireTime())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("expireTime is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            responsStr = this.executeRefresh(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"expireInstance", (CharSequence)activity)) {
            responsStr = this.executeExpire(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"releaseInstance", (CharSequence)activity)) {
            responsStr = this.executeRelease(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"upgrade", (CharSequence)activity)) {
            responsStr = this.executeUpgrade(hwProductDomain);
        } else {
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), "activity error");
        }
        if (StringUtils.isBlank((String)responsStr)) {
            return this.buildFailResponse(400, ResultCodeEnum.OTHER_INNER_ERROR.getResultCode(), "system error");
        }
        return responsStr;
    }

    private String executeNew(HwProductDomain hwProductDomain) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        try {
            String sceneApiCode;
            String mobile = TokenUtils.decryptContent(hwProductDomain.getMobilePhone(), ACCESS_KEY, 1);
            hwProductDomain.setMobilePhone(mobile);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userPhone", mobile);
            map.put("tenantCode", "00000000");
            paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)this.getInternalRouter().inInvoke("um.user.getUserByNameOrPhone", paramsMap);
            String userinfoCode = null;
            if (null == umUserReDomainBean) {
                UmUserDomainBean umUserDomainBean = this.getUmUserDomainBean(hwProductDomain);
                paramsMap.clear();
                paramsMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
                userinfoCode = (String)this.getInternalRouter().inInvoke("um.user.sendOpenUserinfo", paramsMap);
            } else {
                userinfoCode = umUserReDomainBean.getUserPcode();
            }
            paramsMap.clear();
            paramsMap.put("userinfoCode", userinfoCode);
            paramsMap.put("tenantCode", "00000000");
            UmUserinfoReDomainBean umUserinfoReDomain = (UmUserinfoReDomainBean)this.getInternalRouter().inInvoke("um.user.getUserinfoByCode", paramsMap);
            if (null == umUserinfoReDomain) {
                this.logger.error(this.SYS_CODE + ".executeNew.getUserinfoByCode,Userinfo\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tuserPcode:" + umUserReDomainBean.getUserPcode());
                return null;
            }
            if (0 != umUserinfoReDomain.getDataState()) {
                this.logger.error(this.SYS_CODE + ".executeNew.getUserinfoByCode,\u79df\u6237\u72b6\u6001\u65e0\u6548\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tuserPcode:" + umUserReDomainBean.getUserPcode());
                return null;
            }
            String sceneCode = hwProductDomain.getSkuCode();
            paramsMap.clear();
            paramsMap.put("tenantCode", "00000000");
            paramsMap.put("sceneCode", sceneCode);
            TmScene tmScene = (TmScene)this.getInternalRouter().inInvoke("tm.scene.getSceneByCode", paramsMap);
            if (null == tmScene || StringUtils.isBlank((String)tmScene.getSceneroleCode())) {
                this.logger.error(this.SYS_CODE + ".executeNew.getSceneByCode,sceneCode\u5bf9\u5e94\u7684sceneroleCode\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tskuCode:" + hwProductDomain.getSkuCode());
                return null;
            }
            map.clear();
            map.put("fuzzy", false);
            map.put("tenantCode", "00000000");
            map.put("proappSort", "2");
            map.put("sceneroleCode", tmScene.getSceneroleCode());
            paramsMap.clear();
            paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            QueryResult proappResult = (QueryResult)this.getInternalRouter().inInvoke("tm.scene.querySceneProappPage", paramsMap);
            if (null == proappResult || CollectionUtils.isEmpty((Collection)proappResult.getList())) {
                this.logger.error(this.SYS_CODE + ".executeNew.querySceneProappPage,skuCode\u5bf9\u5e94\u7684\u4ea7\u54c1\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tskuCode:" + hwProductDomain.getSkuCode());
                return null;
            }
            TmTmsceneDomain tmTmsceneDomain = this.getTmTmsceneDomain(umUserinfoReDomain, tmScene, proappResult.getList());
            tmTmsceneDomain.setMemberCode(umUserinfoReDomain.getUserinfoCode());
            tmTmsceneDomain.setMemberName(umUserReDomainBean.getUserName());
            tmTmsceneDomain.setUserCode(umUserinfoReDomain.getUserinfoCode());
            tmTmsceneDomain.setUserName(umUserReDomainBean.getUserName());
            String domainUrl = tmTmsceneDomain.getTenantCode() + ".qjclouds.com";
            if (tmTmsceneDomain.getSceneType().equals("op")) {
                String tmsceneConf = tmTmsceneDomain.getTmsceneConf();
                Map<String, String> mapp = null;
                if (StringUtils.isBlank((String)tmsceneConf)) {
                    mapp = new HashMap<String, String>();
                    mapp.put("mallName", "\u5343\u5320\u9ed8\u8ba4\u5546\u94fa");
                    mapp.put("domain", domainUrl);
                    mapp.put("logo", "/paas/shop/00000000/2022-03-31/3327c701b67640b5bc217e35defc8890.jpg");
                    mapp.put("mallUser", "\u5343\u5320\u9ed8\u8ba4\u5546\u94fa" + tmScene.getSceneroleName());
                    mapp.put("managerPhone", mobile);
                    mapp.put("userPwsswd", "123456");
                } else {
                    mapp = (Map)JsonUtil.buildNormalBinder().getJsonToMap(tmsceneConf, String.class, String.class);
                }
                tmTmsceneDomain.setTmsceneConf(JsonUtil.buildNormalBinder().toJson(mapp));
                HashMap<String, Object> sortParam = new HashMap<String, Object>();
                sortParam.put("tenantCode", tmTmsceneDomain.getTenantCode());
                sortParam.put("order", true);
                sortParam.put("fuzzy", true);
                sortParam.put("proappSort", "0");
                sortParam.put("sceneroleCode", tmTmsceneDomain.getSceneroleCode());
                this.saveProappCommon(tmTmsceneDomain, sortParam);
                sortParam.put("proappSort", "1");
                this.saveProappCommon(tmTmsceneDomain, sortParam);
            }
            paramsMap.clear();
            paramsMap.put("tmTmsceneDomain", JsonUtil.buildNormalBinder().toJson((Object)tmTmsceneDomain));
            String instanceId = sceneApiCode = (String)this.getInternalRouter().inInvoke("tm.tenantbase.sendSaveTmscene", paramsMap);
            String userName = mobile;
            String password = "123456";
            String adminUrl = "http://appshop-dev.qjclouds.com";
            String frontEndUrl = domainUrl;
            String memo = "\u8be5\u5bc6\u7801\u4e3a\u4ea7\u54c1\u5bc6\u7801\uff0c\u79df\u6237\u5bc6\u7801\u89c1\u77ed\u4fe1";
            String bodyStr = this.buildNewInstance(userName, password, 1, instanceId, adminUrl, frontEndUrl, memo);
            return this.buildSignatureResponse(bodyStr);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".executeNew.e, businessId:" + hwProductDomain.getBusinessId(), (Throwable)e);
            return null;
        }
    }

    private UmUserDomainBean getUmUserDomainBean(HwProductDomain hwProductDomain) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserName(hwProductDomain.getCustomerName());
        umUserDomainBean.setUserPhone(hwProductDomain.getMobilePhone());
        umUserDomainBean.setUserPwsswd(null);
        umUserDomainBean.setUserRelname(hwProductDomain.getCustomerName());
        umUserDomainBean.setUserinfoQuality("tenant");
        umUserDomainBean.setUserinfoInvite(null);
        umUserDomainBean.setUserinfoDiscode(null);
        umUserDomainBean.setTenantCode("00000000");
        umUserDomainBean.setUserinfoQuality("buy");
        umUserDomainBean.setUserinfoType(1);
        umUserDomainBean.setUserinfoCompname(hwProductDomain.getCustomerName());
        return umUserDomainBean;
    }

    private TmTmsceneDomain getTmTmsceneDomain(UmUserinfoReDomainBean umUserinfoReDomain, TmScene tmScene, List<TmSceneProapp> proappList) throws Exception {
        TmTmsceneDomain tmTmsceneDomain = new TmTmsceneDomain();
        BeanUtils.copyProperties((Object)tmScene, (Object)tmTmsceneDomain);
        ArrayList<TmTmsceneProappDomain> tmsceneProappDomainList = new ArrayList<TmTmsceneProappDomain>();
        for (TmSceneProapp proapp : proappList) {
            TmTmsceneProappDomain proappDomain = new TmTmsceneProappDomain();
            BeanUtils.copyProperties((Object)proapp, (Object)proappDomain);
            tmsceneProappDomainList.add(proappDomain);
        }
        tmTmsceneDomain.setTmTmsceneProappDomainList(tmsceneProappDomainList);
        String tenantCode = umUserinfoReDomain.getUserinfoCode();
        if (StringUtils.isBlank((String)tenantCode) && !StringUtils.equals((CharSequence)umUserinfoReDomain.getTenantCode(), (CharSequence)"00000000")) {
            tenantCode = umUserinfoReDomain.getTenantCode();
        }
        if (StringUtils.isEmpty((String)tenantCode)) {
            throw new Exception("\u53c2\u6570\u9519\u8bef-\u79df\u6237\u672a\u5f00\u901a\uff01");
        }
        tmTmsceneDomain.setTenantCode(tenantCode);
        return tmTmsceneDomain;
    }

    private void saveProappCommon(TmTmsceneDomain tmTmsceneDomain, Map<String, Object> sortParam) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(sortParam));
        SupQueryResult queryTmProappPageForSc = (SupQueryResult)this.getInternalRouter().inInvoke("tm.scene.querySceneProappPage", paramsMap);
        if (null != queryTmProappPageForSc && CollectionUtils.isNotEmpty((Collection)queryTmProappPageForSc.getList())) {
            for (TmSceneProappDomain tmSceneProappDomain : queryTmProappPageForSc.getList()) {
                TmTmsceneProappDomain tmTmsceneProappDomain = new TmTmsceneProappDomain();
                tmTmsceneProappDomain.setSceneProappCode(tmSceneProappDomain.getSceneProappCode());
                tmTmsceneProappDomain.setSceneroleCode(tmSceneProappDomain.getSceneroleCode());
                tmTmsceneProappDomain.setSceneroleName(tmSceneProappDomain.getSceneroleName());
                tmTmsceneProappDomain.setProappCode(tmSceneProappDomain.getProappCode());
                tmTmsceneProappDomain.setProappName(tmSceneProappDomain.getProappName());
                tmTmsceneProappDomain.setTmsceneCode(tmTmsceneDomain.getTmsceneCode());
                tmTmsceneProappDomain.setProappSort(tmSceneProappDomain.getProappSort());
                if (null == tmTmsceneProappDomain) continue;
                if (CollectionUtils.isNotEmpty(tmTmsceneDomain.getTmTmsceneProappDomainList())) {
                    tmTmsceneDomain.getTmTmsceneProappDomainList().add(tmTmsceneProappDomain);
                }
                paramsMap.clear();
                paramsMap.put("tmTmsceneProappDomain", JsonUtil.buildNormalBinder().toJson((Object)tmTmsceneProappDomain));
                this.getInternalRouter().inInvoke("tm.Tmscene.saveTmsceneProapp", paramsMap);
            }
        }
    }

    private String executeRefresh(HwProductDomain hwProductDomain) throws JsonProcessingException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        try {
            String sceneApiCode = hwProductDomain.getInstanceId();
            paramsMap.put("sceneApiCode", sceneApiCode);
            paramsMap.put("tenantCode", "00000000");
            TmSceneApi tmSceneApi = (TmSceneApi)this.getInternalRouter().inInvoke("tm.scene.getSceneApiByCode", paramsMap);
            if (null == tmSceneApi) {
                this.logger.error(this.SYS_CODE + ".executeRefresh.getSceneApiByCode,tmSceneApi\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tsceneApiCode:" + sceneApiCode);
                return null;
            }
            String tmsceneCode = tmSceneApi.getSceneCode();
            OcContractDomain ocContractDomain = new OcContractDomain();
            ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
            OcContractGoodsDomain goods = new OcContractGoodsDomain();
            goods.setGoodsCode(tmsceneCode);
            goodsList.add(goods);
            ocContractDomain.setGoodsList(goodsList);
            ocContractDomain.setTenantCode("00000000");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Date expireTime = sdf.parse(hwProductDomain.getExpireTime());
            if (expireTime == null) {
                this.logger.error(this.SYS_CODE + ".executeRefresh.getExpireTime,\u8fc7\u671f\u65f6\u95f4\u975e\u6cd5\uff01 businessId:" + hwProductDomain.getBusinessId() + "\texpireTime:" + hwProductDomain.getExpireTime());
                return null;
            }
            long times = expireTime.getTime() - System.currentTimeMillis();
            int days = (int)Math.ceil((double)times / 8.64E7);
            ocContractDomain.setContractPumode("" + days);
            paramsMap.clear();
            paramsMap.put("ocContractDomain", ocContractDomain);
            String str = (String)this.getInternalRouter().inInvoke("tm.Tmscene.updateTmsceneByTmsceneEnd", paramsMap);
            if (!StringUtils.equals((CharSequence)"success", (CharSequence)str)) {
                this.logger.error(this.SYS_CODE + ".executeNew.updateTmsceneByTmsceneEnd,\u7eed\u8d39\u5931\u8d25\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tsceneApiCode:" + sceneApiCode + "\texpireTime:" + hwProductDomain.getExpireTime());
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".executeRefresh.e, businessId:" + hwProductDomain.getBusinessId(), (Throwable)e);
            return null;
        }
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String executeExpire(HwProductDomain hwProductDomain) throws JsonProcessingException {
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String executeRelease(HwProductDomain hwProductDomain) throws JsonProcessingException {
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String executeUpgrade(HwProductDomain hwProductDomain) throws JsonProcessingException {
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String buildNewInstance(String userName, String password, int encryptType, String instanceId, String adminUrl, String frontEndUrl, String memo) throws JsonProcessingException {
        this.mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        NewInstanceResp result = new NewInstanceResp();
        result.setResultMsg(ResultCodeEnum.SUCCESS.getResultMsg());
        result.setResultCode(ResultCodeEnum.SUCCESS.getResultCode());
        result.setEncryptType(encryptType);
        result.setInstanceId(instanceId);
        AppInfo appInfo = new AppInfo();
        appInfo.setAdminUrl(adminUrl);
        appInfo.setFrontEndUrl(frontEndUrl);
        appInfo.setMemo(memo);
        appInfo.setUserName(TokenUtils.encryptContent(userName, ACCESS_KEY, encryptType));
        appInfo.setPassword(TokenUtils.encryptContent(password, ACCESS_KEY, encryptType));
        result.setAppInfo(appInfo);
        return this.mapper.writeValueAsString((Object)result);
    }

    private String buildFailResponse(int httpStatus, String code, String message) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpStatus(httpStatus);
        BaseResp result = new BaseResp();
        result.setResultMsg(message);
        result.setResultCode(code);
        responseBean.setHttpBody(this.mapper.writeValueAsString((Object)result));
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private String buildSuccessResponse(String code, String message) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        BaseResp result = new BaseResp();
        result.setResultMsg(message);
        result.setResultCode(code);
        String bodyStr = this.mapper.writeValueAsString((Object)result);
        String signature = TokenUtils.generateResponseBodySignature(ACCESS_KEY, bodyStr);
        if (StringUtils.isEmpty((String)signature)) {
            return this.buildFailResponse(400, ResultCodeEnum.OTHER_INNER_ERROR.getResultCode(), ResultCodeEnum.OTHER_INNER_ERROR.getResultMsg());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put(BODY_SIGN_KEY, BODY_SIGN_VALUE.replace("{signature}", signature));
        headerMap.put(CONTENT_TYPE, "application/json;charset=UTF-8");
        responseBean.setHeaderMap(headerMap);
        responseBean.setHttpBody(bodyStr);
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private String buildSignatureResponse(String bodyStr) throws Exception {
        HttpResponseBean responseBean = new HttpResponseBean();
        String signature = TokenUtils.generateResponseBodySignature(ACCESS_KEY, bodyStr);
        if (StringUtils.isEmpty((String)signature)) {
            return this.buildFailResponse(400, ResultCodeEnum.OTHER_INNER_ERROR.getResultCode(), ResultCodeEnum.OTHER_INNER_ERROR.getResultMsg());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put(BODY_SIGN_KEY, BODY_SIGN_VALUE.replace("{signature}", signature));
        headerMap.put(CONTENT_TYPE, "application/json;charset=UTF-8");
        responseBean.setHeaderMap(headerMap);
        responseBean.setHttpBody(bodyStr);
        return this.mapper.writeValueAsString((Object)responseBean);
    }
}

