/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.hw.saas.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class TokenUtils {
    private static final String CHARSET = "UTF-8";
    private static final int AES256_CBC_PKCS5PADDING = 1;

    public static boolean verificationRequestParams(Map<String, String> paramsMap, String accessKey) {
        String key2;
        String authTokenArray;
        String timeStamp = null;
        String authToken = null;
        String timeStampArray = paramsMap.get("timeStamp");
        if (StringUtils.isNotBlank((CharSequence)timeStampArray)) {
            timeStamp = timeStampArray;
        }
        if (StringUtils.isNotBlank((CharSequence)(authTokenArray = paramsMap.get("authToken")))) {
            authToken = authTokenArray;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(paramsMap);
        sortedMap.remove("authToken");
        StringBuilder strBuffer = new StringBuilder();
        Set keySet = sortedMap.keySet();
        for (String key2 : keySet) {
            String value = (String)sortedMap.get(key2);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            strBuffer.append("&").append(key2).append("=").append(value);
        }
        String reqParams = strBuffer.toString().substring(1);
        key2 = accessKey + timeStamp;
        String signature = null;
        try {
            signature = TokenUtils.generateResponseBodySignature(key2, reqParams);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)authToken) && authToken.equals(signature);
    }

    public static String generateResponseBodySignature(String key, String body) {
        return TokenUtils.base_64(TokenUtils.hmacSHA256(key, body));
    }

    public static byte[] hmacSHA256(String macKey, String macData) {
        try {
            SecretKeySpec secret = new SecretKeySpec(macKey.getBytes(CHARSET), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secret);
            return mac.doFinal(macData.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            return new byte[0];
        }
    }

    public static String encryptContent(String content, String accessKey, int encryptType) {
        String iv = TokenUtils.getRandomChars(16);
        int keySize = 1 == encryptType ? 256 : 128;
        String isvEncryptBody = TokenUtils.encryptAESCBCEncode(content, accessKey, iv, keySize);
        return iv + isvEncryptBody;
    }

    public static String encryptAESCBCEncode(String content, String key, String iv, int keySize) {
        if (StringUtils.isEmpty((CharSequence)content) || StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)iv)) {
            return null;
        }
        try {
            byte[] encrypContent = TokenUtils.encryptAESCBC(content.getBytes(CHARSET), key.getBytes(CHARSET), iv.getBytes(CHARSET), keySize);
            if (null != encrypContent) {
                return TokenUtils.base_64(encrypContent);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] encryptAESCBC(byte[] content, byte[] keyBytes, byte[] iv, int keySize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(keyBytes);
            keyGenerator.init(keySize, secureRandom);
            SecretKey key = keyGenerator.generateKey();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String base_64(byte[] bytes) {
        try {
            return new String(Base64.encodeBase64((byte[])bytes), CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String decryptContent(String encryptStr, String accessKey, int encryptType) {
        if (StringUtils.isEmpty((CharSequence)encryptStr)) {
            return null;
        }
        String iv = encryptStr.substring(0, 16);
        int keySize = 1 == encryptType ? 256 : 128;
        String decryptBody = null;
        try {
            decryptBody = TokenUtils.decryptAESCBCEncode(encryptStr.substring(16), accessKey, iv, keySize);
        }
        catch (Exception e) {
            return null;
        }
        return decryptBody;
    }

    public static String decryptAESCBCEncode(String content, String key, String iv, int keySize) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (StringUtils.isEmpty((CharSequence)content) || StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)iv)) {
            return null;
        }
        return new String(TokenUtils.decryptAESCBC(Base64.decodeBase64((byte[])content.getBytes()), key.getBytes(), iv.getBytes(), keySize));
    }

    public static byte[] decryptAESCBC(byte[] content, byte[] keyBytes, byte[] iv, int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyBytes);
        keyGenerator.init(keySize, secureRandom);
        SecretKey key = keyGenerator.generateKey();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        return cipher.doFinal(content);
    }

    public static String getRandomChars(int length) {
        StringBuilder randomCharsBuf = new StringBuilder(1024);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            if (random.nextInt(2) % 2 == 0) {
                int letterIndex = random.nextInt(2) % 2 == 0 ? 65 : 97;
                randomCharsBuf.append((char)(random.nextInt(26) + letterIndex));
                continue;
            }
            randomCharsBuf.append(random.nextInt(10));
        }
        return randomCharsBuf.toString();
    }

    public static String decryptSaasExtendParams(String saasExtendParams) {
        String decryptStr = null;
        try {
            decryptStr = new String(Base64.decodeBase64((String)saasExtendParams), CHARSET);
            return URLDecoder.decode(decryptStr, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

