/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.hw.saas.service.impl;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.HttpResponseBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.hw.saas.common.constant.ResultCodeEnum;
import com.yqbsoft.laser.service.hw.saas.domain.AppInfo;
import com.yqbsoft.laser.service.hw.saas.domain.BaseResp;
import com.yqbsoft.laser.service.hw.saas.domain.HwProductDomain;
import com.yqbsoft.laser.service.hw.saas.domain.NewInstanceResp;
import com.yqbsoft.laser.service.hw.saas.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.hw.saas.domain.OcContractDomain;
import com.yqbsoft.laser.service.hw.saas.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.hw.saas.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.hw.saas.domain.OcPackageDomain;
import com.yqbsoft.laser.service.hw.saas.domain.OrderDomain;
import com.yqbsoft.laser.service.hw.saas.domain.PackageDomain;
import com.yqbsoft.laser.service.hw.saas.domain.TmScene;
import com.yqbsoft.laser.service.hw.saas.domain.TmSceneProapp;
import com.yqbsoft.laser.service.hw.saas.domain.TmSceneProappDomain;
import com.yqbsoft.laser.service.hw.saas.domain.TmTmsceneDomain;
import com.yqbsoft.laser.service.hw.saas.domain.TmTmsceneProappDomain;
import com.yqbsoft.laser.service.hw.saas.domain.TypeBean;
import com.yqbsoft.laser.service.hw.saas.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.hw.saas.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.hw.saas.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.hw.saas.service.HwSaasService;
import com.yqbsoft.laser.service.hw.saas.service.UserService;
import com.yqbsoft.laser.service.hw.saas.utils.DecryptUtils;
import com.yqbsoft.laser.service.hw.saas.utils.TokenUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class HwSaasServiceImpl
extends BaseServiceImpl
implements HwSaasService {
    private static final int ENCRYPT_TYPE = 1;
    private static final String ACCESS_KEY = "7721336f-6319-4023-93eb-188751b9a099";
    private static final String BODY_SIGN_KEY = "Body-Sign";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String BODY_SIGN_VALUE = "sign_type=\"HMAC-SHA256\", signature= \"{signature}\"";
    private static final String REDIS_REQUEST_KEY = "PASS-HWSAAS_REQUEST_BUSINESSID";
    private static final String expireTime = "yyyyMMddHHmmss";
    ObjectMapper mapper = new ObjectMapper();
    private String SYS_CODE = "hwSaas.HwSaasServiceImpl";
    private String oauthEnvCode = "web";
    private String proappcode = "B02";
    @Autowired
    private UserService userService;
    String CACHE_KEY_CFLOW = "ocProtCflow";

    @Override
    public String productInterface(String instanceId, String activity, String customerId, String customerName, String userId, String userName, String mobilePhone, String email, String businessId, String orderId, String skuCode, String productId, String testFlag, String trialFlag, String expireTime, String chargingMode, String saasExtendParams, Integer amount, Integer diskSize, Integer bandWidth, String periodType, Integer periodNumber, BigDecimal orderAmount, Integer provisionType, String acceptanceTime, String timeStamp, String authToken) throws IOException {
        HwProductDomain hwProductDomain = this.makeHwProductDomain(instanceId, activity, customerId, customerName, userId, userName, mobilePhone, email, businessId, orderId, skuCode, productId, testFlag, trialFlag, expireTime, chargingMode, saasExtendParams, amount, diskSize, bandWidth, periodType, periodNumber, orderAmount, provisionType, acceptanceTime, timeStamp, authToken);
        if (null == hwProductDomain || StringUtils.isBlank((String)hwProductDomain.getBusinessId())) {
            this.logger.error(this.SYS_CODE + ".productInterface", (Object)"param or businessId is null");
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
        }
        String jsonStr = JSONObject.toJSONString((Object)hwProductDomain);
        this.logger.info(this.SYS_CODE + ".productInterface,param=" + jsonStr);
        Map paramsMap = (Map)JSONObject.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        boolean verificationResult = TokenUtils.verificationRequestParams(paramsMap, ACCESS_KEY);
        if (!verificationResult) {
            this.logger.error(this.SYS_CODE + ".productInterface token is invalid ----", (Object)jsonStr);
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_TOKEN.getResultCode(), ResultCodeEnum.INVALID_TOKEN.getResultMsg());
        }
        String mobilePhoneDes = DecryptUtils.decryptMobilePhoneOrEMail(ACCESS_KEY, hwProductDomain.getMobilePhone(), 256);
        if (StringUtils.isEmpty((String)mobilePhoneDes)) {
            this.logger.error(this.SYS_CODE + ".productInterface MobilePhone is invalid ----", (Object)jsonStr);
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_TOKEN.getResultCode(), ResultCodeEnum.INVALID_TOKEN.getResultMsg());
        }
        hwProductDomain.setMobilePhone(mobilePhoneDes);
        if (this.isRepeatRequest(hwProductDomain.getBusinessId())) {
            this.logger.error(this.SYS_CODE + ".productInterface", (Object)("\u91cd\u590d\u8bf7\u6c42\uff0c\u4e0d\u4e88\u5904\u7406\uff01businessId:" + hwProductDomain.getBusinessId()));
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), "repeat businessId");
        }
        String responsStr = null;
        if (StringUtils.equals((CharSequence)"newInstance", (CharSequence)activity)) {
            if (StringUtils.isBlank((String)hwProductDomain.getMobilePhone())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("mobile is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            if (StringUtils.isBlank((String)hwProductDomain.getSkuCode())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("skuCode is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            responsStr = this.executeNew(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"refreshInstance", (CharSequence)activity)) {
            if (StringUtils.isBlank((String)hwProductDomain.getProductId())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("productId is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            if (StringUtils.isBlank((String)hwProductDomain.getExpireTime())) {
                this.logger.error(this.SYS_CODE + ".productInterface", (Object)("expireTime is null,businessId:" + hwProductDomain.getBusinessId()));
                return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg());
            }
            responsStr = this.executeRefresh(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"expireInstance", (CharSequence)activity)) {
            responsStr = this.executeExpire(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"releaseInstance", (CharSequence)activity)) {
            responsStr = this.executeRelease(hwProductDomain);
        } else if (StringUtils.equals((CharSequence)"upgrade", (CharSequence)activity)) {
            responsStr = this.executeUpgrade(hwProductDomain);
        } else {
            return this.buildFailResponse(400, ResultCodeEnum.INVALID_PARAM.getResultCode(), "activity error");
        }
        if (StringUtils.isBlank((String)responsStr)) {
            return this.buildFailResponse(400, ResultCodeEnum.OTHER_INNER_ERROR.getResultCode(), "system error");
        }
        return responsStr;
    }

    private HwProductDomain makeHwProductDomain(String instanceId, String activity, String customerId, String customerName, String userId, String userName, String mobilePhone, String email, String businessId, String orderId, String skuCode, String productId, String testFlag, String trialFlag, String expireTime, String chargingMode, String saasExtendParams, Integer amount, Integer diskSize, Integer bandWidth, String periodType, Integer periodNumber, BigDecimal orderAmount, Integer provisionType, String acceptanceTime, String timeStamp, String authToken) {
        HwProductDomain hwProductDomain = new HwProductDomain();
        hwProductDomain.setInstanceId(instanceId);
        hwProductDomain.setActivity(activity);
        hwProductDomain.setCustomerId(customerId);
        hwProductDomain.setCustomerName(customerName);
        hwProductDomain.setUserId(userId);
        hwProductDomain.setUserName(userName);
        hwProductDomain.setMobilePhone(mobilePhone);
        hwProductDomain.setEmail(email);
        hwProductDomain.setBusinessId(businessId);
        hwProductDomain.setOrderId(orderId);
        hwProductDomain.setSkuCode(skuCode);
        hwProductDomain.setProductId(productId);
        hwProductDomain.setTestFlag(testFlag);
        hwProductDomain.setTrialFlag(trialFlag);
        hwProductDomain.setExpireTime(expireTime);
        hwProductDomain.setChargingMode(chargingMode);
        hwProductDomain.setSaasExtendParams(saasExtendParams);
        hwProductDomain.setAmount(amount);
        hwProductDomain.setDiskSize(diskSize);
        hwProductDomain.setBandWidth(bandWidth);
        hwProductDomain.setPeriodType(periodType);
        hwProductDomain.setPeriodNumber(periodNumber);
        hwProductDomain.setOrderAmount(orderAmount);
        hwProductDomain.setProvisionType(provisionType);
        hwProductDomain.setAcceptanceTime(acceptanceTime);
        hwProductDomain.setTimeStamp(timeStamp);
        hwProductDomain.setAuthToken(authToken);
        return hwProductDomain;
    }

    private String getSceneCode(String tenantCode, String productId, String skuCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)productId) || StringUtils.isBlank((String)skuCode)) {
            return null;
        }
        String field = "00000000".concat("-").concat(productId).concat("-").concat(skuCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isBlank((String)value)) {
            this.logger.error(this.SYS_CODE + ".getSceneCode.value", (Object)(" productId:" + productId + " ;skuCode:" + skuCode));
            return null;
        }
        return value;
    }

    private String executeNew(HwProductDomain hwProductDomain) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        try {
            String mobile = hwProductDomain.getMobilePhone();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userPhone", mobile);
            map.put("tenantCode", "00000000");
            paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            UmUserReDomainBean umUserReDomainBean = null;
            String umUserReDomainBeanStr = (String)this.getInternalRouter().inInvoke("um.user.getUserByNameOrPhone", paramsMap);
            String userinfoCode = null;
            if (!StringUtils.isEmpty((String)umUserReDomainBeanStr)) {
                this.logger.error("\u79df\u6237\u5df2\u5f00\u901a\u6682\u4e0d\u8003\u8651");
                return null;
            }
            UmUserDomainBean umUserDomainBean = this.getUmUserDomainBean(hwProductDomain);
            paramsMap.clear();
            paramsMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            userinfoCode = (String)this.getInternalRouter().inInvoke("um.user.sendOpenUserinfo", paramsMap);
            paramsMap.clear();
            paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            umUserReDomainBeanStr = (String)this.getInternalRouter().inInvoke("um.user.getUserByNameOrPhone", paramsMap);
            umUserReDomainBean = (UmUserReDomainBean)JsonUtil.buildNonNullBinder().getJsonToObject(umUserReDomainBeanStr, UmUserReDomainBean.class);
            this.updateOpenUserinfoModelByCode(userinfoCode, "00000000", 1, 2);
            paramsMap.clear();
            paramsMap.put("userinfoCode", userinfoCode);
            paramsMap.put("tenantCode", "00000000");
            String umUserinfoReDomainStr = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByCode", paramsMap);
            if (StringUtils.isEmpty((String)umUserinfoReDomainStr)) {
                this.logger.error(this.SYS_CODE + ".executeNew.getUserinfoByCode,Userinfo\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tuserPcode:" + umUserReDomainBean.getUserPcode());
                return null;
            }
            UmUserinfoReDomainBean umUserinfoReDomain = (UmUserinfoReDomainBean)JsonUtil.buildNonNullBinder().getJsonToObject(umUserinfoReDomainStr, UmUserinfoReDomainBean.class);
            if (0 != umUserinfoReDomain.getDataState()) {
                this.logger.error(this.SYS_CODE + ".executeNew.getUserinfoByCode,\u79df\u6237\u72b6\u6001\u65e0\u6548\uff01 businessId:" + hwProductDomain.getBusinessId() + "\tuserPcode:" + umUserReDomainBean.getUserPcode());
                return null;
            }
            String value = this.getSceneCode("0", hwProductDomain.getProductId(), hwProductDomain.getSkuCode());
            if (StringUtils.isBlank((String)value)) {
                this.logger.error(this.SYS_CODE + ".executeNew.value", (Object)(" businessId:" + hwProductDomain.getBusinessId() + "skuCode:" + hwProductDomain.getSkuCode()));
                return null;
            }
            paramsMap.clear();
            paramsMap.put("tenantCode", "00000000");
            paramsMap.put("sceneCode", value);
            String tmSceneStr = (String)this.getInternalRouter().inInvoke("tm.scene.getSceneByCode", paramsMap);
            if (StringUtils.isEmpty((String)tmSceneStr)) {
                this.logger.error(this.SYS_CODE + ".executeNew.getSceneByCode", (Object)("sceneCode\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "skuCode:" + hwProductDomain.getSkuCode()));
                return null;
            }
            TmScene tmScene = (TmScene)JsonUtil.buildNonNullBinder().getJsonToObject(tmSceneStr, TmScene.class);
            if (StringUtils.isBlank((String)tmScene.getSceneroleCode())) {
                this.logger.error(this.SYS_CODE + ".executeNew.getSceneByCode", (Object)("sceneCode\u5bf9\u5e94\u7684sceneroleCode\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "skuCode:" + hwProductDomain.getSkuCode()));
                return null;
            }
            map.clear();
            map.put("fuzzy", false);
            map.put("tenantCode", "00000000");
            map.put("proappSort", "2");
            map.put("sceneroleCode", tmScene.getSceneroleCode());
            paramsMap.clear();
            paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            String proappResultStr = (String)this.getInternalRouter().inInvoke("tm.scene.querySceneProappPage", paramsMap);
            if (StringUtils.isEmpty((String)proappResultStr)) {
                this.logger.error(this.SYS_CODE + ".executeNew.querySceneProappPage", (Object)("skuCode\u5bf9\u5e94\u7684\u4ea7\u54c1\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "skuCode:" + hwProductDomain.getSkuCode()));
                return null;
            }
            QueryResult proappResult = (QueryResult)JsonUtil.buildNonNullBinder().getJsonToObject(proappResultStr, QueryResult.class);
            this.logger.error("proappResultStr", (Object)JsonUtil.buildNonNullBinder().toJson((Object)proappResult));
            List tmSceneProappList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)proappResult.getList()), TmSceneProapp.class);
            if (CollectionUtils.isEmpty((Collection)tmSceneProappList)) {
                this.logger.error(this.SYS_CODE + ".executeNew.querySceneProappPage", (Object)("skuCode\u5bf9\u5e94\u7684\u96c6\u5408\u6570\u636e\u4e0d\u5b58\u5728\uff01 businessId:" + hwProductDomain.getBusinessId() + "skuCode:" + hwProductDomain.getSkuCode()));
                return null;
            }
            TmTmsceneDomain tmTmsceneDomain = this.getTmTmsceneDomain(umUserinfoReDomain, tmScene, tmSceneProappList);
            if (StringUtils.isEmpty((String)hwProductDomain.getExpireTime())) {
                tmTmsceneDomain.setTmsceneEnd(DateUtils.addDays((Date)new Date(), (int)15));
            } else {
                tmTmsceneDomain.setTmsceneEnd(DateUtils.getDateToString((String)hwProductDomain.getExpireTime(), (String)expireTime));
            }
            tmTmsceneDomain.setMemberCode(umUserReDomainBean.getUserPcode());
            tmTmsceneDomain.setMemberName(umUserReDomainBean.getUserName());
            tmTmsceneDomain.setUserCode(userinfoCode);
            tmTmsceneDomain.setUserName(mobile);
            String domainUrl = tmTmsceneDomain.getTenantCode() + ".qjclouds.com";
            if (tmTmsceneDomain.getSceneType().equals("op")) {
                String tmsceneConf = tmTmsceneDomain.getTmsceneConf();
                Map<String, String> mapp = null;
                if (StringUtils.isBlank((String)tmsceneConf)) {
                    mapp = new HashMap<String, String>();
                    mapp.put("mallName", "\u5343\u5320\u9ed8\u8ba4\u5546\u94fa");
                    mapp.put("domain", domainUrl);
                    mapp.put("logo", "/paas/shop/00000000/2022-03-31/3327c701b67640b5bc217e35defc8890.jpg");
                    mapp.put("mallUser", "\u5343\u5320\u9ed8\u8ba4\u5546\u94fa" + tmScene.getSceneroleName());
                    mapp.put("managerPhone", mobile);
                    mapp.put("userPwsswd", "123456");
                } else {
                    mapp = (Map)JsonUtil.buildNormalBinder().getJsonToMap(tmsceneConf, String.class, String.class);
                }
                tmTmsceneDomain.setTmsceneConf(JsonUtil.buildNormalBinder().toJson(mapp));
                HashMap<String, Object> sortParam = new HashMap<String, Object>();
                sortParam.put("tenantCode", tmTmsceneDomain.getTenantCode());
                sortParam.put("order", true);
                sortParam.put("fuzzy", true);
                sortParam.put("proappSort", "0");
                sortParam.put("sceneroleCode", tmTmsceneDomain.getSceneroleCode());
                this.saveProappCommon(tmTmsceneDomain, sortParam);
                sortParam.put("proappSort", "1");
                this.saveProappCommon(tmTmsceneDomain, sortParam);
                tmTmsceneDomain.setTmsceneCode(this.getNo(null, "TmTmscene", "tmTmscene", tmTmsceneDomain.getTmsceneCode()));
            }
            paramsMap.clear();
            paramsMap.put("tmTmsceneDomain", JsonUtil.buildNormalBinder().toJson((Object)tmTmsceneDomain));
            String sceneApiCode = (String)this.getInternalRouter().inInvoke("tm.tenantbase.sendSaveTmscene", paramsMap);
            HashMap<String, String> queryTmscenePageMap = new HashMap<String, String>();
            queryTmscenePageMap.put("tmsceneCode", tmTmsceneDomain.getTmsceneCode());
            String queryTmscenePageRes = (String)this.getInternalRouter().inInvoke("tm.Tmscene.queryTmscenePage", queryTmscenePageMap);
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryTmscenePageRes, SupQueryResult.class);
            if (supQueryResult == null || CollectionUtils.isEmpty((Collection)supQueryResult.getList())) {
                this.logger.error(this.SYS_CODE + ".executeNew.getUserinfoByCode,queryTmscenePage\uff01 tmsceneCode:" + hwProductDomain.getBusinessId() + "\tuserPcode:" + umUserReDomainBean.getUserPcode());
                return null;
            }
            this.createOrder(tmTmsceneDomain, hwProductDomain);
            String instanceId = sceneApiCode;
            String userName = mobile;
            String password = "123456";
            String adminUrl = "https://appshop.saas.qjclouds.com/";
            String frontEndUrl = domainUrl;
            String memo = "\u8be5\u5bc6\u7801\u4e3a\u4ea7\u54c1\u5bc6\u7801\uff0c\u79df\u6237\u5bc6\u7801\u89c1\u77ed\u4fe1";
            String bodyStr = this.buildNewInstance(userName, password, 1, instanceId, adminUrl, frontEndUrl, memo);
            return this.buildSignatureResponse(bodyStr);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".executeNew.e", (Object)(" businessId:" + hwProductDomain.getBusinessId()), (Throwable)e);
            return null;
        }
    }

    private void createOrder(TmTmsceneDomain tmTmsceneDomain, HwProductDomain hwProductDomain) {
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = "10";
        HashMap<String, String> map = new HashMap<String, String>();
        TypeBean typeBean = this.getOcSetting(shoppingType, tmTmsceneDomain.getTenantCode());
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractPumode(tmTmsceneDomain.getSceneDeposittype());
        orderDomain.setContractType(shoppingType);
        orderDomain.setGoodsReceiptMem(hwProductDomain.getCustomerName());
        orderDomain.setGoodsReceiptPhone(hwProductDomain.getMobilePhone());
        orderDomain.setContractNbillcode(tmTmsceneDomain.getTmsceneCode());
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        if (StringUtils.isNotBlank((String)tmTmsceneDomain.getEndDate())) {
            orderDomain.setContractEffectivedate(DateUtils.getDateToString((String)tmTmsceneDomain.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        packageDomain.setMemberCode(tmTmsceneDomain.getMemberCode());
        packageDomain.setMemberName(tmTmsceneDomain.getMemberCode());
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        contractGoodsList.add(ocContractGoodsDomain);
        ocContractGoodsDomain.setAppmanageIcode(this.proappcode);
        ocContractGoodsDomain.setContractGoodsGtype("0");
        ocContractGoodsDomain.setContractGoodsInmoney(tmTmsceneDomain.getTmsceneDepositamt());
        ocContractGoodsDomain.setContractGoodsMoney(tmTmsceneDomain.getTmsceneDepositamt());
        ocContractGoodsDomain.setContractGoodsPrice(tmTmsceneDomain.getTmsceneDepositamt());
        ocContractGoodsDomain.setPricesetNprice(tmTmsceneDomain.getTmsceneDepositamt());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsName(tmTmsceneDomain.getSceneName());
        ocContractGoodsDomain.setGoodsNo(tmTmsceneDomain.getTmsceneCode());
        ocContractGoodsDomain.setGoodsCode(tmTmsceneDomain.getTmsceneCode());
        ocContractGoodsDomain.setSkuCode(tmTmsceneDomain.getTmsceneCode());
        ocContractGoodsDomain.setSkuNo(tmTmsceneDomain.getTmsceneCode());
        ocContractGoodsDomain.setSkuName(tmTmsceneDomain.getSceneName());
        ocContractGoodsDomain.setMemberBcode(tmTmsceneDomain.getMemberCode());
        ocContractGoodsDomain.setMemberBname(tmTmsceneDomain.getMemberName());
        ocContractGoodsDomain.setMemberCode(tmTmsceneDomain.getMemberCode());
        ocContractGoodsDomain.setMemberName(tmTmsceneDomain.getMemberCode());
        map.put("contractType", shoppingType);
        this.createOcOrder(orderDomain, shoppingType);
    }

    private void createOcOrder(OrderDomain orderDomain, String contractType) {
        long start = System.currentTimeMillis();
        ArrayList shoppingGoodsIdList = new ArrayList();
        OcContractDomain contractDomain = new OcContractDomain();
        try {
            this.makeaddress(orderDomain);
            contractDomain = this.makeContractDomain(orderDomain, contractType);
            if (StringUtils.isBlank((String)contractDomain.getContractProperty())) {
                contractDomain.setContractProperty("0");
            }
            contractDomain.setPackageList(this.makePackageDomain(contractDomain));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".createOcOrder.ex", (Throwable)e);
        }
        this.logger.info("ocContractDomain+++", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
        this.calculateContract(contractDomain);
        this.logger.info("ocContractDomain---", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
        HashMap result = new HashMap();
        this.logger.error("ocContractDomain===", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractDomain));
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("ocContractDomain", contractDomain);
        map.put("shoppingGoodsIdList", shoppingGoodsIdList);
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.getInternalRouter().inInvoke("oc.shopping.sendContractByDel", paramsMap);
        long end = System.currentTimeMillis();
        this.logger.info("=====createOcOrder=====", (Object)(end - start));
    }

    public void calculateContract(OcContractDomain contractDomain) {
        BigDecimal goodsNum = BigDecimal.ONE;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ONE;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        String memberCode = "";
        boolean teflag = false;
        for (OcPackageDomain ocPackageDomain : contractDomain.getPackageList()) {
            if (StringUtils.isBlank((String)memberCode)) {
                memberCode = ocPackageDomain.getMemberCode();
            } else if (!memberCode.equals(ocPackageDomain.getMemberCode())) {
                teflag = true;
            }
            contractDomain.setMemberCode(ocPackageDomain.getMemberCode());
            contractDomain.setMemberName(ocPackageDomain.getMemberName());
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            goodsNum = goodsNum.add(ocPackageDomain.getGoodsNum());
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            goodsWeight = goodsWeight.add(ocPackageDomain.getGoodsWeight());
            if (null == ocPackageDomain.getGoodsMoney()) {
                ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            if (null == ocPackageDomain.getPackageFare()) {
                ocPackageDomain.setPackageFare(BigDecimal.ZERO.toString());
            }
            contractInmoney = contractInmoney.add(ocPackageDomain.getGoodsMoney());
            goodsLogmoney = goodsLogmoney.add(new BigDecimal(ocPackageDomain.getPackageFare()));
            if (null == ocPackageDomain.getGoodsPmoney()) {
                ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            contractMoney = contractMoney.add(ocPackageDomain.getGoodsPmoney());
            if (null == ocPackageDomain.getPricesetRefrice()) {
                ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            pefMoney = pefMoney.add(ocPackageDomain.getPricesetRefrice());
            if (null == ocPackageDomain.getGoodsPacgemoney()) {
                ocPackageDomain.setGoodsPacgemoney(BigDecimal.ZERO);
            }
            pacgeMoney = pacgeMoney.add(ocPackageDomain.getGoodsPacgemoney());
        }
        if (ListUtil.isNotEmpty(contractDomain.getPackageList()) && contractDomain.getPackageList().size() == 1 && StringUtils.isBlank((String)contractDomain.getContractRemark())) {
            contractDomain.setContractRemark(contractDomain.getPackageList().get(0).getPackageRemark());
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        List<OcContractSettlDomain> ocContractSettlDomainList = contractDomain.getOcContractSettlList();
        if (null == ocContractSettlDomainList) {
            ocContractSettlDomainList = new ArrayList<OcContractSettlDomain>();
        }
        if (null == contractDomain.getContractPaymoney()) {
            contractDomain.setContractPaymoney(BigDecimal.ZERO);
        }
        contractDomain.setContractPaymoney(contractDomain.getContractPaymoney().add(pacgeMoney));
        contractDomain.setOcContractSettlList(ocContractSettlDomainList);
        contractDomain.setPricesetRefrice(pefMoney);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setGoodsMoney(contractMoney);
        if (contractDomain.isFreeFlag()) {
            goodsLogmoney = BigDecimal.ZERO;
        }
        contractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        if ("06".equals(contractDomain.getContractType()) || "28".equals(contractDomain.getContractType())) {
            contractDomain.setDataBmoney(contractMoney.add(goodsLogmoney).add(contractDomain.getContractPaymoney()));
        } else {
            contractDomain.setDataBmoney(contractMoney.add(goodsLogmoney).add(pefMoney).add(contractDomain.getContractPaymoney()));
        }
        contractDomain.setGoodsLogmoney(goodsLogmoney);
        contractDomain.setGoodsPmoney(contractInmoney.subtract(contractMoney));
        TypeBean typeBean = this.getOcSetting(contractDomain.getContractType(), contractDomain.getTenantCode());
        contractDomain.setDataBmoney(BigDecimal.ZERO);
        contractDomain.setContractTypepro("0");
        contractDomain.setContractTypepro("10");
        contractDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
        contractDomain.setMemberName(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
    }

    private List<OcPackageDomain> makePackageDomain(OcContractDomain ocContractDomain) {
        ArrayList<OcPackageDomain> list = new ArrayList<OcPackageDomain>();
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        ocPackageDomain.setPackageCode(this.createUUIDString());
        ocPackageDomain.setMemberCode(ocContractDomain.getMemberCode());
        ocPackageDomain.setMemberName(ocContractDomain.getMemberName());
        ocPackageDomain.setMemberBname(ocContractDomain.getMemberBname());
        ocPackageDomain.setMemberCcode(ocContractDomain.getMemberCcode());
        ocPackageDomain.setMemberCname(ocContractDomain.getMemberCname());
        ocPackageDomain.setContractPumode("365");
        ocPackageDomain.setContractType(ocContractDomain.getContractType());
        ocPackageDomain.setContractTypepro(ocContractDomain.getContractTypepro());
        ocPackageDomain.setGoodsPacgemoney(BigDecimal.ZERO);
        ocPackageDomain.setPackageFare("0");
        ocPackageDomain.setGoodsInmoney(BigDecimal.ZERO);
        ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
        ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
        ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
        ocPackageDomain.setGoodsNum(BigDecimal.ONE);
        ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
        ocPackageDomain.setAppmanageIcode(this.proappcode);
        ocPackageDomain.setTenantCode("00000000");
        list.add(ocPackageDomain);
        return list;
    }

    private OcContractDomain makeContractDomain(OrderDomain orderDomain, String contractType) {
        OcContractDomain contractDomain = new OcContractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
        }
        catch (Exception e) {
            this.logger.error("OcService.makeContractDomain.ex", (Throwable)e);
            return null;
        }
        contractDomain.setContractType(contractType);
        TypeBean typeBean = this.getOcSetting(contractDomain.getContractType(), contractDomain.getTenantCode());
        if (null != typeBean) {
            if (StringUtils.isBlank((String)contractDomain.getContractBlance())) {
                contractDomain.setContractBlance(typeBean.getBlance());
            }
            if (StringUtils.isBlank((String)contractDomain.getContractPmode())) {
                contractDomain.setContractPmode(typeBean.getPmode());
            }
            if (StringUtils.isNotBlank((String)typeBean.getCheckGoods())) {
                contractDomain.setCheckGoods(typeBean.getCheckGoods());
            }
        }
        this.createPackageDomainListOnOrder_temp(orderDomain);
        contractDomain.setTenantCode("00000000");
        contractDomain.setAppmanageIcode(this.proappcode);
        contractDomain.setContractUserurl("https://baidu.com/");
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    private List<PackageDomain> createPackageDomainListOnOrder_temp(OrderDomain orderDomain) {
        PackageDomain packageDomain;
        List<PackageDomain> packageDomainList = orderDomain.getPackageList();
        if (packageDomainList != null) {
            return packageDomainList;
        }
        packageDomainList = new ArrayList<PackageDomain>();
        if (packageDomainList.isEmpty()) {
            packageDomain = new PackageDomain();
            packageDomainList.add(packageDomain);
            orderDomain.setPackageList(packageDomainList);
        } else {
            packageDomain = packageDomainList.get(0);
        }
        if (StringUtils.isNotBlank((String)orderDomain.getPackageMode())) {
            packageDomain.setPackageMode(orderDomain.getPackageMode());
        } else {
            packageDomain.setPackageMode("0");
        }
        packageDomain.setShoppingGoodsIdList(orderDomain.getShoppingGoodsIdList());
        packageDomain.setSkuIdList(orderDomain.getSkuIdList());
        return packageDomainList;
    }

    private void makeaddress(OrderDomain orderDomain) {
        orderDomain.setGoodsReceiptMem(orderDomain.getGoodsReceiptMem());
        orderDomain.setGoodsReceiptArrdess("\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\u5b9e\u9645\u5927\u9053\u4e00\u53f7");
        orderDomain.setGoodsReceiptPhone(orderDomain.getGoodsReceiptPhone());
        orderDomain.setAreaCode("200100");
    }

    public TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    private void updateOpenUserinfoModelByCode(String userinfoCode, String tenantCode, Integer userinfoState, Integer oldUserinfoState) {
        HtmlJsonReBean htmlJsonReBean = this.userService.updateOpenUserinfoModelByCode(userinfoCode, tenantCode, userinfoState, oldUserinfoState);
        this.logger.error("updateOpenUserinfoModelByCode.res", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)htmlJsonReBean));
    }

    private UmUserDomainBean getUmUserDomainBean(HwProductDomain hwProductDomain) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserName(hwProductDomain.getCustomerName());
        umUserDomainBean.setUserPhone(hwProductDomain.getMobilePhone());
        umUserDomainBean.setUserPwsswd("123456");
        umUserDomainBean.setUserRelname(hwProductDomain.getCustomerName());
        umUserDomainBean.setUserinfoQuality("tenant");
        umUserDomainBean.setUserinfoInvite(null);
        umUserDomainBean.setUserinfoDiscode(null);
        umUserDomainBean.setTenantCode("00000000");
        umUserDomainBean.setUserinfoType(1);
        umUserDomainBean.setUserinfoCompname(hwProductDomain.getCustomerName());
        return umUserDomainBean;
    }

    private TmTmsceneDomain getTmTmsceneDomain(UmUserinfoReDomainBean umUserinfoReDomain, TmScene tmScene, List<TmSceneProapp> proappList) throws Exception {
        TmTmsceneDomain tmTmsceneDomain = new TmTmsceneDomain();
        org.springframework.beans.BeanUtils.copyProperties((Object)tmScene, (Object)tmTmsceneDomain);
        ArrayList<TmTmsceneProappDomain> tmsceneProappDomainList = new ArrayList<TmTmsceneProappDomain>();
        for (TmSceneProapp proapp : proappList) {
            TmTmsceneProappDomain proappDomain = new TmTmsceneProappDomain();
            org.springframework.beans.BeanUtils.copyProperties((Object)proapp, (Object)proappDomain);
            tmsceneProappDomainList.add(proappDomain);
        }
        tmTmsceneDomain.setTmTmsceneProappDomainList(tmsceneProappDomainList);
        String tenantCode = umUserinfoReDomain.getUserinfoCode();
        if (StringUtils.isBlank((String)tenantCode) && !StringUtils.equals((CharSequence)umUserinfoReDomain.getTenantCode(), (CharSequence)"00000000")) {
            tenantCode = umUserinfoReDomain.getTenantCode();
        }
        if (StringUtils.isEmpty((String)tenantCode)) {
            throw new Exception("\u53c2\u6570\u9519\u8bef-\u79df\u6237\u672a\u5f00\u901a\uff01");
        }
        String dataTenant = SupDisUtil.getMap((String)"tmtenant-mem-code", (String)umUserinfoReDomain.getUserinfoCode());
        tmTmsceneDomain.setTenantCode("00000000");
        tmTmsceneDomain.setTmsceneTenant(dataTenant);
        return tmTmsceneDomain;
    }

    private void saveProappCommon(TmTmsceneDomain tmTmsceneDomain, Map<String, Object> sortParam) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(sortParam));
        String queryTmProappPageForScStr = (String)this.getInternalRouter().inInvoke("tm.scene.querySceneProappPage", paramsMap);
        if (StringUtils.isEmpty((String)queryTmProappPageForScStr)) {
            return;
        }
        SupQueryResult queryTmProappPageForSc = (SupQueryResult)JsonUtil.buildNonNullBinder().getJsonToObject(queryTmProappPageForScStr, SupQueryResult.class);
        if (null != queryTmProappPageForSc && CollectionUtils.isNotEmpty((Collection)queryTmProappPageForSc.getList())) {
            for (TmSceneProappDomain tmSceneProappDomain : queryTmProappPageForSc.getList()) {
                TmTmsceneProappDomain tmTmsceneProappDomain = new TmTmsceneProappDomain();
                tmTmsceneProappDomain.setSceneProappCode(tmSceneProappDomain.getSceneProappCode());
                tmTmsceneProappDomain.setSceneroleCode(tmSceneProappDomain.getSceneroleCode());
                tmTmsceneProappDomain.setSceneroleName(tmSceneProappDomain.getSceneroleName());
                tmTmsceneProappDomain.setProappCode(tmSceneProappDomain.getProappCode());
                tmTmsceneProappDomain.setProappName(tmSceneProappDomain.getProappName());
                tmTmsceneProappDomain.setTmsceneCode(tmTmsceneDomain.getTmsceneCode());
                tmTmsceneProappDomain.setProappSort(tmSceneProappDomain.getProappSort());
                if (null == tmTmsceneProappDomain) continue;
                if (CollectionUtils.isNotEmpty(tmTmsceneDomain.getTmTmsceneProappDomainList())) {
                    tmTmsceneDomain.getTmTmsceneProappDomainList().add(tmTmsceneProappDomain);
                }
                paramsMap.clear();
                paramsMap.put("tmTmsceneProappDomain", JsonUtil.buildNormalBinder().toJson((Object)tmTmsceneProappDomain));
                this.getInternalRouter().inInvoke("tm.Tmscene.saveTmsceneProapp", paramsMap);
            }
        }
    }

    private String executeRefresh(HwProductDomain hwProductDomain) throws JsonProcessingException {
        HashMap<String, OcContractDomain> paramsMap = new HashMap<String, OcContractDomain>();
        try {
            String value = this.getSceneCode("00000000", hwProductDomain.getProductId(), hwProductDomain.getSkuCode());
            if (StringUtils.isBlank((String)value)) {
                this.logger.error(this.SYS_CODE + ".executeRefresh.value", (Object)(" businessId:" + hwProductDomain.getBusinessId() + "\tskuCode:" + hwProductDomain.getSkuCode()));
                return null;
            }
            OcContractDomain ocContractDomain = new OcContractDomain();
            ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
            OcContractGoodsDomain goods = new OcContractGoodsDomain();
            goods.setGoodsCode(value);
            goodsList.add(goods);
            ocContractDomain.setGoodsList(goodsList);
            ocContractDomain.setTenantCode("00000000");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Date expireTime = sdf.parse(hwProductDomain.getExpireTime());
            if (expireTime == null) {
                this.logger.error(this.SYS_CODE + ".executeRefresh.getExpireTime,\u8fc7\u671f\u65f6\u95f4\u975e\u6cd5\uff01 businessId:" + hwProductDomain.getBusinessId() + "\texpireTime:" + hwProductDomain.getExpireTime());
                return null;
            }
            long times = expireTime.getTime() - System.currentTimeMillis();
            int days = (int)Math.ceil((double)times / 8.64E7);
            ocContractDomain.setContractPumode("" + days);
            paramsMap.clear();
            paramsMap.put("ocContractDomain", ocContractDomain);
            String str = (String)this.getInternalRouter().inInvoke("tm.Tmscene.updateTmsceneByTmsceneEnd", paramsMap);
            if (!StringUtils.equals((CharSequence)"success", (CharSequence)str)) {
                this.logger.error(this.SYS_CODE + ".executeNew.updateTmsceneByTmsceneEnd,\u7eed\u8d39\u5931\u8d25\uff01 businessId:" + hwProductDomain.getBusinessId() + "; value:" + value + ";expireTime:" + hwProductDomain.getExpireTime());
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".executeRefresh.e, businessId:" + hwProductDomain.getBusinessId(), (Throwable)e);
            return null;
        }
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String executeExpire(HwProductDomain hwProductDomain) throws JsonProcessingException {
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String executeRelease(HwProductDomain hwProductDomain) throws JsonProcessingException {
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String executeUpgrade(HwProductDomain hwProductDomain) throws JsonProcessingException {
        return this.buildSuccessResponse(ResultCodeEnum.SUCCESS.getResultCode(), ResultCodeEnum.SUCCESS.getResultMsg());
    }

    private String buildNewInstance(String userName, String password, int encryptType, String instanceId, String adminUrl, String frontEndUrl, String memo) throws JsonProcessingException {
        this.mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        NewInstanceResp result = new NewInstanceResp();
        result.setResultMsg(ResultCodeEnum.SUCCESS.getResultMsg());
        result.setResultCode(ResultCodeEnum.SUCCESS.getResultCode());
        result.setEncryptType(encryptType);
        result.setInstanceId(instanceId);
        AppInfo appInfo = new AppInfo();
        appInfo.setAdminUrl(adminUrl);
        appInfo.setFrontEndUrl(frontEndUrl);
        appInfo.setMemo(memo);
        appInfo.setUserName(TokenUtils.encryptContent(userName, ACCESS_KEY, encryptType));
        appInfo.setPassword(TokenUtils.encryptContent(password, ACCESS_KEY, encryptType));
        result.setAppInfo(appInfo);
        return this.mapper.writeValueAsString((Object)result);
    }

    private String buildFailResponse(int httpStatus, String code, String message) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpStatus(httpStatus);
        BaseResp result = new BaseResp();
        result.setResultMsg(message);
        result.setResultCode(code);
        responseBean.setHttpBody(this.mapper.writeValueAsString((Object)result));
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private String buildSuccessResponse(String code, String message) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        BaseResp result = new BaseResp();
        result.setResultMsg(message);
        result.setResultCode(code);
        String bodyStr = this.mapper.writeValueAsString((Object)result);
        String signature = TokenUtils.generateResponseBodySignature(ACCESS_KEY, bodyStr);
        if (StringUtils.isEmpty((String)signature)) {
            return this.buildFailResponse(400, ResultCodeEnum.OTHER_INNER_ERROR.getResultCode(), ResultCodeEnum.OTHER_INNER_ERROR.getResultMsg());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put(BODY_SIGN_KEY, BODY_SIGN_VALUE.replace("{signature}", signature));
        headerMap.put(CONTENT_TYPE, "application/json;charset=UTF-8");
        responseBean.setHeaderMap(headerMap);
        responseBean.setHttpBody(bodyStr);
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private String buildSignatureResponse(String bodyStr) throws Exception {
        HttpResponseBean responseBean = new HttpResponseBean();
        String signature = TokenUtils.generateResponseBodySignature(ACCESS_KEY, bodyStr);
        if (StringUtils.isEmpty((String)signature)) {
            return this.buildFailResponse(400, ResultCodeEnum.OTHER_INNER_ERROR.getResultCode(), ResultCodeEnum.OTHER_INNER_ERROR.getResultMsg());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put(BODY_SIGN_KEY, BODY_SIGN_VALUE.replace("{signature}", signature));
        headerMap.put(CONTENT_TYPE, "application/json;charset=UTF-8");
        responseBean.setHeaderMap(headerMap);
        responseBean.setHttpBody(bodyStr);
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private boolean isRepeatRequest(String businessId) {
        boolean isRepeat = true;
        String key = "PASS-HWSAAS_REQUEST_BUSINESSID_" + businessId;
        String value = DisUtil.get((String)key);
        if (StringUtils.isEmpty((String)value)) {
            isRepeat = false;
            DisUtil.set((String)key, (String)businessId, (int)86400);
        }
        return isRepeat;
    }
}

