/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.hw.saas.utils;

import com.yqbsoft.laser.service.hw.saas.utils.Constant;
import com.yqbsoft.laser.service.hw.saas.utils.UnsupportProtocolException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.openeuler.BGMProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCipherSuiteUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLCipherSuiteUtil.class);
    private static CloseableHttpClient httpClient;
    private static OkHttpClient okHttpClient;
    private static final int CIPHER_LEN = 256;
    private static final int ENTROPY_BITS_REQUIRED = 384;

    public static HttpClient createHttpClient(String protocol) throws Exception {
        SSLContext sslContext = SSLCipherSuiteUtil.getSslContext(protocol);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{protocol}, Constant.SUPPORTED_CIPHER_SUITES, (HostnameVerifier)new TrustAllHostnameVerifier());
        httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        return httpClient;
    }

    public static OkHttpClient createOkHttpClient(String protocol) throws Exception {
        SSLContext sslContext = SSLCipherSuiteUtil.getSslContext(protocol);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)new TrustAllManager()).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        okHttpClient = builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        return okHttpClient;
    }

    public static HttpURLConnection createHttpsOrHttpURLConnection(URL uUrl, String protocol) throws Exception {
        if (uUrl.getProtocol().toUpperCase(Locale.getDefault()).equals("HTTPS")) {
            SSLContext sslContext = SSLCipherSuiteUtil.getSslContext(protocol);
            HttpsURLConnection.setDefaultHostnameVerifier(new TrustAllHostnameVerifier());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            return (HttpsURLConnection)uUrl.openConnection();
        }
        return (HttpURLConnection)uUrl.openConnection();
    }

    private static SSLContext getSslContext(String protocol) throws UnsupportProtocolException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        if (!"GMTLS".equals(protocol) && !"TLSv1.2".equals(protocol)) {
            LOGGER.info("Unsupport protocol: {}, Only support GMTLS TLSv1.2", (Object)protocol);
            throw new UnsupportProtocolException("Unsupport protocol, Only support GMTLS TLSv1.2");
        }
        TrustManager[] trust = new TrustAllManager[]{new TrustAllManager()};
        KeyManager[] kms = null;
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2", "SunJSSE");
        if ("GMTLS".equals(protocol)) {
            Security.insertProviderAt((Provider)new BGMProvider(), 1);
            sslContext = SSLContext.getInstance("GMTLS", "BGMProvider");
        }
        SecureRandom secureRandom = SSLCipherSuiteUtil.getSecureRandom();
        sslContext.init(kms, trust, secureRandom);
        sslContext.getServerSessionContext().setSessionCacheSize(8192);
        sslContext.getServerSessionContext().setSessionTimeout(3600);
        return sslContext;
    }

    private static SecureRandom getSecureRandom() {
        SecureRandom source;
        try {
            source = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("get SecureRandom failed", (Throwable)e);
            throw new RuntimeException("get SecureRandom failed");
        }
        boolean predictionResistant = true;
        AESEngine cipher = new AESEngine();
        boolean reSeed = false;
        return new SP800SecureRandomBuilder(source, predictionResistant).setEntropyBitsRequired(384).buildCTR((BlockCipher)cipher, 256, null, reSeed);
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private X509Certificate[] issuers = new X509Certificate[0];

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.issuers;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

