/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.sap.domian.DaSalesSumReDomain;
import com.yqbsoft.laser.service.sap.service.ContractService;
import com.yqbsoft.laser.service.sap.service.DataService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataServiceImpl
extends BaseServiceImpl
implements DataService {
    private String SYS_CODE = "jbsSap.DataServiceImpl";
    private ContractService contractService;
    private final String date = DateUtil.getAfterDate((Date)new Date(), (int)-1, (String)"yyyy-MM-dd");
    private final String startDate = this.date + " 00:00:00";
    private final String endDate = this.date + " 23:59:59";

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    @Override
    public void sendSumData(String salesSumCode) throws ApiException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salesSumCode", salesSumCode);
        map.put("flag", 0);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        List daSalesSumReDomains = (List)this.readObj("da.daSalesSum.sendSumData", invokeMap, "list", new Object[]{DaSalesSumReDomain.class});
        if (ListUtil.isNotEmpty((Collection)daSalesSumReDomains)) {
            for (DaSalesSumReDomain daSalesSumReDomain : daSalesSumReDomains) {
                if (daSalesSumReDomain.getDataType() == 1 || daSalesSumReDomain.getDataType() == 2) {
                    this.updateDataStatus(this.contractService.sendContract(daSalesSumReDomain), daSalesSumReDomain.getSalesSumCode());
                    continue;
                }
                if (daSalesSumReDomain.getDataType() != 3 && daSalesSumReDomain.getDataType() != 4) continue;
                this.updateDataStatus(this.contractService.sendContractPayment(daSalesSumReDomain), daSalesSumReDomain.getSalesSumCode());
            }
        }
    }

    @Override
    public String sendSalesOrderSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 1);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendSalesOrderSumReport exception----" + e.getMessage()));
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendSalesOrderSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    @Override
    public String sendRefundOrderSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 2);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendRefundOrderSumReport exception" + e.getMessage()));
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendRefundOrderSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    @Override
    public String sendSalesCashSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 3);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendSalesCashSumReport exception" + e.getMessage()));
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendSalesCashSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    @Override
    public String sendRefundCashSumReport(String tenantCode) throws ApiException {
        try {
            this.queryData(tenantCode, 4);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)("createSendRefundCashSumReport exception" + e.getMessage()));
            return JbsUtils.getErrorMap(this.SYS_CODE + ".createSendRefundCashSumReport", "error");
        }
        return JbsUtils.getSuccessMap("success");
    }

    private void queryData(String tenantCode, int type) throws Exception {
        this.logger.error("----------------queryData\u5f00\u59cb-----------------------");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flag", 1);
        map.put("tenantCode", tenantCode);
        map.put("dataType", type);
        map.put("startDate", this.startDate);
        map.put("endDate", this.endDate);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        List daSalesSumReDomains = (List)this.readObj("da.daSalesSum.sendSumData", invokeMap, "list", new Object[]{DaSalesSumReDomain.class});
        if (ListUtil.isNotEmpty((Collection)daSalesSumReDomains)) {
            for (DaSalesSumReDomain daSalesSumReDomain : daSalesSumReDomains) {
                if (daSalesSumReDomain.getDataType() == 1 || daSalesSumReDomain.getDataType() == 2) {
                    this.updateDataStatus(this.contractService.sendContract(daSalesSumReDomain), daSalesSumReDomain.getSalesSumCode());
                    continue;
                }
                if (daSalesSumReDomain.getDataType() != 3 && daSalesSumReDomain.getDataType() != 4) continue;
                this.updateDataStatus(this.contractService.sendContractPayment(daSalesSumReDomain), daSalesSumReDomain.getSalesSumCode());
            }
        }
        this.logger.error("----------------queryData\u7ed3\u675f-----------------------");
    }

    private void updateDataStatus(String result, String salesSumCode) {
        this.logger.error("----------------updateDataStatus\u5f00\u59cb-----------------------", (Object)result);
        if (StringUtils.isNotBlank((String)result)) {
            Map resultMap = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(result, String.class, Object.class);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("salesSumCode", salesSumCode);
            if (resultMap != null && ((Boolean)resultMap.get("success")).booleanValue()) {
                map.put("dataState", 1);
            } else {
                map.put("dataState", 0);
            }
            HashMap<String, String> invokeMap = new HashMap<String, String>();
            invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
            this.readObj("da.daSalesSum.updateDataState", invokeMap, "map", new Object[]{new HashMap()});
            this.logger.error("----------------updateDataStatus\u7ed3\u675f-----------------------");
        }
    }
}

