/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.facade.http;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.sap.common.facade.SupperFacade;
import com.yqbsoft.laser.service.sap.common.request.SupperRequest;
import com.yqbsoft.laser.service.sap.common.response.SupperResponse;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.sap.utils.RequestUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class HttpFormfacade
extends SupperFacade {
    private static String SYS_CODE = "HttpFormfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(HttpFormfacade.class);

    private String httpRequestReJson(String requestUrl, Map<String, Object> sendhttpParam) {
        String json = "";
        try {
            HashMap<String, String> sendParam = new HashMap<String, String>();
            for (String key : sendhttpParam.keySet()) {
                sendParam.put(key, (String)sendhttpParam.get(key));
            }
            json = WebUtils.doPost((String)requestUrl, sendParam, (int)10000000, (int)10000000, null);
            logger.error(SYS_CODE + "json.=====", (Object)json);
        }
        catch (Exception e) {
            logger.error(SYS_CODE + ".webUtilRequest.e", (Object)requestUrl, (Throwable)e);
            throw new ApiException(SYS_CODE + ".HttpRequestReJson.ex", (Throwable)e);
        }
        return json;
    }

    @Override
    @Retryable(value={ApiException.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5))
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String url = this.getHost() + (StringUtils.isBlank((String)supperRequest.getTopHttpMethod()) ? "" : supperRequest.getTopHttpMethod());
        HashMap<String, Map<String, Object>> finalSendMap = new HashMap<String, Map<String, Object>>();
        finalSendMap.put("header", JbsUtils.makeHearder(supperRequest.getApiMethod()));
        finalSendMap.put("data", supperRequest.getTextParams());
        logger.error(SYS_CODE + ".Httpfacade.execute.json", (Object)(url + "PARAM:======" + JsonUtil.buildNormalBinder().toJson(finalSendMap)));
        ResponseEntity<Map> response = RequestUtils.postForEntity(url, JsonUtil.buildNormalBinder().toJson(finalSendMap), JbsUtils.makeApiHeader());
        Map resultMap = (Map)response.getBody();
        String json = JsonUtil.buildNormalBinder().toJson((Object)resultMap);
        if (StringUtils.isEmpty((String)json)) {
            logger.error(SYS_CODE + ".execute.json", (Object)(url + "====" + supperRequest.getTextParams()));
            return null;
        }
        logger.error(SYS_CODE + ".Httpfacade.execute.ResponseJson\u300b\u300b\u300b\u300b\u300b\u300b", (Object)(url + "=" + json + "===\n" + JsonUtil.buildNormalBinder().toJson(response)));
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException((Throwable)xe);
        }
        localResponse.setMsg(json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    @Override
    public String sign(Map<String, String> param) {
        return null;
    }

    public HttpFormfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public HttpFormfacade(String host) {
        super(host);
    }
}

