/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sap.domian.InvInvlist;
import com.yqbsoft.laser.service.sap.domian.InvInvlistDomain;
import com.yqbsoft.laser.service.sap.domian.InvInvlistGoods;
import com.yqbsoft.laser.service.sap.domian.InvInvlistGoodsDomain;
import com.yqbsoft.laser.service.sap.domian.InvInvrate;
import com.yqbsoft.laser.service.sap.domian.InvUserinv;
import com.yqbsoft.laser.service.sap.domian.OcContractReDomain;
import com.yqbsoft.laser.service.sap.domian.OcRefundReDomain;
import com.yqbsoft.laser.service.sap.domian.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.sap.domian.UmUser;
import com.yqbsoft.laser.service.sap.domian.UmUserinfo;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSendInvoiceRequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSendInvoiceResponse;
import com.yqbsoft.laser.service.sap.service.InvoiceService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceServiceImpl
extends BaseServiceImpl
implements InvoiceService {
    private String SYS_CODE = "jbsSap.InvoiceServiceImpl";

    @Override
    public String sendInvoice(InvInvlistDomain invInvlist) throws Exception {
        if (null == invInvlist) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.invInvlist.null");
            return JbsUtils.getErrorMap("invInvlist\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", "01");
        }
        this.logger.info(this.SYS_CODE + ".sendInvoice.invInvlist", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvlist));
        List<InvInvlistGoodsDomain> invInvlistGoodsDomainList = invInvlist.getInvInvlistGoodsDomainList();
        if (ListUtil.isEmpty(invInvlistGoodsDomainList)) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList.null", (Object)(invInvlist.getTenantCode() + "=======" + invInvlist.getInvlistCode()));
            return JbsUtils.getErrorMap("invInvlistGoodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01", "01");
        }
        OcContractReDomain ocContractReDomain = this.checkOcContract(invInvlist.getInvlistOpcode());
        if (null == ocContractReDomain) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.ocContractReDomain.01");
            return JbsUtils.getErrorMap("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "01");
        }
        String originalInvoiceNo = null;
        InvUserinv invUserinv = this.queryOneInvUser(invInvlist.getUserinvCode());
        if (null == invUserinv) {
            return JbsUtils.getErrorMap("invUserinv", "\u65e0\u5f00\u7968\u4eba");
        }
        List<InvUserinv> invUser = this.queryInvUser(ocContractReDomain.getMemberMcode());
        if (ListUtil.isEmpty(invUser)) {
            return JbsUtils.getErrorMap("invUser", "\u65e0\u9500\u65b9\u4fe1\u606f");
        }
        InvUserinv invUserinvSeller = invUser.get(0);
        Integer i = 0;
        BigDecimal sumMoney = new BigDecimal(0);
        ArrayList<Map<String, Object>> invoiceDetailsList = new ArrayList<Map<String, Object>>();
        for (InvInvlistGoodsDomain invInvlistGoods : invInvlistGoodsDomainList) {
            HashMap<String, Object> detailsMap = new HashMap<String, Object>();
            if (null == invInvlistGoods.getContractGoodsMoney()) {
                invInvlistGoods.setContractGoodsMoney(BigDecimal.ZERO);
            }
            i = i + 1;
            detailsMap.put("requestionLineNo", i);
            detailsMap.put("invoiceLineNature", 0);
            detailsMap.put("itemCode", invInvlistGoods.getSkuNo());
            detailsMap.put("goodsQuantity", invInvlistGoods.getGoodsNum());
            detailsMap.put("goodsPrice", invInvlistGoods.getContractGoodsPrice());
            detailsMap.put("goodsTotalPrice", invInvlistGoods.getContractGoodsMoney());
            sumMoney = sumMoney.add(invInvlistGoods.getContractGoodsMoney());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.getResourceGoods(invInvlistGoods.getGoodsCode());
            if (null == rsResourceGoodsReDomain || StringUtils.isBlank((String)rsResourceGoodsReDomain.getAreaCode())) {
                return JbsUtils.getErrorMap("\u67e5\u8be2\u5f00\u7968\u65e0\u5546\u54c1\u4fe1\u606fgoods/\u65e0\u7a0e\u7387", invInvlistGoods.getGoodsCode());
            }
            List<InvInvrate> invInvrateList = this.queryRate(rsResourceGoodsReDomain.getAreaCode());
            if (EmptyUtil.isEmpty(invInvrateList) && EmptyUtil.isEmpty((Object)invInvrateList.get(0).getInvrateRate())) {
                return JbsUtils.getErrorMap("\u65e0\u7a0e\u7387\u503c", "");
            }
            InvInvrate invInvrate = invInvrateList.get(0);
            BigDecimal newRate = invInvrate.getInvrateRate().divide(new BigDecimal(100));
            BigDecimal tempRate = new BigDecimal(1).add(newRate);
            BigDecimal amountTax = invInvlistGoods.getContractGoodsMoney().divide(tempRate, 2, 4);
            BigDecimal goodsTotalTax = invInvlistGoods.getContractGoodsMoney().subtract(amountTax.setScale(2, 4));
            detailsMap.put("goodsTotalTax", goodsTotalTax);
            if ("1".equals(invInvlist.getInvlistType())) {
                if (null == invInvlistGoods.getGoodsNum()) {
                    invInvlistGoods.setGoodsNum(BigDecimal.ZERO);
                }
                detailsMap.put("goodsQuantity", invInvlistGoods.getGoodsNum().negate());
                if (null == invInvlistGoods.getContractGoodsPrice()) {
                    invInvlistGoods.setContractGoodsPrice(BigDecimal.ZERO);
                }
                detailsMap.put("goodsPrice", invInvlistGoods.getContractGoodsPrice().negate());
                detailsMap.put("goodsTotalPrice", invInvlistGoods.getContractGoodsMoney().negate());
                detailsMap.put("goodsTotalTax", goodsTotalTax.negate());
            }
            invoiceDetailsList.add(detailsMap);
        }
        HttpFormfacade httpFormfacade = new HttpFormfacade();
        httpFormfacade.setInsideOrderNo(invInvlist.getInvlistCode());
        JbsSapSendInvoiceResponse execute = null;
        JbsSapSendInvoiceRequest jbsSapSendInvoiceRequest = new JbsSapSendInvoiceRequest();
        try {
            JSONObject jsonObject = InvoiceServiceImpl.getData();
            httpFormfacade.setHost(jsonObject.getString("url"));
            BeanUtils.copyAllPropertys((Object)jbsSapSendInvoiceRequest, (Object)invInvlist);
            String invoiceTerminalCode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_inv-invoiceTerminalCode");
            jbsSapSendInvoiceRequest.setInvoiceTerminalCode(invoiceTerminalCode);
            jbsSapSendInvoiceRequest.setOriginalInvoiceNo(originalInvoiceNo);
            jbsSapSendInvoiceRequest.setInvoiceDetailsList(invoiceDetailsList);
            jbsSapSendInvoiceRequest.setInvoiceTotalPrice(sumMoney);
            jbsSapSendInvoiceRequest.setSellerTaxNo(invUserinvSeller.getUserinvNo());
            jbsSapSendInvoiceRequest.setSellerBankAccount(invUserinvSeller.getUserinvBank() + "-" + invUserinvSeller.getUserinvBankno());
            jbsSapSendInvoiceRequest.setSellerAddressPhone(invUserinvSeller.getUserinvAdd() + "-" + invUserinvSeller.getUserinvUphone());
            jbsSapSendInvoiceRequest.setBuyerTaxNo(invUserinv.getUserinvNo());
            jbsSapSendInvoiceRequest.setBuyerName(invUserinv.getUserinvMember());
            jbsSapSendInvoiceRequest.setBuyerBankAccount(invUserinv.getUserinvBank() + "-" + invUserinv.getUserinvBankno());
            jbsSapSendInvoiceRequest.setBuyerAddressPhone(invUserinv.getUserinvAdd() + "-" + invUserinv.getUserinvUphone());
            this.logger.info(this.SYS_CODE + ".sendInvoice.executeStart", (Object)("\u53d1\u7968\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570>>>>" + JsonUtil.buildNormalBinder().toJson(jbsSapSendInvoiceRequest.getTextParams())));
            execute = httpFormfacade.execute(jbsSapSendInvoiceRequest);
            this.logger.info(this.SYS_CODE + ".sendInvoice.executeEnd", (Object)("\u53d1\u7968\u63a5\u53e3\u54cd\u5e94\u53c2\u6570>>>>" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("error", "\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u7b49\u5f85\u5f02\u6b65");
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)"\u53d1\u7968\u63a5\u53e3>>>>", (Throwable)e);
            return JbsUtils.getErrorMap("exception", JsonUtil.buildNormalBinder().toJson(execute));
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String receiveInvoice(String dataStr) throws Exception {
        this.logger.info(this.SYS_CODE + ".receiveInvoice.dataStr->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dataStr));
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.dataStr->", (Object)"\u4e3a\u7a7a");
            return JbsUtils.getErrorMap("blank", dataStr);
        }
        JSONObject object = JSONObject.json2object((String)dataStr);
        String msg = this.checkInvinvlist(object);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.object->", (Object)JsonUtil.buildNormalBinder().toJson((Object)object));
            return JbsUtils.getErrorMap("check", msg + "=" + dataStr);
        }
        Integer dataState = 1;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!"2".equals(object.getString("dataState"))) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.datastate->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dataStr));
            return JbsUtils.getSuccessMap("no");
        }
        map.put("invlistOcode", object.getString("invlistOcode"));
        map.put("invlistOcode1", object.getString("invlistOcode1"));
        map.put("invlistOcode2", object.getString("invlistOcode2"));
        map.put("invlistOurl", object.getString("invlistOurl"));
        dataState = 1;
        this.logger.info(this.SYS_CODE + ".receiveInvoice.update->", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        try {
            this.updateInvlist("2019071800001392", object.getString("invlistCode"), dataState, null, map);
        }
        catch (Exception e) {
            return JbsUtils.getErrorMap("exc", "\u4fee\u6539\u53d1\u7968\u5931\u8d25");
        }
        return JbsUtils.getSuccessMap("success");
    }

    public void updateContractInvstate(String invlistOpcode, String dataState) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", invlistOpcode);
        map.put("dataState", dataState);
        map.put("oldDataState", null);
        map.put("tenantCode", "2019071800001392");
        this.getInternalRouter().inInvoke("oc.contract.updateContractInvstate", map);
    }

    public void updateInvlist(String tenantCode, String invlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws Exception {
        HashMap<String, Object> invlistMap = new HashMap<String, Object>();
        invlistMap.put("tenantCode", tenantCode);
        invlistMap.put("invlistCode", invlistCode);
        invlistMap.put("dataState", dataState);
        invlistMap.put("oldDataState", oldDataState);
        invlistMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.getInternalRouter().inInvoke("inv.channelsendBase.sendUpdateInvlistStateByCode", invlistMap);
    }

    public String checkInvinvlist(JSONObject object) {
        String msg = "";
        if (StringUtils.isBlank((String)object.getString("invlistCode"))) {
            msg = msg + "invlistCode\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode"))) {
            msg = msg + "invlistOcode\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode1"))) {
            msg = msg + "invlistOcode1\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode2"))) {
            msg = msg + "invlistOcode2\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("dataState"))) {
            msg = msg + "dataState\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOurl"))) {
            msg = msg + "invlistOurl\u4e3a\u7a7a";
        }
        return msg;
    }

    public InvInvlist queryInvlist(String invlistBatchcode) throws Exception {
        if (StringUtils.isBlank((String)invlistBatchcode)) {
            return null;
        }
        HashMap<String, String> invlistMap = new HashMap<String, String>();
        invlistMap.put("tenantCode", "2019071800001392");
        invlistMap.put("invlistCode", invlistBatchcode);
        String invListStr = (String)this.getInternalRouter().inInvoke("inv.invlist.getInvlistByCode", invlistMap);
        InvInvlist invInvlist = (InvInvlist)JsonUtil.buildNonNullBinder().getJsonToObject(invListStr, InvInvlist.class);
        this.logger.info(this.SYS_CODE + ".queryInvlist->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvlist));
        return invInvlist;
    }

    public List<InvInvrate> queryRate(String areaCode) throws Exception {
        if (StringUtils.isBlank((String)areaCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> rateMap = new HashMap<String, String>();
        rateMap.put("invrateOpcode", areaCode);
        rateMap.put("invrateOptype", "areaCode");
        rateMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNormalBinder().toJson(rateMap));
        QueryResult invInvrateResult = this.sendReSupObject("inv.invset.queryInvratePage", map, InvInvrate.class);
        List invInvrateList = invInvrateResult.getList();
        if (ListUtil.isEmpty((Collection)invInvrateList)) {
            this.logger.error(this.SYS_CODE + ".queryRate.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvrateList));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryRate->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvrateList));
        return invInvrateList;
    }

    public RsResourceGoodsReDomain getResourceGoods(String goodsCode) throws Exception {
        if (StringUtils.isBlank((String)goodsCode)) {
            return null;
        }
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        goodsMap.put("goodsCode", goodsCode);
        goodsMap.put("tenantCode", "2019071800001392");
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", goodsMap, "object", new Object[]{RsResourceGoodsReDomain.class});
        if (null == rsResourceGoodsReDomain) {
            this.logger.error(this.SYS_CODE + ".getResourceGoods.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsMap));
            throw new Exception("resourceGoodslist\u4e3a\u7a7a\uff01");
        }
        return rsResourceGoodsReDomain;
    }

    public List<InvUserinv> queryInvUser(String memberCode) throws Exception {
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        HashMap<String, String> invMap = new HashMap<String, String>();
        HashMap<String, String> invMapStr = new HashMap<String, String>();
        invMapStr.put("memberCode", memberCode);
        invMapStr.put("tenantCode", "2019071800001392");
        invMap.put("map", JsonUtil.buildNormalBinder().toJson(invMapStr));
        QueryResult invQueryResult = this.sendReSupObject("inv.userinv.queryUserinvPage", invMap, InvUserinv.class);
        List invlist = invQueryResult.getList();
        if (ListUtil.isEmpty((Collection)invlist)) {
            this.logger.error(this.SYS_CODE + ".queryInvUser.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(invMapStr));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryInvUser->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invlist));
        return invlist;
    }

    public List<UmUser> queryUmUser(String userinfoCode) throws Exception {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        HashMap<String, String> userMapStr = new HashMap<String, String>();
        userMapStr.put("userPcode", userinfoCode);
        userMapStr.put("tenantCode", "2019071800001392");
        userMap.put("map", JsonUtil.buildNormalBinder().toJson(userMapStr));
        QueryResult umQueryResult = this.sendReSupObject("um.user.queryUserPage", userMap, UmUser.class);
        List userslist = umQueryResult.getList();
        if (ListUtil.isEmpty((Collection)userslist)) {
            this.logger.error(this.SYS_CODE + ".queryUmUser.userslist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userMapStr));
            throw new Exception("userslist\u4e3a\u7a7a\uff01");
        }
        return userslist;
    }

    public UmUserinfo queryOneUmUserinfo(String userinfoCode) throws Exception {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("userinfoCode", userinfoCode);
        userInfoMap.put("tenantCode", "2019071800001392");
        String userInfoStr = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", userInfoMap);
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNonNullBinder().getJsonToObject(userInfoStr, UmUserinfo.class);
        if (umUserinfo == null) {
            this.logger.error(this.SYS_CODE + ".queryOneUmUserinfo.umUserinfo.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userInfoMap));
            throw new Exception("umUserinfo\u4e3a\u7a7a\uff01");
        }
        return umUserinfo;
    }

    public InvUserinv queryOneInvUser(String userinvCode) throws Exception {
        if (StringUtils.isBlank((String)userinvCode)) {
            return null;
        }
        HashMap<String, String> userinvMap = new HashMap<String, String>();
        userinvMap.put("tenantCode", "2019071800001392");
        userinvMap.put("userinvCode", userinvCode);
        String userinvStr = (String)this.getInternalRouter().inInvoke("inv.userinv.getUserinvByCode", userinvMap);
        InvUserinv invUserinv = (InvUserinv)JsonUtil.buildNonNullBinder().getJsonToObject(userinvStr, InvUserinv.class);
        if (invUserinv == null) {
            this.logger.error(this.SYS_CODE + ".queryOneInvUser.invUserinv.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userinvMap));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryOneInvUser->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invUserinv));
        return invUserinv;
    }

    public OcRefundReDomain checkOcRefund(String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke("oc.refund.getRefundByCode", parameter);
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcRefundReDomain.class);
        this.logger.info(this.SYS_CODE + ".checkOcRefund.ocRefundReDomain.ocRefundReDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        return ocRefundReDomain;
    }

    public OcContractReDomain checkOcContract(String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", parameter);
        OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcContractReDomain.class);
        this.logger.info(this.SYS_CODE + ".checkOcContract.ocContractReDomain.ocContractReDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        return ocContractReDomain;
    }

    public List<InvInvlistGoods> queryInvlistGoodsPage(String tenantCode, String invlistCode) throws Exception {
        if (StringUtils.isBlank((String)invlistCode)) {
            return null;
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("invlistCode", invlistCode);
        map.put("tenantCode", tenantCode);
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult invQueryResult = this.sendReSupObject("inv.invlistGoods.queryInvlistGoodsPage", parameter, InvInvlistGoods.class);
        List invlist = invQueryResult.getList();
        if (ListUtil.isEmpty((Collection)invlist)) {
            this.logger.error(this.SYS_CODE + ".queryInvlistGoodsPage.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryInvlistGoodsPage->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invlist));
        return invlist;
    }

    private static JSONObject getData() {
        String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_inv-jbs_inv");
        return JSONObject.json2object((String)paramJson);
    }
}

