/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sap.domian.DaStoreErpDomain;
import com.yqbsoft.laser.service.sap.domian.GoodsBean;
import com.yqbsoft.laser.service.sap.domian.RsResourceGoods;
import com.yqbsoft.laser.service.sap.domian.RsSku;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapExWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapInWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapMaterialMovePostingRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapQueryWhRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSTORequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSendPurchaseRequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapInExWhConfirmResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapMaterialMovePostingResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapQueryWhResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSTOResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSendPurchaseResponse;
import com.yqbsoft.laser.service.sap.model.HtmlJsonReBean;
import com.yqbsoft.laser.service.sap.model.WhOpstoreGoods;
import com.yqbsoft.laser.service.sap.model.WhOpstoreSku;
import com.yqbsoft.laser.service.sap.model.WhWarehouse;
import com.yqbsoft.laser.service.sap.service.JbsSapWarehouseService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.sap.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JbsSapWarehouseServiceImpl
extends BaseServiceImpl
implements JbsSapWarehouseService {
    public static final String SYS_CODE = "jbsSap.JbsSapWarehouseServiceImpl";

    @Override
    public String sendSTOBill(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            JbsSapSTORequest jbsSapSTORequest = new JbsSapSTORequest();
            jbsSapSTORequest.setApiMethod("os_mpf_if_sc_006");
            BeanUtils.copyAllPropertys((Object)jbsSapSTORequest, (Object)whOpstoreDomain);
            JbsSapSTOResponse execute = httpFormfacade.execute(jbsSapSTORequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            this.updateWhOutSiteNumber(execute, whOpstoreDomain);
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.STO\u521b\u5efa\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return JbsUtils.getErrorMap(".STO\u521b\u5efa\u63a5\u53e3\u5f02\u5e38", whOpstoreDomain.getOpstoreCode());
        }
    }

    private void updateWhOutSiteNumber(JbsSapSTOResponse execute, WhOpstoreDomain whOpstoreDomain) {
        try {
            if (!EmptyUtil.isEmpty((Object)execute) && ListUtil.isNotEmpty(execute.getStoDataList()) && !EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
                List<Map<String, String>> stoDataList = execute.getStoDataList();
                HashMap<String, String> stoData = new HashMap<String, String>();
                for (Map<String, String> map : stoDataList) {
                    stoData.put(map.get("skuNo") + "-" + map.get("warehouseCode"), map.get("stoNumber"));
                }
                if (ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreGoodsReDomainList())) {
                    whOpstoreDomain.getWhOpstoreGoodsReDomainList().stream().forEach(goodsobj -> goodsobj.getWhOpstoreSkuReDomainList().stream().forEach(skuObj -> {
                        if (StringUtils.isNotBlank((String)((String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getEmployeeCode()))) || StringUtils.isNotBlank((String)((String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getWarehouseCode())))) {
                            goodsobj.setGoodsWebremark(StringUtils.isNotBlank((String)((String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getEmployeeCode()))) ? (String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getEmployeeCode()) : (String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getWarehouseCode()));
                        }
                    }));
                } else if (ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
                    whOpstoreDomain.getWhOpstoreGoodsDomainList().stream().forEach(goodsobj -> goodsobj.getWhOpstoreSkuDomainList().stream().forEach(skuObj -> {
                        if (StringUtils.isNotBlank((String)((String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getEmployeeCode()))) || StringUtils.isNotBlank((String)((String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getWarehouseCode())))) {
                            goodsobj.setGoodsWebremark(StringUtils.isNotBlank((String)((String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getEmployeeCode()))) ? (String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getEmployeeCode()) : (String)stoData.get(skuObj.getSkuNo() + "-" + whOpstoreDomain.getWarehouseCode()));
                        }
                    }));
                }
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
                this.internalInvoke("wh.whStoreGoodsBase.sendUpdateOpstore", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.STOCreate.updateWhOutSiteNumber Exception", (Object)e.toString(), (Throwable)e);
            throw new ApiException("\u56de\u5199STO\u5355\u53f7\u5f02\u5e38" + whOpstoreDomain.getOpstoreCode());
        }
    }

    @Override
    public String sendPurchaseRequest(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            JbsSendPurchaseRequest jbsSendPurchaseRequest = new JbsSendPurchaseRequest();
            jbsSendPurchaseRequest.setApiMethod("os_mpf_if_sc_010");
            BeanUtils.copyAllPropertys((Object)jbsSendPurchaseRequest, (Object)whOpstoreDomain);
            JbsSendPurchaseResponse execute = httpFormfacade.execute(jbsSendPurchaseRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.\u521b\u5efa\u91c7\u8d2d\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return JbsUtils.getErrorMap(".\u521b\u5efa\u91c7\u8d2d\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38", whOpstoreDomain.getOpstoreCode());
        }
    }

    @Override
    public HtmlJsonReBean receiveInDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.info(SYS_CODE, (Object)("jbsSap.receiveInDeliveryBill.param" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = null;
        try {
            Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
            whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
            if (null == whOpstoreDomain) {
                this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
                errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25");
                throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            Map checkResultMap = this.checkExist(whOpstoreDomain);
            Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
            WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
            this.checkGoodsClass(currentObj);
            if (StringUtils.isBlank((String)currentObj.getWarehouseName())) {
                this.HandleWarehouseName(currentObj);
            }
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
            this.logger.info(SYS_CODE, (Object)(checkFlag + "=" + JsonUtil.buildNormalBinder().toJson(sendMap)));
            if (checkFlag.booleanValue()) {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateOpstore", sendMap);
            } else {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u63a5\u6536\u5185\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "SAP\u63a5\u6536\u5185\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a" + errorCodes));
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String InDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapInWhConfirmRequest jbsSapInWhConfirmRequest = new JbsSapInWhConfirmRequest();
            jbsSapInWhConfirmRequest.setApiMethod("oa_mpf_if_sc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapInWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapInWhConfirmRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u5185\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38>>>>", (Throwable)e);
            return JbsUtils.getErrorMap("SAP\u5185\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public HtmlJsonReBean receiveExDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.info(SYS_CODE, (Object)("jbsSap.receiveExDeliveryBill.param" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || EmptyUtil.isEmpty(((HashMap)object.get((Object)"data")).get("list"))) {
            this.logger.error(SYS_CODE, (Object)("data\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<String> errorCodes = new ArrayList<String>();
        WhOpstoreDomain whOpstoreDomain = null;
        try {
            Map dataMap = (Map)((HashMap)object.get((Object)"data")).get("list");
            whOpstoreDomain = ParamsUtils.JbsSapMap2opDomain(dataMap);
            if (null == whOpstoreDomain) {
                this.logger.error(SYS_CODE, (Object)("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25>>>>" + JsonUtil.buildNormalBinder().toJson((Object)dataMap)));
                errorCodes.add("data \u8f6c\u6362\u5bf9\u8c61\u5931\u8d25");
                throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            Map checkResultMap = this.checkExist(whOpstoreDomain);
            Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
            WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
            this.checkGoodsClass(currentObj);
            if (StringUtils.isBlank((String)currentObj.getWarehouseName())) {
                this.HandleWarehouseName(currentObj);
            }
            sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
            this.logger.info(SYS_CODE, (Object)(checkFlag + "=" + JsonUtil.buildNormalBinder().toJson(sendMap)));
            if (checkFlag.booleanValue()) {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateOpstore", sendMap);
            } else {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u63a5\u6536\u5916\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            errorCodes.add(whOpstoreDomain.getOpstoreOcode() + "SAP\u63a5\u6536\u5916\u5411\u4ea4\u8d27\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            this.logger.error(SYS_CODE, (Object)("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a" + errorCodes));
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorCodes);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String ExDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapExWhConfirmRequest jbsSapExWhConfirmRequest = new JbsSapExWhConfirmRequest();
            jbsSapExWhConfirmRequest.setApiMethod("oa_mpf_if_sc_004");
            BeanUtils.copyAllPropertys((Object)jbsSapExWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapExWhConfirmRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"\u63a8\u9001SAP\u5916\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38>>", (Throwable)e);
            return JbsUtils.getErrorMap("\u63a8\u9001SAP\u5916\u5411\u4ea4\u8d27\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain.getOpstoreCode()));
        }
    }

    @Override
    public String queryInventoryInfo(Map<String, Object> paramsMap, String tenantCode, String warehouseCode) throws ApiException {
        if (StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String batch = DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd");
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("warehouseCode", warehouseCode);
        sendMap.put("storeErpTime", batch);
        sendMap.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("da.dastoreerp.deleteStoreBatch", sendMap);
        if (null == paramsMap) {
            paramsMap = new HashMap<String, Object>();
        }
        int startRow = 0;
        paramsMap.put("startRow", startRow);
        paramsMap.put("rows", 200);
        try {
            JbsSapQueryWhResponse execute = null;
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            JbsSapQueryWhRequest jbsSapQueryWhRequest = new JbsSapQueryWhRequest();
            jbsSapQueryWhRequest.setApiMethod("os_mpf_if_sc_008");
            boolean flag = true;
            do {
                jbsSapQueryWhRequest.setParamMap(paramsMap);
                Date starDate = new Date();
                execute = httpFormfacade.execute(jbsSapQueryWhRequest);
                if (!execute.getSuccess().booleanValue()) {
                    return JbsUtils.getErrorMap("\u8c03\u7528\u5931\u8d25:" + execute.getMsg(), JsonUtil.buildNormalBinder().toJson((Object)execute));
                }
                if (StringUtils.isBlank((String)execute.getReturnCount()) || Integer.valueOf(execute.getReturnCount()) <= 0) {
                    flag = false;
                    continue;
                }
                if ("success".equals(this.saveSap(execute.getReturnData(), batch, starDate, tenantCode))) continue;
                this.getInternalRouter().inInvoke("da.dastoreerp.deleteStoreBatch", sendMap);
                return JbsUtils.getErrorMap("\u67e5\u8be2SAP\u5e93\u5b58\u4fdd\u5b58\u5931\u8d25", paramsMap.toString());
            } while (flag);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"\u67e5\u8be2SAP\u5e93\u5b58\u8bb0\u5f55\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return JbsUtils.getErrorMap("\u67e5\u8be2SAP\u5e93\u5b58\u8bb0\u5f55\u63a5\u53e3\u5f02\u5e38", paramsMap.toString());
        }
        return JbsUtils.getSuccessMap("");
    }

    private String saveSap(String str, String batch, Date starDate, String tenantCode) {
        if (StringUtils.isBlank((String)str) || StringUtils.isBlank((String)batch)) {
            return "success";
        }
        Map rmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(str, String.class, Object.class);
        if (MapUtil.isEmpty((Map)rmap)) {
            return "error";
        }
        DaStoreErpDomain daStoreErpDomain = new DaStoreErpDomain();
        String skuNo = "";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsClass", "plat");
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", "20021000276227");
        paramMap.put("tenantCode", tenantCode);
        String returnJsonStr = this.internalInvoke("rs.resourceGoods.getResourceBySkuNo", paramMap);
        if (StringUtils.isNotBlank((String)returnJsonStr)) {
            GoodsBean goodsBean = (GoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(returnJsonStr, GoodsBean.class);
            daStoreErpDomain.setGoodsCode(goodsBean.getRsSku().getGoodsCode());
            daStoreErpDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
            daStoreErpDomain.setSkuName(goodsBean.getRsSku().getSkuName());
        }
        daStoreErpDomain.setStoreErpEtime(new Date());
        daStoreErpDomain.setStoreErpStime(starDate);
        daStoreErpDomain.setStoreErpType("sap");
        daStoreErpDomain.setStoreErpTime(batch);
        daStoreErpDomain.setTenantCode(tenantCode);
        ArrayList<DaStoreErpDomain> daStoreErpDomainList = new ArrayList<DaStoreErpDomain>();
        daStoreErpDomainList.add(daStoreErpDomain);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("daStoreErpDomainList", JsonUtil.buildNormalBinder().toJson(daStoreErpDomainList));
        this.getInternalRouter().inInvoke("da.dastoreerp.saveStoreErpBatch", sendMap);
        return "success";
    }

    @Override
    public String MaterialMovePosting(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.MaterialMovePosting.paramas", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        if ("L0".equals(whOpstoreDomain.getStoreGoodsBtype()) && StringUtils.isBlank((String)whOpstoreDomain.getCompanyCode())) {
            return JbsUtils.getErrorMap("\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", "");
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            return JbsUtils.getErrorMap("GoodsList\u5546\u54c1\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", "");
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                return JbsUtils.getErrorMap("SkuList\u6279\u6b21\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", "");
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                if (!StringUtils.isBlank((String)whOpstoreSkuDomain.getPntreeCode())) continue;
                return JbsUtils.getErrorMap("SkuList\u6279\u6b21\u5c42\u7ea7\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "");
            }
        }
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsSapMaterialMovePostingResponse execute = null;
            JbsSapMaterialMovePostingRequest jbsSapMaterialMovePostingRequest = new JbsSapMaterialMovePostingRequest();
            jbsSapMaterialMovePostingRequest.setApiMethod("os_mpf_if_sc_005");
            BeanUtils.copyAllPropertys((Object)jbsSapMaterialMovePostingRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapMaterialMovePostingRequest);
            if (!execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", execute.getReturnData());
            }
            return JbsUtils.getSuccessMap(execute.getReturnData());
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"SAP\u7269\u6599\u79fb\u52a8\u8fc7\u8d26\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return JbsUtils.getErrorMap("SAP\u7269\u6599\u79fb\u52a8\u8fc7\u8d26\u63a5\u53e3\u5f02\u5e38", "");
        }
    }

    public Map checkExist(WhOpstoreDomain whOpstoreDomain) throws Exception {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            throw new Exception("checkExist.\u4f20\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            WhOpstoreDomain getDbObj = null;
            queryMap.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
            if (queryStoreResult != null && ListUtil.isNotEmpty((Collection)queryStoreResult.getList()) && !EmptyUtil.isEmpty(queryStoreResult.getList().get(0))) {
                getDbObj = (WhOpstoreDomain)queryStoreResult.getList().get(0);
                BeanUtils.copyAllPropertysNotNull((Object)getDbObj, (Object)whOpstoreDomain);
                List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
                HashMap<String, WhOpstoreGoodsDomain> receiveGoodsDataMap = new HashMap<String, WhOpstoreGoodsDomain>();
                HashMap<String, WhOpstoreSkuDomain> receiveSkuDataMap = new HashMap<String, WhOpstoreSkuDomain>();
                if (ListUtil.isNotEmpty(whOpstoreGoodsDomainList)) {
                    for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
                        List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                        if (ListUtil.isNotEmpty(whOpstoreSkuDomainList)) {
                            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                                receiveSkuDataMap.put(whOpstoreGoodsDomain.getChannelName() + "-" + whOpstoreGoodsDomain.getGoodsProperty2() + "-" + whOpstoreGoodsDomain.getGoodsEocode() + "-" + whOpstoreSkuDomain.getSkuNo(), whOpstoreSkuDomain);
                            }
                        }
                        receiveGoodsDataMap.put(whOpstoreGoodsDomain.getChannelName() + "-" + whOpstoreGoodsDomain.getGoodsProperty2() + "-" + whOpstoreGoodsDomain.getGoodsEocode(), whOpstoreGoodsDomain);
                    }
                }
                queryMap.clear();
                map.clear();
                if (StringUtils.isBlank((String)getDbObj.getOpstoreCode())) {
                    throw new Exception("checkExist\u67e5\u8be2Goods\u5546\u54c1\u7684opstoreCode\u4e3a\u7a7a");
                }
                queryMap.put("tenantCode", "2019071800001392");
                queryMap.put("opstoreCode", getDbObj.getOpstoreCode());
                map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapGoodsMap", (Object)JsonUtil.buildNormalBinder().toJson(map));
                QueryResult queryDbGoodsResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreGoodsPage", map, WhOpstoreGoods.class);
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapGoodsResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryDbGoodsResult));
                if (queryDbGoodsResult != null && ListUtil.isNotEmpty((Collection)queryDbGoodsResult.getList())) {
                    ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomains = new ArrayList<WhOpstoreGoodsDomain>();
                    for (WhOpstoreGoods whOpstoreGoods : queryDbGoodsResult.getList()) {
                        WhOpstoreGoodsDomain whOpstoreGoodsDomain = (WhOpstoreGoodsDomain)receiveGoodsDataMap.get(whOpstoreGoods.getChannelName() + "-" + whOpstoreGoods.getGoodsProperty2() + "-" + whOpstoreGoods.getGoodsEocode());
                        if (null == whOpstoreGoodsDomain) continue;
                        BeanUtils.copyAllPropertysNotNull((Object)whOpstoreGoods, (Object)whOpstoreGoodsDomain);
                        WhOpstoreGoodsDomain afterEditGoodsObj = new WhOpstoreGoodsDomain();
                        BeanUtils.copyAllPropertys((Object)afterEditGoodsObj, (Object)whOpstoreGoods);
                        if (StringUtils.isBlank((String)getDbObj.getOpstoreCode())) {
                            throw new Exception("checkExist\u67e5\u8be2Sku\u6279\u6b21\u7684opstoreGoodsCode\u4e3a\u7a7a");
                        }
                        queryMap.clear();
                        map.clear();
                        queryMap.put("tenantCode", "2019071800001392");
                        queryMap.put("opstoreGoodsCode", afterEditGoodsObj.getOpstoreGoodsCode());
                        map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
                        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapSkuMap", (Object)JsonUtil.buildNormalBinder().toJson(map));
                        QueryResult queryDbSkuResult = this.sendReSupObject("wh.WhOpstore.queryOpstoreSkuPage", map, WhOpstoreSku.class);
                        this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.queryMapSkuResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryDbSkuResult));
                        if (queryDbSkuResult != null && ListUtil.isNotEmpty((Collection)queryDbSkuResult.getList())) {
                            ArrayList<WhOpstoreSkuDomain> whStoreSkuDomains = new ArrayList<WhOpstoreSkuDomain>();
                            for (WhOpstoreSku whOpstoreSku : queryDbSkuResult.getList()) {
                                WhOpstoreSkuDomain whOpstoreSkuDomain = (WhOpstoreSkuDomain)receiveSkuDataMap.get(whOpstoreGoodsDomain.getChannelName() + "-" + whOpstoreGoodsDomain.getGoodsProperty2() + "-" + whOpstoreGoodsDomain.getGoodsEocode() + "-" + whOpstoreSku.getSkuNo());
                                if (null == whOpstoreSkuDomain) continue;
                                BeanUtils.copyAllPropertysNotNull((Object)whOpstoreSku, (Object)whOpstoreSkuDomain);
                                WhOpstoreSkuDomain afterEditSkuObj = new WhOpstoreSkuDomain();
                                BeanUtils.copyAllPropertys((Object)afterEditSkuObj, (Object)whOpstoreSku);
                                whStoreSkuDomains.add(afterEditSkuObj);
                            }
                            afterEditGoodsObj.setWhOpstoreSkuDomainList(whStoreSkuDomains);
                        }
                        whOpstoreGoodsDomains.add(afterEditGoodsObj);
                    }
                    getDbObj.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomains);
                }
                queryMap.put("checkFlag", "true");
            } else {
                queryMap.put("checkFlag", "false");
            }
            queryMap.put("currentObj", null == getDbObj ? whOpstoreDomain : getDbObj);
            this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkExist.FinnalResult", (Object)JsonUtil.buildNormalBinder().toJson(queryMap));
            return queryMap;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new Exception("checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38");
        }
    }

    private void HandleWarehouseName(WhOpstoreDomain whOpstoreDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && StringUtils.isNotBlank((String)whOpstoreDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreDomain.getWarehouseName())) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("warehouseOcode", whOpstoreDomain.getWarehouseCode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryResult = this.sendReSupObject("wh.warehouse.queryWarehousePage", sendMap, WhWarehouse.class);
            if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList()) && !EmptyUtil.isEmpty(queryResult.getList().get(0))) {
                whOpstoreDomain.setWarehouseName(((WhWarehouse)queryResult.getList().get(0)).getWarehouseName());
            }
        }
    }

    public void checkGoodsClass(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("goodsClass", "plat");
                paramMap.put("skuNo", whOpstoreGoodsDomain.getGoodsNo());
                paramMap.put("memberCode", whOpstoreDomain.getMemberCode());
                paramMap.put("tenantCode", "2019071800001392");
                String returnJsonStr = this.internalInvoke("rs.resourceGoods.getResourceBySkuNo", paramMap);
                this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkGoodsClass", (Object)("internalInvoke\u8fd4\u56de\n" + returnJsonStr));
                if (StringUtils.isNotBlank((String)returnJsonStr)) {
                    GoodsBean goodsBean = (GoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(returnJsonStr, GoodsBean.class);
                    this.logger.info("jbsSap.JbsSapWarehouseServiceImpl.checkGoodsClass", (Object)("GoodsBeanJSON\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)goodsBean)));
                    if (null == goodsBean || null == goodsBean.getRsResourceGoods() || null == goodsBean.getRsSku()) continue;
                    RsResourceGoods rsResourceGoods = goodsBean.getRsResourceGoods();
                    whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                    whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
                    whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
                    List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                    BigDecimal sumNum = BigDecimal.ZERO;
                    BigDecimal sumWeight = BigDecimal.ZERO;
                    if (!ListUtil.isNotEmpty(whOpstoreSkuDomainList)) continue;
                    for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                        whOpstoreSkuDomain.setClasstreeCode(goodsBean.getRsSku().getClasstreeCode());
                        whOpstoreSkuDomain.setClasstreeName(goodsBean.getRsSku().getClasstreeName());
                    }
                    continue;
                }
                throw new ApiException(whOpstoreGoodsDomain.getGoodsNo() + ":\u8be5\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        }
    }

    private void calculateNumOrWeight(RsSku rsSku, WhOpstoreSkuDomain whOpstoreSkuDomain) {
        Optional.ofNullable(rsSku).map(RsSku::getSkuName).map(name -> {
            if (name.contains("-")) {
                return name.split("-")[0];
            }
            return name;
        }).map(str -> new BigDecimal((String)str)).map(divide -> {
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" divide: " + divide));
            BigDecimal goodsNum = whOpstoreSkuDomain.getGoodsNum();
            BigDecimal goodsWeight = whOpstoreSkuDomain.getGoodsWeight();
            this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" goodsNum: " + goodsNum + "goodsWeight: " + goodsWeight));
            if (goodsNum == null && goodsWeight != null) {
                goodsNum = goodsWeight.divide((BigDecimal)divide, 4, RoundingMode.HALF_UP);
                this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" goodsNum: " + goodsNum));
                whOpstoreSkuDomain.setGoodsNum(goodsNum);
                whOpstoreSkuDomain.setPartsnameNumunit(rsSku.getPartsnameNumunit());
            }
            if (goodsWeight == null && goodsNum != null) {
                goodsWeight = goodsNum.multiply((BigDecimal)divide);
                this.logger.error("jbsSap.JbsSapWarehouseServiceImpl.calculateNumOrWeight", (Object)(" goodsWeight: " + goodsWeight));
                whOpstoreSkuDomain.setGoodsWeight(goodsWeight);
                whOpstoreSkuDomain.setPartsnameWeightunit(rsSku.getPartsnameWeightunit());
            }
            return whOpstoreSkuDomain;
        }).orElseThrow(() -> new ApiException());
    }
}

