/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sap.JbsSapServerConstants;
import com.yqbsoft.laser.service.sap.domian.InvInvlist;
import com.yqbsoft.laser.service.sap.domian.InvInvlistDomain;
import com.yqbsoft.laser.service.sap.domian.InvInvlistGoods;
import com.yqbsoft.laser.service.sap.domian.InvInvlistGoodsDomain;
import com.yqbsoft.laser.service.sap.domian.InvInvrate;
import com.yqbsoft.laser.service.sap.domian.InvUserinv;
import com.yqbsoft.laser.service.sap.domian.OcContractReDomain;
import com.yqbsoft.laser.service.sap.domian.OcRefundReDomain;
import com.yqbsoft.laser.service.sap.domian.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.sap.domian.UmUser;
import com.yqbsoft.laser.service.sap.domian.UmUserinfo;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSendInvoiceRequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSendInvoiceResponse;
import com.yqbsoft.laser.service.sap.service.InvoiceService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceServiceImpl
extends BaseServiceImpl
implements InvoiceService {
    private String SYS_CODE = "jbsSap.InvoiceServiceImpl";

    @Override
    public String sendInvoice(InvInvlistDomain invInvlist) throws Exception {
        if (null == invInvlist) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.invInvlist.null");
            return JbsUtils.getErrorMap("invInvlist\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", "01");
        }
        this.logger.info(this.SYS_CODE + ".sendInvoice.invInvlist", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvlist));
        List<InvInvlistGoodsDomain> invInvlistGoodsDomainList = invInvlist.getInvInvlistGoodsDomainList();
        if (ListUtil.isEmpty(invInvlistGoodsDomainList)) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList.null", (Object)(invInvlist.getTenantCode() + "=======" + invInvlist.getInvlistCode()));
            return JbsUtils.getErrorMap("invInvlistGoodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01", "01");
        }
        OcContractReDomain ocContractReDomain = this.checkOcContract(invInvlist.getInvlistOpcode());
        if (null == ocContractReDomain) {
            this.logger.error(this.SYS_CODE + ".sendInvoice.ocContractReDomain.01");
            return JbsUtils.getErrorMap("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "01");
        }
        String originalInvoiceNo = null;
        InvUserinv invUserinv = this.queryOneInvUser(invInvlist.getUserinvCode());
        if (null == invUserinv) {
            return JbsUtils.getErrorMap("invUserinv", "\u65e0\u5f00\u7968\u4eba");
        }
        List<InvUserinv> invUser = this.queryInvUser(ocContractReDomain.getMemberMcode(), ocContractReDomain.getTenantCode());
        if (ListUtil.isEmpty(invUser)) {
            return JbsUtils.getErrorMap("invUser", "\u65e0\u9500\u65b9\u4fe1\u606f");
        }
        InvUserinv invUserinvSeller = invUser.get(0);
        Integer i = 0;
        BigDecimal sumMoney = BigDecimal.ZERO;
        ArrayList<Map<String, Object>> invoiceDetailsList = new ArrayList<Map<String, Object>>();
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomains = new ArrayList<InvInvlistGoodsDomain>();
        BigDecimal famount = BigDecimal.ZERO;
        for (InvInvlistGoodsDomain invInvlistGoodsDomain : invInvlistGoodsDomainList) {
            if (null == invInvlistGoodsDomain.getGoodsPro()) {
                invInvlistGoodsDomain.setGoodsPro("0");
            }
            if ("5".equals(invInvlistGoodsDomain.getGoodsPro())) continue;
            if (invInvlistGoodsDomain.getDataOpbillstate() == null) {
                invInvlistGoodsDomain.setDataOpbillstate(0);
            }
            if (invInvlistGoodsDomain.getDataOpbillstate() != 3 && invInvlistGoodsDomain.getDataOpbillstate() != 4) {
                invInvlistGoodsDomains.add(invInvlistGoodsDomain);
                continue;
            }
            famount = famount.add(invInvlistGoodsDomain.getContractGoodsMoney());
        }
        if (null == invInvlist.getInvlistOpamt()) {
            invInvlist.setInvlistOpamt(BigDecimal.ZERO);
        }
        BigDecimal tempAll = BigDecimal.ZERO;
        for (InvInvlistGoodsDomain invInvlistGoodsDomain : invInvlistGoodsDomains) {
            BigDecimal temp;
            i = i + 1;
            if (invInvlistGoodsDomain.getGoodsNum() == null) {
                invInvlistGoodsDomain.setGoodsNum(BigDecimal.ONE);
            }
            HashMap<String, Object> detailsMap = new HashMap<String, Object>();
            if (null == invInvlistGoodsDomain.getContractGoodsMoney()) {
                invInvlistGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            if (i.intValue() != invInvlistGoodsDomains.size()) {
                temp = invInvlistGoodsDomain.getContractGoodsMoney().divide(invInvlist.getInvlistOpamt().subtract(famount), 8, 4).multiply(famount).setScale(2, 4);
                invInvlistGoodsDomain.setContractGoodsPrice(invInvlistGoodsDomain.getContractGoodsPrice().add(temp.divide(invInvlistGoodsDomain.getGoodsNum(), 2, 4)));
                tempAll = tempAll.add(temp);
            } else {
                temp = famount.subtract(tempAll);
                invInvlistGoodsDomain.setContractGoodsPrice(invInvlistGoodsDomain.getContractGoodsPrice().add(temp.divide(invInvlistGoodsDomain.getGoodsNum(), 2, 4)));
            }
            invInvlistGoodsDomain.setContractGoodsMoney(invInvlistGoodsDomain.getContractGoodsMoney().add(temp));
            detailsMap.put("requestionLineNo", i);
            detailsMap.put("invoiceLineNature", 0);
            detailsMap.put("itemCode", invInvlistGoodsDomain.getSkuNo());
            detailsMap.put("goodsQuantity", invInvlistGoodsDomain.getGoodsNum());
            detailsMap.put("goodsPrice", invInvlistGoodsDomain.getContractGoodsPrice().setScale(2, 4));
            detailsMap.put("goodsTotalPrice", invInvlistGoodsDomain.getContractGoodsMoney().setScale(2, 4));
            sumMoney = sumMoney.add(invInvlistGoodsDomain.getContractGoodsMoney());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.getResourceGoods(invInvlistGoodsDomain.getGoodsNo());
            if ((null == rsResourceGoodsReDomain || StringUtils.isBlank((String)rsResourceGoodsReDomain.getAreaCode())) && (null == (rsResourceGoodsReDomain = this.getResourceGoodsCode(invInvlistGoodsDomain.getGoodsCode())) || StringUtils.isBlank((String)rsResourceGoodsReDomain.getAreaCode()))) {
                return JbsUtils.getErrorMap("\u67e5\u8be2\u5f00\u7968\u65e0\u5546\u54c1\u4fe1\u606fgoods/\u65e0\u7a0e\u7387:" + invInvlistGoodsDomain.getGoodsNo(), invInvlistGoodsDomain.getGoodsCode());
            }
            List<InvInvrate> invInvrateList = this.queryRate(rsResourceGoodsReDomain.getAreaCode());
            if (EmptyUtil.isEmpty(invInvrateList) || EmptyUtil.isEmpty((Object)invInvrateList.get(0).getInvrateRate())) {
                return JbsUtils.getErrorMap("\u65e0\u7a0e\u7387\u503c", rsResourceGoodsReDomain.getAreaCode());
            }
            InvInvrate invInvrate = invInvrateList.get(0);
            BigDecimal newRate = invInvrate.getInvrateRate().divide(new BigDecimal(100));
            BigDecimal tempRate = new BigDecimal(1).add(newRate);
            BigDecimal amountTax = invInvlistGoodsDomain.getContractGoodsMoney().divide(tempRate, 2, 4);
            BigDecimal goodsTotalTax = invInvlistGoodsDomain.getContractGoodsMoney().subtract(amountTax).setScale(2, 4);
            detailsMap.put("goodsTaxRate", newRate.setScale(3, 4));
            detailsMap.put("goodsTotalTax", goodsTotalTax);
            if ("1".equals(invInvlist.getInvlistType())) {
                if (null == invInvlistGoodsDomain.getGoodsNum()) {
                    invInvlistGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                detailsMap.put("goodsQuantity", invInvlistGoodsDomain.getGoodsNum().negate());
                if (null == invInvlistGoodsDomain.getContractGoodsPrice()) {
                    invInvlistGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                detailsMap.put("goodsPrice", invInvlistGoodsDomain.getContractGoodsPrice().setScale(2, 4));
                detailsMap.put("goodsTotalPrice", invInvlistGoodsDomain.getContractGoodsMoney().negate().setScale(2, 4));
                detailsMap.put("goodsTotalTax", goodsTotalTax.negate().setScale(2, 4));
            }
            invoiceDetailsList.add(detailsMap);
        }
        HttpFormfacade httpFormfacade = new HttpFormfacade();
        httpFormfacade.setInsideOrderNo(invInvlist.getInvlistCode());
        Object var15_18 = null;
        JbsSapSendInvoiceRequest jbsSapSendInvoiceRequest = new JbsSapSendInvoiceRequest();
        try {
            JSONObject jsonObject = InvoiceServiceImpl.getData();
            httpFormfacade.setHost(jsonObject.getString("url"));
            BeanUtils.copyAllPropertys((Object)jbsSapSendInvoiceRequest, (Object)invInvlist);
            String invoiceTerminalCode = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_inv-invoiceTerminalCode");
            String source = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_inv-source");
            jbsSapSendInvoiceRequest.setInvoiceTerminalCode(invoiceTerminalCode);
            jbsSapSendInvoiceRequest.setOriginalInvoiceNo(originalInvoiceNo);
            jbsSapSendInvoiceRequest.setInvoiceDetailsList(invoiceDetailsList);
            jbsSapSendInvoiceRequest.setInvoiceTotalPrice(sumMoney);
            jbsSapSendInvoiceRequest.setDeductibleAmount(sumMoney);
            jbsSapSendInvoiceRequest.setSellerTaxNo(StringUtils.isNotBlank((String)invUserinvSeller.getUserinvNo()) ? invUserinvSeller.getUserinvNo() : null);
            if (StringUtils.isNotBlank((String)invUserinvSeller.getUserinvBank()) && StringUtils.isNotBlank((String)invUserinvSeller.getUserinvBankno())) {
                jbsSapSendInvoiceRequest.setSellerBankAccount(invUserinvSeller.getUserinvBank() + " " + invUserinvSeller.getUserinvBankno());
            }
            if (StringUtils.isNotBlank((String)invUserinvSeller.getUserinvAdd()) && StringUtils.isNotBlank((String)invUserinvSeller.getUserinvUphone())) {
                jbsSapSendInvoiceRequest.setSellerAddressPhone(invUserinvSeller.getUserinvAdd() + " " + invUserinvSeller.getUserinvUphone());
            }
            jbsSapSendInvoiceRequest.setBuyerTaxNo(StringUtils.isNotBlank((String)invUserinv.getUserinvNo()) ? invUserinv.getUserinvNo() : null);
            jbsSapSendInvoiceRequest.setBuyerName(StringUtils.isNotBlank((String)invUserinv.getUserinvMember()) ? invUserinv.getUserinvMember() : null);
            if (StringUtils.isNotBlank((String)invUserinv.getUserinvBank()) && StringUtils.isNotBlank((String)invUserinv.getUserinvBankno())) {
                jbsSapSendInvoiceRequest.setBuyerBankAccount(invUserinv.getUserinvBank() + " " + invUserinv.getUserinvBankno());
            }
            if (StringUtils.isNotBlank((String)invUserinv.getUserinvAdd()) && StringUtils.isNotBlank((String)invUserinv.getUserinvPhone())) {
                jbsSapSendInvoiceRequest.setBuyerAddressPhone(invUserinv.getUserinvAdd() + " " + invUserinv.getUserinvPhone());
            }
            if (StringUtils.isNotBlank((String)invUserinv.getUserinvUeamil())) {
                jbsSapSendInvoiceRequest.setBuyerEmail(invUserinv.getUserinvUeamil());
            }
            if (StringUtils.isNotBlank((String)invUserinv.getUserinvUphone())) {
                jbsSapSendInvoiceRequest.setBuyerMobilePhone(invUserinv.getUserinvUphone());
            }
            jbsSapSendInvoiceRequest.setMemo(source);
            this.logger.info(this.SYS_CODE + ".sendInvoice.executeStart", (Object)("\u53d1\u7968\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570>>>>" + JsonUtil.buildNormalBinder().toJson(jbsSapSendInvoiceRequest.getTextParams())));
            JbsSapSendInvoiceResponse jbsSapSendInvoiceResponse = httpFormfacade.execute(jbsSapSendInvoiceRequest);
            this.logger.info(this.SYS_CODE + ".sendInvoice.executeEnd", (Object)("\u53d1\u7968\u63a5\u53e3\u54cd\u5e94\u53c2\u6570>>>>" + JsonUtil.buildNormalBinder().toJson((Object)jbsSapSendInvoiceResponse)));
            if (!jbsSapSendInvoiceResponse.isSuccess()) {
                HashMap<String, Object> executeError = new HashMap<String, Object>();
                executeError.put("memo", jbsSapSendInvoiceResponse.getMsg());
                this.updateInvlist("2019071800001392", invInvlist.getInvlistCode(), JbsSapServerConstants.ERROR_DATA_STATE, null, executeError);
                return JbsUtils.getErrorMap("error", "\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u7b49\u5f85\u5f02\u6b65:" + jbsSapSendInvoiceResponse.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE, (Object)"\u53d1\u7968\u63a5\u53e3>>>>", (Throwable)e);
            return JbsUtils.getErrorMap("exception", JsonUtil.buildNormalBinder().toJson(var15_18));
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String receiveInvoice(String dataStr) throws Exception {
        this.logger.info(this.SYS_CODE + ".receiveInvoice.dataStr->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dataStr));
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.dataStr->", (Object)"\u4e3a\u7a7a");
            return JbsUtils.getErrorMap("blank", dataStr);
        }
        JSONArray jsonArray = JSONArray.json2array((String)dataStr);
        StringBuffer sb = new StringBuffer();
        jsonArray.stream().forEach(j -> {
            String msg = this.checkInvinvlist((JSONObject)j);
            if (StringUtils.isNotBlank((String)msg)) {
                sb.append(msg).append(",");
            }
        });
        if (StringUtils.isNotBlank((String)sb.toString())) {
            this.logger.error(this.SYS_CODE + ".receiveInvoice.object->", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonArray));
            return JbsUtils.getErrorMap("check", sb.toString() + "=" + dataStr);
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (JSONObject j2 : jsonArray) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("invlistOcode", j2.getString("invlistOcode"));
            map.put("invlistOcode1", j2.getString("invlistOcode1"));
            map.put("invlistOcode2", j2.getString("invlistOcode2"));
            map.put("invlistOurl", j2.getString("invlistOurl"));
            try {
                if ("2".equals(j2.getString("dataState"))) {
                    this.logger.info(this.SYS_CODE + ".receiveInvoice.datastate->done", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
                    this.updateInvlist("2019071800001392", j2.getString("invlistCode"), JbsSapServerConstants.SUCCESS_DATA_STATE, null, map);
                    continue;
                }
                if ("5".equals(j2.getString("dataState"))) {
                    this.logger.info(this.SYS_CODE + ".receiveInvoice.datastate->GG", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
                    this.updateInvlist("2019071800001392", j2.getString("invlistCode"), JbsSapServerConstants.GG_DATA_STATE, null, map);
                    continue;
                }
                this.logger.info(this.SYS_CODE + ".receiveInvoice.update->", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
                this.updateInvlist("2019071800001392", j2.getString("invlistCode"), JbsSapServerConstants.RED_FLUSH_DATA_STATE, null, map);
            }
            catch (Exception e) {
                list.add(j2);
            }
        }
        if (ListUtil.isNotEmpty(list)) {
            return JbsUtils.getSuccessMap("\u4fee\u6539\u53d1\u7968\u6570\u636e\u5931\u8d25--" + JsonUtil.buildNonDefaultBinder().toJson(list));
        }
        return JbsUtils.getSuccessMap("success");
    }

    public void updateContractInvstate(String invlistOpcode, String dataState) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", invlistOpcode);
        map.put("dataState", dataState);
        map.put("oldDataState", null);
        map.put("tenantCode", "2019071800001392");
        this.getInternalRouter().inInvoke("oc.contract.updateContractInvstate", map);
    }

    public void updateInvlist(String tenantCode, String invlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        HashMap<String, Object> invlistMap = new HashMap<String, Object>();
        invlistMap.put("tenantCode", tenantCode);
        invlistMap.put("invlistCode", invlistCode);
        invlistMap.put("dataState", dataState + "");
        invlistMap.put("oldDataState", oldDataState);
        invlistMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.getInternalRouter().inInvoke("inv.channelsendBase.sendUpdateInvlistStateByCode", invlistMap);
    }

    public String checkInvinvlist(JSONObject object) {
        String msg = "";
        if (StringUtils.isBlank((String)object.getString("invlistCode"))) {
            msg = msg + "invlistCode\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode"))) {
            msg = msg + "invlistOcode\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode1"))) {
            msg = msg + "invlistOcode1\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOcode2"))) {
            msg = msg + "invlistOcode2\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("dataState"))) {
            msg = msg + "dataState\u4e3a\u7a7a\uff0c";
        }
        if (StringUtils.isBlank((String)object.getString("invlistOurl"))) {
            msg = msg + "invlistOurl\u4e3a\u7a7a";
        }
        return msg;
    }

    public InvInvlist queryInvlist(String invlistBatchcode) throws Exception {
        if (StringUtils.isBlank((String)invlistBatchcode)) {
            return null;
        }
        HashMap<String, String> invlistMap = new HashMap<String, String>();
        invlistMap.put("tenantCode", "2019071800001392");
        invlistMap.put("invlistCode", invlistBatchcode);
        String invListStr = (String)this.getInternalRouter().inInvoke("inv.invlist.getInvlistByCode", invlistMap);
        InvInvlist invInvlist = (InvInvlist)JsonUtil.buildNonNullBinder().getJsonToObject(invListStr, InvInvlist.class);
        this.logger.info(this.SYS_CODE + ".queryInvlist->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvlist));
        return invInvlist;
    }

    public List<InvInvrate> queryRate(String areaCode) throws Exception {
        if (StringUtils.isBlank((String)areaCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> rateMap = new HashMap<String, String>();
        rateMap.put("invrateOpcode", areaCode);
        rateMap.put("invrateOptype", "areaCode");
        rateMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNormalBinder().toJson(rateMap));
        QueryResult invInvrateResult = this.sendReSupObject("inv.invset.queryInvratePage", map, InvInvrate.class);
        List invInvrateList = invInvrateResult.getList();
        if (ListUtil.isEmpty((Collection)invInvrateList)) {
            this.logger.error(this.SYS_CODE + ".queryRate.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvrateList));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryRate->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invInvrateList));
        return invInvrateList;
    }

    public RsResourceGoodsReDomain getResourceGoods(String goodsNo) throws Exception {
        if (StringUtils.isBlank((String)goodsNo)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        goodsMap.put("goodsNo", goodsNo);
        goodsMap.put("goodsClass", "plat");
        goodsMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNonNullBinder().toJson(goodsMap));
        QueryResult queryResutl = this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", map, RsResourceGoodsReDomain.class);
        if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(this.SYS_CODE + ".getResourceGoods.null", (Object)((Object)map).toString());
            return null;
        }
        return (RsResourceGoodsReDomain)queryResutl.getList().get(0);
    }

    public RsResourceGoodsReDomain getResourceGoodsCode(String goodsCode) throws Exception {
        if (StringUtils.isBlank((String)goodsCode)) {
            return null;
        }
        HashMap<String, String> goodsMap = new HashMap<String, String>();
        goodsMap.put("goodsCode", goodsCode);
        goodsMap.put("tenantCode", "2019071800001392");
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", goodsMap, "object", new Object[]{RsResourceGoodsReDomain.class});
        if (null == rsResourceGoodsReDomain) {
            this.logger.error(this.SYS_CODE + ".getResourceGoods.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsMap));
            return null;
        }
        return rsResourceGoodsReDomain;
    }

    public List<InvUserinv> queryInvUser(String memberCode, String tenantCode) throws Exception {
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
            this.logger.error(this.SYS_CODE + ".queryInvUser.memberCode", (Object)(memberCode + "-" + tenantCode));
        }
        HashMap<String, String> invMap = new HashMap<String, String>();
        HashMap<String, String> invMapStr = new HashMap<String, String>();
        invMapStr.put("memberCode", memberCode);
        invMapStr.put("tenantCode", "2019071800001392");
        invMap.put("map", JsonUtil.buildNormalBinder().toJson(invMapStr));
        QueryResult invQueryResult = this.sendReSupObject("inv.userinv.queryUserinvPage", invMap, InvUserinv.class);
        List invlist = invQueryResult.getList();
        if (ListUtil.isEmpty((Collection)invlist)) {
            this.logger.error(this.SYS_CODE + ".queryInvUser.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(invMapStr));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryInvUser->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invlist));
        return invlist;
    }

    public List<UmUser> queryUmUser(String userinfoCode) throws Exception {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        HashMap<String, String> userMapStr = new HashMap<String, String>();
        userMapStr.put("userPcode", userinfoCode);
        userMapStr.put("tenantCode", "2019071800001392");
        userMap.put("map", JsonUtil.buildNormalBinder().toJson(userMapStr));
        QueryResult umQueryResult = this.sendReSupObject("um.user.queryUserPage", userMap, UmUser.class);
        List userslist = umQueryResult.getList();
        if (ListUtil.isEmpty((Collection)userslist)) {
            this.logger.error(this.SYS_CODE + ".queryUmUser.userslist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userMapStr));
            throw new Exception("userslist\u4e3a\u7a7a\uff01");
        }
        return userslist;
    }

    public UmUserinfo queryOneUmUserinfo(String userinfoCode) throws Exception {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("userinfoCode", userinfoCode);
        userInfoMap.put("tenantCode", "2019071800001392");
        String userInfoStr = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", userInfoMap);
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNonNullBinder().getJsonToObject(userInfoStr, UmUserinfo.class);
        if (umUserinfo == null) {
            this.logger.error(this.SYS_CODE + ".queryOneUmUserinfo.umUserinfo.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userInfoMap));
            throw new Exception("umUserinfo\u4e3a\u7a7a\uff01");
        }
        return umUserinfo;
    }

    public InvUserinv queryOneInvUser(String userinvCode) throws Exception {
        if (StringUtils.isBlank((String)userinvCode)) {
            return null;
        }
        HashMap<String, String> userinvMap = new HashMap<String, String>();
        userinvMap.put("tenantCode", "2019071800001392");
        userinvMap.put("userinvCode", userinvCode);
        String userinvStr = (String)this.getInternalRouter().inInvoke("inv.userinv.getUserinvByCode", userinvMap);
        InvUserinv invUserinv = (InvUserinv)JsonUtil.buildNonNullBinder().getJsonToObject(userinvStr, InvUserinv.class);
        if (invUserinv == null) {
            this.logger.error(this.SYS_CODE + ".queryOneInvUser.invUserinv.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(userinvMap));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryOneInvUser->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invUserinv));
        return invUserinv;
    }

    public OcRefundReDomain checkOcRefund(String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke("oc.refund.getRefundByCode", parameter);
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcRefundReDomain.class);
        this.logger.info(this.SYS_CODE + ".checkOcRefund.ocRefundReDomain.ocRefundReDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        return ocRefundReDomain;
    }

    public OcContractReDomain checkOcContract(String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", "2019071800001392");
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", parameter);
        OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcContractReDomain.class);
        this.logger.info(this.SYS_CODE + ".checkOcContract.ocContractReDomain.ocContractReDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        return ocContractReDomain;
    }

    public List<InvInvlistGoods> queryInvlistGoodsPage(String tenantCode, String invlistCode) throws Exception {
        if (StringUtils.isBlank((String)invlistCode)) {
            return null;
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("invlistCode", invlistCode);
        map.put("tenantCode", tenantCode);
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult invQueryResult = this.sendReSupObject("inv.invlistGoods.queryInvlistGoodsPage", parameter, InvInvlistGoods.class);
        List invlist = invQueryResult.getList();
        if (ListUtil.isEmpty((Collection)invlist)) {
            this.logger.error(this.SYS_CODE + ".queryInvlistGoodsPage.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            return null;
        }
        this.logger.info(this.SYS_CODE + ".queryInvlistGoodsPage->", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)invlist));
        return invlist;
    }

    private static JSONObject getData() {
        String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_inv-jbs_inv");
        return JSONObject.json2object((String)paramJson);
    }
}

