/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.facade.response;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.sap.common.response.SupperResponse;
import com.yqbsoft.laser.service.sap.domian.DaStoreErpDomain;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JbsSapQueryWhResponse
extends SupperResponse {
    private static final SupperLogUtil logger = new SupperLogUtil(JbsSapQueryWhResponse.class);
    private List<DaStoreErpDomain> storeErpDomainList;

    public List<DaStoreErpDomain> getStoreErpDomainList() {
        return this.storeErpDomainList;
    }

    public void setStoreErpDomainList(List<DaStoreErpDomain> storeErpDomainList) {
        this.storeErpDomainList = storeErpDomainList;
    }

    @Override
    public void makeDomain(String body) {
        try {
            logger.error("==http==", (Object)body);
            this.setSuccess(false);
            if (StringUtils.isEmpty((String)body)) {
                this.setMsg("\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(body, String.class, Object.class);
            if (MapUtil.isEmpty((Map)jsonToMap) || EmptyUtil.isEmpty(jsonToMap.get("data"))) {
                this.setMsg("\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            JSONObject data = JSONObject.json2object((String)JsonUtil.buildNormalBinder().toJson(jsonToMap.get("data")));
            JSONArray stockList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(data.get((Object)"stock")));
            if (null == stockList) {
                this.setMsg("\u8f6c\u6362\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            ArrayList<DaStoreErpDomain> daStoreErpDomains = new ArrayList<DaStoreErpDomain>();
            for (JSONObject jsonObject : stockList) {
                Object skuNo = jsonObject.get((Object)"material");
                if (EmptyUtil.isEmpty((Object)skuNo) || "0".equals(String.valueOf(skuNo))) {
                    this.setMsg("SAP\u5e93\u5b58\u6570\u636e\u4e3a\u7a7a");
                    return;
                }
                DaStoreErpDomain daStoreErpDomain = this.handleErpData(jsonObject);
                daStoreErpDomains.add(daStoreErpDomain);
            }
            this.setSuccess(true);
            this.setMsg("\u64cd\u4f5c\u6210\u529f");
            this.setStoreErpDomainList(daStoreErpDomains);
        }
        catch (Exception e) {
            this.setSuccess(false);
            this.setMsg("\u9002\u914d\u5668\u5904\u7406Response\u5f02\u5e38");
            return;
        }
    }

    private DaStoreErpDomain handleErpData(JSONObject jsonObject) {
        if (null == jsonObject) {
            throw new ApiException("handleErpData.null");
        }
        DaStoreErpDomain daStoreErpDomain = new DaStoreErpDomain();
        String skuNo = jsonObject.get((Object)"material") + "";
        String warehouseCode = jsonObject.get((Object)"Plant") + "";
        String whLocal = jsonObject.get((Object)"SLoc") + "";
        String batchNumber = jsonObject.get((Object)"Batch") + "";
        BigDecimal num = this.handleBigDecimal(jsonObject.get((Object)"Quantity"));
        BigDecimal blockNum = this.handleBigDecimal(jsonObject.get((Object)"Quantity_BLOCK"));
        String unit = jsonObject.get((Object)"Unit") + "";
        daStoreErpDomain.setSkuNo(skuNo);
        daStoreErpDomain.setWarehouseCode(warehouseCode);
        daStoreErpDomain.setStoreWhlocal(whLocal);
        daStoreErpDomain.setSkuBarcode(batchNumber);
        if ("KG,G".contains(unit.toUpperCase())) {
            daStoreErpDomain.setGoodsWeight(num);
            daStoreErpDomain.setGoodsSweight(blockNum);
            daStoreErpDomain.setPartsnameWeightunit(unit);
        } else {
            daStoreErpDomain.setGoodsNum(num);
            daStoreErpDomain.setGoodsSnum(blockNum);
            daStoreErpDomain.setPartsnameNumunit(unit);
        }
        daStoreErpDomain.setTenantCode("2019071800001392");
        return daStoreErpDomain;
    }

    private BigDecimal handleBigDecimal(Object obj) {
        if (EmptyUtil.isEmpty((Object)obj)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal((obj + "").trim());
    }
}

