/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdjos.goods.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.cloudtrade.ApiCtpSkuService.response.getSkuList.ApiSkuListInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthToken;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.jdjos.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdjos.domain.PoolSkubean;
import com.yqbsoft.laser.service.ext.channel.jdjos.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.channel.jdjos.goods.service.DisGoodsServiceImpl;
import com.yqbsoft.laser.service.ext.channel.jdjos.util.JdBeanUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EsGoodsServiceImpl
extends DisGoodsServiceImpl
implements EsGoodsService {
    private String SYS_CODE = "jdjos.EsGoodsServiceImpl";
    private static final String RESOURCEGOODS_GETNO_API_CODE = "rs.resourceGoods.getResourceBySkuNo";
    private static final String RESOURCEGOODS_DEL_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SOLD_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SHELVE_CODE = "rs.resource.sendUpdateShelveGoods";

    @Override
    public void saveGoodsPool(PoolSkubean poolSkubean) throws Exception {
        this.saveGoodsSku(poolSkubean);
    }

    @Override
    public void saveGoodsPrice(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            return;
        }
        ApiSkuListInfo poolInfo = poolSkubean.getPoolInfo();
        DisChannel disChannel = poolSkubean.getDisChannel();
        JdClient client = poolSkubean.getClient();
    }

    @Override
    public boolean saveVopJdSkuIds(PoolSkubean poolSkubean) {
        return true;
    }

    @Override
    public void updateGoodsInfo(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".updateGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
                return;
            }
            ArrayList<Long> addGoodsVopIds = new ArrayList<Long>();
            RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
            addGoodsVopIds.add(Long.parseLong(rsResourceGoods.getGoodsNo()));
            this.logger.info(this.SYS_CODE + ".updateGoodsInfo.updateGoodsSku========16================" + skuId);
            JdClient client = this.getJdClient(jdResponseMessageContentDomain);
            this.updateGoodsSku(client, addGoodsVopIds, jdResponseMessageContentDomain.getDisChannel(), jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        }
    }

    @Override
    public void putOrOffGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        this.logger.info(this.SYS_CODE + ".putOrOffGoods.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        String state = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            this.logger.info(this.SYS_CODE + ".contentMap>>>>>>>>>>>>>>>>" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            ArrayList<String> goodsIds = new ArrayList<String>();
            goodsIds.add(skuId);
            state = JsonUtil.buildNormalBinder().toJson(contentMap.get("state"));
            this.soldOrShelveGoodsByGoodsIds(goodsIds, state, jdResponseMessageContentDomain);
        }
    }

    @Override
    public void addOrRemoveGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        Object pageNum = null;
        if (!MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoods \u4eac\u4e1c\u8fd4\u56de\u6d88\u606f\u5185\u5bb9\u9519\u8bef\uff0ccontent= " + content);
            return;
        }
        skuId = contentMap.get("skuId").toString();
        GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        if (goodsBean != null) {
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods contentMap= " + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
        if ("1".equals(contentMap.get("state").toString())) {
            if (null != goodsBean) {
                this.logger.error(this.SYS_CODE + ".addGoods \u5546\u54c1\u5df2\u7ecf\u5b58\u5728\uff0cskuId= " + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".addGoods skuId= ", (Object)skuId);
            this.addGoodsBySkuId(Long.valueOf(skuId), jdResponseMessageContentDomain);
        } else if ("2".equals(contentMap.get("state").toString())) {
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".RemoveGoods \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".RemoveGoods goodsIds= ", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsIds));
            this.delGoodsByGoodsIds(goodsIds);
        }
    }

    @Override
    public String updateGoodsPrice(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        return "SUCCESS";
    }

    private void delGoodsByGoodsIds(List<Integer> goodsIds) {
        this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", goodsIds);
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        try {
            params.put("goodsIds", goodsIds);
            this.logger.error(this.SYS_CODE + ".deletePromotioneToGoods.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".delGoodsByGoodsIds.ex", (Throwable)e);
        }
    }

    private void addGoodsBySkuId(Long skuId, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
    }

    private void soldOrShelveGoodsByGoodsIds(List<String> jdSkuIds, String type, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (ListUtil.isEmpty(jdSkuIds) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", (Object)(jdSkuIds + "===" + type));
            return;
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (String skuNo : jdSkuIds) {
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuNo, jdResponseMessageContentDomain.getDisChannel());
            if (goodsBean == null) {
                this.logger.error(this.SYS_CODE + ".contentMap---------------" + JsonUtil.buildNonEmptyBinder().toJson((Object)goodsBean));
                continue;
            }
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
            this.logger.info(this.SYS_CODE + ".contentMap==========>" + JsonUtil.buildNonEmptyBinder().toJson(goodsIds));
            if (!ListUtil.isNotEmpty(goodsIds)) continue;
            HashMap<String, ArrayList<Integer>> params = new HashMap<String, ArrayList<Integer>>();
            try {
                params.put("goodsIds", goodsIds);
                if ("0".equals(type)) {
                    this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                    this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
                    continue;
                }
                if (!"1".equals(type)) continue;
                this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.mapStr:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                this.getInternalRouter().inInvoke(RESOURCEGOODS_SHELVE_CODE, params);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u4e0a/\u4e0b\u67b6\u5931\u8d25", (Object)e.getMessage());
                throw new ApiException(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.ex", (Throwable)e);
            }
        }
    }

    @Override
    public String updateGoodsSku(JdClient client, List<Long> skuId, DisChannel disChannel, String tenantCode) {
        return "SUCCESS";
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", null);
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.error(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.buildNonEmptyBinder().toJson(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private JdClient getJdClient(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        String channelCode = jdResponseMessageContentDomain.getDisChannel().getChannelCode();
        String memberCode = jdResponseMessageContentDomain.getDisChannel().getMemberCcode();
        String accessToken = this.getToken(tenantCode, channelCode, memberCode);
        String serverUrl = (String)jdResponseMessageContentDomain.getKeyMap().get("serverUrl");
        String appKey = (String)jdResponseMessageContentDomain.getKeyMap().get("appKey");
        String appSecret = (String)jdResponseMessageContentDomain.getKeyMap().get("appSecret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }

    public String getToken(DisChannel disChannel) {
        String tokenStr;
        String tenantCode = disChannel.getTenantCode();
        String channelCode = disChannel.getChannelCode();
        String memberCode = disChannel.getMemberCcode();
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = "";
        }
        if (StringUtils.isBlank((String)(tokenStr = DisUtil.getRemotMap((String)"DisOauthToken-channelCode", (String)(channelCode + "-" + memberCode + "-" + tenantCode))))) {
            return null;
        }
        DisOauthToken disOauthToken = (DisOauthToken)JsonUtil.buildNormalBinder().getJsonToObject(tokenStr, DisOauthToken.class);
        if (null == disOauthToken) {
            return null;
        }
        return disOauthToken.getOauthTokenToken();
    }
}

