/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdjos.goods.service;

import com.alibaba.fastjson.JSONObject;
import com.jcloud.jcq.protocol.Message;
import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.cloudtrade.ApiCtpSkuService.response.getSkuDetail.ApiSkuDetail;
import com.jd.open.api.sdk.domain.cloudtrade.ApiCtpSkuService.response.getSkuDetail.ImageInfo;
import com.jd.open.api.sdk.domain.cloudtrade.ApiCtpSkuService.response.getSkuList.ApiSkuListInfo;
import com.jd.open.api.sdk.domain.cloudtrade.ApiGetSkuPriceService.response.getSkuPriceInfoList.ApiSkuPriceInfo;
import com.jd.open.api.sdk.domain.cloudtrade.ApiGetSkuPriceService.response.getSkuPriceInfoList.PriceInfo;
import com.jd.open.api.sdk.response.cloudtrade.CtpWarePriceGetSkuPriceInfoListResponse;
import com.jd.open.api.sdk.response.cloudtrade.CtpWareSkuGetSkuDetailResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthToken;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.jdjos.JdJosConstants;
import com.yqbsoft.laser.service.ext.channel.jdjos.domain.EditSkuDomain;
import com.yqbsoft.laser.service.ext.channel.jdjos.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdjos.domain.PoolSkubean;
import com.yqbsoft.laser.service.ext.channel.jdjos.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.channel.jdjos.goods.service.DisGoodsServiceImpl;
import com.yqbsoft.laser.service.ext.channel.jdjos.util.JdApi;
import com.yqbsoft.laser.service.ext.channel.jdjos.util.JdBeanUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EsGoodsServiceImpl
extends DisGoodsServiceImpl
implements EsGoodsService {
    private JdApi jdApi = new JdApi();
    private String SYS_CODE = "jdjos.EsGoodsServiceImpl";
    private static final String RESOURCEGOODS_GETNO_API_CODE = "rs.resourceGoods.getResourceBySkuNo";
    private static final String RESOURCEGOODS_DEL_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SOLD_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SHELVE_CODE = "rs.resource.sendUpdateShelveGoods";
    private static final String RESOURCEGOODS_UPDATE_CODE = "rs.resource.sendUpdateResourceGoods";
    private static final String RESOURCE_UPDATE_CODE = "rs.resourceGoods.updateSkuByEdit";

    @Override
    public void saveGoodsPool(PoolSkubean poolSkubean) throws Exception {
        this.saveGoodsSku(poolSkubean);
    }

    @Override
    public void saveGoodsPrice(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            return;
        }
        ApiSkuListInfo poolInfo = poolSkubean.getPoolInfo();
        DisChannel disChannel = poolSkubean.getDisChannel();
        JdClient client = poolSkubean.getClient();
    }

    @Override
    public boolean saveVopJdSkuIds(PoolSkubean poolSkubean) {
        return true;
    }

    @Override
    public void updateGoodsInfo(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".updateGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
                return;
            }
            ArrayList<Long> addGoodsVopIds = new ArrayList<Long>();
            RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
            addGoodsVopIds.add(Long.parseLong(rsResourceGoods.getGoodsNo()));
            this.logger.info(this.SYS_CODE + ".updateGoodsInfo.updateGoodsSku========16================" + skuId);
            JdClient client = this.getJdClient(jdResponseMessageContentDomain);
            this.updateGoodsSku(client, addGoodsVopIds, jdResponseMessageContentDomain.getDisChannel(), jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        }
    }

    @Override
    public String updateJcqGoodsPrice(Message message, String tenantCode) {
        JSONObject jsonObject = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".updateJcqGoodsPrice.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0cskuId = " + jsonObject.getString("skuId"));
            return "ERROR";
        }
        RsSkuDomain goodsBean = this.getSkuBySkuNo(jsonObject.getString("skuId"), disChannel);
        if (null == goodsBean) {
            this.logger.error(this.SYS_CODE + ".updateJcqGoodsPrice \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + jsonObject.getString("skuId"));
            return "ERROR";
        }
        String skuId = jsonObject.getString("skuId");
        String customerId = jsonObject.getString("customerId");
        String channelId = jsonObject.getString("channelId");
        HashSet<Long> skuIds = new HashSet<Long>();
        skuIds.add(jsonObject.getLongValue("skuId"));
        CtpWarePriceGetSkuPriceInfoListResponse jcqSkuPrice = null;
        try {
            jcqSkuPrice = this.jdApi.getJcqSkuPrice(this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()), "", Long.valueOf(customerId), Long.valueOf(channelId), skuIds);
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsPrice.sku:" + skuId + ".getJcqSkuPrice.result:" + JSONObject.toJSONString((Object)jcqSkuPrice));
        }
        catch (Exception e1) {
            this.logger.error(this.SYS_CODE + ".updateJcqGoodsPrice,sku:" + skuId, (Object)".e1", (Throwable)e1);
            return "ERROR";
        }
        if (Objects.isNull(jcqSkuPrice.getResult()) || !jcqSkuPrice.getResult().getSuccess() || ListUtil.isEmpty((Collection)jcqSkuPrice.getResult().getData().getSkuPriceList()) || !((PriceInfo)jcqSkuPrice.getResult().getData().getSkuPriceList().get(0)).getIsSuccess().booleanValue()) {
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsPrice.sku:" + skuId + ".getJcqSkuPrice.failed");
            return "ERROR";
        }
        return this.updateJcqGoodsPriceInformation(goodsBean, jcqSkuPrice.getResult().getData(), skuId, customerId, channelId);
    }

    public String updateJcqGoodsPriceInformation(RsSkuDomain goodsBean, ApiSkuPriceInfo apiSkuPriceInfo, String skuId, String customerId, String channelId) {
        if (null == goodsBean.getPricesetNprice()) {
            goodsBean.setPricesetNprice(BigDecimal.ZERO);
        }
        if (null == goodsBean.getPricesetAsprice()) {
            goodsBean.setPricesetAsprice(BigDecimal.ZERO);
        }
        if (goodsBean.getPricesetNprice().compareTo(((PriceInfo)apiSkuPriceInfo.getSkuPriceList().get(0)).getSkuPrice()) == 0 && goodsBean.getPricesetAsprice().compareTo(new BigDecimal(((PriceInfo)apiSkuPriceInfo.getSkuPriceList().get(0)).getBackStagePrice())) == 0) {
            this.logger.error(this.SYS_CODE + ".updateJcqGoodsPriceInformation.skuid:" + skuId + ",PricesetNprice=" + goodsBean.getPricesetNprice());
            return "SUCCESS";
        }
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(goodsBean.getSkuId());
        editSkuDomain.setGoodsCode(goodsBean.getGoodsCode());
        editSkuDomain.setSkuCode(goodsBean.getSkuCode());
        editSkuDomain.setSkuNo(skuId);
        editSkuDomain.setPricesetNprice(new BigDecimal(((PriceInfo)apiSkuPriceInfo.getSkuPriceList().get(0)).getBackStagePrice()));
        editSkuDomain.setPricesetMakeprice(new BigDecimal(((PriceInfo)apiSkuPriceInfo.getSkuPriceList().get(0)).getBackStagePrice()));
        editSkuDomain.setPricesetPrefprice(new BigDecimal(((PriceInfo)apiSkuPriceInfo.getSkuPriceList().get(0)).getBackStagePrice()));
        editSkuDomain.setPricesetAsprice(new BigDecimal(((PriceInfo)apiSkuPriceInfo.getSkuPriceList().get(0)).getBackStagePrice()));
        String json = JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain);
        this.logger.info(this.SYS_CODE + ".updateJcqGoodsPriceInformation.skuid:" + skuId + ".info:", (Object)json);
        try {
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("editSkuDomain", json);
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEdit,skuid:" + skuId, updateMap);
            return "SUCCESS";
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice,skuid:" + skuId + ",e:", (Throwable)e);
            return "ERROR";
        }
    }

    @Override
    public String updateJcqGoodsInfo(Message message, String tenantCode) {
        JSONObject jsonObject = JSONObject.parseObject((String)message.getBody().toString());
        if (!this.skuChangeMessageDoFilter(jsonObject)) {
            return "ERROR";
        }
        String skuId = jsonObject.getString("skuId");
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsInfo.getDisChannel,\u83b7\u53d6dischannel\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
            return "ERROR";
        }
        GoodsBean goodsBean = this.getGoodsBySkuNoAndOuterSkuId(skuId, disChannel);
        if (null == goodsBean) {
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
            return "ERROR";
        }
        HashSet<Long> addGoodsVopIds = new HashSet<Long>();
        addGoodsVopIds.add(jsonObject.getLongValue("skuId"));
        String customerId = jsonObject.getString("customerId");
        String channelId = jsonObject.getString("channelId");
        this.logger.info(this.SYS_CODE + ".updateJcqGoodsInfo========16================" + skuId);
        CtpWareSkuGetSkuDetailResponse jdJcqGoodsInfo = null;
        try {
            jdJcqGoodsInfo = this.jdApi.getSkuDetail(this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()), "", Long.valueOf(customerId), Long.valueOf(channelId), addGoodsVopIds);
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsInfo.sku:" + skuId + ".getSkuDetail.result:" + skuId + JSONObject.toJSONString((Object)jdJcqGoodsInfo));
        }
        catch (Exception e1) {
            this.logger.error(this.SYS_CODE + ".updateJcqGoodsInfo,sku:" + skuId + "e1", (Throwable)e1);
            return "ERROR";
        }
        if (!jdJcqGoodsInfo.getResult().getSuccess() || ListUtil.isEmpty((Collection)jdJcqGoodsInfo.getResult().getData())) {
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsInfo.null,sku:", (Object)skuId);
            return "ERROR";
        }
        String pntreeCode = EsGoodsServiceImpl.getPntreeCode(customerId);
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsInfo.pntreeCode", (Object)"=====>pntreeCode");
            return "ERROR";
        }
        this.updateJcqGoodsInformation((ApiSkuDetail)jdJcqGoodsInfo.getResult().getData().get(0), goodsBean, customerId, pntreeCode, skuId);
        return "SUCCESS";
    }

    private boolean skuChangeMessageDoFilter(JSONObject jsonObject) {
        if (StringUtils.isBlank((String)jsonObject.getString("skuId"))) {
            return false;
        }
        if (StringUtils.isBlank((String)jsonObject.getString("type")) || !"2".equals(jsonObject.getString("type"))) {
            this.logger.info(this.SYS_CODE + ".skuChangeMessageDoFilter.\u4e0d\u662f\u5546\u54c1\u4fee\u6539\u6d88\u606f\u4e22\u5f03\uff0cskuId = " + jsonObject.getString("skuId"));
            return false;
        }
        if (StringUtils.isBlank((String)jsonObject.getString("customerId"))) {
            return false;
        }
        return !StringUtils.isBlank((String)jsonObject.getString("channelId"));
    }

    @Override
    public void putOrOffGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        this.logger.info(this.SYS_CODE + ".putOrOffGoods.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        String state = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            this.logger.info(this.SYS_CODE + ".contentMap>>>>>>>>>>>>>>>>" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            ArrayList<String> goodsIds = new ArrayList<String>();
            goodsIds.add(skuId);
            state = JsonUtil.buildNormalBinder().toJson(contentMap.get("state"));
            this.soldOrShelveGoodsByGoodsIds(goodsIds, state, jdResponseMessageContentDomain);
        }
    }

    @Override
    public void addOrRemoveGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        Object pageNum = null;
        if (!MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoods \u4eac\u4e1c\u8fd4\u56de\u6d88\u606f\u5185\u5bb9\u9519\u8bef\uff0ccontent= " + content);
            return;
        }
        skuId = contentMap.get("skuId").toString();
        GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        if (goodsBean != null) {
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods contentMap= " + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
        if ("1".equals(contentMap.get("state").toString())) {
            if (null != goodsBean) {
                this.logger.error(this.SYS_CODE + ".addGoods \u5546\u54c1\u5df2\u7ecf\u5b58\u5728\uff0cskuId= " + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".addGoods skuId= ", (Object)skuId);
            this.addGoodsBySkuId(Long.valueOf(skuId), jdResponseMessageContentDomain);
        } else if ("2".equals(contentMap.get("state").toString())) {
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".RemoveGoods \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".RemoveGoods goodsIds= ", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsIds));
            this.delGoodsByGoodsIds(goodsIds);
        }
    }

    @Override
    public String updateGoodsPrice(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        return "SUCCESS";
    }

    private void delGoodsByGoodsIds(List<Integer> goodsIds) {
        this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", goodsIds);
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        try {
            params.put("goodsIds", goodsIds);
            this.logger.error(this.SYS_CODE + ".deletePromotioneToGoods.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".delGoodsByGoodsIds.ex", (Throwable)e);
        }
    }

    private void addGoodsBySkuId(Long skuId, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
    }

    private void soldOrShelveGoodsByGoodsIds(List<String> jdSkuIds, String type, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (ListUtil.isEmpty(jdSkuIds) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", (Object)(jdSkuIds + "===" + type));
            return;
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (String skuNo : jdSkuIds) {
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuNo, jdResponseMessageContentDomain.getDisChannel());
            if (goodsBean == null) {
                this.logger.error(this.SYS_CODE + ".contentMap---------------" + JsonUtil.buildNonEmptyBinder().toJson((Object)goodsBean));
                continue;
            }
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
            this.logger.info(this.SYS_CODE + ".contentMap==========>" + JsonUtil.buildNonEmptyBinder().toJson(goodsIds));
            if (!ListUtil.isNotEmpty(goodsIds)) continue;
            HashMap<String, ArrayList<Integer>> params = new HashMap<String, ArrayList<Integer>>();
            try {
                params.put("goodsIds", goodsIds);
                if ("0".equals(type)) {
                    this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                    this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
                    continue;
                }
                if (!"1".equals(type)) continue;
                this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.mapStr:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                this.getInternalRouter().inInvoke(RESOURCEGOODS_SHELVE_CODE, params);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u4e0a/\u4e0b\u67b6\u5931\u8d25", (Object)e.getMessage());
                throw new ApiException(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.ex", (Throwable)e);
            }
        }
    }

    @Override
    public String updateGoodsSku(JdClient client, List<Long> skuId, DisChannel disChannel, String tenantCode) {
        return "SUCCESS";
    }

    private void soldJcqOrShelveGoodsByGoodsIds(String skuNo, Integer type) {
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        GoodsBean goodsBean = this.getJcqGoodsBySkuNo(skuNo, null);
        if (goodsBean == null) {
            this.logger.error(this.SYS_CODE + ".soldJcqOrShelveGoodsByGoodsIds.goodsBean---------------" + JsonUtil.buildNonEmptyBinder().toJson((Object)goodsBean) + ",skuNo:" + skuNo);
            return;
        }
        goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        this.logger.info(this.SYS_CODE + ".soldJcqOrShelveGoodsByGoodsIds.goodsBean==========>" + JsonUtil.buildNonEmptyBinder().toJson(goodsIds) + ",skuNo:" + skuNo);
        if (ListUtil.isNotEmpty(goodsIds)) {
            HashMap<String, ArrayList<Integer>> params = new HashMap<String, ArrayList<Integer>>();
            try {
                params.put("goodsIds", goodsIds);
                if ("0".equals(type)) {
                    this.logger.info(this.SYS_CODE + ".soldJcqOrShelveGoodsByGoodsIds.params:", (Object)(JsonUtil.buildNormalBinder().toJson(params) + ",skuNo:" + skuNo));
                    this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
                } else if ("1".equals(type)) {
                    this.logger.info(this.SYS_CODE + ".soldJcqOrShelveGoodsByGoodsIds.params:", (Object)(JsonUtil.buildNormalBinder().toJson(params) + ",skuNo:" + skuNo));
                    this.getInternalRouter().inInvoke(RESOURCEGOODS_SHELVE_CODE, params);
                }
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".soldJcqOrShelveGoodsByGoodsIds:\u4e0a/\u4e0b\u67b6\u5931\u8d25,skuNo:" + skuNo, (Object)e.getMessage());
                throw new ApiException(this.SYS_CODE + ".soldJcqOrShelveGoodsByGoodsIds.ex", (Throwable)e);
            }
        }
    }

    public String updateJcqGoodsInformation(ApiSkuDetail jdJcpGoodsInfo, GoodsBean goodsBean, String tenantCode, String pntreeCode, String skuId) {
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        if (!ListUtil.isEmpty((Collection)jdJcpGoodsInfo.getImageInfos())) {
            editSkuDomain.setDataPic(((ImageInfo)jdJcpGoodsInfo.getImageInfos().get(0)).getPath());
        }
        if (!Objects.isNull(jdJcpGoodsInfo.getSkuBaseInfo().getSkuStatus())) {
            this.soldJcqOrShelveGoodsByGoodsIds(skuId, jdJcpGoodsInfo.getSkuBaseInfo().getSkuStatus());
        }
        RsResourceGoodsDomain rsResourceGoods = null;
        if (goodsBean != null && (rsResourceGoods = goodsBean.getRsResourceGoods()) != null && StringUtils.isNotBlank((String)rsResourceGoods.getGoodsCode()) && StringUtils.isNotBlank((String)rsResourceGoods.getSpuCode())) {
            editSkuDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
            editSkuDomain.setSpuCode(rsResourceGoods.getSpuCode());
        }
        editSkuDomain.setClasstreeCode(jdJcpGoodsInfo.getSkuBaseInfo().getCategoryId() == null ? "" : jdJcpGoodsInfo.getSkuBaseInfo().getCategoryId().toString());
        editSkuDomain.setPntreeCode(pntreeCode);
        editSkuDomain.setTenantCode(tenantCode);
        editSkuDomain.setGoodsNum(new BigDecimal("999"));
        editSkuDomain.setGoodsNum(new BigDecimal("999"));
        editSkuDomain.setPricesetNprice(BigDecimal.ZERO);
        editSkuDomain.setGoodsNo(String.valueOf(jdJcpGoodsInfo.getSkuId()));
        editSkuDomain.setGoodsType("40");
        editSkuDomain.setGoodsPro("11");
        editSkuDomain.setGoodsEocode(String.valueOf(jdJcpGoodsInfo.getSkuId()));
        editSkuDomain.setTenantCode(editSkuDomain.getTenantCode());
        editSkuDomain.setGoodsNum(new BigDecimal("999"));
        editSkuDomain.setGoodsSupplynum(new BigDecimal("999"));
        editSkuDomain.setGoodsNo(String.valueOf(jdJcpGoodsInfo.getSkuId()));
        editSkuDomain.setGoodsEocode(String.valueOf(jdJcpGoodsInfo.getSkuId()));
        editSkuDomain.setSkuNo(String.valueOf(jdJcpGoodsInfo.getSkuId()));
        HashMap<String, String> goodsparamMap = new HashMap<String, String>();
        goodsparamMap.put("editSkuDomain", JsonUtil.buildNonNullBinder().toJson((Object)editSkuDomain));
        String resultGoods = null;
        try {
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsInformation,\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString(goodsparamMap));
            resultGoods = (String)this.getInternalRouter().inInvoke(RESOURCE_UPDATE_CODE, goodsparamMap);
            this.logger.info(this.SYS_CODE + ".updateJcqGoodsInformation." + RESOURCE_UPDATE_CODE + editSkuDomain.getSkuId() + "\u66f4\u65b0\u5546\u54c1result:", (Object)resultGoods);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".updateJcqGoodsInformation." + editSkuDomain.getSkuId() + "\u66f4\u65b0\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            return "ERROR";
        }
        return "SUCCESS";
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", null);
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.error(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.buildNonEmptyBinder().toJson(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private GoodsBean getJcqGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", null);
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.info(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.buildNonEmptyBinder().toJson(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private GoodsBean getGoodsBySkuNoAndOuterSkuId(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", null);
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.info(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.buildNonEmptyBinder().toJson(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private JdClient getJdClient(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        String channelCode = jdResponseMessageContentDomain.getDisChannel().getChannelCode();
        String memberCode = jdResponseMessageContentDomain.getDisChannel().getMemberCcode();
        String accessToken = this.getToken(tenantCode, channelCode, memberCode);
        String serverUrl = (String)jdResponseMessageContentDomain.getKeyMap().get("serverUrl");
        String appKey = (String)jdResponseMessageContentDomain.getKeyMap().get("appKey");
        String appSecret = (String)jdResponseMessageContentDomain.getKeyMap().get("appSecret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }

    public String getToken(DisChannel disChannel) {
        String tokenStr;
        String tenantCode = disChannel.getTenantCode();
        String channelCode = disChannel.getChannelCode();
        String memberCode = disChannel.getMemberCcode();
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = "";
        }
        if (StringUtils.isBlank((String)(tokenStr = DisUtil.getRemotMap((String)"DisOauthToken-channelCode", (String)(channelCode + "-" + memberCode + "-" + tenantCode))))) {
            return null;
        }
        DisOauthToken disOauthToken = (DisOauthToken)JsonUtil.buildNormalBinder().getJsonToObject(tokenStr, DisOauthToken.class);
        if (null == disOauthToken) {
            return null;
        }
        return disOauthToken.getOauthTokenToken();
    }
}

