/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdjos.message.service;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.common.consumer.ConsumeFromWhere;
import com.jcloud.jcq.common.message.AckAction;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.protocol.Message;
import com.jcloud.jcq.sdk.JCQClientFactory;
import com.jcloud.jcq.sdk.auth.UserCredential;
import com.jcloud.jcq.sdk.consumer.PullConsumer;
import com.jcloud.jcq.sdk.consumer.PullConsumerConfig;
import com.jcloud.jcq.sdk.consumer.async.AsyncAckCallback;
import com.jcloud.jcq.sdk.consumer.async.AsyncPullCallback;
import com.jcloud.jcq.sdk.consumer.model.AckResult;
import com.jcloud.jcq.sdk.consumer.model.PullResult;
import com.jcloud.jcq.sdk.producer.model.ResultCode;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.ext.channel.jdjos.enums.JdJcqTopic;
import com.yqbsoft.laser.service.ext.channel.jdjos.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.channel.jdjos.message.JdJcqPullMessageService;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdJcqPullMessageServiceImpl
implements JdJcqPullMessageService {
    private EsGoodsService esGoodsService = (EsGoodsService)SpringApplicationContextUtil.getBean((String)"esGoodsService");
    private static final Logger logger = LoggerFactory.getLogger(JdJcqPullMessageServiceImpl.class);

    private static PullConsumer buildPullConsumer(String consumerGroup, Integer pullSize) throws ClientException {
        UserCredential userCredential = new UserCredential("D299406AB438C4EDC88A0C02F5A28919", "c1c75ac2c28d4daeb5ccae0edf3b55dc");
        PullConsumerConfig pullConsumerConfig = PullConsumerConfig.builder().consumerGroupId(consumerGroup).metaServerAddress("jcq-shared-004-manager-nlb-FI.jvessel-open-hb.jdcloud.com:2888").enableMessageTrace(true).defaultConsumePosition(ConsumeFromWhere.HEAD).maxBatchSizePerPull(pullSize.intValue()).maxRetryTimes(3).build();
        PullConsumer pullConsumer = JCQClientFactory.getInstance().createPullConsumer(userCredential, pullConsumerConfig);
        pullConsumer.start();
        return pullConsumer;
    }

    public void onMessage(JdJcqTopic topic, Integer pullSize, String tenantCode) {
        try {
            final PullConsumer pullConsumer = JdJcqPullMessageServiceImpl.buildPullConsumer("open_message_735445952729", pullSize);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        pullConsumer.shutdown();
                    }
                    catch (ClientException e) {
                        e.printStackTrace();
                    }
                }
            }));
            while (true) {
                try {
                    while (true) {
                        this.pullMessageSync(pullConsumer, topic, tenantCode);
                    }
                }
                catch (ClientException e) {
                    logger.error("there some thing happen topic:", (Object)topic.getTopicName(), (Object)e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        JdJcqPullMessageServiceImpl jdJcqPullMessageService = new JdJcqPullMessageServiceImpl();
        jdJcqPullMessageService.onMessage(JdJcqTopic.CT_ORDER_CREATE, 1, "");
        final PullConsumer pullConsumer = JdJcqPullMessageServiceImpl.buildPullConsumer("open_message_735445952729", 2);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    pullConsumer.shutdown();
                }
                catch (ClientException e) {
                    e.printStackTrace();
                }
            }
        }));
        while (true) {
            try {
                while (true) {
                    jdJcqPullMessageService.pullMessageSync(pullConsumer, null, "");
                }
            }
            catch (ClientException e) {
                logger.error("there some thing happen ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void pullMessageSync(PullConsumer pullConsumer, JdJcqTopic topic, String tenantCode) throws ClientException {
        PullResult pullResult = pullConsumer.pullMessage(topic.getTopicName(), null);
        this.processPullResult(pullConsumer, pullResult, topic, tenantCode);
    }

    private void pullMessageAsync(final PullConsumer pullConsumer) throws ClientException {
        pullConsumer.pullMessageAsync("\u66ff\u6362\u6210\u666e\u901aTopic\u540d\u79f0", null, new AsyncPullCallback(){

            public void onResult(PullResult pullResult) {
                try {
                    JdJcqPullMessageServiceImpl.this.processPullResult(pullConsumer, pullResult, null, null);
                }
                catch (ClientException e) {
                    logger.warn("there some error happened ", (Throwable)e);
                }
            }

            public void onException(Throwable throwable) {
                logger.error("async pull message error ", throwable);
            }
        });
    }

    private static void pullMessageAckASync(final PullConsumer pullConsumer) throws ClientException {
        PullResult pullResult = pullConsumer.pullMessage("\u66ff\u6362\u6210\u666e\u901aTopic\u540d\u79f0", null);
        if (ResultCode.SUCCESS != pullResult.getResultCode()) {
            logger.warn("pull request failed, pull result is  {}", (Object)pullResult);
            return;
        }
        if (StringUtils.isEmpty((String)pullResult.getAckIndex()) || pullResult.getMessages() == null) {
            logger.info("there is no message. pull result is {}", (Object)pullResult);
            return;
        }
        final String ackIndex = pullResult.getAckIndex();
        logger.info("Sync pullResult.resultCode:{}, pullResult.ackIndex:{}, pullResult.messages:{}", new Object[]{pullResult.getResultCode(), pullResult.getAckIndex(), pullResult.getMessages()});
        final AtomicReference<AckAction> ackAction = new AtomicReference<AckAction>(AckAction.CONSUME_FAILED);
        pullConsumer.ackMessageAsync("\u66ff\u6362\u6210\u666e\u901aTopic\u540d\u79f0", ackIndex, ackAction.get(), new AsyncAckCallback(){

            public void onResult(AckResult ackResult) {
                JdJcqPullMessageServiceImpl.processAckResult(pullConsumer, ackIndex, (AckAction)ackAction.get(), ackResult, "");
            }

            public void onException(Throwable throwable) {
                logger.error("async pull message error ", throwable);
            }
        });
    }

    private void processPullResult(PullConsumer pullConsumer, PullResult pullResult, JdJcqTopic topic, String tenantCode) throws ClientException {
        if (!JdJcqPullMessageServiceImpl.dataFiltering(pullResult, topic.getTopicName())) {
            return;
        }
        String ackIndex = pullResult.getAckIndex();
        logger.info("\u4eac\u4e1c\u5f00\u666e\u52d2\u6d88\u606f\u63a8\u9001topic:" + topic.getTopicName() + ",\u6d88\u606f\u4f53:" + pullResult.getMessages());
        AckAction ackAction = this.businessFactory(topic, pullResult.getMessages(), tenantCode);
        AckResult ackResult = pullConsumer.ackMessage(topic.getTopicName(), ackIndex, ackAction);
        JdJcqPullMessageServiceImpl.processAckResult(pullConsumer, ackIndex, ackAction, ackResult, topic.getTopicName());
    }

    public AckAction businessFactory(JdJcqTopic topic, List<Message> messages, String tenantCode) {
        switch (topic) {
            case CT_SKU_CHANGE: {
                return this.getSkuDetailChange(messages, tenantCode);
            }
            case CT_SKU_PRICE_CHANGE: {
                return this.getSkuPriceChange(messages, tenantCode);
            }
            case JD_ADDRESS_CHANGE: {
                return JdJcqPullMessageServiceImpl.getJdAddressChange(messages);
            }
            case CT_ORDER_CREATE: {
                return JdJcqPullMessageServiceImpl.getCtOrderCreate(messages);
            }
            case CT_ORDER_PAY: {
                return JdJcqPullMessageServiceImpl.getCtOrderPay(messages);
            }
            case CT_ORDER_STOCKOUT: {
                return JdJcqPullMessageServiceImpl.getCtOrderStockout(messages);
            }
            case CT_ORDER_DELIVERED: {
                return JdJcqPullMessageServiceImpl.getCtOrderDelivered(messages);
            }
            case CT_ORDER_FINISH: {
                return JdJcqPullMessageServiceImpl.getCtOrderFinish(messages);
            }
            case CT_ORDER_CANCEL: {
                return JdJcqPullMessageServiceImpl.getCtOrderCancel(messages);
            }
            case CT_ORDER_REFUND: {
                return JdJcqPullMessageServiceImpl.getCtOrderRefund(messages);
            }
            case CT_AFS_CREATE: {
                return JdJcqPullMessageServiceImpl.getCtAfsCreate(messages);
            }
            case CT_AFS_STEP_RESULT: {
                return JdJcqPullMessageServiceImpl.getCtAfsStepResult(messages);
            }
            case CT_ORDER_BALANCE_NOT_ENOUGH: {
                return JdJcqPullMessageServiceImpl.getCtOrderBalanceNotEnough(messages);
            }
            case CT_CLEARANCE_RESULT: {
                return JdJcqPullMessageServiceImpl.getCtClearanceResult(messages);
            }
        }
        return AckAction.CONSUME_FAILED;
    }

    public static AckAction getCtClearanceResult(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderBalanceNotEnough(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtAfsStepResult(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtAfsCreate(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderRefund(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderCancel(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderFinish(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderDelivered(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderStockout(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderPay(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getCtOrderCreate(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public static AckAction getJdAddressChange(List<Message> messages) {
        return AckAction.SUCCESS;
    }

    public AckAction getSkuPriceChange(List<Message> messages, String tenantCode) {
        if (ListUtil.isNotEmpty(messages)) {
            String resultCode = this.esGoodsService.updateJcqGoodsPrice(messages.get(0), tenantCode);
            return resultCode.equals("SUCCESS") ? AckAction.SUCCESS : AckAction.CONSUME_FAILED;
        }
        return AckAction.SUCCESS;
    }

    public AckAction getSkuDetailChange(List<Message> messages, String tenantCode) {
        if (ListUtil.isNotEmpty(messages)) {
            String resultCode = this.esGoodsService.updateJcqGoodsInfo(messages.get(0), tenantCode);
            return resultCode.equals("SUCCESS") ? AckAction.SUCCESS : AckAction.CONSUME_FAILED;
        }
        return AckAction.SUCCESS;
    }

    public static boolean dataFiltering(PullResult pullResult, String topic) {
        if (ResultCode.SUCCESS != pullResult.getResultCode()) {
            logger.warn("topic:{},pull request failed, pull result is  {}", (Object)topic, (Object)pullResult);
            return false;
        }
        if (StringUtils.isEmpty((String)pullResult.getAckIndex()) || pullResult.getMessages() == null) {
            logger.info("topic:{},there is no message.", (Object)topic);
            return false;
        }
        logger.info("topic:{},Sync pullResult.resultCode:{}, pullResult. ackIndex:{}, pullResult.messages:{}", new Object[]{topic, pullResult.getResultCode(), pullResult.getAckIndex(), pullResult.getMessages()});
        return true;
    }

    private static void processAckResult(PullConsumer pullConsumer, String ackIndex, AckAction ackAction, AckResult ackResult, String topic) {
        logger.info("Sync ackResult:{}", (Object)ackResult.getResultCode());
        if (ResultCode.SUCCESS != ackResult.getResultCode() && ackAction == AckAction.SUCCESS) {
            try {
                ackResult = pullConsumer.ackMessage(topic, ackIndex, ackAction);
                if (ackResult.getResultCode() != ResultCode.SUCCESS) {
                    logger.warn("when retry ack for  topic {}, at ack Index {}, action {}, failed or ack already ,please confirm", new Object[]{"\u66ff\u6362\u6210\u666e\u901aTopic\u540d\u79f0", ackIndex, ackAction});
                }
            }
            catch (ClientException e) {
                logger.warn("when retry ack exception", (Throwable)e);
            }
        }
    }

    @Override
    public void skuDetailChange() {
        this.onMessage(JdJcqTopic.CT_SKU_CHANGE, 1, "00000000");
    }

    @Override
    public void skuPriceChange() {
        this.onMessage(JdJcqTopic.CT_SKU_PRICE_CHANGE, 1, "00000000");
    }

    @Override
    public void jdAddressChange() {
        this.onMessage(JdJcqTopic.CT_SKU_PRICE_CHANGE, 1, "00000000");
    }

    @Override
    public void ctOrderCreate() {
        this.onMessage(JdJcqTopic.CT_ORDER_CREATE, 1, "00000000");
    }

    @Override
    public void gctOrderPay() {
        this.onMessage(JdJcqTopic.CT_ORDER_PAY, 1, "00000000");
    }

    @Override
    public void ctOrderStockout() {
        this.onMessage(JdJcqTopic.CT_ORDER_STOCKOUT, 1, "00000000");
    }

    @Override
    public void ctOrderDelivered() {
        this.onMessage(JdJcqTopic.CT_ORDER_DELIVERED, 1, "00000000");
    }

    @Override
    public void ctOrderFinish() {
        this.onMessage(JdJcqTopic.CT_ORDER_FINISH, 1, "00000000");
    }

    @Override
    public void ctOrderCancel() {
        this.onMessage(JdJcqTopic.CT_ORDER_CANCEL, 1, "00000000");
    }

    @Override
    public void ctOrderRefund() {
        this.onMessage(JdJcqTopic.CT_ORDER_REFUND, 1, "00000000");
    }

    @Override
    public void ctAfsCreate() {
        this.onMessage(JdJcqTopic.CT_AFS_CREATE, 1, "00000000");
    }

    @Override
    public void ctAfsStepResult() {
        this.onMessage(JdJcqTopic.CT_AFS_STEP_RESULT, 1, "00000000");
    }

    @Override
    public void ctOrderBalanceNotEnough() {
        this.onMessage(JdJcqTopic.CT_ORDER_BALANCE_NOT_ENOUGH, 1, "00000000");
    }

    @Override
    public void ctClearanceResult() {
        this.onMessage(JdJcqTopic.CT_CLEARANCE_RESULT, 1, "00000000");
    }
}

