/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdjos.order.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jcloud.jcq.protocol.Message;
import com.jd.open.api.sdk.DefaultJdClient;
import com.yqbsoft.laser.service.contract.model.OcPackage;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.jdjos.JdJosConstants;
import com.yqbsoft.laser.service.ext.channel.jdjos.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdjos.es.SendOrderRefundPollThread;
import com.yqbsoft.laser.service.ext.channel.jdjos.es.SendOrderRefundService;
import com.yqbsoft.laser.service.ext.channel.jdjos.order.EsOrderRefundService;
import com.yqbsoft.laser.service.ext.channel.jdjos.util.JdBeanUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DisRefundServiceImpl
extends DisRefundBaseService
implements EsOrderRefundService {
    private String SYS_CODE = "jdjos.DisRefundrServiceImpl";
    private static final String OC_REFUND_UPDATE_DATE = "oc.refundEngine.sendRefundNext";
    private static final String OC_REFUND_ENGINE_SAVE_ORDER_REFUND = "oc.refundEngine.sendSaveOrderRefund";
    private static final String OC_CONTRACT_SEND_SAVE_SEND_GOODS_REFUND = "oc.contract.sendSaveSendgoodsRefund";
    private static final String OC_REFUND_ENGINE_SEND_SAVE_REFUND = "oc.refundEngine.sendsaveRefund";
    private static final String OC_CONTRACT_QUERY_CONTRACT_PAGE = "oc.contract.queryContractPageReDomain";
    private static final String OC_CONTRACT_ENGINE_SEND_CONTRACT_NEXT = "oc.contractEngine.sendContractNext";
    private static final String OC_CONTRACT_GET_CONTRACT_BY_CODE = "oc.contract.getContractByCode";
    private static final String OC_CONTRACT_UPDATE_BATCH_GOODS_AND_REFUND = "oc.contract.updateBatchContractGoodsAndRefund";
    private static final String OC_REFUND_ENGINE_SEND_BATCH_SAVE_REFUND = "oc.refundEngine.sendBatchSaveRefund";
    private static SendOrderRefundService sendOrderRefundService;
    private static Object sendOrderRefundLock;

    protected String getChannelCode() {
        return JdJosConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComRefundParam", (Object)("=:=" + channelApiCode + "=:=" + sendParam.toString() + "=:=" + configMap.toString() + "=:=" + param.toString()));
            return null;
        }
        sendParam.put("serverUrl", configMap.get("ophost"));
        sendParam.put("accessToken", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode()));
        sendParam.put("appKey", configMap.get("key"));
        sendParam.put("appSecret", configMap.get("secret"));
        if ("cmc.disRefund.saveSendOcRefund".equals(channelApiCode) || "cmc.disRefund.saveSendOcRefundState".equals(channelApiCode)) {
            sendParam.put("ocRefundDomain", param.get("ocRefundDomain"));
            sendParam.put("tenantCode", param.get("tenantCode"));
            sendParam.put("memberCode", param.get("memberCode"));
        }
        return sendParam;
    }

    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String serverUrl = configMap.get("ophost");
        String accessToken = this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode());
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        this.logger.error(this.SYS_CODE + "sendComRefund.channelApiCode", (Object)channelApiCode);
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        if ("cmc.disRefund.saveSendOcRefund".equals(channelApiCode)) {
            OcRefundReDomain ocRefundDomain = (OcRefundReDomain)sendhttpParam.get("ocRefundDomain");
            return "SUCCESS";
        }
        if ("cmc.disRefund.saveSendOcRefundState".equals(channelApiCode)) {
            OcRefundReDomain ocRefundDomain = (OcRefundReDomain)sendhttpParam.get("ocRefundDomain");
            boolean result = false;
            return result ? "SUCCESS" : "ERROR";
        }
        if ("cmc.disRefund.queryVopAfsGetGoodsAttributes".equals(channelApiCode)) {
            String thirdApplyId = (String)param.get("thirdApplyId");
            String orderId = (String)param.get("orderId");
            String skuIds = (String)param.get("skuIds");
            return "ERROR";
        }
        if ("cmc.disRefund.queryOcRefundInfo".equals(channelApiCode)) {
            String thirdApplyId = (String)param.get("thirdApplyId");
            String orderId = (String)param.get("orderId");
            return "ERROR";
        }
        if ("cmc.disRefund.getAfsOutline".equals(channelApiCode)) {
            String thirdApplyId = (String)param.get("thirdApplyId");
            String orderId = (String)param.get("orderId");
            String skuId = (String)param.get("skuId");
            return "ERROR";
        }
        if ("cmc.disRefund.getJdRefundMessage".equals(channelApiCode)) {
            String jdMessageType = "104";
            HashMap<String, String> keymap = new HashMap<String, String>();
            keymap.put("serverUrl", serverUrl);
            keymap.put("appKey", appKey);
            keymap.put("appSecret", appSecret);
            keymap.put("tenantCode", disChannel.getTenantCode());
            return null;
        }
        return "ERROR";
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    private String resultReturn(String code, String msg, String data) {
        String result = "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
        return result;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        DisRefundDomain disRefundDomain;
        this.logger.error(this.SYS_CODE + "......", (Object)(sendhttpParam + "=:=" + configMap + "=:=" + param));
        if (null == sendhttpParam || null == sendhttpParam.get("jd_param_json")) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jd_param_json is null!", (Object)sendhttpParam.toString());
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        if (StringUtils.isBlank((String)jdParamList)) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jd_param_json", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jd_param_json");
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveRefundParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String methodType = (String)sendhttpParam.get("methodType");
        String billId = (String)jsonToMap.get("billId");
        String statusId = (String)jsonToMap.get("statusId");
        if ("newApplyAfterSaleBill".equals(methodType) || "newAfterSaleBill".equals(methodType)) {
            if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                this.logger.error(this.SYS_CODE + ".newApplyAfterSaleBill:", (Object)("billId:" + billId + ";statusId:" + statusId));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), billId, disChannel);
            if (null == disRefundDomain && null == (disRefundDomain = this.getSendRefund(null, billId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode()))) {
                this.logger.error(this.SYS_CODE + ".disRefundDomain.", (Object)(billId + "=:=" + sendhttpParam + "=:=" + disChannel.getTenantCode()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
        }
        if ("afterSaleBillStatus".equals(methodType)) {
            if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                this.logger.error(this.SYS_CODE + ".afterSaleBillStatus:", (Object)("billId:" + billId + ";statusId:" + statusId));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if ("11".equals(statusId) || "12".equals(statusId) || "30".equals(statusId) || "90".equals(statusId) || "92".equals(statusId) || "93".equals(statusId) || "110".equals(statusId) || "111".equals(statusId) || "1101".equals(statusId) || "1111".equals(statusId) || "1112".equals(statusId) || "112".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), billId, disChannel);
            if (null == disRefundDomain && null == (disRefundDomain = this.getSendRefund(null, billId, (String)sendhttpParam.get("memberCode"), disChannel.getTenantCode()))) {
                this.logger.error(this.SYS_CODE + ".afterSaleBillStatus.", (Object)("disRefundDomain is null" + billId + "=:=" + sendhttpParam.get("memberCode")));
                return this.resultReturn("-1", "ERROR", "jd_param_json");
            }
            if ("50".equals(statusId)) {
                statusId = "51";
            }
            HashMap<String, String> mapP = new HashMap<String, String>();
            mapP.put("dataStatestr", statusId);
            this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(statusId), disRefundDomain.getDataState(), mapP);
        }
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeRefund(param, disChannel);
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        Object o;
        String pic;
        this.logger.error(this.SYS_CODE + ".makeRefund1: ", map);
        String PICURL = "http://img10.360buyimg.com/o2o/";
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(disChannel.getTenantCode());
        String orderId = map.get("orderId").toString();
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel);
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain1", (Object)orderId);
            return null;
        }
        disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode());
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain", (Object)orderId);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
        }
        disRefundDomain.setContractNbillcode(orderId);
        disRefundDomain.setRefundOcode(map.get("afsServiceOrder").toString());
        disRefundDomain.setDataStatestr(map.get("afsServiceState").toString());
        Object time = map.get("createTime");
        String createTime = null == time ? null : String.valueOf(time);
        Date refundTime = null;
        if (null != createTime && Long.valueOf(createTime) > 0L) {
            refundTime = StringUtils.isNotBlank((String)createTime) ? new Date(Long.valueOf(createTime)) : null;
        }
        disRefundDomain.setRefundDate(refundTime);
        Object questionType = map.get("questionTypeCid");
        String questionTypeCid = null == questionType ? null : String.valueOf(questionType);
        disRefundDomain.setRefundEx(this.fetchRefundType(questionTypeCid));
        String questionDesc = null == map.get("questionDesc") ? "" : (String)map.get("questionDesc");
        disRefundDomain.setRefundMeo(questionDesc);
        disRefundDomain.setRefundUsertype("0");
        if (null != map.get("questionPic") && StringUtils.isNotBlank((String)(pic = String.valueOf(map.get("questionPic"))))) {
            pic = "http://img10.360buyimg.com/o2o/" + pic;
            pic = pic.replace(",", ",http://img10.360buyimg.com/o2o/");
            String[] str = pic.split("\\,");
            List<String> listStr = Arrays.asList(str);
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        String refundPrice = null == (o = map.get("cashMoney")) ? null : String.valueOf(o);
        List goodlist = (List)map.get("afsDetailList");
        if (ListUtil.isEmpty((Collection)goodlist)) {
            this.logger.error(this.SYS_CODE + ".goodsList jddj1", map);
            return null;
        }
        String refundAuditTime = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode());
        if (null != refundAuditTime && StringUtils.isNotBlank((String)refundAuditTime)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(refundAuditTime)));
        }
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        BigDecimal refundMoney = new BigDecimal(refundPrice).divide(new BigDecimal("100")).setScale(2, 4);
        if (null != refundMoney) {
            disRefundDomain.setRefundMoney(refundMoney);
        }
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disContractDomain, disRefundDomain));
        this.logger.error(this.SYS_CODE + ".makeRefund2: ", (Object)JsonUtil.buildNormalBinder().toJson((Object)disRefundDomain));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisContractDomain disContractDomain, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)(goodlist + "=:=" + disContractDomain + "=:=" + disRefundDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            for (String key : map.keySet()) {
                BigDecimal refnum;
                disRefundDomain.setRefundType("jddj2");
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(key);
                if (null == disContractGoodsDomain) {
                    return null;
                }
                BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
                if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                    refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                    continue;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                refundGoodsList.add(disRefundGoodsDomain);
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
            }
            if (null == disRefundDomain.getRefundMoney()) {
                disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
            }
        } else {
            BigDecimal addRefundNum = BigDecimal.ZERO;
            for (Map<String, Object> gmap : goodlist) {
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(gmap.get("skuIdIsv"));
                if (null == disContractGoodsDomain) {
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                Integer skuCount = null == gmap.get("skuCount") ? null : (Integer)gmap.get("skuCount");
                BigDecimal number = null == skuCount ? BigDecimal.ZERO : BigDecimal.valueOf(skuCount.intValue());
                Object o = map.get("cashMoney");
                String cashMoney = null == o ? null : String.valueOf(o);
                BigDecimal totalRefund = null == cashMoney ? BigDecimal.ZERO : new BigDecimal(cashMoney).divide(new BigDecimal("100")).setScale(2, 4);
                disRefundGoodsDomain.setRefundGoodsNum(number);
                disRefundGoodsDomain.setRefundGoodsPrice(totalRefund.divide(number).setScale(2, 4));
                disRefundGoodsDomain.setRefundGoodsAmt(totalRefund);
                disRefundGoodsDomain.setRefundGoodsWeight(number);
                addRefundNum = addRefundNum.add(number);
                refundGoodsList.add(disRefundGoodsDomain);
            }
            BigDecimal refundNum = BigDecimal.ZERO;
            refundNum = refundNum.add(addRefundNum);
            List disRefundList = this.queryDisRefundByNbbillcode(disContractDomain.getChannelCode(), disContractDomain.getContractNbillcode(), disContractDomain.getTenantCode());
            if (ListUtil.isEmpty((Collection)disRefundList)) {
                disRefundDomain.setRefundType("jddj1");
            } else {
                disRefundDomain.setRefundType("jddj1");
                for (DisRefundReDomain disRefundReDomain : disRefundList) {
                    List ocRefundGoodsDomainList = disRefundReDomain.getOcRefundGoodsDomainList();
                    if (ListUtil.isEmpty((Collection)ocRefundGoodsDomainList)) {
                        return null;
                    }
                    for (DisRefundGoodsDomain disRefundGoods : ocRefundGoodsDomainList) {
                        refundNum = refundNum.add(disRefundGoods.getRefundGoodsNum());
                    }
                }
            }
            if (refundNum.compareTo(disContractDomain.getGoodsNum()) == 0) {
                disRefundDomain.setRefundType("jddj2");
            }
        }
        return refundGoodsList;
    }

    private String fetchRefundType(String id) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("201", "\u5546\u54c1\u8d28\u91cf\u95ee\u9898");
        map.put("202", "\u9001\u9519\u8d27");
        map.put("203", "\u7f3a\u4ef6\u5c11\u4ef6");
        map.put("501", "\u5168\u90e8\u5546\u54c1\u672a\u6536\u5230");
        map.put("208", "\u5305\u88c5\u810f\u6c61\u6709\u7834\u635f");
        map.put("207", "\u7f3a\u65a4\u5c11\u4e24");
        map.put("210", "\u5546\u5bb6\u901a\u77e5\u6211\u7f3a\u8d27");
        map.put("303", "\u5b9e\u7269\u4e0e\u539f\u56fe\u4e0d\u7b26");
        map.put("402", "\u4e0d\u60f3\u8981\u4e86");
        map.put("502", "\u672a\u5728\u65f6\u6548\u5185\u9001\u8fbe");
        return (String)map.get(id);
    }

    private String getVopSkuType(String contractGoodsGtype) {
        String skuType = "10";
        switch (contractGoodsGtype) {
            case "0": {
                skuType = "10";
                break;
            }
            case "1": {
                skuType = "20";
                break;
            }
        }
        return skuType;
    }

    private Integer getVopRefundType(String refundType) {
        Integer vopRefundType = 10;
        switch (refundType) {
            case "JDB02": {
                vopRefundType = 10;
                break;
            }
            case "JDB03": {
                vopRefundType = 20;
                break;
            }
            case "JDB04": {
                vopRefundType = 30;
                break;
            }
        }
        return vopRefundType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendOrderRefundService getSendOrderRefundService() {
        Object object = sendOrderRefundLock;
        synchronized (object) {
            if (null == sendOrderRefundService) {
                sendOrderRefundService = new SendOrderRefundService((EsOrderRefundService)SpringApplicationContextUtil.getBean((String)"esOrderRefundService"));
                for (int i = 0; i < 200; ++i) {
                    sendOrderRefundService.addPollPool(new SendOrderRefundPollThread(sendOrderRefundService));
                }
            }
            return sendOrderRefundService;
        }
    }

    @Override
    public void updateRefundState(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
    }

    @Override
    public void refundSuccessForOrder(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
    }

    @Override
    public void refundSuccessForApply(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
    }

    @Override
    public void updateRefundApplyState(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> refundMap = JdBeanUtil.getJdContentMap(content);
        this.logger.info(this.SYS_CODE + ".updateRefundApplyState.refundMap", (Object)JsonUtil.buildNormalBinder().toJson(refundMap));
        String thirdApplyId = refundMap.get("thirdApplyId").toString();
        String orderId = refundMap.get("orderId").toString();
        String applyStep = refundMap.get("applyStep").toString();
        String stepPassType = null;
        if ("20".equals(applyStep) || "40".equals(applyStep)) {
            stepPassType = refundMap.get("stepPassType").toString();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refundCode", thirdApplyId);
        params.put("tenantCode", jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        String dataStatestr = this.jdRefundStateMapRefundState(applyStep, stepPassType);
        if (StringUtils.isBlank((String)dataStatestr)) {
            this.logger.error(this.SYS_CODE + ".updateRefundApplyState.jdResponseMessageContentDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
            return;
        }
        map.put("newDataStatestr", dataStatestr);
        params.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        this.logger.info(this.SYS_CODE + ".updateRefundApplyState.params", (Object)JsonUtil.buildNonDefaultBinder().toJson(params));
        this.getInternalRouter().inInvoke(OC_REFUND_UPDATE_DATE, params);
    }

    @Override
    public String cancelOrderByJdMessage(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        this.logger.info(this.SYS_CODE + ".cancelOrderByJdMessage.contentMap", (Object)JsonUtil.buildNormalBinder().toJson(contentMap));
        if (!contentMap.containsKey("orderId")) {
            this.logger.error(this.SYS_CODE + ".cancelOrderByJdMessage.contentMap not have key orderId", (Object)JsonUtil.buildNonDefaultBinder().toJson(contentMap));
            return "ERROR";
        }
        String jdOrderId = contentMap.get("orderId").toString();
        if (StringUtils.isBlank((String)jdOrderId)) {
            this.logger.error(this.SYS_CODE + ".cancelOrderByJdMessage.ocContractReDomainQueryResult.jdOrderId is null", (Object)jdOrderId);
            return "ERROR";
        }
        OcContractReDomain ocContractReDomain = this.getOcContractReDomainByJdOrderId(jdOrderId, jdResponseMessageContentDomain.getDisChannel());
        if (null == ocContractReDomain) {
            this.logger.error(this.SYS_CODE + ".cancelOrderByJdMessage.ocContractReDomain is null");
            return "ERROR";
        }
        return null;
    }

    @Override
    public String rejectionOrderByJdMessage(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        if (!contentMap.containsKey("orderId") || !contentMap.containsKey("state")) {
            this.logger.error(this.SYS_CODE + ".cancelOrderByJdMessage.contentMap not have key orderId or state", (Object)JsonUtil.buildNonDefaultBinder().toJson(contentMap));
        }
        String orderId = contentMap.get("orderId").toString();
        String jdState = contentMap.get("state").toString();
        OcContractReDomain ocContractReDomain = this.getOcContractReDomainByJdOrderId(orderId, jdResponseMessageContentDomain.getDisChannel());
        if (null == ocContractReDomain) {
            this.logger.error(this.SYS_CODE + ".rejectionOrderByJdMessage.ocContractReDomain is null");
            return "ERROR";
        }
        if ("1".equals(jdState) && 3 == ocContractReDomain.getDataState()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("contractBillcode", ocContractReDomain.getContractBillcode());
            params.put("tenantCode", jdResponseMessageContentDomain.getDisChannel().getTenantCode());
            params.put("map", new HashMap());
            this.getInternalRouter().inInvoke(OC_CONTRACT_ENGINE_SEND_CONTRACT_NEXT, params);
        } else if ("2".equals(jdState)) {
            // empty if block
        }
        return "SUCCESS";
    }

    @Override
    public String deliveryOrderMessage(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        return "SUCCESS";
    }

    @Override
    public String ctOrderCreate(Message message, String tenantCode) {
        JSONObject orderMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctOrderCreate.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + orderMessage.getString("orderId"));
            return "ERROR";
        }
        switch (orderMessage.getIntValue("orderModel")) {
            case 1: {
                return this.orderCreateMethod(orderMessage, disChannel);
            }
            case 2: {
                return this.afsOrderInfoafterChangeNew(orderMessage, disChannel);
            }
        }
        return "ERROR";
    }

    @Override
    public String ctOrderPay(Message message, String tenantCode) {
        JSONObject orderPayMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctOrderPay.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + orderPayMessage.getString("orderId"));
            return "ERROR";
        }
        String orderId = orderPayMessage.getString("orderId");
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderByContractBillCode(orderId, disChannel);
        if (Objects.isNull(ocContractReDomainQueryResult) || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".ctOrderPay.queryOrderByContractBillCode,orderId = " + orderPayMessage.getString("orderId") + ",\u4eac\u4e1c\u652f\u4ed8\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return "SUCCESS";
        }
        if (Objects.nonNull(((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState()) && ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState() > 1) {
            this.logger.error(this.SYS_CODE + ".ctOrderPay.queryOrderByContractBillCode \u8ba2\u5355\u4ed8\u6b3e\u6210\u529f\uff0corderId = " + orderPayMessage.getString("orderId") + ",\u8ba2\u5355\u652f\u4ed8\u72b6\u6001:" + ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState());
            return "SUCCESS";
        }
        this.logger.error(this.SYS_CODE + ".ctOrderPay.queryOrderByContractBillCode \u8ba2\u5355\u6ca1\u6709\u4ed8\u6b3e\u6210\u529f,\u9700\u8981\u4fee\u6539\uff0corderId = " + orderPayMessage.getString("orderId") + ",\u8ba2\u5355\u72b6\u6001:" + ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("contractId", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getContractId());
        map.put("dataState", 2);
        map.put("oldDataState", 1);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.sendReSupObject("oc.contract.updateContractState", param, Object.class);
        return "SUCCESS";
    }

    @Override
    public String ctStockOut(Message message, String tenantCode) {
        JSONObject stockOutMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctStockOut.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + stockOutMessage.getString("orderId"));
            return "ERROR";
        }
        JSONArray packages = stockOutMessage.getJSONArray("packages");
        if (ListUtil.isEmpty((Collection)packages)) {
            return "ERROR";
        }
        String orderId = stockOutMessage.getString("orderId");
        JSONObject jsonObject = packages.getJSONObject(0);
        String logisticsCode = jsonObject.getString("logisticsCode");
        String waybillCode = jsonObject.getString("waybillCode");
        Date outboundTime = jsonObject.getDate("outboundTime");
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderByContractBillCode(orderId, disChannel);
        if (Objects.nonNull(ocContractReDomainQueryResult) && ListUtil.isNotEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            if (Objects.nonNull(((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState()) && ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState() == 4) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".ctStockOut.queryOrderByContractBillCode \u8ba2\u5355\u6ca1\u6709\u4ed8\u6b3e\u6210\u529f\uff0corderId = " + orderId + ",\u8ba2\u5355\u72b6\u6001:" + ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState());
        }
        String contractBillcode = ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getContractBillcode();
        this.updateSendgoodsPackage(tenantCode, contractBillcode, logisticsCode, waybillCode, outboundTime);
        return "SUCCESS";
    }

    public void updateSendgoodsPackage(String tenantCode, String contractBillcode, String logisticsCode, String waybillCode, Date outboundTime) {
        HashMap<String, String> parammap = new HashMap<String, String>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        QueryResult packageQueryResult = this.sendReSupObject("oc.contract.queryPackagePage", parammap, OcPackage.class);
        if (Objects.isNull(packageQueryResult) || ListUtil.isEmpty((Collection)packageQueryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".updateSendgoodsPackage.sendReSupObject \u8ba2\u5355\u6ca1\u6709\u5305\u88f9\u4fe1\u606f\u7cfb\u7edf\u8ba2\u5355\u53f7\uff0ccontractBillcode = " + contractBillcode);
            return;
        }
        HashMap paramUpdateMap = new HashMap(1);
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        ocPackageDomain.setPackageId(((OcPackage)packageQueryResult.getList().get(0)).getPackageId());
        ocPackageDomain.setPackageBillno(waybillCode);
        ocPackageDomain.setExpressCode(logisticsCode);
        ocPackageDomain.setGmtUse(outboundTime);
        parammap.put("ocPackageDomain", (String)ocPackageDomain);
        this.sendReSupObject("oc.contract.updatePackage", parammap, Object.class);
    }

    @Override
    public String ctOrderDelivered(Message message, String tenantCode) {
        JSONObject orderDeliveredMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctOrderDelivered.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + orderDeliveredMessage.getString("orderId"));
            return "ERROR";
        }
        String orderId = orderDeliveredMessage.getString("orderId");
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderByContractBillCode(orderId, disChannel);
        if (Objects.isNull(ocContractReDomainQueryResult) || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            this.logger.info(this.SYS_CODE + ".ctOrderDelivered.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u59a5\u6295\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return "SUCCESS";
        }
        if (((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState() == 4) {
            this.logger.info(this.SYS_CODE + ".ctOrderDelivered.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u59a5\u6295\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e5f\u4ee5\u59a5\u6295return");
            return "SUCCESS";
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("contractId", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getContractId());
        map.put("dataState", 4);
        map.put("oldDataState", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.sendReSupObject("oc.contract.updateContractState", param, Object.class);
        return "SUCCESS";
    }

    @Override
    public String ctOrderFinish(Message message, String tenantCode) {
        JSONObject orderFinishMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctOrderFinish.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + orderFinishMessage.getString("orderId"));
            return "ERROR";
        }
        String orderId = orderFinishMessage.getString("orderId");
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderByContractBillCode(orderId, disChannel);
        if (Objects.isNull(ocContractReDomainQueryResult) || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            this.logger.info(this.SYS_CODE + ".ctOrderFinish.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u59a5\u6295\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return "SUCCESS";
        }
        if (((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState() == 4) {
            this.logger.info(this.SYS_CODE + ".ctOrderFinish.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u59a5\u6295\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e5f\u4ee5\u59a5\u6295return");
            return "SUCCESS";
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("contractId", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getContractId());
        map.put("dataState", 4);
        map.put("oldDataState", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.sendReSupObject("oc.contract.updateContractState", param, Object.class);
        return "SUCCESS";
    }

    @Override
    public String ctOrderCancel(Message message, String tenantCode) {
        JSONObject orderCancelMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctOrderCancel.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + orderCancelMessage.getString("orderId"));
            return "ERROR";
        }
        String orderId = orderCancelMessage.getString("orderId");
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderByContractBillCode(orderId, disChannel);
        if (Objects.isNull(ocContractReDomainQueryResult) || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            this.logger.info(this.SYS_CODE + ".ctOrderCancel.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u59a5\u6295\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return "SUCCESS";
        }
        if (((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState() == -1) {
            this.logger.info(this.SYS_CODE + ".ctOrderCancel.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u7528\u6237\u6216\u7ba1\u7406\u5458\u53d6\u6d88\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e5f\u4ee5\u53d6\u6d88return");
            return "SUCCESS";
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("contractId", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getContractId());
        map.put("dataState", -1);
        map.put("oldDataState", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.sendReSupObject("oc.contract.updateContractState", param, Object.class);
        return "SUCCESS";
    }

    @Override
    public String ctOrderRefund(Message message, String tenantCode) {
        JSONObject orderRefundMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctOrderRefund.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + orderRefundMessage.getString("orderId"));
            return "ERROR";
        }
        String orderId = orderRefundMessage.getString("orderId");
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderByContractBillCode(orderId, disChannel);
        if (Objects.isNull(ocContractReDomainQueryResult) || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            this.logger.info(this.SYS_CODE + ".ctOrderRefund.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u59a5\u6295\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return "SUCCESS";
        }
        if (((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState() == -1) {
            this.logger.info(this.SYS_CODE + ".ctOrderRefund.queryOrderByContractBillCode,orderId = " + orderId + ",\u4eac\u4e1c\u7528\u6237\u6216\u7ba1\u7406\u5458\u53d6\u6d88\u8ba2\u5355,\u7cfb\u7edf\u4e2d\u4e5f\u4ee5\u53d6\u6d88return");
            return "SUCCESS";
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("contractId", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getContractId());
        map.put("dataState", -1);
        map.put("oldDataState", ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getDataState());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.sendReSupObject("oc.contract.updateContractState", param, Object.class);
        com.yqbsoft.laser.service.contract.domain.OcContractReDomain returnContractData = this.getReturnContractData(orderId, ((OcContractReDomain)ocContractReDomainQueryResult.getList().get(0)).getContractBillcode(), orderRefundMessage, disChannel);
        this.logger.info(this.SYS_CODE + ".ctOrderRefund.createdRefundOrder,orderId = " + orderId + ",\u4eac\u4e1c\u9000\u6b3e\u8ba2\u5355\u52a0\u5165\u9000\u6b3e\u5217\u8868\u6570\u636e:" + JSONObject.toJSONString((Object)returnContractData));
        HashMap<String, String> returnParam = new HashMap<String, String>();
        returnParam.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)returnContractData));
        this.sendReSupObject("oc.refund.createdRefundOrder", returnParam, Object.class);
        return "SUCCESS";
    }

    public com.yqbsoft.laser.service.contract.domain.OcContractReDomain getReturnContractData(String orderId, String contractBlillcode, JSONObject orderRefundMessage, DisChannel disChannel) {
        JSONArray skuList = orderRefundMessage.getJSONArray("skuList");
        com.yqbsoft.laser.service.contract.domain.OcContractReDomain ocContractDomain = new com.yqbsoft.laser.service.contract.domain.OcContractReDomain();
        ocContractDomain.setTenantCode(disChannel.getTenantCode());
        ocContractDomain.setContractBbillcode(contractBlillcode);
        ArrayList<com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain> ocContractGoodsDomains = new ArrayList<com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain>();
        com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain ocContractGoodsDomain = null;
        if (ListUtil.isNotEmpty((Collection)skuList)) {
            for (int i = 0; i < skuList.size(); ++i) {
                JSONObject jsonObject = skuList.getJSONObject(i);
                ocContractGoodsDomain = new com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain();
                ocContractGoodsDomain.setGoodsNum(jsonObject.getBigDecimal("quantity"));
                ocContractGoodsDomain.setSkuCode(jsonObject.getString("skuId"));
                ocContractGoodsDomain.setSkuName(jsonObject.getString("skuName"));
                ocContractGoodsDomains.add(ocContractGoodsDomain);
            }
        }
        ocContractDomain.setGoodsList(ocContractGoodsDomains);
        ocContractDomain.setMemberGname(disChannel.getMemberName());
        ocContractDomain.setContractNbillcode(orderId);
        ocContractDomain.setDataState(Integer.valueOf(-1));
        ocContractDomain.setDataBmoney(orderRefundMessage.getBigDecimal("refundFee"));
        return ocContractDomain;
    }

    @Override
    public String ctAfsCreate(Message message, String tenantCode) {
        JSONObject ctAfsCreateMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctAfsCreate.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + ctAfsCreateMessage.getString("orderId"));
            return "ERROR";
        }
        String afsServiceId = ctAfsCreateMessage.getString("afsServiceId");
        return null;
    }

    @Override
    public String ctAfsStepResult(Message message, String tenantCode) {
        JSONObject ctAfsStepResultMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctAfsStepResult.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + ctAfsStepResultMessage.getString("orderId"));
            return "ERROR";
        }
        String afsServiceId = ctAfsStepResultMessage.getString("afsServiceId");
        String afsResultType = ctAfsStepResultMessage.getString("afsResultType");
        return null;
    }

    @Override
    public String ctOrderBalanceNotEnough(Message message, String tenantCode) {
        JSONObject ctOrderBalanceNotEnoughMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctOrderBalanceNotEnough.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + ctOrderBalanceNotEnoughMessage.getString("orderId"));
            return "ERROR";
        }
        return null;
    }

    @Override
    public String ctClearanceResult(Message message, String tenantCode) {
        JSONObject ctClearanceResultMessage = JSONObject.parseObject((String)message.getBody().toString());
        DisChannel disChannel = this.getDisChannel(tenantCode, JdJosConstants.channelCode);
        if (Objects.isNull(disChannel)) {
            this.logger.error(this.SYS_CODE + ".ctClearanceResult.getDisChannel \u901a\u8fc7tenantCode\u67e5\u8be2disChannel\u5931\u8d25\uff0corderId = " + ctClearanceResultMessage.getString("orderId"));
            return "ERROR";
        }
        return null;
    }

    public String orderCreateMethod(JSONObject orderMessage, DisChannel disChannel) {
        String orderId = orderMessage.getString("orderId");
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderByContractBillCode(orderId, disChannel);
        if (!Objects.isNull(ocContractReDomainQueryResult) && ListUtil.isNotEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            return "SUCCESS";
        }
        return "ERROR";
    }

    public String afsOrderInfoafterChangeNew(JSONObject orderMessage, DisChannel disChannel) {
        long orderId = orderMessage.getLongValue("orderId");
        String channelOrderId = orderMessage.getString("channelOrderId");
        String createTime = orderMessage.getString("createTime");
        String afsOrderId = orderMessage.getJSONObject("afsOrderInfo").getString("orderId");
        String parentOrderId = orderMessage.getJSONObject("afsOrderInfo").getString("parentOrderId");
        String serviceId = orderMessage.getJSONObject("afsOrderInfo").getString("serviceId");
        return "ERROR";
    }

    protected QueryResult<OcContractReDomain> queryOrderByContractBillCode(String contractBillCode, DisChannel disChannel) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rows", 1);
        map.put("startRow", 0);
        map.put("tenantCode", disChannel.getTenantCode());
        map.put("contractNbillcode", contractBillCode);
        map.put("childFlag", false);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult ocContractReDomainQueryResult = this.sendReSupObject(OC_CONTRACT_GET_CONTRACT_BY_CODE, param, OcContractReDomain.class);
        return ocContractReDomainQueryResult;
    }

    protected OcContractReDomain getOcContractReDomainByJdOrderId(String jdOrderId, DisChannel disChannel) {
        int rows = 1;
        int startRow = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rows", rows);
        map.put("startRow", startRow);
        map.put("tenantCode", disChannel.getTenantCode());
        map.put("contractNbillcode", jdOrderId);
        map.put("childFlag", true);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult ocContractReDomainQueryResult = this.sendReSupObject(OC_CONTRACT_QUERY_CONTRACT_PAGE, param, OcContractReDomain.class);
        if (null == ocContractReDomainQueryResult || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".queryOrderByJdOrderId.ocContractReDomainQueryResult is null", (Object)ocContractReDomainQueryResult);
            return null;
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)ocContractReDomainQueryResult.getList().get(0);
        return ocContractReDomain;
    }

    protected OcRefundDomain setRefundDomainByOcContractReDomain(OcContractReDomain ocContractReDomain, int skuNum) {
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractReDomain);
            BigDecimal refundMoney = BigDecimal.ZERO;
            ocRefundDomain.setRefundType("B03");
            List goodsList = ocContractReDomain.getGoodsList();
            ArrayList<OcRefundGoodsDomain> ocRefundGoodsList = new ArrayList<OcRefundGoodsDomain>();
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                ocContractGoodsDomain.getContractGoodsCode();
                OcRefundGoodsDomain ocRefundGoods = new OcRefundGoodsDomain();
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoods, (Object)ocContractGoodsDomain);
                ocRefundGoods.setRefundGoodsNum(new BigDecimal(skuNum));
                ocRefundGoodsList.add(ocRefundGoods);
            }
            ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsList);
            return ocRefundDomain;
        }
        catch (Exception exception) {
            this.logger.error(this.SYS_CODE + ".setRefundDomainByOcContractReDomain.copyAllPropertysNotNull exception", (Throwable)exception);
            return null;
        }
    }

    private String jdRefundStateMapRefundState(String applyStep, String stepPassType) {
        String dataStatestr = null;
        if ("20".equals(applyStep)) {
            if ("10".equals(stepPassType)) {
                dataStatestr = "1";
            } else if ("20".equals(stepPassType)) {
                dataStatestr = "1";
            } else if ("30".equals(stepPassType)) {
                dataStatestr = "2";
            }
        } else if ("40".equals(applyStep)) {
            if ("10".equals(stepPassType)) {
                dataStatestr = "3";
            } else if ("20".equals(stepPassType)) {
                dataStatestr = "3";
            } else if ("30".equals(stepPassType)) {
                dataStatestr = "4";
            }
        } else if ("30".equals(applyStep)) {
            dataStatestr = "11";
        } else if ("50".equals(applyStep)) {
            dataStatestr = "6";
        } else if ("60".equals(applyStep)) {
            dataStatestr = "8";
        } else if ("70".equals(applyStep)) {
            dataStatestr = "9";
        }
        return dataStatestr;
    }

    static {
        sendOrderRefundLock = new Object();
    }
}

