/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdpc.service;

import com.jddglobal.open.client.JddClient;
import com.jddglobal.open.request.TrademCashierAcceptOrderRequest;
import com.jddglobal.open.request.TrademCashierGeturlRequest;
import com.jddglobal.open.request.base.JddRequest;
import com.jddglobal.open.response.TrademCashierAcceptOrderResponse;
import com.jddglobal.open.response.TrademCashierGeturlResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.ext.channel.jdpc.JDPayPcConstants;
import com.yqbsoft.laser.service.ext.channel.jdpc.config.JDSDKConfig;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    private static final String CODE = "jdpc.ChannelInServiceImpl";

    public String getFchannelCode() {
        return JDPayPcConstants.CHANNEL_CODE;
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty() || null == channelRequest.getCmChannelClear()) {
            this.logger.error("jdpc.ChannelInServiceImpl.channelRequest.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)channelRequest));
            throw new ApiException("jdpc.ChannelInServiceImpl.channelRequest.param is null");
        }
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        String agentCode = (String)channelRequest.getConfigMap().get("agent_code");
        String successUrl = (String)channelRequest.getConfigMap().get("success_url");
        String platformMerchantId = (String)channelRequest.getConfigMap().get("mer_id");
        if (StringUtils.isBlank((String)agentCode) || StringUtils.isBlank((String)successUrl) || StringUtils.isBlank((String)platformMerchantId)) {
            this.logger.error(CODE, (Object)"\u4ee3\u7406\u5546\u7f16\u7801\u548c\u524d\u53f0\u8df3\u8f6c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a,\u68c0\u67e5(cm_fchannel_config)\u914d\u7f6e");
            throw new ApiException(CODE, "\u5fc5\u8981\u914d\u7f6e\u4e3a\u7a7a");
        }
        TrademCashierAcceptOrderRequest request = new TrademCashierAcceptOrderRequest();
        request.setPlatformSerialNo(cmChannelClear.getPaymentOrderMemo());
        request.setMerchantOrderNo(cmChannelClear.getPaymentOrderMemo());
        request.setAgentCode(agentCode);
        request.setPlatformMerchantId(platformMerchantId);
        request.setPlatformUserId(cmChannelClear.getOpuserCode());
        request.setOrderAmount(cmChannelClear.getOrderAmount().setScale(2, 4));
        request.setPlatformUserName(cmChannelClear.getBusinessOrderno());
        try {
            JddClient jddClient = new JDSDKConfig((Map<String, String>)channelRequest.getConfigMap()).jddClient;
            this.logger.info("jdpc.ChannelInServiceImpl.\u4eac\u4e1cPC\u652f\u4ed8\u8bf7\u6c42.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)request));
            TrademCashierAcceptOrderResponse adaptResponse = (TrademCashierAcceptOrderResponse)jddClient.execute((JddRequest)request);
            this.logger.info("jdpc.ChannelInServiceImpl.\u4eac\u4e1cPC\u652f\u4ed8\u8bf7\u6c42\u8fd4\u56de.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)adaptResponse));
            if (!"00000".equals(adaptResponse.getCode())) {
                this.logger.error("jdpc.ChannelInServiceImpl.\u4eac\u4e1cPC\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)adaptResponse));
                throw new ApiException("jdpc.ChannelInServiceImpl.ex", adaptResponse.getMsg());
            }
            TrademCashierGeturlRequest getUrlRequest = new TrademCashierGeturlRequest();
            getUrlRequest.setAgentCode(agentCode);
            getUrlRequest.setPlatformMerchatId(platformMerchantId);
            getUrlRequest.setPlatformUserId(cmChannelClear.getOpuserCode());
            getUrlRequest.setPlatformUserName(cmChannelClear.getBusinessOrderno());
            getUrlRequest.setPlatformSerialNo(cmChannelClear.getPaymentOrderMemo());
            getUrlRequest.setMerchantOrderNo(cmChannelClear.getPaymentOrderMemo());
            getUrlRequest.setAgentUserRole(Integer.valueOf(0));
            getUrlRequest.setTradeType(Integer.valueOf(0));
            getUrlRequest.setTradeOrderNo(adaptResponse.getData().getTradeOrderNo());
            getUrlRequest.setSuccessUrl(successUrl);
            this.logger.info("jdpc.ChannelInServiceImpl.getUrl.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)getUrlRequest));
            TrademCashierGeturlResponse getUrlResponse = (TrademCashierGeturlResponse)jddClient.execute((JddRequest)getUrlRequest);
            this.logger.info("jdpc.ChannelInServiceImpl.getUrl.result", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)getUrlResponse));
            if (!"00000".equals(getUrlResponse.getCode())) {
                this.logger.error("jdpc.ChannelInServiceImpl.\u4eac\u4e1cPC\u9884\u4e0b\u5355\u8fd4\u56de\u5931\u8d25", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)getUrlResponse));
                throw new ApiException("jdpc.ChannelInServiceImpl.ex", adaptResponse.getMsg());
            }
            return getUrlResponse.getData().getTradeUrl();
        }
        catch (Exception e) {
            throw new ApiException("jdpc.ChannelInServiceImpl\u4eac\u4e1cPay\u8bf7\u6c42\u5f02\u5e38.ex", (Throwable)e);
        }
    }
}

