/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdpc.service;

import com.jddglobal.open.client.JddClient;
import com.jddglobal.open.request.TrademCashierRefundRequest;
import com.jddglobal.open.request.base.JddRequest;
import com.jddglobal.open.response.TrademCashierRefundResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelReBaseService;
import com.yqbsoft.laser.service.ext.channel.jdpc.JDPayPcConstants;
import com.yqbsoft.laser.service.ext.channel.jdpc.config.JDSDKConfig;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class ChannelReServiceImpl
extends ChannelReBaseService {
    private static final String CODE = "jdpc.ChannelInServiceImpl";

    public String getFchannelCode() {
        return JDPayPcConstants.CHANNEL_CODE;
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty() || null == channelRequest.getCmChannelClear()) {
            this.logger.error("jdpc.ChannelInServiceImpl.channelRequest.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)channelRequest));
            throw new ApiException("jdpc.ChannelInServiceImpl.channelRequest.param is null");
        }
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        String agentCode = (String)channelRequest.getConfigMap().get("agent_code");
        String platformMerchantId = (String)channelRequest.getConfigMap().get("mer_id");
        if (StringUtils.isBlank((String)agentCode) || StringUtils.isBlank((String)platformMerchantId)) {
            this.logger.error(CODE, (Object)"\u4ee3\u7406\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u68c0\u67e5(cm_fchannel_config)\u914d\u7f6e");
            throw new ApiException(CODE, "\u5fc5\u8981\u914d\u7f6e\u4e3a\u7a7a");
        }
        String outRefundNo = (String)channelRequest.getRequestData().get("out_refund_no");
        String totalFee = (String)channelRequest.getRequestData().get("total_fee");
        if (StringUtils.isBlank((String)outRefundNo) || StringUtils.isBlank((String)totalFee)) {
            this.logger.error(CODE, (Object)"\u9000\u6b3e\u8ba2\u5355\u53f7\u548c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApiException(CODE, "\u5fc5\u8981\u914d\u7f6e\u4e3a\u7a7a");
        }
        BigDecimal refundFee = new BigDecimal(totalFee).setScale(2, RoundingMode.HALF_UP).divide(new BigDecimal(100));
        if (refundFee.compareTo(BigDecimal.ZERO) == -1) {
            throw new ApiException(CODE, "\u9000\u6b3e\u91d1\u989d\u9519\u8bef");
        }
        TrademCashierRefundRequest refundRequest = new TrademCashierRefundRequest();
        refundRequest.setAgentCode(agentCode);
        refundRequest.setPlatformMerchantId(platformMerchantId);
        refundRequest.setPlatformSerialNo(cmChannelClear.getPaymentOrderMemo());
        refundRequest.setPlatformRefundNo(outRefundNo);
        refundRequest.setTotalAmount(refundFee);
        try {
            JddClient jddClient = new JDSDKConfig((Map<String, String>)channelRequest.getConfigMap()).jddClient;
            this.logger.info("jdpc.ChannelInServiceImpl.\u4eac\u4e1cPC\u9000\u6b3e\u8bf7\u6c42.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)refundRequest));
            TrademCashierRefundResponse refundResponse = (TrademCashierRefundResponse)jddClient.execute((JddRequest)refundRequest);
            this.logger.info("jdpc.ChannelInServiceImpl.\u4eac\u4e1cPC\u9000\u6b3e\u8bf7\u6c42\u8fd4\u56de.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)refundResponse));
            if (!"00000".equals(refundResponse.getCode())) {
                this.logger.error("jdpc.ChannelInServiceImpl.\u4eac\u4e1cPC\u9000\u6b3e\u5931\u8d25\u5931\u8d25", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)refundResponse));
                throw new ApiException("jdpc.ChannelInServiceImpl.ex", refundResponse.getMsg());
            }
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("out_refund_no", outRefundNo);
            resultMap.put("refund_id", refundResponse.getData().getRefundNo());
            resultMap.put("trade_status", refundResponse.getCode());
            resultMap.put("result_code", refundResponse.getCode());
            return JsonUtil.buildNonNullBinder().toJson(resultMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

