/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.util;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryDeliveryInfo.DeliveryInfoQueryOpenResp;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryDeliveryInfo.LogisticInfoOrderOpenResp;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryDeliveryInfo.OpenRpcResult;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryDeliveryInfo.TrackInfoOrderOpenResp;
import com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryOrderDetail.QueryOrderOpenResp;
import com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.getAfsOutline.OpenPagingResult;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.CheckSkuSaleGoodsResp;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSellPrice.GetSellPriceGoodsResp;
import com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.VopBizTransMessage;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderQueryDeliveryInfoRequest;
import com.jd.open.api.sdk.request.vopdd.VopOrderQueryOrderDetailRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsGetAfsOutlineRequest;
import com.jd.open.api.sdk.request.vopsp.VopGoodsCheckSkuSaleListRequest;
import com.jd.open.api.sdk.request.vopsp.VopGoodsGetSellPriceRequest;
import com.jd.open.api.sdk.request.vopsp.VopGoodsGetSkuDetailInfoRequest;
import com.jd.open.api.sdk.request.vopxx.VopMessageDeleteClientMsgByIdListRequest;
import com.jd.open.api.sdk.request.vopxx.VopMessageQueryTransByVopNormalRequest;
import com.jd.open.api.sdk.response.vopdd.VopOrderQueryDeliveryInfoResponse;
import com.jd.open.api.sdk.response.vopdd.VopOrderQueryOrderDetailResponse;
import com.jd.open.api.sdk.response.vopsh.VopAfsGetAfsOutlineResponse;
import com.jd.open.api.sdk.response.vopsp.VopGoodsCheckSkuSaleListResponse;
import com.jd.open.api.sdk.response.vopsp.VopGoodsGetSellPriceResponse;
import com.jd.open.api.sdk.response.vopsp.VopGoodsGetSkuDetailInfoResponse;
import com.jd.open.api.sdk.response.vopxx.VopMessageDeleteClientMsgByIdListResponse;
import com.jd.open.api.sdk.response.vopxx.VopMessageQueryTransByVopNormalResponse;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.enums.ResultCode;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.UtilResultBean;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdInterfaceUtil {
    private static final String SYS_CODE = "JdInterfaceUtil";
    private Logger logger = LoggerFactory.getLogger(JdInterfaceUtil.class);

    public static JdClient getJdClient(JdResponseMessageContentDomain jdResponseMessageContentDomain, String accessToken) {
        Map<String, Object> keyMap = jdResponseMessageContentDomain.getKeyMap();
        String serverUrl = keyMap.get("serverUrl").toString();
        String appKey = (String)keyMap.get("appKey");
        String appSecret = (String)keyMap.get("appSecret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }

    public static UtilResultBean<List<String>> checkSkuSaleGoodsReq(JdClient client, String skuIds, int type) {
        if (1 != type || 2 != type) {
            return UtilResultBean.errorResult("type \u7c7b\u578b\u9519\u8bef");
        }
        UtilResultBean result = UtilResultBean.successResult(null);
        UtilResultBean<com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.queryCheckSaleGoods(client, skuIds);
        if (ResultCode.ERROR.getCode().equals(openRpcResultUtilResultBean.getCode())) {
            result = UtilResultBean.copyProperties(openRpcResultUtilResultBean, result);
            return result;
        }
        com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.OpenRpcResult openRpcResult = openRpcResultUtilResultBean.getData();
        ArrayList<String> goodsStateOffList = new ArrayList<String>();
        ArrayList<String> goodsStatePutList = new ArrayList<String>();
        List checkSkuSaleGoodsRespList = null;
        if ("2004".equals(openRpcResult.getResultCode())) {
            String message = openRpcResult.getResultMessage();
            StringBuffer messageBuffer = new StringBuffer(message);
            messageBuffer.delete(messageBuffer.indexOf("\u4e0d\u5728"), messageBuffer.length());
            String[] skuIdsError = messageBuffer.toString().split(",");
            StringBuffer skuIdsTow = new StringBuffer();
            for (int i = 0; i < skuIdsError.length; ++i) {
                goodsStateOffList.add(skuIdsError[i]);
            }
            for (String skuId : skuIds.split(",")) {
                if (!messageBuffer.toString().contains(skuId)) continue;
                skuIdsTow.append(skuId).append(",");
            }
            skuIdsTow.delete(skuIdsTow.lastIndexOf(","), skuIdsTow.length());
            UtilResultBean<com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.OpenRpcResult> openRpcResultUtilResultBeanTow = JdInterfaceUtil.queryCheckSaleGoods(client, skuIdsTow.toString());
            if (openRpcResult.getSuccess()) {
                checkSkuSaleGoodsRespList = openRpcResultUtilResultBeanTow.getData().getResult();
            }
        }
        if (openRpcResult.getSuccess()) {
            checkSkuSaleGoodsRespList = openRpcResult.getResult();
        }
        if (ListUtil.isEmpty(checkSkuSaleGoodsRespList)) {
            return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods \u4eac\u4e1c\u8fd4\u56de\u53ef\u552e\u6027skuId \u4e3a\u7a7a");
        }
        for (CheckSkuSaleGoodsResp checkSkuSaleGoodsResp : checkSkuSaleGoodsRespList) {
            String skuId = String.valueOf(checkSkuSaleGoodsResp.getSkuId());
            if (1 == checkSkuSaleGoodsResp.getSaleState()) {
                UtilResultBean<Boolean> checkGoodsStatePutResult = JdInterfaceUtil.checkGoodsStatePut(client, skuId);
                if (ResultCode.ERROR.getCode().equals(checkGoodsStatePutResult.getCode())) {
                    return UtilResultBean.copyProperties(checkGoodsStatePutResult, result);
                }
                if (checkGoodsStatePutResult.getData().booleanValue()) {
                    goodsStatePutList.add(skuId);
                    continue;
                }
                goodsStateOffList.add(skuId);
                continue;
            }
            if (2 != checkSkuSaleGoodsResp.getSaleState() && (null == checkSkuSaleGoodsResp.getBanCause() || !checkSkuSaleGoodsResp.getBanCause().contains("\u4e0b\u67b6"))) continue;
            goodsStateOffList.add(skuId);
        }
        if (1 == type) {
            result.setData(goodsStatePutList);
        } else if (2 == type) {
            result.setData(goodsStateOffList);
        }
        return result;
    }

    public static UtilResultBean<Boolean> checkGoodsStatePut(JdClient client, String skuId) {
        UtilResultBean<com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.jdvopGoodsDetailInfo(client, skuId);
        if (ResultCode.ERROR.getCode().equals(openRpcResultUtilResultBean.getCode())) {
            return UtilResultBean.errorResult(openRpcResultUtilResultBean.getMessage());
        }
        com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult openRpcResult = openRpcResultUtilResultBean.getData();
        if (1 == openRpcResult.getResult().getSkuState()) {
            return UtilResultBean.successResult(true);
        }
        if (2 == openRpcResult.getResult().getSkuState()) {
            return UtilResultBean.successResult(false);
        }
        return UtilResultBean.errorResult("JdInterfaceUtil.checkGoodsStatePut \u4eac\u4e1c\u8fd4\u56de\u4e3b\u7ad9\u4e0a\u4e0b\u67b6\u72b6\u6001\uff1a" + JsonUtil.buildNonEmptyBinder().toJson((Object)openRpcResult.getResult()));
    }

    public static UtilResultBean<com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult> jdvopGoodsDetailInfo(JdClient client, String skuId) {
        if (null == client) {
            return UtilResultBean.errorResult("JdInterfaceUtil.jdvopGoodsDetailInfo \u4eac\u4e1c\u8bf7\u6c42\u5ba2\u6237\u7aef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)skuId)) {
            return UtilResultBean.errorResult("JdInterfaceUtilqueryJdvopGoodsDetailInfo skuId \u53c2\u6570\u4e3a\u7a7a");
        }
        VopGoodsGetSkuDetailInfoRequest request = new VopGoodsGetSkuDetailInfoRequest();
        request.setSkuId(Long.valueOf(skuId).longValue());
        try {
            VopGoodsGetSkuDetailInfoResponse response = (VopGoodsGetSkuDetailInfoResponse)client.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtilJdInterfaceUtilqueryJdvopGoodsDetailInfo \u67e5\u8be2\u4eac\u4e1cvop\u5546\u54c1\u8be6\u60c5\u63a5\u53e3\u9519\u8bef " + JsonUtil.buildNonEmptyBinder().toJson((Object)response));
            }
            com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtilqueryJdvopGoodsDetailInfo \u67e5\u8be2\u4eac\u4e1cvop\u5546\u54c1\u8be6\u60c5\u63a5\u53e3\u9519\u8bef " + JsonUtil.buildNonDefaultBinder().toJson((Object)openRpcResult));
            }
            return UtilResultBean.successResult(openRpcResult);
        }
        catch (Exception e) {
            return UtilResultBean.exceptionResult("JdInterfaceUtilqueryJdvopGoodsDetailInfo ", e);
        }
    }

    public static UtilResultBean<com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryOrderDetail.OpenRpcResult> queryJdOrderDetailInfo(JdClient client, Long orderId) {
        if (null == client) {
            return UtilResultBean.errorResult("JdInterfaceUtil.queryJdOrderDetailInfo.client is null");
        }
        if (null == orderId) {
            return UtilResultBean.errorResult("JdInterfaceUtilqueryJdOrderDetailInfo.orderId is null");
        }
        VopOrderQueryOrderDetailRequest request = new VopOrderQueryOrderDetailRequest();
        request.setJdOrderId(orderId);
        try {
            VopOrderQueryOrderDetailResponse response = (VopOrderQueryOrderDetailResponse)client.execute((JdRequest)request);
            if (null == response || !"0".equals(response.getCode())) {
                return UtilResultBean.errorResult("JdInterfaceUtilqueryJdOrderDetailInfo.response " + JsonUtil.buildNonEmptyBinder().toJson((Object)response));
            }
            com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryOrderDetail.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtilqueryJdOrderDetailInfo.openRpcResult " + JsonUtil.buildNonDefaultBinder().toJson((Object)response));
            }
            return UtilResultBean.successResult(openRpcResult);
        }
        catch (Exception e) {
            return UtilResultBean.exceptionResult("JdInterfaceUtilqueryJdOrderDetailInfo ", e);
        }
    }

    public static UtilResultBean<com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.OpenRpcResult> queryCheckSaleGoods(JdClient client, String skuIds) {
        if (null == client) {
            return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.client.null");
        }
        if (StringUtils.isBlank((String)skuIds)) {
            return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.skuIds.null");
        }
        VopGoodsCheckSkuSaleListRequest request = new VopGoodsCheckSkuSaleListRequest();
        request.setSkuId(skuIds);
        try {
            VopGoodsCheckSkuSaleListResponse response = (VopGoodsCheckSkuSaleListResponse)client.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.response.null");
            }
            com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.openRpcResult.null");
            }
            return UtilResultBean.successResult(openRpcResult);
        }
        catch (Exception e) {
            return UtilResultBean.exceptionResult("JdInterfaceUtilqueryCheckSaleGoods.exception", e);
        }
    }

    public static UtilResultBean<List<GetSellPriceGoodsResp>> queryGoodsPrice(String skuId, JdClient client) {
        VopGoodsGetSellPriceRequest request = new VopGoodsGetSellPriceRequest();
        request.setSkuId(skuId);
        try {
            VopGoodsGetSellPriceResponse response = (VopGoodsGetSellPriceResponse)client.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryGoodsPrice.response is null");
            }
            com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSellPrice.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryGoodsPrice.openRpcResult is null");
            }
            List getSellPriceGoodsResps = openRpcResult.getResult();
            return UtilResultBean.successResult(getSellPriceGoodsResps);
        }
        catch (Exception exception) {
            return UtilResultBean.exceptionResult("JdInterfaceUtil.queryGoodsPrice exception", exception);
        }
    }

    public static UtilResultBean<OpenPagingResult> queryJdRefundDetail(JdClient jdClient, String thirdApplyId, Long orderId) {
        int pageSize = 20;
        int pageIndex = 1;
        VopAfsGetAfsOutlineRequest request = new VopAfsGetAfsOutlineRequest();
        request.setThirdApplyId(thirdApplyId);
        request.setPageSize(pageSize);
        request.setOrderId(orderId);
        request.setPageIndex(pageIndex);
        try {
            VopAfsGetAfsOutlineResponse response = (VopAfsGetAfsOutlineResponse)jdClient.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdRefundDetail.response.null");
            }
            com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.getAfsOutline.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdRefundDetail.openRpcResult.null");
            }
            OpenPagingResult openPagingResult = openRpcResult.getResult();
            if (null == openPagingResult) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdRefundDetail.openRpcResult.null");
            }
            return UtilResultBean.successResult(openPagingResult);
        }
        catch (Exception exception) {
            return UtilResultBean.exceptionResult("JdInterfaceUtil.queryJdRefundDetail.exception", exception);
        }
    }

    public static UtilResultBean<com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.OpenRpcResult> queryJdMessage(String type, JdClient client) {
        com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.OpenRpcResult openRpcResult = null;
        try {
            VopMessageQueryTransByVopNormalRequest request = new VopMessageQueryTransByVopNormalRequest();
            request.setType(type);
            VopMessageQueryTransByVopNormalResponse response = (VopMessageQueryTransByVopNormalResponse)client.execute((JdRequest)request);
            if (null == response || null == response.getOpenRpcResult()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryVopMsg.response.getOpenRpcResult() ", JsonUtil.buildNormalBinder().toJson((Object)response));
            }
            openRpcResult = response.getOpenRpcResult();
            return UtilResultBean.successResult(openRpcResult);
        }
        catch (Exception e) {
            return UtilResultBean.exceptionResult("\u8bf7\u6c42\u4eac\u4e1c\u6d88\u606f\u63a5\u53e3\u5f02\u5e38 ", e);
        }
    }

    public static boolean deleteVopMsgById(JdClient client, String msgIds) {
        com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.deleteClientMsgByIdList.OpenRpcResult vopOrderRpcResult = null;
        try {
            VopMessageDeleteClientMsgByIdListRequest request = new VopMessageDeleteClientMsgByIdListRequest();
            request.setId(msgIds);
            VopMessageDeleteClientMsgByIdListResponse response = (VopMessageDeleteClientMsgByIdListResponse)client.execute((JdRequest)request);
            if (null == response.getVopOrderRpcResult()) {
                return false;
            }
            vopOrderRpcResult = response.getVopOrderRpcResult();
            return vopOrderRpcResult.getSuccess();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteVopMsgByIds(List<VopBizTransMessage> vopBizTransMessageList, JdClient client) {
        StringBuffer messageIds = new StringBuffer();
        for (VopBizTransMessage vopBizTransMessage : vopBizTransMessageList) {
            messageIds.append(vopBizTransMessage.getId()).append(",");
        }
        if (messageIds.length() == 0) {
            return false;
        }
        String messageId = messageIds.delete(messageIds.lastIndexOf(","), messageIds.length()).toString();
        JdInterfaceUtil.deleteVopMsgById(client, messageId);
        return true;
    }

    public static UtilResultBean<List<SgSendgoodsLogDomain>> queryDeliveryInfo(String thirdOrderId, String jdOrderId, String tenantCode, JdClient client) {
        UtilResultBean<com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryOrderDetail.OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.queryJdOrderDetailInfo(client, Long.valueOf(jdOrderId));
        if (ResultCode.ERROR.getCode().equals(openRpcResultUtilResultBean.getCode())) {
            return UtilResultBean.errorResult(openRpcResultUtilResultBean.getMessage());
        }
        com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryOrderDetail.OpenRpcResult orderDetailResult = openRpcResultUtilResultBean.getData();
        if (null == orderDetailResult || !orderDetailResult.getSuccess()) {
            return UtilResultBean.errorResult("JdInterfaceUtilqueryDeliveryInfo.orderDetailResult is null");
        }
        List orderDetailInfoList = orderDetailResult.getResult();
        if (ListUtil.isEmpty((Collection)orderDetailInfoList)) {
            return UtilResultBean.errorResult("JdInterfaceUtilqueryDeliveryInfo.orderDetailInfoList is null");
        }
        Iterator iterator = orderDetailInfoList.iterator();
        if (iterator.hasNext()) {
            QueryOrderOpenResp queryOrderOpenResp = (QueryOrderOpenResp)iterator.next();
            DeliveryInfoQueryOpenResp result = null;
            if (ListUtil.isEmpty((Collection)queryOrderOpenResp.getChildJdOrderIdList())) {
                UtilResultBean<DeliveryInfoQueryOpenResp> deliveryInfoQueryOpenRespUtilResultBean = JdInterfaceUtil.queryJdDeliveryInfoList(jdOrderId, client);
                if (ResultCode.ERROR.getCode().equals(deliveryInfoQueryOpenRespUtilResultBean.getCode())) {
                    return UtilResultBean.errorResult(deliveryInfoQueryOpenRespUtilResultBean.getMessage());
                }
                result = deliveryInfoQueryOpenRespUtilResultBean.getData();
                List<SgSendgoodsLogDomain> sgSendgoodsLogDomainList = JdInterfaceUtil.setSgSendgoodsLogDomainByJdDelivery(result, thirdOrderId, jdOrderId, tenantCode);
                return UtilResultBean.successResult(sgSendgoodsLogDomainList);
            }
            List childJdOrderIdList = queryOrderOpenResp.getChildJdOrderIdList();
            ArrayList<SgSendgoodsLogDomain> sgSendgoodsLogDomainList = new ArrayList<SgSendgoodsLogDomain>();
            for (Long orderId : childJdOrderIdList) {
                UtilResultBean<DeliveryInfoQueryOpenResp> deliveryInfoQueryOpenRespUtilResultBean = JdInterfaceUtil.queryJdDeliveryInfoList(orderId.toString(), client);
                if (ResultCode.ERROR.getCode().equals(deliveryInfoQueryOpenRespUtilResultBean.getCode())) {
                    return UtilResultBean.errorResult(deliveryInfoQueryOpenRespUtilResultBean.getMessage());
                }
                result = deliveryInfoQueryOpenRespUtilResultBean.getData();
                List<SgSendgoodsLogDomain> sgSendgoodsLogDomainListTemp = JdInterfaceUtil.setSgSendgoodsLogDomainByJdDelivery(result, thirdOrderId, jdOrderId, tenantCode);
                sgSendgoodsLogDomainList.addAll(sgSendgoodsLogDomainListTemp);
            }
            return UtilResultBean.successResult(sgSendgoodsLogDomainList);
        }
        return UtilResultBean.successResult(null);
    }

    public static List<SgSendgoodsLogDomain> setSgSendgoodsLogDomainByJdDelivery(DeliveryInfoQueryOpenResp deliveryInfoQueryOpenResp, String thirdOrderId, String jdOrderId, String tenantCode) {
        List logisticInfoList = deliveryInfoQueryOpenResp.getLogisticInfoList();
        ArrayList<SgSendgoodsLogDomain> logList = new ArrayList<SgSendgoodsLogDomain>();
        List trackList = deliveryInfoQueryOpenResp.getTrackInfoList();
        if (ListUtil.isEmpty((Collection)trackList)) {
            return null;
        }
        for (TrackInfoOrderOpenResp trackInfoOrderOpenResp : trackList) {
            SgSendgoodsLogDomain sgSendgoodsLogDomain = new SgSendgoodsLogDomain();
            if (ListUtil.isNotEmpty((Collection)logisticInfoList)) {
                String deliveryOrderId = ((LogisticInfoOrderOpenResp)logisticInfoList.get(0)).getDeliveryOrderId();
                String deliveryCarrier = ((LogisticInfoOrderOpenResp)logisticInfoList.get(0)).getDeliveryCarrier();
                sgSendgoodsLogDomain.setExpressName(deliveryCarrier);
                sgSendgoodsLogDomain.setExpressCode(deliveryOrderId);
                if (StringUtils.isNotBlank((String)deliveryOrderId) && StringUtils.isBlank((String)deliveryCarrier)) {
                    sgSendgoodsLogDomain.setExpressName("\u7b2c\u4e09\u65b9\u7269\u6d41");
                }
            }
            sgSendgoodsLogDomain.setContractBillcode(thirdOrderId);
            sgSendgoodsLogDomain.setContractNbillcode(jdOrderId);
            sgSendgoodsLogDomain.setTenantCode(tenantCode);
            sgSendgoodsLogDomain.setSendgoodsLogMsg(trackInfoOrderOpenResp.getTrackContent());
            sgSendgoodsLogDomain.setRemark(DateUtils.getDateString((Date)trackInfoOrderOpenResp.getTrackMsgTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            logList.add(sgSendgoodsLogDomain);
        }
        return logList;
    }

    public static UtilResultBean<DeliveryInfoQueryOpenResp> queryJdDeliveryInfoList(String jdOrderId, JdClient client) {
        OpenRpcResult openRpcResult = null;
        DeliveryInfoQueryOpenResp result = null;
        try {
            VopOrderQueryDeliveryInfoRequest request = new VopOrderQueryDeliveryInfoRequest();
            request.setJdOrderId(Long.valueOf(jdOrderId));
            VopOrderQueryDeliveryInfoResponse response = (VopOrderQueryDeliveryInfoResponse)client.execute((JdRequest)request);
            openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdVopOrderDelivery.openRpcResult is null");
            }
            if (!openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdVopOrderDelivery.getSuccess is false");
            }
            result = openRpcResult.getResult();
        }
        catch (Exception e) {
            return UtilResultBean.exceptionResult("JdInterfaceUtil.queryJdVopOrderDelivery.e", e);
        }
        return UtilResultBean.successResult(result);
    }

    public static Map<String, Object> setKeyMap(String serverUrl, String appKey, String appSecret) {
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put("serverUrl", serverUrl);
        keyMap.put("appKey", appKey);
        keyMap.put("appSecret", appSecret);
        return keyMap;
    }

    public static void main(String[] args) {
        String serverUrl = "https://api.jd.com/routerjson";
        String accessToken = "7db6048176c84e7fa1838074ce2f1be6a0od";
        String appKey = "116655B15B84711F2F24F7F417205CCC";
        String appSecret = "f87590a8068b4535b1d61369c8bf35f7";
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        String type = "104";
        UtilResultBean<com.jd.open.api.sdk.domain.vopdd.QueryOrderOpenProvider.response.queryOrderDetail.OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.queryJdOrderDetailInfo((JdClient)client, Long.valueOf("148583885360"));
        System.out.println(JsonUtil.buildNormalBinder().toJson(openRpcResultUtilResultBean));
    }
}

